(****************************************************************************

                      A.N.G.E.L. Setup - Win32 Version
                       Copyright(c) 2002 Jimmy Rose

Version  : 1.0
Compiler : Delphi 6.0
Updated  : Jan 20, 2002

****************************************************************************)


UNIT Main;

INTERFACE

USES  Dialogs, Windows, SysUtils, Classes,
      Graphics, Forms, Controls, StdCtrls,
      Buttons, ComCtrls, ExtCtrls,
      About;

TYPE
  TPagesDlg = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    OKBtn: TButton;
    AboutBtn: TButton;
    HelpBtn: TButton;
    PageControl1: TPageControl;
    tsNODE: TTabSheet;
    lblNode: TLabel;
    lblDropfile: TLabel;
    lblDropPath: TLabel;
    lblBBSName: TLabel;
    lblSysop: TLabel;
    lblBaud: TLabel;
    lblDoorPath: TLabel;
    editNode: TEdit;
    cmbDropfile: TComboBox;
    editDropPath: TEdit;
    editBBSName: TEdit;
    editSysop: TEdit;
    cmbBaud: TComboBox;
    editDoorPath: TEdit;
    btnSaveCFG: TButton;
    tsIBBSCfg: TTabSheet;
    lblIBBS: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure editNodeChange(Sender: TObject);
    procedure btnSaveCFGClick(Sender: TObject);
    procedure cmbDropfileChange(Sender: TObject);
    procedure editDropPathChange(Sender: TObject);
    procedure editBBSNameChange(Sender: TObject);
    procedure editSysopChange(Sender: TObject);
    procedure cmbBaudChange(Sender: TObject);
    procedure editDoorPathChange(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;


VAR // Global
  PagesDlg: TPagesDlg;
  nLine: array [1..10] of string;
  //
  // Set the following booleans to TRUE if any information
  // is changed in any of the config files.
  //
  NodeConfigChanged,
  IBBSConfigChanged: boolean;


CONST
  ProgramName   = 'A.N.G.E.L. Setup - 32 bit';
  Version       = 'v1.0';
  Copyright     = 'Copyright (c) 2001 Atlantis Software';
  Website       = 'http://wwww.jimmyrose.com/atlantis';
  Email         = 'jimmyrose@jimmyrose.com';
  Company       = 'Atlantis Software';
  ConfigVersion : Byte = 2;

IMPLEMENTATION

{$R *.DFM}

Procedure SetDefaults;
Begin
  { Set defaults for NODEx.CFG }
  if nline[1]='' then
  nline[1]:='DOOR32';         //DOOR32';

  if nline[2]='' then
  nline[2]:='C:\BBS\NODE1\';  //C:\BBS\NODE1\';

  if nline[3]='' then
  nline[3]:='BBS Name';       //BBS Name';

  if nline[4]='' then
  nline[4]:='Sysop Name';     //Sysop Name';

  if nline[5]='' then
  nline[5]:='TELNET';         //TELNET';

  if nline[6]='' then
  nline[6]:='D:\DOORS\DOOR\'; //D:\DOORS\DOOR\';

  nline[7]:='0'; // Future use
  nline[8]:='0'; // Future use
  nline[9]:='0'; // Future use
  nline[10]:='0';// Future use
End;




Procedure ReadNodeConfig(who: string);
{ Read NODEx.CFG (who) into the nline array. }
var
 cnt: word;
 thefile: textfile;

Begin
  //SetDefaults;
  If not FileExists(who) then exit;
  AssignFile (thefile, who);
  reset (thefile);
  for cnt:=1 to 10 do readln (thefile, nline[cnt]);
  CloseFile (thefile);
  NodeConfigChanged:=false;
end;

Procedure WriteNodeConfig(node: string);
var
 ncf: TextFile;

begin
  AssignFile(ncf,'NODE'+node+'.CFG');
  if FileExists('NODE'+node+'.CFG') then Erase (ncf);
  Rewrite(ncf);
  Writeln(ncf,nline[1]);
  Writeln(ncf,nline[2]);
  Writeln(ncf,nline[3]);
  Writeln(ncf,nline[4]);
  Writeln(ncf,nline[5]);
  Writeln(ncf,nline[6]);
  Writeln(ncf,nline[7]);
  Writeln(ncf,nline[8]);
  Writeln(ncf,nline[9]);
  Writeln(ncf,nline[10]);
  Writeln(ncf,' ');
  Writeln(ncf,' ');
  Writeln(ncf,';');
  Writeln(ncf,'; '+ProgramName+#32+Version+#32+'- Node '+node+' configuration file');
  Writeln(ncf,'; Created '+TimeToStr(Time)+#32+DateToStr(Date));
  Writeln(ncf,';');
  Writeln(ncf,'; '+Copyright);
  Close(ncf);
end;


procedure CheckSaveNodeConfig(node: string);
begin
  if node<>'' then
    if MessageBox(0,PChar('Save NODE'+node+'.CFG?'+#10#13#10#13+
                           nline[1]+#10#13+
                           nline[2]+#10#13+
                           nline[3]+#10#13+
                           nline[4]+#10#13+
                           nline[5]+#10#13+
                           nline[6]+#10#13+
                           nline[7]+#10#13+
                           nline[8]+#10#13+
                           nline[9]+#10#13+
                           nline[10]),
                           PChar('Save NODE'+node+'.CFG'),
                           MB_YESNO) = IDYES then WriteNodeConfig(node);
  NodeConfigChanged:=false;
end;


procedure TPagesDlg.OKBtnClick(Sender: TObject);
{ Save changes and exit Setup }
begin
  { Do Exit/Save Stuff Here }
  if (NodeConfigChanged) and (editDropPath.Text<>'')
     then CheckSaveNodeConfig(editNODE.Text);
  halt(0);
end;

procedure TPagesDlg.CancelBtnClick(Sender: TObject);
{ Exits Setup without saving any information }
begin
  halt(1);
end;

procedure TPagesDlg.AboutBtnClick(Sender: TObject);
{ Show About Dialog Box }
begin
  AboutBox.Visible:=true;
end;

procedure TPagesDlg.editNodeChange(Sender: TObject);
{ Change all .Text upon the change of the node number }

begin
  {if (NodeConfigChanged) and (editDropPath.Text<>'')
     then CheckSaveNodeConfig(editNODE.Text);}
  if editNode.Text<>'' then
    begin
      ReadNodeConfig('NODE'+editNODE.Text+'.CFG');
      btnSaveCfg.Caption:='Save NODE'+editNode.Text+'.CFG';
      cmbDropfile.Text:=nline[1];
      editDropPath.Text:=nline[2];
      editBBSName.Text:=nline[3];
      editSysop.Text:=nline[4];
      cmbBaud.Text:=nline[5];
      editDoorPath.Text:=nline[6];
      if not btnSaveCfg.Visible then btnSaveCfg.Visible:=True;
        {if (NodeConfigChanged) and (editDropPath.Text<>'')
            then CheckSaveNodeConfig(editNODE.Text);}
    end
  else
    begin
      if btnSaveCfg.Visible then btnSaveCfg.Visible:=False;
      SetDefaults;
    end;
 {if (NodeConfigChanged) and (editDropPath.Text<>'')
     then CheckSaveNodeConfig(editNODE.Text);}
end;

procedure TPagesDlg.btnSaveCFGClick(Sender: TObject);
begin
  CheckSaveNodeConfig(editNode.Text);
end;


procedure TPagesDlg.cmbDropfileChange(Sender: TObject);
begin
  NodeConfigChanged:=true;
  nline[1] := cmbDropfile.Text;
end;

procedure TPagesDlg.editDropPathChange(Sender: TObject);
begin
  NodeConfigChanged:=true;
  nline[2]:=editDroppath.Text;
end;

procedure TPagesDlg.editBBSNameChange(Sender: TObject);
begin
  NodeConfigChanged:=true;
  nline[3]:=editBBSName.Text;
end;

procedure TPagesDlg.editSysopChange(Sender: TObject);
begin
  NodeConfigChanged:=true;
  nline[4]:=editSysop.Text;
end;

procedure TPagesDlg.cmbBaudChange(Sender: TObject);
begin
  NodeConfigChanged:=true;
  nline[5]:=cmbBaud.Text;
end;

procedure TPagesDlg.editDoorPathChange(Sender: TObject);
begin
  NodeConfigChanged:=true;
  nline[6]:=editDoorPath.Text;
end;


Procedure Setup32Init;
begin
  NodeConfigChanged := false;
  IBBSConfigChanged := false;
  if FileExists('NODE1.CFG') then
    ReadNodeConfig('NODE1.CFG') else SetDefaults;
end;

procedure TPagesDlg.HelpBtnClick(Sender: TObject);
begin
  MessageBox(0,PChar('Please read ANGEL.TXT for more information.'),
               PChar('A.N.G.E.L. Setup32 Help'),
               MB_OK);
end;

BEGIN
  Setup32Init;
END.

