
PROGRAM Tutor4;

{$A+,B-,F+,I-,Q-,R-,S-,X+}

USES
  Concerto, IO, Scripts, xStrings;

VAR
  Entry  : pChar3;
  Number : Byte;

BEGIN

{ Our brief introduction to Concerto is finished.  Now we're going to
  start working on an actual door game!  We trust, at this point, that
  you will refer to the INT (interface) files if you are looking for
  details not described in this and subsequent tutorials. }


{ As always, the first step is to initialize the door. }

RegisterConcerto;
Script('Init');


{ Our door game is going to be simple -- after you, you probably want
  to get started on your *own* game as soon as possible.  We are going
  to make a number guessing name (no groans please!) ;-}


{ Select a random number from 1 to 100 }

Number:=Random(100)+1;

REPEAT

  { Display the prompt }

  Write(SO,'Enter your guess: ');


  { Get a number from the user.  We are going to use the SI_pChar
    procedure, which is a low-level pChar input routine.  It
    accepts two parameters:

       1) a pChar to hold the result, and
       2) the maximum length of the string.

    SI_pChar has a unique feature.  If the pChar is not empty, the user
    will be allowed to edit the existing characters! This can be good at
    times, but you'll have to erase the string if you need the user to
    enter something from scratch.  See below. }

  Entry[0]:=#0;           { Erase the string }
  SI_pChar(Entry,3);      { Get an entry (maximum 3 characters) }


  { Check the answer... }

  IF p_Int(Entry)=Number THEN
    BEGIN
    WriteLn(SO,'|FFThe geezer actually won!|07~p');
    ExitDoor(0);
    END
  ELSE
    IF p_Int(Entry)>Number THEN
      WriteLn(SO,'Too big, dummy.')
    ELSE
      WriteLn(SO,'Think bigger, peabrain.');

UNTIL False;

{ This line will never be reached -- look closely at the UNTIL statement! }

END.
