
PROGRAM Tutor6;

{$A+,B-,F+,I-,Q-,R-,S-,X+}

USES
  Concerto, IO, Scripts, Types, xStrings;

CONST
  Prompt  : pChar40 = 'And on this day, he spoke: ';
  TooHigh : pChar80 = 'Your eyes are toward the heavens, esteemed one.~|';
  TooLow  : pChar80 = 'Your feet forever touch the earth, O Great One!~|';
  Winner  : pChar80 = 'He has left us, after a mere {guesses} verses.~p';

                                                    {^^^^^^^}
                                                    {examine}
VAR
  Entry   : pChar3;
  Guesses : Byte;
  Number  : Byte;


PROCEDURE RegisterGame;
  BEGIN

  { This procedure registers our variables with Concerto.  This has a
    great effect: The sysop can now access these variables in any text
    file or script!  We'll start with the strings: }

  RegisterString('Prompt',  @Prompt,  40);
  RegisterString('TooHigh', @TooHigh, 80);
  RegisterString('TooLow',  @TooLow,  80);
  RegisterString('Winner',  @Winner,  80);

  { Next, register byte containing the number of guesses: }

  RegisterByte('Guesses', @Guesses);

  { These variables can now be accessed by the sysop in a few different ways:

    a. Script: LET <variable> = <value>
    b. String: Hello {username}

  { Refer to SYSOP.DOC for more information. }

  END;


BEGIN

RegisterConcerto;

{ Before we run the initialization script, let's *EXTEND* the language! }

RegisterGame;

{ Now call the script... }

Script('Init');


SO_ClrScr;
Guesses := 0;
Number  := Random(100)+1;

REPEAT

  { Get an entry }

  SO_pChar(Prompt);
  Entry[0]:=#0;
  SI_pChar(Entry,3);
  SO_CRLF;
  Inc(Guesses);


  { The rest of this is pretty much the same }

  IF p_Int(Entry)=Number THEN
    BEGIN
    SO_pCharLn(Winner);
    ExitDoor(0);
    END
  ELSE
    IF p_Int(Entry)>Number THEN
      SO_pCharLn(TooHigh)
    ELSE
      SO_pCharLn(TooLow);

UNTIL False;
END.
