
PROGRAM Tutor7;

{$A+,B-,F+,I-,Q-,R-,S-,X+}

USES
  Concerto, IO, Scripts, Types, xStrings;

CONST
  Prompt  : pChar = NIL;
  TooHigh : pChar = NIL;
  TooLow  : pChar = NIL;
  Winner  : pChar = NIL;

VAR
  Entry   : pChar3;
  Guesses : Byte;
  Number  : Byte;


PROCEDURE RegisterGame;
  BEGIN
  RegisterByte    ('Guesses', @Guesses);
  RegisterDynamic ('Prompt',  @Prompt);
  RegisterDynamic ('TooHigh', @TooHigh);
  RegisterDynamic ('TooLow',  @TooLow);
  RegisterDynamic ('Winner',  @Winner);

  { The RegisterDynamic procedure registers a special type of
    variable with Concerto: a null-terminated string that is
    reallocated and deallocated as needed.  Look at TYPES.INT
    for more information. }

  END;


BEGIN

{ Setup the door }

RegisterConcerto;
RegisterGame;
Script('Init');

{***}
Script('Init7');     { Examine INIT7.SCR now! }
{***}

SO_ClrScr;
Guesses:=0;
Number:=Random(100)+1;

REPEAT

  { Get an entry }

  SO_pChar(Prompt);
  Entry[0]:=#0;
  SI_pChar(Entry,3);
  SO_CRLF;
  Inc(Guesses);


  IF p_Int(Entry)=Number THEN
    BEGIN
    SO_pCharLn(Winner);
    ExitDoor(0);
    END
  ELSE
    IF p_Int(Entry)>Number THEN
      SO_pCharLn(TooHigh)
    ELSE
      SO_pCharLn(TooLow);

UNTIL False;
END.
