/****************************************************************************
 *   FILE CKIT.H                                                            *
 *   Created 11-FEB-1990            Rickie W. Belitz                        *
 *                                  820 Brentwood Drive                     *
 *                                  Maryville, Tennessee  37801             *
 *                                  BBS (615) 690-8231                      *
 *                                      (615) 690-7968                      *
 *                                      (615) 690-7913                      *
 *                                                                          *
 *   Include file for    CKIT - DOOR Toolkit v2.58                          *
 *   Modifications for better C++ compatiblity with MSC++ and BC++          *
 *                                                                          *
 ****************************************************************************/
/******************************************************************************
*                        INCLUDE files needed                                 *
*******************************************************************************/
#if     !defined(__CKIT_H)
#define __CKIT_H

#include    <stdio.h>
#include    <stdlib.h>
#include    <dos.h>
#include    <time.h>
#include    <string.h>
#include    <stdarg.h>
#include    <share.h>
#include    <io.h>
#define     MICROSOFT   1
#define     TURBOC      2
/****************************************************************************
 *      IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF         *
 ****************************************************************************/
#if COMPILER == MICROSOFT
    #include    <malloc.h>
#else
    #if COMPILER == TURBOC
        #include    <alloc.h>
    #endif
#endif

/****************************************************************************
 *     ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF    *
 ****************************************************************************/

/* data type definitions */
typedef     unsigned char BYTE;    /* Define BYTE to mean unsigned char */

/* logical  constants  */
#define     ERR         -1
#define     EVER        ;;         /* Used in "for (EVER)"              */
#define     FALSE       0
#define     TRUE        1
#define     NOT_READY   -1
#define     NO_KEY      0
#define     EXITDOOR    0           /* User exited Door     */
#define     NOCARRIER   1           /* Carrier lost         */
#define     TIMEOUT     2           /* Keyboard timeout     */
#define     SYSOP_O     3           /* Sysop request        */
#define     SYSTEMTIME  4           /* System time elapse   */
#define     LOGOFF      5           /* Normal logoff        */
/******************************************************************************
*                        ANSI color table indexes                             *
*******************************************************************************/
#define dkblue          1
#define dkgreen         2
#define dkcyan          3
#define dkred           4
#define dkviolet        5
#define magenta         5
#define brown           6
#define grey            7
#define dkgrey          8
#define blue            9
#define green           10
#define cyan            11
#define red             12
#define violet          13
#define yellow          14
#define white           15


/******************************************************************************
 *        External variable declarations                                      *
 ******************************************************************************/
extern  BYTE    ck_option;             /* Defines how the user was logged off */
extern  int     ck_DUMP_USER;          /* Set to log off user from door       */
extern  BYTE    ck_DOTS;               /* Echo dots with input()              */

extern  char    ck_system_time_HHMMSS[];       /* System time                   */
extern  char    ck_todays_date_MMDDYY[];       /* System date                   */
extern  BYTE    ck_cmdline[];                  /* Used to hold user input       */
extern  char    ck_par[];                      /* Used to parse next cmd to     */
extern  short   ck_linenum;                    /* Number of lines displayed     */
extern  short   ck_graphics;                   /* ANSI in use                   */
extern  short   ck_display;                    /* Local display on/off          */
extern  short   ck_local;                      /* Local mode indicator          */
extern  short   ck_printer;                    /* Printer online/offline        */
extern  short   ck_pagebell;                   /* Page bell on/off              */
extern  short   ck_callalarm;                  /* Caller alarm on/off           */
extern  short   ck_port;                       /* Port number in use            */
extern  short   ck_error_connection;           /* Error correction modem?       */
extern  short   ck_scan_code;                  /* Keycodes for non-standard key */
                                            /* F1 - F10, arrow keys etc      */
                                            /* Holds received all keycodes   */

/* misc. see CKIT.DOC for more information on these */
extern  short   ck_time_on, ck_prev_used, ck_time_limit, ck_dload_limit,
                ck_time_added, ck_time_credit, ck_min_left,ck_event_active,
                ck_event_slide,ck_user_record, ck_ansi_ng, ck_record_lock,
                ck_PCB12, ck_PCB, ck_WILDCAT, ck_GENERIC,ck_GAP, ck_RBBS,
                ck_expert, ck_parity, ck_current_conf, ck_chatmode,
                ck_uart_base, ck_irq, ck_non_ibm, ck_FOSSIL, ck_silent,
                ck_NO_FKEYS, ck_NO_STATUS, ck_key_source, ck_Digiboard;




extern  long    ck_mem_msg;             /* Mem. msg number, PCB 14.x       */
extern  short   ck_time_credit_old;     /* PCB  14.x                       */

/* Info specific to PC14.5A users */
extern  BYTE    ck_exited_DOS, ck_event_coming_up, ck_disable_uploads;
extern  short   ck_last_event_mins, ck_last_conf;
extern  char    ck_last_event_date[9];     /* MM-DD-YY                 */


/* C strings containing information read from BBS system files  */
extern  BYTE    ck_firstname[16];
extern  BYTE    ck_fullname[26];
extern  BYTE    ck_bps_open[6];
extern  BYTE    ck_baud_rate[6];
extern  BYTE    ck_sysop_next[2];
extern  BYTE    ck_netchat[2];
extern  BYTE    ck_password[13];
extern  BYTE    ck_language[6];
extern  BYTE    ck_event_time[6];
extern  BYTE    ck_aport[2];
extern  BYTE    ck_BBSname[63];

extern  char    ck_node[6];

extern  char    ck_upload_total[5];        /* Total files downloaded   */
extern  char    ck_dload_total[5];         /* Total files uploaded     */
extern  char    ck_daily_bytes[4];         /* Total Daily K bytes      */
extern  char    ck_download_Kbytes[10];    /* Total K bytes downloaded */
extern  char    ck_upload_Kbytes[10];      /* Total K bytes uploaded   */
extern  BYTE    ck_time_logged[6];
extern  char    ck_caller_bday[8];         /* Caller's birthday        */
extern  char    ck_main_dir[80];           /* Main bbs system path     */
extern  char    ck_gen_dir[80];            /* BBS system general path  */
extern  char    ck_sysop_name[15];         /* Sysop first name         */
extern  char    ck_sysop_alias[15];        /* Sysop's alias name       */
extern  char    ck_last_file_scan[8];      /* Last new file scan       */
extern  char    ck_max_files[4];           /* Max files allowed to dl  */
extern  char    ck_daily_files[4];         /* Number of files today    */
extern  char    ck_total_doors[4];         /* Total doors opened       */
extern  char    ck_msgs_left[4];           /* Number of messages left  */
extern  BYTE    ck_page_length;            /* User page length         */
extern  char    ck_protocol[15];           /* User's default protocol  */
extern  char    ck_security_level[5];      /* User's security level    */
extern  char    ck_min_remaining[6];       /* mins left (door.sys)     */
extern  char    ck_sec_remaining[6];       /* secs left (door.sys)     */
extern  char    ck_default_color[2];       /* (door.sys)               */
extern  char    ck_last_called[6];         /* (door.sys)               */
                                              
/* Below is info specific to WILDCAT! users */
extern  char    ck_monitor_type[5]; /* MONO/COLOR (Graphics On/Off)        */
extern  char    ck_max_sec[5];      /* Maximum security allowed             */
extern  char    ck_high_msg[10];    /* High message number read             */
extern  BYTE    ck_name_in_use;     /* True/False Name in use on other node */
extern  char    ck_door_opened[5];  /* Door user opened                     */


/* Below is info you will need to define in your door program */
extern  short   ck_FORCEOFFHOOK;       /* Set to TRUE or FALSE                */
extern  short   ck_LOGOFFMSG;          /* Set to TRUE or FALSE                */
extern  short   ck_USERSFILE;          /* Set true if you want user file info */
                                       /* PCBoard systems only                */
extern  char    ck_progname[21];       /* Put you program name here.  define  */
                                       /* the string in YOUR program          */
                                       /* MAX. 20 chars. See CKITDEMO.H       */
                                       /* for example                         */
extern  char    ck_error_msg11[40];    /* Display file error msg, if you want */
                                       /* to change it...MAX 40 chars!        */
extern  short   ck_logoff_color;     /* Log off message color                 */
extern  BYTE    *ck_conferences;     /* pointer to conferences registered in  */
extern  BYTE    *ck_pcbsysbuf;       /* pointer to buffer holding pcboard.sys */
extern  char    **ck_logoff_msgs;    /* pointer to log off messages           */
extern  char    **ck_gen_msgs;       /* pointer to general internal messages  */


/******************************************************************************
 *                    Structure declarations (PCBoard 14.5 only)              *
 ******************************************************************************/
struct pcbuserstype {
    char    name[26];                   /* First and Last name                */
    char    city[25];                   /* City and State                     */
    char    pwrd[13];                   /* Password                           */
    char    bphone[14];                 /* Business/Data phone number         */
    char    phone[14];                  /* Home phone number                  */
    char    last_date[7];               /* Last date on in (YYMMDD) format    */
    char    last_time[6];               /* Last logon time in HH:MM) format   */
    char    expert[2];                  /* Expert Mode (Y or N)               */
    char    protocol[2];                /* Protocol type                      */
    BYTE    packed_byte;                /* Bit packed flags                   */
    char    filedate[7];                /* Last DIR look date (YYMMDD) format */
    BYTE    security;                   /* Security level of user             */
    short   total_calls;                /* Number of times on                 */
    BYTE    page_length;                /* Page length                        */
    short   uploads;                    /* Number of Uploads                  */
    short   downloads;                  /* Number of Downloads                */
    double  dload_bytes;                /* Daily dload bytes so far           */
    char    comment1[31];               /* User maintained comment            */
    char    comment2[31];               /* Sysop maintained comment           */
    short   time_used;                  /* Elapsed time on system             */
    char    expire_date[7];             /* Subscription Reg. Date (YYMMDD)    */
    BYTE    expire_level;               /* Expired security level             */
    BYTE    current_conf;               /* Area number last in                */
    BYTE    conferences[6];             /* Conferences area allowed in        */
    BYTE    expire_conf[6];             /* Expired conference areas           */
    BYTE    scan_conf[6];               /* Conferences desired for mail scan  */
    double  dload_total;                /* Total bytes downloaded - all calls */
    double  upload_total;               /* Total bytes uploaded - all calls   */
    char    delete_user[2];             /* Delete user flag (Y or N)          */
    unsigned long last_msg_read;        /* Last read msg Main area (default)  */
    long    last_read[39];              /* Last Read Message Area pointers    */
    BYTE    space2[15];                 /* Reserved                           */
} extern ck_user;

/******************************************************************************
 *   Structure to use with CKIT for BBS's not supported by CKIT               *
 ******************************************************************************/
struct ckitgeneric {
    char port[6];                   /* COM:?  */
    short min_left;                 /* minutes left */
};                                  /* Name this what you want */
extern  short  ck_NOSYSTEM;         /* Set true if want C-kit open_door()  */
                                    /* to obtain information from ck_gen   */
                                    /* ckitgeneric structure               */
/****************************************************************************
 *      IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF         *
 ****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
 *                Function prototypes                                         *
 ******************************************************************************/
void    s_printf(char *,...);       /* High level variable sio puts           */

/*  COMMENT
   Copy this function to your door source code to create the s_printf() func.
   See ckitdemo.c. Default buffer is 82 chars, modify as  needed.

void s_printf(char *s_format,...) {
    va_list arg_pointer;
    char buffer[82];
    va_start(arg_pointer, s_format);
    vsprintf(buffer, s_format, arg_pointer);
    s_puts(buffer);
    va_end(arg_pointer);
}

*/

/******************************************************************************
 *                External function prototypes                                *
 ******************************************************************************/

extern  void    ck_clear_screen(void);
extern  void    ck_set_r_c(short, short);
extern  short   ck_open_door(char *, ...);
extern  void    ck_close_door(void);
extern  void    ck_s_putv();                   /* High level send variable string I/O function     */
extern  void    ck_s_puts(char *);             /* High level send string I/O function              */
extern  void    ck_s_putsn(char *);            /* High level send string LOCAL only                */
extern  void    ck_s_putstd(char *);           /* High level send string using STD output          */
extern  void    ck_s_putc(BYTE);               /* High level send char.  I/O function              */
extern  void    ck_newline(void);              /* send a Carriage return, line feed                */
extern  void    ck_clear_row(short);           /* Clear a given row of screen                      */
extern  void    ck_color(short);               /* Select ANSI color to use                         */
extern  void    ck_pos_cursor(short, short);   /* Position cursor using ANSI                       */
extern  void    ck_clr_screen(void);           /* Clear local/remote screens                       */
extern  void    ck_back_space(short);          /* Destructive backspace  local/remote              */
extern  void    ck_clear_eol(void);            /* Clear to end of line local/remote                */
extern  short   ck_display_file(char *);       /* Display file local/remote                        */
extern  void    ck_prompt_def(char *, char *); /* Display prompt, with default string              */
extern  void    ck_get_def(char *, char *);    /* Same as prompt_def, but gets input               */
extern  void    ck_get_defn(char *, char *);   /* Same as get_def, appends "(Enter)=none?"                 */
extern  void    ck_get_defen(char *);          /* Same as get_def, but default is always "(Enter=none? "   */
extern  void    ck_get_defyn(char *, short);   /* Get input with yes/no default based on short value       */
extern  short   ck_nomore(void);               /* prompt more?, returns TRUE if no or              */
extern  short   ck_inkey(void);                /* Read char. from local/remote                     */
extern  short   ck_getkey(void);               /* Read char. from local keyboard                   */
extern  short   ck_wait_keypress(void);        /* Waits for any key press, high level              */
extern  void    ck_force_enter(void);          /* Force user to press enter key to continue        */
extern  void    ck_get_cmdline(void);
extern  void    ck_get_cmdline_raw(short);     /* Get cmdline, erase prompt based on short         */
extern  void    ck_input(BYTE *, short);       /* Read input into cmdline, local/remote            */
extern  short   ck_keystat();                  /* Check if key waiting                             */
extern  BYTE    ck_receive(void);              /* Get character receieved from the receive buffer  */
extern  BYTE    ck_sio_getbyte (void);         /* Returns byte from port, if available             */
extern  char    ck_get_nextpar(void);
extern  void    ck_check_time_left(void);  /* Check if user time is up, sets DUMPUSER              */
extern  short   ck_mins_left_system(void); /* Returns number of minutes left on system */
extern  short   ck_system_time_used(void); /* Returns mins since door was opened */
extern  void    ck_adjust_time_allowed(short); /* Add/Subtract user time left                      */
extern  short   ck_check_event(void);      /* Check if time left conflicts with event              */
extern  short   ck_mins_before_event(void);/* Return minutes left before event                     */
extern  short   ck_event_minutes(void);    /* Return minutes from midnight of event                */
extern  void    ck_lower_dtr(void);        /* Lower DTR line on serial port                        */
extern  void    ck_raise_dtr(void);        /* Raise DTR line on serial port                        */
extern  void    ck_force_offhook(void);    /* Force modem to hangup, go offhook                    */
extern  BYTE    ck_check_cd(void);         /* Return CARRIER status, Non-Zero = CARRIER            */
extern  void    ck_transmit_data(char *);  /* Xmit to remote only, with CARRIER detect             */
extern  short   ck_transmit_modem(char *); /* Xmit to modem, WITHOUT CARRIER detect                */
extern  short   ck_tqueue_len(void);       /* Returns length (in bytes) of serial xmit buffer      */
extern  BYTE *  ck_flush_rqueue(void);     /* Flush serial input buffer        */
extern  void    ck_wait(short);            /* Wait delay in seconds            */
extern  short   ck_check_CR(void);         /* Check for Carriage Return, TRUE/FALSE */
extern  short   ck_check_keypress(BYTE);   /* Check for any ASCII code press   */
extern  short   ck_r_count(void);          /* Return number bytes in rqueue    */
extern  void    ck_purge_buffer(BYTE *, short); /* Purge buffer to NULLS       */
extern  void    ck_debug_on(void);         /* Disable keyboard timer, carrier  */
extern  void    ck_debug_off(void);        /* Disable keyboard timer, carrier  */
extern  void    ck_carrier_off(void);      /* Same as debug on                 */
extern  void    ck_carrier_on(void);       /* Same as debug off                */
extern  short   ck_dos_shell(char *, char *);  /* Execute external program     */
extern  void    ck_shell_entry(void);          /* Prepare for a DOS shell      */
extern  void    ck_shell_exit(void);           /* Cleanup after a DOS shell    */
extern  void    ck_set_r_c(short, short);  /* Position cursor on local console */
extern  short   ck_update_user();          /* Update user record               */
extern  short   ck_check_CTRL_K(void);     /* Check for CTRL-K press           */
extern  void    ck_CtrlK_ON(void);         /* Enable CTRL-K checking (default) */
extern  void    ck_CtrlK_OFF(void);        /* Disable CTRL-K checking          */
extern  void    ck_set_kybd_time(BYTE, BYTE); /* Set keyboard timeouts         */
extern  short   ck_set_ANSI(short);           /* Turn on ANSI compability      */


/****************************************************************************
 *      IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF IF         *
 ****************************************************************************/
/* Turbo C has a delay() function and does the same thing.                  */
#if COMPILER == MICROSOFT           /* Use Ckit's delay if not using TURBOC */

extern  void    ck_delay(short);    /* Gen. Purpose delay X 55 milliseconds */

#endif

/****************************************************************************
 *     ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF ENDIF    *
 ****************************************************************************/
#ifdef __cplusplus
}
#endif


#endif  /* __CKIT_H */

/******************************************************************************
 ************************ E N D  OF  M O D U L E ******************************/
