
unit ddigmovr;

{$O+,F+,V-}

interface

uses dos,crt;

procedure Loadconfig(
 var lord_path : dirstr;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: longint;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var NoFossInit: boolean;
 var board_name: string;
 var pause_code: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime:  word;
 var localcol: boolean;
 var statfore: byte;
 var statback: byte;
 var statline: boolean;
 var EMSOk,NetOk,NoLocal: boolean;
 var fossilio,digiio: boolean;
 var lockbaud: longint;
 var nodirect: boolean;
 var port1,port2,port3,port4:word;
 var irq1,irq2,irq3,irq4 : byte;
 var accountnum : integer;
 var fairy : byte;
 var aliasname: string;
 var nn : extstr
 );

var
 ddcfgp1,ddcfgp2,ddcfgps: string[80];

const
 DDUserConfigPtr: pointer = nil;

implementation

var
 ctlnm:string[2];
 fn : DirStr;

Procedure CallProc;
inline($FF/$1E/DDUserConfigPtr);

procedure Loadconfig(
 var lord_path: dirstr;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: longint;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var noFossInit: boolean;
 var board_name: string;
 var pause_code: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime:  word;
 var localcol: boolean;
 var statfore: byte;
 var statback: byte;
 var statline: boolean;
 var EMSOk,NetOK,NoLocal: boolean;
 var fossilio,digiio: boolean;
 var lockbaud: longint;
 var nodirect: boolean;
 var port1,port2,port3,port4:word;
 var irq1,irq2,irq3,irq4 : byte;
 var accountnum : integer;
 var fairy : byte;
 var aliasname: string;
 var nn : extstr );

function getparam(s: string; n: integer): string;
var
 a: integer;
 s2: string;
begin;
 while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 if n<>1 then begin;
  while (length(s)>0) and (s[1]<>' ') do delete(s,1,1);
  while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 end;
 if n=3 then begin;
  while (length(s)>0) and (s[1]<>' ') do delete(s,1,1);
  while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 end;
 while (pos(' ',s)<>0) do begin;
  a:=1;
  s2:='';
  while s[a]<>' ' do begin;
   s2:=s2+upcase(s[a]);
   a:=a+1;
  end;
  s:=s2;
 end;
 while (length(s)>0) and (s[length(s)]=' ') do delete(s,length(s),1);
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 getparam:=s;
end;

function getsecond(s: string): string;
var
 a: integer;
 s2: string;
begin;
 while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 while (length(s)>0) and (s[1]<>' ') do delete(s,1,1);
 while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 while (length(s)>0) and (s[length(s)]=' ') do delete(s,length(s),1);
 getsecond:=s;
end;

function numparams(s: string): integer;
var
 i: integer;
begin;
 i:=0;
 numparams:=0;
 if length(s)=0 then exit;
 if s[1]=';' then exit;
 if s[2]=';' then exit;
 if getparam(s,1)<>'' then inc(i);
 if getparam(s,2)<>'' then inc(i);
 if getparam(s,3)<>'' then inc(i);
 numparams:=i;
end;

procedure Port_rtn (var s2,s3 : string;
                    var portadd : word;
                    var irq  : byte);
var
  a : integer;
begin
  val('$'+s2,portadd,a);
  val(s3,irq,a);
end;

procedure DDError(s: string);
begin;
 write(^G^G);
 writeln('ERROR: '+s);
 write(^G^G);
 delay(2000);
end;

procedure BadParam(s: string);
begin;
 dderror('Invalid parameter');
 halt;
end;

procedure processcmdline(var n:string);
var
 a,b: integer;
 s,s2: string;
begin;
 ctlnm:='';
 Lord_path:='';
 for a:=1 to paramcount do
   begin
      s:=paramstr(a);
      for b:=1 to length(s) do s[b]:=upcase(s[b]);
      if (s[1]='/') and (length(s)>1) then
       begin
        delete(s,1,1);
        s2:=s;
        delete(s2,1,1);
        EMSOK:=False;
        case s[1] of
         'E': EMSOk:=true;
         'L': begin
                local := true;
                n:='0';
              end;
         'N': begin
                n:=s2;
                val(s2,node_num,b);
              end;
    'P': begin;
          if s2[length(s2)]<>'\' then s2:=s2+'\';
          Lord_path:=s2;
         end;
        end;
      end;
  end;
end;

Procedure CloseUp;
type
  strarr = array [1..4] of string[60];
var
 f: text;
 s:string;
 i,a:integer;
 ps,p1,p2,p3: string[80];
 ofm: word;
 strx : strarr;
begin
 fn:='INFO.'+nn;
 ofm:=filemode;
 filemode:=64;
 assign(f,fn);
 {$i-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Node file, '+fn+', is missing!');

 for i:=1 to 4 do
   readln(f,strx[i]);
 close(f);

 filemode:=66;
 {$i-}
 rewrite(f);
 {$I+}
  bbs_time_left:=200;

  for i := 1 to 4 do
    writeln(f,strx[i]);
  str(bbs_time_left,s);
  writeln(f,s);

  close(f);
  filemode:=ofm;
end;

Procedure SelectNode;
var
  P : PathStr;
  D : DirStr;
  N : NameStr;
  E : ExtStr;
begin
  p := fn;
  Fsplit(p,d,n,e);
  if lord_path='' then lord_path:=d;
  fn := lord_path+n+ctlnm+e;
end;

var
 s : string;
 f: text;
 ch:char;
 a,b,c,count: integer;
 ps,p1,p2,p3: string[80];
 ofm: word;
begin;
 maxtime:=999;
 local:=false;
 localcol:=true;
 sysop_first_name:='STEVE';
 sysop_last_name:='LORENZ';
 board_name:='The Officers Club BBS';
 pause_code:='@PAUSE@';
 statline:=true;
 nodirect:=false;
 color1:=false;
 EMSOK:=false;
 NetOK:=false;
 NoLocal:=false;
 fossilio:=false;
 digiio:=false;
 lockbaud:=0;
 accountnum:=0;
 fairy:=0;

 processcmdline(nn);
 fn:='NODE'+nn+'.DAT';
 selectnode;
 ofm:=filemode;
 filemode:=64;
 assign(f,fn);
 {$i-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Configuration file, '+fn+', is missing!');
 while not eof(f) do
  begin
  readln(f,s);
  if numparams(s)>0 then
   begin
    p1:=getparam(s,1);
    p2:=getparam(s,2);
    p3:=getparam(s,3);
    ps:=getsecond(s);
    if p1='SYSOPFIRST' then sysop_first_name:=ps else
    if p1='SYSOPLAST' then sysop_last_name:=ps else
    if p1='BBSNAME' then board_name:=ps else
    if p1='STATUS' then
    begin
     if p2='OFF' then statline:=false else
     if p2='ON' then statline:=true
    end                              else
    if p1='DIGI'   then digiio:=true   else
    if p1='FOSSIL' then fossilio:=true else
    if p1='XFOSSIL' then
       begin
         fossilio:=true;
         noFossInit:=true;
       end                                 else
    if p1='LOCKBAUD' then val(p2,lockbaud,a) else
    if p1='PORT1'    then port_rtn(p2,p3,port1,irq1) else
    if p1='PORT2'    then port_rtn(p2,p3,port2,irq2) else
    if p1='PORT3'    then port_rtn(p2,p3,port3,irq3) else
    if p1='PORT4'    then port_rtn(p2,p3,port4,irq4) else
    if p1='COLOR' then localcol:=true else
    if p1='MONO' then localcol:=false else
    if p1='COLOR1' then color1:=true else
    if p1='COMPORT' then val(p2,com_port,a) else
    if p1='PAUSECODE' then pause_code:=ps else
    begin
      ddcfgp1:=p1;
      ddcfgp2:=p2;
      ddcfgps:=ps;
      if dduserconfigptr<>nil then callproc;
    end;
   end;
  end;
 close(f);

 count:=0;
 fn:='INFO.'+nn;
 selectnode;
 assign(f,fn);
 {$i-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Info file, '+fn+', is missing!');

 while not eof(f) do
  begin
    readln(f,s);
    inc(count);
    case count of
      1   :  val(s,accountnum,a);
      2   :  val(s,graphics,a);
      3,4 :  if numparams(s)>0 then
             begin
               p1:=getparam(s,1);
               p2:=getparam(s,2);
               if p1='RIP' then
                if p2='YES' then
                 graphics:=5;
               if p1='FAIRY' then
                if p2='YES' then
                 Fairy:=5;
             end;
      5   : val(s,bbs_time_left,a);
      6   : aliasname:=s;
      7   : user_first_name:=s;
      8   : user_last_name:=s;
      9   : val(s,com_port,a);
     10   : val(s,baud_rate,a);
     12   :  if numparams(s)>0 then
             begin
               p1:=getparam(s,1);
               if p1='INTERNAL' then
                begin
                 fossilio:=false;
                 noFossInit:=false;
                 digiio:=false;
                end                               else
               if p1='DIGI'   then digiio:=true   else
               if p1='FOSSIL' then fossilio:=true else
               if p1='XFOSSIL' then
                begin
                 fossilio:=true;
                 noFossInit:=true;
                end;
             end;
    end;
 end;
 close(f);
 filemode:=ofm;
 If bbs_time_left>999 then bbs_time_left:=999;
end;


end.

{
 /E - Use EMS for extra memory for overlays
      This is forced on.  To set it off sysop must edit the nodex.dat
      file and change one of the ;Unused to NOEMS

    }
