{.$A+,B-,D+,E-,F+,G-,I+,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}
{.$D-,L-,Y-}
Unit RipLink1;
{$F+,O+}

interface

{$I RIPLINK.PA2}
const
  MegaArray : array[0..35] of Char = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

type
  Str2  = string[2];
  Str4  = string[4];

  CharMapRecord = record
    s8x8   : Array[1..8] of Byte;
    s7x8   : Array[1..8] of Byte;
    s8x14  : Array[1..14] of Byte;
    s7x14  : Array[1..14] of Byte;
    s16x14 : Array[1..14] of Word;
  end;

Function IntToStr(I: longint) : string;
Function StrToInt(S: string) : longint;
Function BackSlash(instring : string) : string;
Function EscapeString(instring : string) : string;
Function Exists(FN : string) : boolean;
Function WordToMega(Num : word) : Str2;
Function WordToMega4(Num : word) : Str4;
Function MegaToWord(S2 : Str2) : Word;
Function Mega4ToLong(S4 : Str4) : Longint;
Procedure DisplayChar(x,y:word;clr,bclr:byte;c:CharMapRecord;tsize:byte);

implementation

uses
  dos,graph;

Function IntToStr(I: longint) : string;
var
  s     : string[11];
begin
  str(I,S);
  inttostr := s;
end;

Function StrToInt(S: string) : longint;
var
  I     : longint;
  code  : integer;
begin
  I := 0;
  val(S,I,code);
  strtoint := I;
end;

Function BackSlash(instring : string) : string;
begin
  if not ((instring[length(instring)]) = '\') then
    backslash := instring + '\'
  else
    backslash := instring;
end;

Function EscapeString(instring : string) : string;
var
  st : string;
  c  : byte;
begin
  st := '';
  for c := 1 to length(instring) do
  begin
    if instring[c] in ['!','\','|'] then
      st := st + '\';
    st := st + instring[c];
  end;
  escapestring := st;
end;

Function Exists(FN : string) : boolean;
var
  F     : searchrec;
begin
  findfirst (FN,AnyFile,F);
  Exists := DosError = 0;
end;

Function WordToMega(Num : word) : Str2;
var
  work          : str2;
begin
  work := '';
  if (Num < 0) or (Num > 1295) then
  begin
    WordToMega := '  ';
    Exit;
  end;
  while Num >0 do
  begin
    work := megaarray[num mod 36]+work;
    num := num div 36;
  end;
  while length(work)<2 do
    work := '0'+work;
  WordToMega := work;
end;

Function WordToMega4(Num : word) : Str4;
var
  work          : str4;
begin
  work := '';
  while Num >0 do
  begin
    work := megaarray[num mod 36]+work;
    num := num div 36;
  end;
  while length(work)<4 do
    work := '0'+work;
  WordToMega4 := work;
end;

Function MegaToWord(S2 : Str2) : Word;
var
  Num           : word;
begin
  num := 0;
  if not ord(upcase(s2[1])) in [48..57,65..90] then Exit;
  if not ord(upcase(s2[2])) in [48..57,65..90] then Exit;
  while s2 <> '' do
  begin
    if s2[1] > '9' then
      num := num*36+ord(s2[1])-55
    else
      num := num*36+ord(s2[1])-48;
    delete(s2,1,1);
  end;
  MegaToWord := num;
end;

Function Mega4ToLong(S4 : Str4) : Longint;
var
  Num           : longint;
begin
  num := 0;
  if not ord(upcase(s4[1])) in [48..57,65..90] then Exit;
  if not ord(upcase(s4[2])) in [48..57,65..90] then Exit;
  if not ord(upcase(s4[3])) in [48..57,65..90] then Exit;
  if not ord(upcase(s4[4])) in [48..57,65..90] then Exit;
  while s4 <> '' do
  begin
    if s4[1] > '9' then
      num := num*36+ord(s4[1])-55
    else
      num := num*36+ord(s4[1])-48;
    delete(s4,1,1);
  end;
  Mega4ToLong := num;
end;

Function FlagOn(Flags : Byte; FlagMask : Byte) : Boolean;
begin
  if FlagMask = 0 then
  begin
    flagon := true;
    exit;
  end;
  FlagOn := (Flags and FlagMask) <> 0;
end;

Procedure DisplayChar(x,y:word;clr,bclr:byte;c:CharMapRecord;tsize:byte);
var
  ct : byte;
begin
  case tsize of
    0 : begin {8x8}
          for ct := 1 to 8 do
          begin
            if flagon(c.s8x8[ct],$01) then putpixel(x  ,y+ct-1,clr) else putpixel(x  ,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$02) then putpixel(x+1,y+ct-1,clr) else putpixel(x+1,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$04) then putpixel(x+2,y+ct-1,clr) else putpixel(x+2,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$08) then putpixel(x+3,y+ct-1,clr) else putpixel(x+3,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$10) then putpixel(x+4,y+ct-1,clr) else putpixel(x+4,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$20) then putpixel(x+5,y+ct-1,clr) else putpixel(x+5,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$40) then putpixel(x+6,y+ct-1,clr) else putpixel(x+6,y+ct-1,bclr);
            if flagon(c.s8x8[ct],$80) then putpixel(x+7,y+ct-1,clr) else putpixel(x+7,y+ct-1,bclr);
          end;
        end;
    1 : begin {7x8}
          for ct := 1 to 8 do
          begin
            if flagon(c.s7x8[ct],$01) then putpixel(x  ,y+ct-1,clr) else putpixel(x  ,y+ct-1,bclr);
            if flagon(c.s7x8[ct],$02) then putpixel(x+1,y+ct-1,clr) else putpixel(x+1,y+ct-1,bclr);
            if flagon(c.s7x8[ct],$04) then putpixel(x+2,y+ct-1,clr) else putpixel(x+2,y+ct-1,bclr);
            if flagon(c.s7x8[ct],$08) then putpixel(x+3,y+ct-1,clr) else putpixel(x+3,y+ct-1,bclr);
            if flagon(c.s7x8[ct],$10) then putpixel(x+4,y+ct-1,clr) else putpixel(x+4,y+ct-1,bclr);
            if flagon(c.s7x8[ct],$20) then putpixel(x+5,y+ct-1,clr) else putpixel(x+5,y+ct-1,bclr);
            if flagon(c.s7x8[ct],$40) then putpixel(x+6,y+ct-1,clr) else putpixel(x+6,y+ct-1,bclr);
          end;
        end;
    2 : begin {8x14}
          for ct := 1 to 14 do
          begin
            if flagon(c.s8x14[ct],$01) then putpixel(x  ,y+ct-1,clr) else putpixel(x  ,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$02) then putpixel(x+1,y+ct-1,clr) else putpixel(x+1,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$04) then putpixel(x+2,y+ct-1,clr) else putpixel(x+2,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$08) then putpixel(x+3,y+ct-1,clr) else putpixel(x+3,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$10) then putpixel(x+4,y+ct-1,clr) else putpixel(x+4,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$20) then putpixel(x+5,y+ct-1,clr) else putpixel(x+5,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$40) then putpixel(x+6,y+ct-1,clr) else putpixel(x+6,y+ct-1,bclr);
            if flagon(c.s8x14[ct],$80) then putpixel(x+7,y+ct-1,clr) else putpixel(x+7,y+ct-1,bclr);
          end;
        end;
    3 : begin {7x14}
          for ct := 1 to 14 do
          begin
            if flagon(c.s7x14[ct],$01) then putpixel(x  ,y+ct-1,clr) else putpixel(x  ,y+ct-1,bclr);
            if flagon(c.s7x14[ct],$02) then putpixel(x+1,y+ct-1,clr) else putpixel(x+1,y+ct-1,bclr);
            if flagon(c.s7x14[ct],$04) then putpixel(x+2,y+ct-1,clr) else putpixel(x+2,y+ct-1,bclr);
            if flagon(c.s7x14[ct],$08) then putpixel(x+3,y+ct-1,clr) else putpixel(x+3,y+ct-1,bclr);
            if flagon(c.s7x14[ct],$10) then putpixel(x+4,y+ct-1,clr) else putpixel(x+4,y+ct-1,bclr);
            if flagon(c.s7x14[ct],$20) then putpixel(x+5,y+ct-1,clr) else putpixel(x+5,y+ct-1,bclr);
            if flagon(c.s7x14[ct],$40) then putpixel(x+6,y+ct-1,clr) else putpixel(x+6,y+ct-1,bclr);
          end;
        end;
    4 : begin {16x14}
          for ct := 1 to 14 do
          begin
            if flagon(lo(c.s16x14[ct]),$01) then putpixel(x   ,y+ct-1,clr) else putpixel(x   ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$02) then putpixel(x+1 ,y+ct-1,clr) else putpixel(x+1 ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$04) then putpixel(x+2 ,y+ct-1,clr) else putpixel(x+2 ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$08) then putpixel(x+3 ,y+ct-1,clr) else putpixel(x+3 ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$10) then putpixel(x+4 ,y+ct-1,clr) else putpixel(x+4 ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$20) then putpixel(x+5 ,y+ct-1,clr) else putpixel(x+5 ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$40) then putpixel(x+6 ,y+ct-1,clr) else putpixel(x+6 ,y+ct-1,bclr);
            if flagon(lo(c.s16x14[ct]),$80) then putpixel(x+7 ,y+ct-1,clr) else putpixel(x+7 ,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$01) then putpixel(x+8 ,y+ct-1,clr) else putpixel(x+8 ,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$02) then putpixel(x+9 ,y+ct-1,clr) else putpixel(x+9 ,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$04) then putpixel(x+10,y+ct-1,clr) else putpixel(x+10,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$08) then putpixel(x+11,y+ct-1,clr) else putpixel(x+11,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$10) then putpixel(x+12,y+ct-1,clr) else putpixel(x+12,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$20) then putpixel(x+13,y+ct-1,clr) else putpixel(x+13,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$40) then putpixel(x+14,y+ct-1,clr) else putpixel(x+14,y+ct-1,bclr);
            if flagon(hi(c.s16x14[ct]),$80) then putpixel(x+15,y+ct-1,clr) else putpixel(x+15,y+ct-1,bclr);
          end;
        end;
  end;
end;

End.
