unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, DXPlay, ComCtrls,
  Grids, CComFunc;

type
  TGamePlayerRecord = record
    ServerID: string;
    CurrX: Integer;
    CurrY: Integer;
  end;

  GamePlayRecArray = array[0..4] of TGamePlayerRecord;

  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FilePrintSetupItem: TMenuItem;
    FileExitItem: TMenuItem;
    HelpContentsItem: TMenuItem;
    HelpSearchItem: TMenuItem;
    HelpHowToUseItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    StatusLine: TStatusBar;
    PrintDialog: TPrintDialog;
    PrintSetupDialog: TPrinterSetupDialog;
    SpeedBar: TPanel;
    SpeedButton1: TSpeedButton; { P&rint Setup... }
    SpeedButton2: TSpeedButton; { E&xit }
    SpeedButton3: TSpeedButton; { &Contents }
    SpeedButton4: TSpeedButton; { &Search for Help On... }
    SpeedButton5: TSpeedButton; { &How to Use Help }
    SpeedButton6: TSpeedButton;
    ScrollBox1: TScrollBox;
    ScrollBox2: TScrollBox;
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    StringGrid1: TStringGrid;
    GroupBox1: TGroupBox;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton; { &About... }
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FilePrintSetup(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure HelpContents(Sender: TObject);
    procedure HelpSearch(Sender: TObject);
    procedure HelpHowToUse(Sender: TObject);
    procedure HelpAbout(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  public
    procedure InitializeTheGame;
    procedure BeginTheGame;
    procedure ExecuteGameMove;
  end;

var
  MainForm: TMainForm;
  MyGamePlayRecArray: GamePlayRecArray;
  TheLastMoveMadeIs: Integer;

implementation

uses About, CConfig, CChatMod;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  TheGameNameIs := 'Game';
  MyPlayerShortNameIs := 'Player';
  Application.OnHint := ShowHint;
  Randomize;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.SimpleText := Application.Hint;
end;

procedure TMainForm.FilePrintSetup(Sender: TObject);
begin
  PrintSetupDialog.Execute;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.HelpContents(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.HelpSearch(Sender: TObject);
const
  EmptyString: PChar = '';
begin
  Application.HelpCommand(HELP_PARTIALKEY, Longint(EmptyString));
end;

procedure TMainForm.HelpHowToUse(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TMainForm.HelpAbout(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  ConfigForm: TConfigForm;
begin
  TheGameHostIs := CCom1.DxPlay1.TCPIPSetting.HostName;
  TheGamePortIs := CCom1.DxPlay1.TCPIPSetting.Port;
  //Starts up the client and brings it online
  ClientIsUp := False;
  try
    ConfigForm := TConfigForm.Create(Self);
    try
      ConfigForm.DXPlay := CCom1.DxPlay1;
      ConfigForm.ShowModal;
      if ConfigForm.Tag = 0 then Abort;
    finally
      ConfigForm.Free;
    end;
  except
    on E: Exception do
    begin
      Application.HandleException(E);
      Memo1.Lines.Add('Error unable to start up!');
    end;
  end;
  if ClientIsUp = True then
  begin
    CCom1.InitPlayerGameDataArray;
    InitializeTheGame;
    Memo1.Lines.Add('Client is online.');
  end;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  ClientIsUp := False;
  Memo1.Lines.Add('Client has been closed down.');
  CCom1.DxPlay1.Close;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
{Starts up the chat module}
  ChatModForm1.ShowModal;
end;

procedure TMainForm.InitializeTheGame;
var
  I, J: Integer;
begin
  for I := 0 to StringGrid1.ColCount - 1 do
  begin
    for J := 0 to StringGrid1.RowCount - 1 do
    begin
      StringGrid1.Cells[I, J] := '-';
    end;
  end;
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
  TheLastMoveMadeIs := 1;
  CCom1.Send_GameDataMsg(1, 'None', ServerIDIs);
end;

procedure TMainForm.Button5Click(Sender: TObject);
begin
  TheLastMoveMadeIs := 2;
  CCom1.Send_GameDataMsg(2, 'None', ServerIDIs);
end;

procedure TMainForm.Button6Click(Sender: TObject);
begin
  TheLastMoveMadeIs := 3;
  CCom1.Send_GameDataMsg(3, 'None', ServerIDIs);
end;

procedure TMainForm.Button7Click(Sender: TObject);
begin
  TheLastMoveMadeIs := 4;
  CCom1.Send_GameDataMsg(4, 'None', ServerIDIs);
end;

procedure TMainForm.BeginTheGame;
begin
  TheLastMoveMadeIs := 0;
  InitializeTheGame;
  MyGamePlayRecArray[0].CurrX := StrToInt(MyPlayerDataRecArray[0].pgdata[1]);
  MyGamePlayRecArray[0].CurrY := StrToInt(MyPlayerDataRecArray[0].pgdata[2]);
  StringGrid1.Cells[MyGamePlayRecArray[0].CurrX, MyGamePlayRecArray[0].CurrY] := MyPlayerDataRecArray[0].pgdata[0];
  Memo1.Lines.Add('You may begin moving.');
  MyPlayerNumIs := MyPlayerDataRecArray[0].pgdata[0];
end;

procedure TMainForm.ExecuteGameMove;
var
  tempx, tempy: Integer;
  PlayerIndexNumIs: Integer;
begin
  case TheLastMoveMadeIs of
    1: begin //Player Moving North
        tempy := MyGamePlayRecArray[0].CurrY - 1;
        tempx := MyGamePlayRecArray[0].CurrX;
        StringGrid1.Cells[tempx, tempy] := MyPlayerNumIs;
        StringGrid1.Cells[tempx, MyGamePlayRecArray[0].CurrY] := '-';
        MyGamePlayRecArray[0].CurrY := tempy;
      end;
    2: begin //Player Moving East
        tempy := MyGamePlayRecArray[0].CurrY;
        tempx := MyGamePlayRecArray[0].CurrX + 1;
        StringGrid1.Cells[tempx, tempy] := MyPlayerNumIs;
        StringGrid1.Cells[MyGamePlayRecArray[0].CurrX, tempy] := '-';
        MyGamePlayRecArray[0].CurrX := tempx;
      end;
    3: begin //Player Moving South
        tempy := MyGamePlayRecArray[0].CurrY + 1;
        tempx := MyGamePlayRecArray[0].CurrX;
        StringGrid1.Cells[tempx, tempy] := MyPlayerNumIs;
        StringGrid1.Cells[tempx, MyGamePlayRecArray[0].CurrY] := '-';
        MyGamePlayRecArray[0].CurrY := tempy;
      end;
    4: begin //Player Moving West
        tempy := MyGamePlayRecArray[0].CurrY;
        tempx := MyGamePlayRecArray[0].CurrX - 1;
        StringGrid1.Cells[tempx, tempy] := MyPlayerNumIs;
        StringGrid1.Cells[MyGamePlayRecArray[0].CurrX, tempy] := '-';
        MyGamePlayRecArray[0].CurrX := tempx;
      end;
  end;
end;

end.

