unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, DXPlay, ComCtrls,
  Grids, SComFunc;

type
  TGamePlayerRecord = record
    ServerID: string;
    CurrX: Integer;
    CurrY: Integer;
  end;

  GamePlayRecArray = array[0..4] of TGamePlayerRecord;

  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FilePrintSetupItem: TMenuItem;
    FileExitItem: TMenuItem;
    HelpContentsItem: TMenuItem;
    HelpSearchItem: TMenuItem;
    HelpHowToUseItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    StatusLine: TStatusBar;
    PrintDialog: TPrintDialog;
    PrintSetupDialog: TPrinterSetupDialog;
    SpeedBar: TPanel;
    SpeedButton1: TSpeedButton; { P&rint Setup... }
    SpeedButton2: TSpeedButton; { E&xit }
    SpeedButton3: TSpeedButton; { &Contents }
    SpeedButton4: TSpeedButton; { &Search for Help On... }
    SpeedButton5: TSpeedButton; { &How to Use Help }
    SpeedButton6: TSpeedButton;
    ScrollBox1: TScrollBox;
    ScrollBox2: TScrollBox;
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    StringGrid1: TStringGrid; { &About... }
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FilePrintSetup(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure HelpContents(Sender: TObject);
    procedure HelpSearch(Sender: TObject);
    procedure HelpHowToUse(Sender: TObject);
    procedure HelpAbout(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  public
    procedure InitializeTheGame;
    procedure CheckGameMove(From: TDXPlayPlayer);
    procedure AssignGameGridPos(From: TDXPlayPlayer);
  end;

var
  MainForm: TMainForm;
  MyGamePlayRecArray: GamePlayRecArray;

implementation

uses About, SConfig, SChatMod;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  TheGameNameIs := 'Game';
  MyPlayerShortNameIs := 'Sysop';
  Application.OnHint := ShowHint;
  Randomize;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.SimpleText := Application.Hint;
end;

procedure TMainForm.FilePrintSetup(Sender: TObject);
begin
  PrintSetupDialog.Execute;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.HelpContents(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.HelpSearch(Sender: TObject);
const
  EmptyString: PChar = '';
begin
  Application.HelpCommand(HELP_PARTIALKEY, Longint(EmptyString));
end;

procedure TMainForm.HelpHowToUse(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TMainForm.HelpAbout(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  ConfigForm: TConfigForm;
begin
  TheGameHostIs := SCom1.DXPlay1.TCPIPSetting.HostName;
  TheGamePortIs := SCom1.DXPlay1.TCPIPSetting.Port;
  //Starts up the server and bring's it online
  ServerIsUp := False;
  try
    ConfigForm := TConfigForm.Create(Self);
    try
      ConfigForm.DXPlay := SCom1.DXPlay1;
      ConfigForm.ShowModal;
      if ConfigForm.Tag = 0 then Abort;
    finally
      ConfigForm.Free;
    end;
  except
    on E: Exception do
    begin
      Application.HandleException(E);
      Memo1.Lines.Add('Error unable to start up!');
    end;
  end;
  if ServerIsUp = True then
  begin
    SCom1.InitPlayerGameDataArray;
    InitializeTheGame;
    Memo1.Lines.Add('Server is online.');
  end;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  ServerIsUp := False;
  Memo1.Lines.Add('Server has been closed down.');
  SCom1.DXPlay1.Close;
end;

procedure TMainForm.AssignGameGridPos(From: TDXPlayPlayer);
var
  HasBeenPlaced: Boolean;
  PlayerIndexNumIs: Integer;
  tempX, tempY: Integer;
  PlayerInfoStr: string;
begin
  PlayerIndexNumIs := SCom1.FindPlayerGameDataRec(From);
  HasBeenPlaced := False;
  while HasBeenPlaced = False do
  begin
    tempX := Random(7);
    tempY := Random(6);
    if StringGrid1.Cells[tempx, tempy] = '-' then
    begin
      MyGamePlayRecArray[PlayerIndexNumIs].CurrX := tempX;
      MyGamePlayRecArray[PlayerIndexNumIs].CurrY := tempY;
      MyGamePlayRecArray[PlayerIndexNumIs].ServerID := IntToStr(PlayerIndexNumIs);
      HasBeenPlaced := True;
      StringGrid1.Cells[tempx, tempy] := IntToStr(PlayerIndexNumIs);
    end;
  end;
  PlayerInfoStr := IntToStr(PlayerIndexNumIs) + '~' + IntToStr(tempX) + '~' + IntToStr(tempY) + '~';
  PlayerIDSelected := From.ID;
  SCom1.Send_GameDataMsg(7, PlayerInfoStr, PlayerIDSelected);
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
{Starts up the chat module}
  ChatModForm1.ShowModal;
end;

procedure TMainForm.InitializeTheGame;
var
  I, J: Integer;
begin
  for I := 0 to StringGrid1.ColCount - 1 do
  begin
    for J := 0 to StringGrid1.RowCount - 1 do
    begin
      StringGrid1.Cells[I, J] := '-';
    end;
  end;
end;

procedure TMainForm.CheckGameMove(From: TDXPlayPlayer);
var
  tempx, tempy: Integer;
  PlayerIndexNumIs: Integer;
begin
{  We check the move the player wants to make and notify player
   of the results
}
  PlayerIndexNumIs := SCom1.FindPlayerGameDataRec(From);
  case MyPlayerDataRecArray[PlayerIndexNumIs].PlayerGameFlagIs of
    1: begin //Player Moving North
        tempy := MyGamePlayRecArray[PlayerIndexNumIs].CurrY - 1;
        tempx := MyGamePlayRecArray[PlayerIndexNumIs].CurrX;
        if (tempy >= 0) and (StringGrid1.Cells[tempx, tempy] = '-') then
        begin
          StringGrid1.Cells[tempx, tempy] := IntToStr(PlayerIndexNumIs);
          StringGrid1.Cells[tempx, MyGamePlayRecArray[PlayerIndexNumIs].CurrY] := '-';
          MyGamePlayRecArray[PlayerIndexNumIs].CurrY := tempy;
          SCom1.Send_GameDataMsg(5, 'None', From.ID);
        end
        else
        begin
          SCom1.Send_GameDataMsg(6, 'None', From.ID);
        end;
      end;
    2: begin //Player Moving East
        tempy := MyGamePlayRecArray[PlayerIndexNumIs].CurrY;
        tempx := MyGamePlayRecArray[PlayerIndexNumIs].CurrX + 1;
        if (tempx <= 7) and (StringGrid1.Cells[tempx, tempy] = '-') then
        begin
          StringGrid1.Cells[tempx, tempy] := IntToStr(PlayerIndexNumIs);
          StringGrid1.Cells[MyGamePlayRecArray[PlayerIndexNumIs].CurrX, tempy] := '-';
          MyGamePlayRecArray[PlayerIndexNumIs].CurrX := tempx;
          SCom1.Send_GameDataMsg(5, 'None', From.ID);
        end
        else
        begin
          SCom1.Send_GameDataMsg(6, 'None', From.ID);
        end;
      end;
    3: begin //Player Moving South
        tempy := MyGamePlayRecArray[PlayerIndexNumIs].CurrY + 1;
        tempx := MyGamePlayRecArray[PlayerIndexNumIs].CurrX;
        if (tempy <= 6) and (StringGrid1.Cells[tempx, tempy] = '-') then
        begin
          StringGrid1.Cells[tempx, tempy] := IntToStr(PlayerIndexNumIs);
          StringGrid1.Cells[tempx, MyGamePlayRecArray[PlayerIndexNumIs].CurrY] := '-';
          MyGamePlayRecArray[PlayerIndexNumIs].CurrY := tempy;
          SCom1.Send_GameDataMsg(5, 'None', From.ID);
        end
        else
        begin
          SCom1.Send_GameDataMsg(6, 'None', From.ID);
        end;
      end;
    4: begin //Player Moving West
        tempy := MyGamePlayRecArray[PlayerIndexNumIs].CurrY;
        tempx := MyGamePlayRecArray[PlayerIndexNumIs].CurrX - 1;
        if (tempx >= 0) and (StringGrid1.Cells[tempx, tempy] = '-') then
        begin
          StringGrid1.Cells[tempx, tempy] := IntToStr(PlayerIndexNumIs);
          StringGrid1.Cells[MyGamePlayRecArray[PlayerIndexNumIs].CurrX, tempy] := '-';
          MyGamePlayRecArray[PlayerIndexNumIs].CurrX := tempx;
          SCom1.Send_GameDataMsg(5, 'None', From.ID);
        end
        else
        begin
          SCom1.Send_GameDataMsg(6, 'None', From.ID);
        end;
      end;
  end;
end;

end.

