unit SChatMod;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, Grids, DirectX;

type
  TChatModForm1 = class(TForm)
    CancelBtn: TButton;
    Bevel1: TBevel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    GroupBox3: TGroupBox;
    Memo1: TMemo;
    Button1: TButton;
    StringGrid1: TStringGrid;
    CheckBox1: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ChatModForm1: TChatModForm1;
  RowYChoice: Integer;

implementation

uses SComFunc, Main;

{$R *.DFM}

procedure TChatModForm1.FormActivate(Sender: TObject);
var
  i: Integer;
  xcoord: Integer;
  j, k: Integer;
begin
  for k := 0 to StringGrid1.ColCount - 1 do
  begin
    for j := 0 to StringGrid1.RowCount - 1 do
    begin
      StringGrid1.Cells[k, j] := '';
    end;
  end;
  StringGrid1.RowCount := SCom1.DXPlay1.Players.Count + 1;
  StringGrid1.Cells[0, 0] := 'ID Number';
  StringGrid1.Cells[1, 0] := 'Player Name';
  for i := 0 to SCom1.DXPlay1.Players.Count - 1 do
  begin
    if SCom1.DXPlay1.Players[i].RemotePlayer then
    begin
      StringGrid1.Cells[0, i] := IntToStr(SCom1.DXPlay1.Players[i].ID);
      StringGrid1.Cells[1, i] := SCom1.DXPlay1.Players[i].Name;
    end;
  end;
  RowYChoice := 1;
  if CheckBox1.Checked then StringGrid1.Enabled := True else
    StringGrid1.Enabled := False;
end;

procedure TChatModForm1.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
  begin
    Button1Click(nil);
    key := 0;
  end;
end;

procedure TChatModForm1.Button1Click(Sender: TObject);
var
  temp3, s: string;
begin
  PlayerIDSelected := StrToInt(StringGrid1.Cells[0, RowYChoice]);
  if Edit1.Text <> '' then
  begin
    if CheckBox1.Checked then
    begin
      SCom1.Send_GameDataMsg(999, trim(Edit1.Text), DPID_ALLPLAYERS);
    end
    else
    begin
      SCom1.Send_GameDataMsg(999, trim(Edit1.Text), PlayerIDSelected);
    end;
    Memo1.Lines.Add('You>>' + trim(Edit1.Text));
    Edit1.Text := '';
    Edit1.SetFocus;
    Update;
  end;
end;

procedure TChatModForm1.StringGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  RowYChoice := ARow;
end;

procedure TChatModForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then StringGrid1.Enabled := True else
    StringGrid1.Enabled := False;
end;

end.

