/*
	LORD II Structures

        Converted from Turbo Pascal to C by Mike Dillon aka GSValore.

	These structures were directly translated from the 3RDPARTY.DOC
	file found in the LORDII archive and directory.  LORD II was
	written by Seth Able and is now owned by Metropolis gameport.

	****Use these structures at your own risk!!!

        Tested with: 
                     Visual C++ 4.0 Standard edition.
                     DJGPP 2.952

        Revision:
                05-20-2000 Made the structures completely compatible
                           with ANSI C compilers.

	-- THESE STRUCTURES ARE PUBLIC DOMAIN --

        LORD II Copyright (C) Metropolis Gameport.
        Visual C++ Copyright (C) Microsoft Corp.
        DJGPP Copyright (C) D.J. Delorie
        Turbo Pascal Copyright (C) Inprise Corp.
*/

#if !defined( LORD2_STRUCTURES__H )
#define LORD2_STRUCTURES__H 1

/* 
/* Structure alignment must be 1 for the size to be correct. */
/* If your compiler supports pragma pack(), then set this    */
/* line to include your compiler                             */
#if defined( _WIN32 ) || defined( DJGPP )
        #pragma pack( 1 )
#endif

/* Structure for the ITEMS.DAT file                                  */
/* There are 99 records in the ITEMS.DAT file you must not go beyond */
/* this limit.                                                       */
typedef struct {
        signed char             name[ 31 ];     /* Name of the Item                                     */
        signed char             action[ 41 ];   /* String said when item used                           */
        unsigned char           use_once;       /* Can only use once (BOOLEAN)                          */
        unsigned char           armour;         /* Item Armour? (BOOLEAN)                               */
        unsigned char           weapon;         /* Item Weapon? (BOOLEAN)                               */
        unsigned char           sell;           /* Unknown (BOOLEAN)                                    */
        unsigned char           used;           /* Item Used? (BOOLEAN)                                 */
        signed long int         value;          /* Item's Value                                         */
        signed short int        breakage;       /* Break percentage per usage                           */
        signed short int        max_buy;        /* Unused                                               */
        signed short int        def;            /* Defense added when equipped                          */
        signed short int        strength;       /* Strength added when equipped                         */
        signed short int        eat;            /* Unused                                               */
        signed char             ref[ 13 ];      /* Label of .REF procedure                              */
        signed char             string[ 31 ];   /* String for using this item with the .REF             */
        signed char             descrip[ 31 ];  /* Description shown to the right                       */
        unsigned char           drop;           /* Can item be dropped or is it a quest item? (BOOLEAN) */
        signed char             extra[ 37 ];    /* RESERVED!                                            */
} l2_item;

/* There are a MAX of 200 players in the TRADER.DAT file.  Do not go      */
/* beyond this max. Any players above #200 will not be read or used, and  */
/* will be lost.                                                          */
typedef struct {                                                                  
        signed char             name[ 26 ];       /* User's Handle in LORD II       */
        signed char             real_names[ 41 ]; /* User's name from the BBS       */
        signed long int         gold;             /* Amount of gold user has        */
        signed long int         bank;             /* Amount of gold in the bank     */
        signed long int         exp;              /* Not used but RESERVED          */
        signed short int        last_day_on;      /* Last day user was on           */
        signed short int        love;             /* Not used but RESERVED          */
        signed char             wep;              /* item # of the weapon           */
                                                  /* the user has equipped          */
        signed char             arm;              /* item # of the armour           */
                                                  /* the user has equipped          */
        signed char             race[ 31 ];       /* RESERVED!                      */
        signed short int        sex_male;         /* 1 if male, otherwise female    */
        unsigned char           on_now;           /* 0 if the user isn't online     */
        unsigned char           battle;           /* User is offline if 0           */
                                                  /* otherwise user is battling     */
        signed short int        dead;             /* User is dead (0,1)             */
        signed short int        busy;             /* User is busy (0,1)             */
        signed short int        deleted;          /* User is deleted (0,1)          */
        signed short int        nice;             /* User is nice?!                 */
        signed short int        map;              /* Map block # user is in         */
        signed short int        e6;               /* Unknown                        */
        signed short int        x;                /* Current X coord of the user    */
        signed short int        y;                /* Current Y coord of the user    */
        signed short int        item[ 99 ];       /* Unknown "items. Used by `i"    */
        signed long int         p[ 99 ];          /* Unknown "longints. Used by `i" */
        unsigned char           b[ 99 ];          /* Unknown "bytes. Used by `i"    */
        signed long int         last_saved;       /* Last day saved                 */
        signed long int         last_day_played;  /* Last day user played           */
        signed short int        lmap;             /* Last map user was visible on   */
        signed char             extra[ 354 ];     /* RESERVED!                      */
} l2_player;

/* Layout info for each square of a map */
typedef struct {
        signed char             fc;             /* Foreground color of the square */
        signed char             bc;             /* Background color of the square */
        signed char             c;              /* Char, unknown                  */
        signed short int        t;              /* Unknown                        */
        signed char             s;              /* Type of terrain                */
} l2_map_info;
/* NOTES on Terrain (Value of s for struct l2_map_info): */
/* s = 0        UNPASSABLE                               */
/* s = 1        GRASS                                    */
/* s = 2        ROCKY                                    */
/* s = 3        WATER                                    */
/* s = 4        OCEAN                                    */
/* s = 5        FOREST                                   */


/* Structure of the 10 most hotspots for each given map screen */
typedef struct {
        signed short int        move_place;     /* map to move to, 0 if not a warp           */
        signed char             dx;             /* x coord of hotspot, 0 if hotspot not used */
        signed char             dy;             /* y coord of hotspot, 0 if hotspot not used */
        signed char             x;              /* x coord of warp destination               */
                                                /* 0 if not a warp                           */
        signed char             y;              /* y coord of warp destination               */
                                                /* 0 if not a warp                           */
        signed char             refname[ 13 ];  /* label of the .REF procedure               */
                                                /* to run, if not a warp                     */
        signed char             reffile[ 13 ];  /* filename of the .REF to run               */
                                                /* if not a warp                             */
        signed char             extra[ 100 ];   /* RESERVED!                                 */
} l2_map_special;

/* Primary map structure, this contains the 2 above structures. */
/* Each screen contains this structure.  These structures can   */
/* be found in the MAP.DAT file.                                */
typedef struct {
        signed char             name[ 31 ];     /* Name of the Screen       */
        l2_map_info             w[ 80 ][ 20 ];  /* Array of each block      */
                                                /* of the screen            */
        l2_map_special          special[ 10 ];  /* Array of the 10 hotspots */
        signed long int         battle_odds;    /* Odds of running the      */
                                                /* screen random ref        */
        signed char             batfile[ 13 ];  /* .REF file name           */
        signed char             batname[ 13 ];  /* Label of .REF procedure  */
        signed char             safe;           /* true if players cannot   */
                                                /* fight on this screen     */
                                                /* (BOOLEAN)                */
        signed char             extra[ 469 ];   /* RESERVED!                */
} l2_map;

/* Structure for the layout of the world.dat file.                        */
/* -- EXCERPT --                                                          */
/* For the world.dat file -  this is kind of                              */
/* the index for the MAP.REF file.  It tells LORD2 how each screen hooks  */
/* to each other.  loc is each screen - starting at x1,y1 is 1, then this */
/* goes right until 80 is reached, then starts at x1,y2 for 81 etc.       */
typedef struct {
        signed char             name[ 61 ];         /* Name of??                  */
        signed short int        loc[ 1600 ];        /* Physical map location      */
                                                    /* within the MAP.DAT file    */
                                                    /* for this screen.  If the # */
                                                    /* is 0 then there is no map  */
                                                    /* there.                     */
        signed long int         v[ 40 ];            /* used by `v ?               */
        signed char             string[ 10 ][ 81 ]; /* used by `s ?               */
        signed long int         time;               /* year+month+day (Unknown)   */
        unsigned char           show[ 1600 ];       /* Players on the auto 'map'? */
        signed char             extra[ 396 ];       /* RESERVED                   */
} l2_world_info;

/* Structure for the .IDF files.      */
/* This is for the @data information. */
typedef struct {
        signed long int         last_used;      /* used to tell @datanewday  */
                                                /* to reset or not if the    */
                                                /* value was from the day    */
                                                /* previous                  */
        signed long int         data[ 200 ];    /* The actual data to retain */
        signed char             extra[ 200 ];   /* RESERVED                  */
} l2_igm_data;

/* The structure of the update.tmp file.  This is a CURRENT record */
/* of what is going on in real-time.  Each player has a record (if */
/* online) in this file.                                           */
typedef struct {
        signed char             x;      /* X coord of the player's position */
        signed char             y;      /* Y coord of the player's position */
        signed short int        map;    /* Map # the player is in           */
        signed char             on_now; /* Indicator to if the player is on */
        signed char             busy;   /* Is the player busy?              */
                                        /* on_now & busy are value 1        */
                                        /* for true, 0 for false            */
        signed char             battle; /* Is the player engaged in battle? */
} l2_update;

#endif

/* -- END OF FILE -- */
