Program Latrine_Docs;

uses dos,crt,screen;

const
  maxlines = 13000;
  Alt_H = #35;
  Alt_S = #31;
  Up = #72;
  Down = #80;
  PageUp = #73;
  PageDown = #81;
{  UpKey        =$0148; DownKey       =$0150;
  LeftKey      =$014B; RightKey      =$014D;
  PageUp       =$0149; PageDown      =$0151;}

type
  adaptertype = (MDA,CGA,EGAMono,EGAColor);

var
  string_found : boolean;
  search_str : string;
  ch, ch2 : char;
  n : string[30];
  copyfile,f : text;
  newname,iline : string;
  firstnum,lastnum,i,counter : integer;
  first,quit : boolean;
  Lines : Array[1..maxlines] of ^string;
  x,linesread,linenum : longint;

Procedure Disposevars;
Begin
  for linenum := 1 to (linesread - 1) do
    dispose(lines[linenum]);
end;

Procedure UpString(var S : string);

var
  x : integer;
  tstr : string;

Begin
  tstr := '';
  for x := 1 to length(s) DO
  tstr := tstr + upcase(s[x]);
  s := tstr;
end;

Function UpStr(var S : string) : string;

var
  x : integer;
  tstr : string;

Begin
  tstr := '';
  for x := 1 to length(s) DO
  tstr := tstr + upcase(s[x]);
  upstr := tstr;
end;

Procedure NotFound;
Begin
  writeln('File not found - ' + paramstr(1));
  halt(0);
end;

Function Exist(var a : text) : boolean;
Begin
{$I-}
  Reset(a);
{$I+}
  If IOResult <> 0 then exist := false else exist := true;
{$I-}
  close(a);
{$I+}
end;

Procedure Help;
Begin
  save_screen;
  window(24,9,54,14);
  textbackground(0);
  textcolor(15);
  clrscr;
  gotoxy(1,1);
  writeln(' Help ͻ');
  writeln('                            ');
  writeln('  Alt-H     Help Menu       ');
  writeln('  Alt-S     Search for text ');
  writeln('  Esc       Exit            ');
  write('ͼ');
  ch:=readkey;
  textbackground(0);
  textcolor(7);
  window(1,1,80,24);
  restore_screen;
end;

Procedure Search;
var i : integer;
Begin
  save_screen;
  window(1,1,80,25);
  gotoxy(1,25);
  textbackground(1);
  textcolor(15);
  clreol;
  cursor_on;
  write(' Search for: ');
  search_str := '';
  repeat
    ch := readkey;
    if (ch<>#8) and (ch<>#13) and (length(search_str) < 55) then
    Begin
      search_str := search_str + ch;
      write(ch);
    end;
    if ch=#8 then
    Begin
      if length(search_str) > 0 then
      begin
        delete(search_str, length(search_str), 1);
        write(#8);
        write(' ');
        write(#8);
      end;
    end;
  until ch=#13;
  i := 0;
  repeat
    i := i + 1;
    string_found := false;
    if pos(upstr(search_str),upstr(lines[i]^)) > 0 then
    string_found := true
      else
    string_found := false;
  until (i >= linesread) or (string_found);

  if string_found then
  begin
    cursor_off;
    firstnum := i;
    lastnum := i + 23;
    window(1,1,80,24);
    textbackground(0);
    textcolor(7);
    clrscr;
    for x := firstnum to lastnum do
      if lines[x]^ = '' then writeln else
        writeln(lines[x]^);
    gotoxy( ( pos(search_str,lines[i]^) ), 1);
    for x := 1 to length(search_str) do
    Begin
      textcolor(15);
      textbackground(7);
      write(lines[i]^[x + pos(search_str,lines[i]^)]);
    end;
    textbackground(0);
    textcolor(7);
    ch := readkey;
    restore_screen;
  end;

  if not(string_found) then
  Begin
    cursor_off;
    gotoxy(40-length('** String not found **') div 2, 25);
    textcolor(15);
    textbackground(1);
    write('** String not found **');
    ch := readkey;
    restore_screen;
  end;

  window(1,1,80,24);
  textbackground(0);
  textcolor(7);
  cursor_off;
end;

Procedure Status_line;
var
  x,y : integer;
  temp : string;

Begin
  x:=wherex;
  y:=wherey;
  cursor_off;
  window(1,1,80,25);
  gotoxy(1,25);
  textcolor(15);
  textbackground(1);
  clreol;
  upstring(newname);
  str(linesread,temp);
  gotoxy(40-(length('Viewing file ' + newname + ' (' + temp + ' lines)  Press Alt-H for help ') div 2),25);
  write('Viewing file ' + newname + ' (' + temp + ' lines)   Press Alt-H for help');first:=false;
  window(1,1,80,24);
  gotoxy(x,y);
  textcolor(7);
  textbackground(0);
end;

Procedure DisplayFile;
Begin
  clrscr;
  cursor_off;
  textbackground(0);
  textcolor(7);
  clrscr;
  for linenum := 1 to 24 do
    if lines[linenum]^ = '' then writeln else
      writeln(lines[linenum]^);
  firstnum:=1;lastnum:=24;
  status_line;
  repeat
  ch := readkey;
  if ch = #0 then
  Begin
  ch2 := readkey;
  CASE ch2 of
    Alt_S : search;
    Alt_H : help;
    PageUp: Begin
              firstnum:=firstnum-24;
              lastnum:=lastnum-24;
              if firstnum<1 then
              repeat
                firstnum:=firstnum+1;
                lastnum:=lastnum+1;
              until firstnum=1;
              clrscr;
              for i := firstnum to lastnum-1 do
                writeln(lines[i]^);
            end;
    PageDown : Begin
                 firstnum:=firstnum+24;
                 lastnum:=lastnum+24;
                 if lastnum>linesread then
                 repeat
                   firstnum:=firstnum-1;
                   lastnum:=lastnum-1;
                 until lastnum = linesread;
                 clrscr;
                 for i := firstnum to lastnum-1 do
                     writeln(lines[i]^);
               end;
       Up : Begin
              firstnum:=firstnum-1;
              lastnum:=lastnum-1;
              if (firstnum<1) and (lastnum<24) then
              Begin
                firstnum:=1;
                lastnum:=24;
                gotoxy(1,1);clreol;
                write(lines[firstnum]^);
              end else
              if firstnum>=1 then
              Begin
                gotoxy(1,1);
                insline;
                write(lines[firstnum]^);
              end;
            end;
     Down : Begin
              firstnum:=firstnum+1;
              lastnum:=lastnum+1;
              if lastnum>linesread then
              Begin
                lastnum:=linesread;
                firstnum:=firstnum-1;
              end else
              if lastnum<=linesread then
              Begin
                gotoxy(1,1);
                delline;
                gotoxy(1,24);
                write(lines[lastnum]^);
              end;
            end;
  end;
  end;
  Until ch = #27;
window(1,1,80,25);
gotoxy(1,25);
textbackground(0);
textcolor(7);
clreol;
writeln;
cursor_on;
disposevars;
end;

Begin
  cursor_on;
  first:=true;
  quit := false;
  firstnum := 1;
  lastnum := 24;
  if paramcount = 0 then
  Begin
    newname:='LATRINE.DOC';
    assign(f,newname);
    if NOT(exist(f)) then notfound;
    reset(f);
    linenum := 1;
    repeat
      readln(f,iline);
      new(lines[linenum]);
      (lines[linenum]^) := iline;
      linesread := linenum;
      if linesread >= maxlines then
      Begin
        writeln('File too large - ' + newname);
        disposevars;
        halt(0);
      end;
      linenum := linenum + 1;
    until eof(f);
    displayfile;
  end else
  Begin
    newname := paramstr(1);
    assign(f,newname);
    if NOT(exist(f)) then notfound;
    reset(f);
    linenum := 1;
    repeat
      readln(f,iline);
      new(lines[linenum]);
      (lines[linenum]^) := iline;
      linesread := linenum;
      if linesread >= maxlines then
      Begin
        writeln('File too large - ' + newname);
        disposevars;
        halt(0);
      end;
      linenum := linenum + 1;
    until eof(f);
{    if linesread < 24 then
    Begin
      for i := linesread to 24 do
      Begin
        new(lines[linenum]);
        lines[linenum]^ := '';
      end;
      linesread := 24;
    end;}
    DisplayFile;
  end;
  close(f);
  cursor_on;
end.