Unit MStuff;
{$O+}
Interface

uses dos,crt,ddscott,ddovr,screen;

function stu(s: string): string;
Procedure lPrompt(var s : string; i : integer);
Procedure lwriteln(s:string);
Procedure lwrite(s:string);
FUNCTiON GetChar:Char;
procedure fwriteln(s:string);
procedure fwrite(s:string);
Procedure lMore;
Procedure Display_menu(s : string; df : string);
Procedure cursoroff;
Procedure cursoron;
Procedure Center(x:integer;s:string);
Function Exist(s : string) : Boolean;
Function Comma(i:longint) : string;
Procedure Upstr(var s : string);
Procedure Instruct;

type player_info = record
  names: string[20]; {player handle in the game}
  real_names: string[50] {real name/or handle from BBS} ;
  hit_points  {player hit points}
  ,bad  {don't know - might not be used at all}
  ,rate: integer; {again, couldn't find this one in the source}
  hit_max: integer; {hit_point max}
  weapon_num: integer; {weapon number}
  weapon: string[20]; {name of weapon}
  seen_master: integer; {equals 5 if seen master, else 0}
  fights_left: integer; {forest fights left}
  human_left: integer; {human fights left}
  gold: longint; {gold in hand}
  bank: longint; {gold in bank}
  def: integer;  {total defense points }
  strength: integer; {total strength}
  charm: integer; {good looking meter}
  seen_dragon: integer; {seen dragon?  5 if yes else 0}
  seen_violet: integer; {seen violet?  5 if yes else 0}
  level: integer; {level of player}
  time: word; {day # that player last played on}
  arm: string[20]; {armour name}
  arm_num: integer; {armour number}
  dead: shortint; {player dead?  5 if yes else 0}
  inn: shortint; {player sleeping at inn?  5 if yes else 0}
  gem: integer; {# of gems on hand}
  exp: longint; {experience}
  sex: shortint; {gender, 5 if female else 0}
  seen_bard: shortint; {seen bard?  5 if yes else 0}
  last_alive_time: integer; {day # player was last reincarnated on}
  Lays: integer; {players lays stat}
  Why: integer; {not used yet}
  on_now: boolean; {is player on?}
  m_time: integer; {day on_now stat was last used}
  time_on: string[5]; {time player logged on in Hour:Minutes format}
  class: shortint; {class, should be 1, 2 or 3}
  extra: integer;      {*NEW*  If 1, player has a horse}
  love: string[25]; {not used - may be used for inter-player marrages later}
  married: integer; {who player is married to, should be -1 if not married}
  kids: integer; {# of kids}
  king: integer; {# of times player has won game}
  skillw: shortint; {number of Death Knight skill points}
  skillm: shortint; {number of Mystical Skills points}
  skillt: shortint; {number of Thieving Skills points}

  levelw: shortint; {number of Death Knight skill uses left today}
  levelm: shortint; {number of Mystical skill uses left today}
  levelt: shortint; {number of Thieving skill uses left today}

  inn_random: boolean; {not used yet}
  married_to: integer; {same as Married, I think - don't know why it's here}
  v1: longint;
  v2: integer; {# of player kills}
  v3: integer; {if 5, 'wierd' event in forest will happen}
  v4: boolean; {has player done 'special' for that day?}
  v5: shortint; {has player flirted with another player that day?  if so, 5}
  new_stat1: shortint;
  new_stat2: shortint;  {these 3 are unused right now}
  new_stat3: shortint;  {Warning: Joseph's NPCLORD screws with all three}
end;

type monst = record
           name: string[60];
           strength: longint;
           gold: longint;
           weapon: string[60];
           exp_points: longint;
           hit_points: longint;
           death: string[100]; {shown when monster is killed by power move}
end;

type
  lat_player = record
                real_name : string[50]; {BBS name}
                handle : string[20]; {Handle in LORD}
                account : byte; {Account # in LORD}
                chal : boolean; {Are they challenged for drinking contest?}
                challenges : integer; {How many challenges left?}
                contest : integer; {How many contests have they won?}
                drunk : boolean; {Are they drunk?}
                expert_m : boolean; {Expert Mode on?}
                whore : boolean; {Been with whore?}
                machine : boolean; {Look at Mechanism on wall (main menu)}
                alive : boolean; {Alive?}
                times : integer; {How many times have they been to the bathroom?}
                been : boolean; {Been to the bathroom?}
                find : boolean; {Searched in "Deeper" menu?}
                c1 : boolean; {Done a cheat code?}
                c2 : boolean; {Done a cheat code?}
                fight : byte; {# of dungeon fights}
               end;

{  list_ptr = ^lat_player_list;}
  lat_player_list = record
           handle : string[20]; {Handle in LORD}
           account : byte; {Account # in LORD}
           contest : integer; {How many contests have they won?}
           times : integer; {How many times have they been to the bathroom?}
           level: byte; {level of player}
           total : integer; {Relief times plus Contest wins}
{           next : list_ptr;
           prev : list_ptr;}
          end;

type
  registration = record
                   first_name : string;
                   last_name : string;
                   bbsname : string;
                   registered : boolean;
                   reg1 : longint;
                   reg2 : longint;
                   reg3 : longint;
                 end;

type
  big_list = array[1..150] of lat_player_list;

Procedure Rank_Players(lat:lat_player);
Procedure Inn(o:lat_player; l:player_info);
Procedure Searchplayers(s : string; vgood : boolean; blank : boolean; play : lat_player);

type time_chk = record
                  year : integer;
                  month : integer;
                  day : integer;
                end;

const
  pf = 'PLAYER.DAT';
  opf= 'LPLYRS.DAT';
  tf = 'LTMCHK.DAT';
  mf = 'BENEMY.DAT';

var
  regf : file of registration;
  reg_info : registration;
  temp_list : big_list;
  f : text;
  tempstr : ^string;
  bl,test : boolean;
  player : player_info;
  lplayer : player_info;
  lfile : file of player_info;
  tempo : lat_player;
  outp : lat_player;
  challenge : lat_player;
  num_cha,num,say,which,bs,ffights,lnum,i : integer;
  yr,mon,day,dof : word;
  multi,q,p,first : boolean;
  w : string;
  ch : char;
  play,b : boolean;
  otf : text;
  lf : file of player_info;
  out : file of lat_player;
  om : file of monst;
  timef : file of time_chk;
  time : time_chk;
  monster : monst;

Implementation

uses mons,configs,ddplus,netfilep;

function stu(s: string): string;
var
 a: integer;
begin;
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 stu:=s;
end;

Procedure lPrompt(var s : string; i : integer);
var
  ch_ : char;
  x,y : integer;

Begin
  x:=wherex;
  y:=wherey;
  s:='';
  ch:=#0;
  repeat
    ch:=readkey;
    if (ch <> #8) and (ch <> #13) and (length(s)<i) then
    Begin
      s:=s+ch;
      write(ch);
    end;
    if ch = #8 then
    Begin
      delete(s,length(s),1);
      if x<wherex then
      Begin
        write(#8);
        write(' ');
        write(#8);
      end;
    end;
  until ch = #13;
end;

Procedure Searchplayers(s : string; vgood : boolean; blank : boolean; play : lat_player);
var
  temp : lat_player;
  good : boolean;
  yesno : char;
Begin
  blank:=false;
  vgood:=false;
  good:=false;
  if shareinst then filemode:=66;
  assign(out,'LPLYRS.DAT');
  reset(out);
  repeat
    good:=false;
    vgood:=false;
    read(out,temp);
    if pos(stu(s),stu(temp.handle)) > 0 then good:=true;
    if good then
    Begin
      fwrite('  `2You mean `0'+temp.handle+' `2[`5N`2]: ');
      repeat
        yesno := upcase(getchar);
      until yesno in ['Y','N',#13];
      if yesno = #13 then yesno:='N';
      CASE yesno of
        'Y' : Begin
               swriteln('Yes!');
               vgood:=true;
               bl:=false;
              end;
        'N' : Begin
                swriteln('No!');
                vgood:=false;
                bl:=true;
              end;
      end;
    end;
  until vgood or (eof(out));
  netclose(out);
  if shareinst then filemode:=64;
  if vgood then challenge:=temp;
  if vgood then test:=true else test:=false;
end;

Procedure Search_lord(s : string; vgood : boolean; blank : boolean; play : player_info);
var
  temp : player_info;
  good : boolean;
  yesno : char;
Begin
  blank:=false;
  vgood:=false;
  good:=false;
  if shareinst then filemode:=66;
  assign(lfile,lpath+'PLAYER.DAT');
  reset(lfile);
  repeat
    good:=false;
    vgood:=false;
    read(lfile,temp);
    if pos(stu(s),stu(temp.names)) > 0 then good:=true;
    if good then
    Begin
      fwrite('  `2You mean `0'+temp.names+' `2[`5N`2]: ');
      repeat
        yesno := upcase(getchar);
      until yesno in ['Y','N',#13];
      if yesno = #13 then yesno:='N';
      CASE yesno of
        'Y' : Begin
               swriteln('Yes!');
               vgood:=true;
               bl:=false;
              end;
        'N' : Begin
                swriteln('No!');
                vgood:=false;
                bl:=true;
              end;
      end;
    end;
  until vgood or (eof(lfile));
  netclose(lfile);
  if shareinst then filemode:=64;
end;

procedure lwriteln(s:string);
 var
   f,goo,h: string;
   done:boolean;
   q:byte;
  begin
    done := false;
    IF NOT POS('`',s) > 0 then begin
      writeln(s);
      exit;
    end;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] then
    begin
       goo := '';
       for q := 1 to POS('`',s)-1 do goo := goo + s[q];
       write(goo);
       CASE s[POS('`',s)+1] of
         '1':textcolor(1);
         '2':textcolor(2);
         '3':textcolor(3);
         '4':textcolor(4);
         '5':textcolor(5);
         '6':textcolor(6);
         '7':textcolor(7);
         '8':textcolor(8);
         '9':textcolor(9);
         '0':textcolor(10);
         '!':textcolor(11);
         '@':textcolor(12);
         '#':textcolor(13);
         '$':textcolor(14);
         '%':textcolor(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
    end;
   until POS('`',s) = 0;
   writeln(s);
  end;


procedure lwrite(s:string);
 var f,goo,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
    IF NOT POS('`',s) > 0 then begin
      writeln(s);
      exit;
    end;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] then begin
       goo := '';
       for q := 1 to POS('`',s)-1 do goo := goo + s[q];
       write(goo);
       CASE s[POS('`',s)+1] of
       '1':textcolor(1);
       '2':textcolor(2);
       '3':textcolor(3);
       '4':textcolor(4);
       '5':textcolor(5);
       '6':textcolor(6);
       '7':textcolor(7);
       '8':textcolor(8);
       '9':textcolor(9);
       '0':textcolor(10);
       '!':textcolor(11);
       '@':textcolor(12);
       '#':textcolor(13);
       '$':textcolor(14);
       '%':textcolor(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
   write(s);
  end;

FUNCTiON GetChar:Char;
 Var C:Char;
 Begin
  Sread_Char(C);
  GetChar:=C
 End;

procedure fwriteln(s:string);
 var f,g,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%','.'] then begin
       g := '';
       for q := 1 to POS('`',s)-1 do g := g + s[q];
       swrite(g);
       CASE s[POS('`',s)+1] of
       '.':swriteln('');
       '1':set_foreground(1);
       '2':set_foreground(2);
       '3':set_foreground(3);
       '4':set_foreground(4);
       '5':set_foreground(5);
       '6':set_foreground(6);
       '7':set_foreground(7);
       '8':set_foreground(8);
       '9':set_foreground(9);
       '0':set_foreground(10);
       '!':set_foreground(11);
       '@':set_foreground(12);
       '#':set_foreground(13);
       '$':set_foreground(14);
       '%':set_foreground(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
   swriteln(s);
  end;

procedure fwrite(s:string);
 var f,g,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
    IF NOT POS('`',s) > 0 then begin
      swrite(s);
      exit;
    end;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%','.'] then begin
       g := '';
       for q := 1 to POS('`',s)-1 do g := g + s[q];
       swrite(g);
       CASE s[POS('`',s)+1] of
       '.':swriteln('');
       '1':set_foreground(1);
       '2':set_foreground(2);
       '3':set_foreground(3);
       '4':set_foreground(4);
       '5':set_foreground(5);
       '6':set_foreground(6);
       '7':set_foreground(7);
       '8':set_foreground(8);
       '9':set_foreground(9);
       '0':set_foreground(10);
       '!':set_foreground(11);
       '@':set_foreground(12);
       '#':set_foreground(13);
       '$':set_foreground(14);
       '%':set_foreground(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
   swrite(s);
  end;

Procedure lMore;
var
b : integer;
ch : char;

Begin
  lwrite('`2<MORE>');
  ch := readkey;
  for b:=1 to 26 do
  write(chr(8));
  clreol;
End;

Procedure Display_menu(s : string; df : string);
var
  t : text;
  temp,l : string;
  g : boolean;

begin
  g := false;
  temp := s;
  upstr(temp);
  assign(t,df);
{$i-}
  reset(t);
{$I+}
  if ioresult <> 0 then
  begin
    set_foreground(15);
    swriteln('');
    swriteln(df+' file not found!  Please inform your sysop.');
{$I-}
    close(t);
{$I+}
    exit;
  end;
  reset(t);
  repeat
    readln(t,l);
    if pos('@#' + temp,l) > 0 then g := true else g := false;
  until g or eof(t);
  if not(g) then
  Begin
    close(t);
    exit;
  end else
  repeat
    readln(t,l);
    if (pos('@#',l) = 0) then fwriteln(l);
  until (pos('@#',l) > 0) or (eof(t));
  close(t);
end;

procedure cursoroff;
var
 regs: registers;
begin;
 regs.ax:=$0100;
 regs.cx:=$2000;
 intr($10,regs);
end;

procedure cursoron;
var
 regs: registers;
begin;
 regs.ax:=$0100;
 regs.ch:=determinepoints-2;
 regs.cl:=determinepoints-1;
 intr($10,regs);
end;

Procedure Center(x:integer;s:string);
Begin
  gotoxy(40-(length(s) div 2),x);
  writeln(s);
end;

Procedure sCenter(x:integer;s:string);
Begin
  sgoto_xy(40-(length(s) div 2),x);
  fwriteln(s);
end;

Function Exist(s : string) : Boolean;
var
  Inf: SearchRec;
begin
    findfirst(s,AnyFile,Inf);
    Exist := (DOSError = 0);
end;  {func Exist}

Function Comma(i:longint) : string;
var
  tem,tem1 : string;
begin
  tem1 := '';
  str(i,tem);
  if length(tem) = 10 then
  tem1 := tem[1]+','+tem[2]+tem[3]+tem[4]+','+tem[5]+tem[6]+tem[7]+','+tem[8]+tem[9]+tem[10];
  if length(tem) = 9 then
  tem1 := tem[1]+tem[2]+tem[3]+','+tem[4]+tem[5]+tem[6]+','+tem[7]+tem[8]+tem[9];
  if length(tem) = 8 then
  tem1 := tem[1]+tem[2]+','+tem[3]+tem[4]+tem[5]+','+tem[6]+tem[7]+tem[8];
  if length(tem) = 7 then
  tem1 := tem[1]+','+tem[2]+tem[3]+tem[4]+','+tem[5]+tem[6]+tem[7];
  if length(tem) = 6 then
  tem1 := tem[1]+tem[2]+tem[3]+','+tem[4]+tem[5]+tem[6];
  if length(tem) = 5 then
  tem1 := tem[1]+tem[2]+','+tem[3]+tem[4]+tem[5];
  if length(tem) = 4 then
  tem1 := tem[1]+','+tem[2]+tem[3]+tem[4];
  if length(tem) < 4 then tem1 := tem;
  comma := tem1;
end;

Procedure Upstr(var s : string);
var
  t : string;
  o : integer;
Begin
  t := '';
  for o := 1 to length(s) do
    t := t + upcase(s[o]);
  s := t;
end;

Procedure Instruct;
Begin
  textcolor(7);
  writeln;
  writeln('Type LREADME at the DOS prompt for correct usage.');
  halt(0);
end;

procedure QuickSort(var A: big_list; numElements : Integer);
var
  i, j : integer;
  temp : lat_player_list;

begin
  for i := 1 to numElements - 1 do
    for j := i + 1 to numElements do
    Begin
      if (a[i].total > a[j].total) then
      Begin
        temp := a[i];
        a[i] := a[j];
        a[j] := temp;
      end;
    end;
end;

Procedure Rank_players(lat:lat_player);
var
  temp_number : string[10];
  current_player : lat_player_list;
  player_file : file of lat_player;
  lord_pfile : file of player_info;
  lord_player : player_info;
  latrine_player : lat_player;

Begin
  sclrscr;
  swriteln('');swriteln('');
  sCenter(3, '  `%Latrine v3.0 Player Rankings');
  swriteln('');
  sCenter(5, '  `%Name                     Level         Contests Won         Times Relieved');
  sCenter(6, '`1-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');

  assign(player_file, 'LPLYRS.DAT');
  assign(lord_pfile, lpath+'PLAYER.DAT');
  if shareinst then filemode:=66;
  reset(player_file);
  reset(lord_pfile);

  for i := 1 to filesize(player_file) do
  Begin
    seek(player_file,(i-1));
    read(player_file,latrine_player);
    if latrine_player.handle = lat.handle then
    Begin
      temp_list[i].handle := lat.handle;
      temp_list[i].account := lat.account;
      temp_list[i].contest := lat.contest;
      temp_list[i].times := lat.times;
      seek(lord_pfile,temp_list[i].account);
      read(lord_pfile, lord_player);
      temp_list[i].level := lord_player.level;
      temp_list[i].total := temp_list[i].contest + temp_list[i].times;
    end else
    Begin
      temp_list[i].handle := latrine_player.handle;
      temp_list[i].account := latrine_player.account;
      temp_list[i].contest := latrine_player.contest;
      temp_list[i].times := latrine_player.times;
      seek(lord_pfile,temp_list[i].account);
      read(lord_pfile, lord_player);
      temp_list[i].level := lord_player.level;
      temp_list[i].total := temp_list[i].contest + temp_list[i].times;
    end;
  end;

  quicksort(temp_list, filesize(player_file));

  for i := filesize(player_file) downto 1 do
  Begin
    fwrite('  `0'+temp_list[i].handle);
    temp_number := comma(temp_list[i].level);
    sgoto_xy(30, wherey);
    fwrite('`2'+temp_number);
    temp_number := comma(temp_list[i].contest);
    sgoto_xy(47, wherey);
    fwrite('`%'+temp_number);
    temp_number := comma(temp_list[i].times);
    sgoto_xy(69, wherey);
    fwriteln('`#'+temp_number);
  end;

  netclose(player_file);
  netclose(lord_pfile);
  if shareinst then filemode:=64;
  swriteln('');
  more;
  first:=false;
end;

Procedure Inn(o:lat_player; l:player_info);
var
  subtract,pl1,pl2,loseexp,winexp : longint;
  k,where,wowee : integer;
  win1,win2,goo : boolean;
  round,attempts : byte;
  te : lat_player;
  gen1,gen2,acc : string[4];
  expsay,rs,message,opponent : string;
  y,y1 : char;
  f1,f2 : text;
  i1 : integer;
  s1,s2 : string;
  found : boolean;

Begin
  first:=true;
  str(o.account,s1);
  repeat
  if exist('LAT_C'+s1+'.DAT') then
  begin
    sclrscr;
    assign(f,'LAT_C'+s1+'.DAT');
    swriteln('');
    fwriteln('  `2Otak, the bartender, sees you and tells you `0(you can''t remember):');
    swriteln('');
    reset(f);
    repeat
      readln(f,s2);
      fwriteln('`%  '+s2);
    until eof(f);
    close(f);
    erase(f);
    swriteln('');more;
  end;
  repeat
    if first and not(o.expert_m) then display_menu('inn','LMENUS.DAT');
    if (o.expert_m) and (y='?') then display_menu('inn','LMENUS.DAT');
    first:=true;
    if scr then
    Begin
      swriteln('');
      fwriteln('  `5Inn of the Last Home  `8(? for Menu)');
      fwriteln('  `8(C,T,R)');
      swriteln('');
      fwrite('  `2Your command, `0' + lh + '`2? [`%');
      write(soutput,c);fwrite(':');write(soutput,d);
      fwrite('`2]:');
    end;
    scr:=true;
    y := upcase(getchar);
    if y='?' then swriteln('?');
  until y <> '?';
  q := true;
  if y in ['E','Q','X','C','T','?','R'] then q := false;
  if q then first := false;
  if y='Q' then y:='R';
  if (y<>#35) and (y<>#46) then swriteln(y);
  CASE y of
    'E' : Begin
            rank_players(o);
          end;
    'X' : Begin
            swriteln('');
            if o.expert_m then
            Begin
              o.expert_m := false;
              fwriteln('  `2EXPERT MODE `%OFF');
            end
            else
            if not(o.expert_m) then
            Begin
              o.expert_m:=true;
              fwriteln('  `2EXPERT MODE `%ON');
            end;
          end;
    'T' : Begin
            sclrscr;
            repeat
              repeat
                if first and not(o.expert_m) then display_menu('bar','lmenus.dat');
                if (o.expert_m) and (ch='?') then display_menu('bar','LMENUS.DAT');
                first:=true;
                if scr then
                Begin
                  swriteln('');
                  fwriteln('  `5Seat at the Bar  `8(? for Menu)');
                  fwriteln('  `8(O,W,R)');
                  swriteln('');
                  fwrite('  `2Your command, `0' + lh + '`2? [`%');
                  write(soutput,c);fwrite(':');write(soutput,d);
                  fwrite('`2]:');
                end;
                scr:=true;
                ch:=upcase(getchar);
                if ch='?' then swriteln('?');
              until ch <> '?';
              q := true;
              if ch in ['Q','X','O','C','?','R'] then q := false;
              if q then first := false;
              if (ch<>#35) and (ch<>#46) then swriteln(ch);
              if ch='Q' then ch:='R';
              CASE ch of
                'O' : Begin
                        if not(reg_info.registered) then
                        Begin
                          sclrscr;
                          swriteln('');
                          fwriteln('  `2Otak says, `0"Get your SysOp to register the Latrine.  It''s free!');
                          fwriteln('  `0All they have to do is send a letter to Vamsi Tadepalli!  Really!');
                          fwriteln('  `0It''s `%THAT `2easy!  Write ''em some email or something!  Until ');
                          fwriteln('  `0then, I can''t serve you anything to eat or drink.  Sorry."');
                          swriteln('');
                          more;
                        end else
                        if o.drunk then
                        Begin
                          swriteln('');
                          fwriteln('  `%You''ve had enough for today.');swriteln('');
                          more;first:=false;
                        end else
                        Begin
                        swriteln('');
                        fwriteln('  `2You tell the bartender you''d like something to drink.  He tells you what''s');
                        fwriteln('  `2available.');
                        swriteln('');more;
                        sclrscr;
                        swriteln('');swriteln('');
                        sCenter(3,'`%Available Items for Purchase  ');
                        swriteln('');
                        display_menu('items','lmenus.dat');
                        swriteln('');
                        fwriteln('  `5"Which would ya like?"');
                        fwrite('  `%:');
                        sread_num(i1);
                        CASE i1 of
                          1 : Begin
                                swriteln('');
                                fwrite('  `2"Thatta boy..a nice cold ale''ll do ya good.  ');
                                fwriteln('But it''ll cost ya `0500 gold`2."');
                                swriteln('');
                                fwrite('  `2You want it? [`5Y`2]: ');
                                repeat
                                  y := upcase(getchar);
                                until y in ['Y','N',#13];
                                if y = #13 then y:='Y';
                                CASE y of
                                  'Y' : Begin
                                          fwriteln('`0Yes!');
                                          swriteln('');
                                          Begin
                                          if l.gold >= 500 then
                                          Begin
                                            fwrite('  `0The bartender hands you a mug of ale, and you gulp it down.');
                                            swriteln('  ''sgood.');
                                            swriteln('');more;
                                            l.gold := l.gold - 500;
                                            o.drunk := true;
                                            k := l.level*5;
                                            str(k,s1);
                                            fwriteln('  `%You feel a bit more manly!  `2You gain `0' + s1 + '`2 experience!');
                                            l.exp:=l.exp+k;
                                            swriteln('');more;
                                          end else
                                          Begin
                                            fwriteln('  `4You fool!  You don''t have that much gold!');swriteln('');
                                            more;
                                          end;
                                          end;
                                        end;
                                  'N' : Begin
                                          fwriteln('`0No!');
                                          swriteln('');
                                          fwrite('  `2You didn''t seem like the manly man I thought you once to be,');
                                          swriteln(' anyway. Bye.');
                                          swriteln('');
                                          more;
                                        end;
                                end;
                              end;
                          2 : Begin
                                swriteln('');
                                fwrite('  `2"Oh, I love to see one taste my fine potatoes!');
                                swriteln('  Only problem is, ');
                                fwriteln('  they cost `02,500 gold`2."');
                                swriteln('');
                                fwrite('  `2You want ''em? [`5Y`2]: ');
                                repeat
                                  y := upcase(getchar);
                                until y in ['Y','N',#13];
                                if y = #13 then y:='Y';
                                CASE y of
                                  'Y' : Begin
                                          fwriteln('`0Yes!');
                                          swriteln('');
                                          Begin
                                          if l.gold >= 2500 then
                                          Begin
                                            fwrite('  `0It takes a while, but after Otak finishes cooking');
                                            swriteln(' his fine potatoes, ');
                                            swriteln('you figure it was worth the wait.');
                                            swriteln('');more;
                                            l.gold := l.gold - 2500;
                                            o.drunk := true;
                                            k := l.level*3;
                                            str(k,s1);
                                            fwrite('  `2Those potatoes are filled with...steroids?!  ');
                                            fwriteln('You gain `0'+s1+'`2 hit points!');
                                            l.hit_points:=l.hit_points+k;
                                            swriteln('');more;
                                          end else
                                          Begin
                                            fwriteln('  `4You fool!  You don''t have that much gold!');swriteln('');
                                            more;
                                          end;
                                          end;
                                        end;
                                  'N' : Begin
                                          fwriteln('`0No!');
                                          swriteln('');
                                          fwrite('  `2Oh, I see.  You want to tease me, like I''m some dog ');
                                          swriteln('or something, eh?');
                                          swriteln('');
                                          more;
                                        end;
                                end;
                              end;
                          3 : Begin
                                swriteln('');
                                fwriteln('  `2"You''re in for a real deal here!  Toilety water is');
                                fwriteln('  hard to find in these parts.  It''ll cost `03,400 gold`2."');
                                swriteln('');
                                fwrite('  `2You want it? [`5Y`2]: ');
                                repeat
                                  y := upcase(getchar);
                                until y in ['Y','N',#13];
                                if y = #13 then y:='Y';
                                CASE y of
                                  'Y' : Begin
                                          fwriteln('`0Yes!');
                                          swriteln('');
                                          Begin
                                          if l.gold >= 3400 then
                                          Begin
                                            fwrite('  `0Otak takes a bottle of ordinary looking water from under');
                                            swriteln(' the bar, ');
                                            swriteln('and pours a glass for you.  You drink.');
                                            swriteln('');more;
                                            l.gold := l.gold - 3400;
                                            o.drunk := true;
                                            k:=l.level;
                                            str(k,s1);
                                            l.hit_points:=l.hit_points-k;
                                            fwrite('  `%The water tastes terrible!  `4You lose '+s1+' hitpoint');
                                            if k>1 then swriteln('s!') else swriteln('!');
                                            swriteln('');more;
                                          end else
                                          Begin
                                            fwriteln('  `4You fool!  You don''t have that much gold!');swriteln('');
                                            more;
                                          end;
                                          end;
                                        end;
                                  'N' : Begin
                                          fwriteln('`0No!');
                                          swriteln('');
                                          fwriteln('  `2Not up to it today, huh?  Well, that''s ok.');
                                          swriteln('');
                                          more;
                                        end;
                                end;
                              end;
                          4 : Begin
                                swriteln('');
                                fwriteln('  `2"Ahh...a real man, I see before me.  The cost is `06,000 gold`2."');
                                swriteln('');
                                fwrite('  `2Are you up to it? [`5Y`2]: ');
                                repeat
                                  y := upcase(getchar);
                                until y in ['Y','N',#13];
                                if y = #13 then y:='Y';
                                CASE y of
                                  'Y' : Begin
                                          fwriteln('`0Yes!');
                                          swriteln('');
                                          Begin
                                          if l.gold >= 6000 then
                                          Begin
                                            fwriteln('  `0A pungent odor fills the air, as Otak pours an off-white liquid');
                                            swrite('  into a shot glass.  Your hand shakes as you retrieve the cup.');
                                            swriteln('  Quickly,');
                                            swriteln('  you gulp the liquid down.');
                                            swriteln('');more;
                                            l.gold := l.gold - 6000;
                                            o.drunk := true;
                                            k:=l.level;
                                            str(k,s1);
                                            l.charm:=l.charm-k;
                                            fwrite('  `%After drinking the strange liquid, you suddenly start');
                                            swriteln(' sprouting hair');
                                            swriteln('  in all parts of the body!  `4You are ugly!  You lose '+s1+' charm!');
                                            fwriteln('  `2(You bear a strange resemblence to a troll!  Gee, I wonder why.)');
                                            swriteln('');more;
                                          end else
                                          Begin
                                            fwriteln('  `4You fool!  You don''t have that much gold!');swriteln('');
                                            more;
                                          end;
                                          end;
                                        end;
                                  'N' : Begin
                                          fwriteln('`0No!');
                                          swriteln('');
                                          fwriteln('  `2What?  You lose your mood, or something?!');
                                          swriteln('');
                                          more;
                                        end;
                                end;
                              end;
                          5 : Begin
                                swriteln('');
                                fwriteln('  `2"Only the mightiest warriors can handle this one."');
                                swriteln('');
                                fwrite('  `2You sure you want this? [`5Y`2]: ');
                                repeat
                                  y := upcase(getchar);
                                until y in ['Y','N',#13];
                                if y = #13 then y:='Y';
                                CASE y of
                                  'Y' : Begin
                                          fwriteln('`0Yes!');
                                          swriteln('');
                                          Begin
                                          if l.gold >= 10000 then
                                          Begin
                                            fwriteln('  `0As Otak opens the flask labeled "Dragon''s Breath", your nostrils');
                                            swriteln('  pick up the smell of fire.  You think twice about your decision, but');
                                            swriteln('  decide to drink the damn thing anyway.');
                                            swriteln('');more;
                                            l.gold := l.gold - 10000;
                                            o.drunk := true;
                                            k:=l.level*10;
                                            if l.level < 6 then
                                            Begin
                                              k := k div 3;
                                              str(k,s1);
                                              l.hit_points:=l.hit_points-k;
                                              fwriteln('  `%As Otak said, only the MIGHTIEST warriors can handle this one.');
                                              swrite('  Obviously you don''t fit into that category.');
                                              swriteln('  `4You lose '+s1+' hit points.');
                                              swriteln('');
                                              more;
                                            end else
                                            Begin
                                              str(k,s1);
                                              fwriteln('  `%Oh my!  You feel good!  You feel great!  You feel wonderful!');
                                              fwriteln('  `2You gain `0'+s1+' `2hit points!');
                                              swriteln('');more;
                                            end;
                                          end else
                                          Begin
                                            fwriteln('  `4You fool!  You don''t have that much gold!');swriteln('');
                                            more;
                                          end;
                                          end;
                                        end;
                                  'N' : Begin
                                          fwriteln('`0No!');
                                          swriteln('');
                                          fwriteln('  `2Indeed, indeed.  Wise decision on your behalf.');
                                          swriteln('');
                                          more;
                                        end;
                                end;
                        end;
                        end;
                      end;
                      end;
                'C' : if o.challenges <= 0 then
                      Begin
                        swriteln('');
                        fwriteln('  `%You''ve had enough for today.');
                        first:=false;
                      end else
                      if o.challenges > 0 then
                      Begin
                        swriteln('');
                        fwriteln('  `%Who would you like to challenge?');swriteln('');
                        fwriteln('  `2(Full or `0PARTIAL `2name)');
                        fwrite('  `2:`%');
                        sread(opponent);
                        if opponent = '' then
                        Begin
                          swriteln('');
                          fwriteln('  `%Try typing something next time.');swriteln('');
                          first:=false;
                          more;
                          end else
                          if opponent <> '' then
                          Begin
                          swriteln('');
                          Searchplayers(opponent,test,bl,challenge);
                          if not(test) then
                          Begin
                            if bl then swriteln('');
                            fwriteln('  `%No matching names found.');swriteln('');
                            first:=false;
                            more;
                          end else
                          Begin
                            if challenge.handle=o.handle then
                            Begin
                              swriteln('');
                              fwriteln('  `%Sorry, but that would be cheating.');
                              swriteln('');more;first:=false;
                            end else
                            Begin
                            str(challenge.account,acc);
                            if (challenge.chal) then
                            Begin
                              swriteln('');
                              fwriteln('  `%Sorry, that player has already been challenged.');swriteln('');
                              fwriteln('  `%Try again later.');
                              swriteln('');more;first:=false;
                            end else
                            Begin
                              swriteln('');
                              o.challenges:=o.challenges-1;
                              fwrite('  `2Summoning `0'+challenge.handle);
                              for i := 1 to 5 do
                              Begin
                                delay(200);
                                fwrite('`2.');
                              end;
                              delay(200);swriteln('');swriteln('');more;
                              challenge.chal:=true;
                              sclrscr;
                              swriteln('');swriteln('');
                              fwriteln('`0  '+challenge.handle+'`2 takes a seat next to you at the bar.  The bartender');
                              fwriteln('`2  hands each of you a mug of beer.  You begin the contest.');swriteln('');
                              more;
                              assign(lfile,lpath+'PLAYER.DAT');
                              if shareinst then filemode:=66;
                              reset(lfile);
                              netseek(lfile,challenge.account);
                              netread(lfile,lplayer);
                              netclose(lfile);
                              if shareinst then filemode:=64;
                              round:=1;
                              pl1:=abs(l.strength-l.def)*l.level;
                              pl2:=abs(lplayer.strength-lplayer.def)*lplayer.level;
                              if pl1 < 0 then pl1 := -pl1;
                              if pl2 < 0 then pl2 := -pl2;
                              win1:=false;win2:=false;
                              if l.sex=5 then gen1:='her' else gen1:='his';
                              if lplayer.sex=5 then gen2:='her' else gen2:='his';
                              sclrscr;swriteln('');
                              repeat
                                swriteln('');
                                str(round,rs);
                                fwriteln('  `2ROUND `0'+rs);
                                swriteln('');swrite('  ');
                                for i := 1 to 4 do
                                Begin
                                  delay(300);
                                  fwrite('`%GLUG`2...');
                                end;
                                delay(300);
                                swriteln('');swriteln('');
                                if pl1 <= 9 then message:='falls down unconscious!' else
                                if (pl1 >= 10) and (pl1 <= 14) then message:='has no clue what''s going on!' else
                                if (pl1 >= 15) and (pl1 <= 19) then
                                message:='falls out of '+gen1+' chair and gets back up!' else
                                if (pl1 >= 20) and (pl1 <= 29) then message:='looks a bit woozy!' else
                                if (pl1 >= 30) and (pl1 <= 44) then message:='belches loudly!' else
                                if (pl1 >= 45) and (pl1 <= 54) then
                                message:='wipes the foam from '+gen1+' mouth and shakes '+gen1+' head!' else
                                if (pl1 <= 59) and (pl1 >= 55) then message:='yells for another!' else
                                if (pl1 <= 69) and (pl1 >= 60) then message:='laughs heartily!' else
                                if (pl1 >= 70) then message:='doesn''t feel a thing!';
                                fwrite('  `0'+o.handle+'`2...`%');delay(400);swriteln(message);
                                if pl2 <= 9 then message:='falls down unconscious!' else
                                if (pl2 >= 10) and (pl2 <= 14) then message:='has no clue what''s going on!' else
                                if (pl2 >= 15) and (pl2 <= 19) then
                                message:='falls out of '+gen2+' chair and gets back up!' else
                                if (pl2 >= 20) and (pl2 <= 29) then message:='looks a bit woozy!' else
                                if (pl2 >= 30) and (pl2 <= 44) then message:='belches loudly!' else
                                if (pl2 >= 45) and (pl2 <= 54) then
                                message:='wipes the foam from '+gen2+' mouth and shakes '+gen2+' head!' else
                                if (pl2 <= 59) and (pl2 >= 55) then message:='yells for another!' else
                                if (pl2 <= 69) and (pl2 >= 60) then message:='laughs heartily!' else
                                if (pl2 >= 70) then message:='doesn''t feel a thing!';
                                fwrite('  `0'+challenge.handle+'`2...`%');delay(400);swriteln(message);
                                swriteln('');more;
                                round:=round+1;
                                if (pl1<=9) then win2:=true;
                                if (pl2<=9) then win1:=true;
                                subtract:=pl1 div 5;
                                pl1:=pl1-subtract;
                                subtract:=pl2 div 5;
                                pl2:=pl2-subtract;
                              until win1 or win2;
                              if win1 then
                              Begin
                                o.contest:=o.contest+1;
                                fwriteln('  `2You have defeated `0'+challenge.handle+'`2!');
                                swriteln('');
                                fwriteln('  `%You are the ultimate beer drinker!');swriteln('');
                                loseexp:=lplayer.exp div 20;
                                winexp:=lplayer.exp div 5;
                                lplayer.exp:=lplayer.exp-loseexp;
                                l.exp:=l.exp+winexp;
                                expsay:=comma(winexp);
                                fwriteln('  `2You get `0'+expsay+' `2experience points!');swriteln('');
                                str(challenge.account,acc);
                                expsay:=comma(loseexp);
                                assign(f,'LAT_C'+acc+'.DAT');
                                rewrite(f);
                                writeln(f);
                                writeln(f,'  `%YOU WERE CHALLENGED IN A CONTEST!!');
                                writeln(f,'`2-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
                                writeln(f,'  `0'+o.handle+' `2challenged you to a beer drinking contest!');
                                writeln(f,'  `%You fell off the bar stool unconscious!  `2You lost `%'+expsay);
                                writeln(f,'  `2experience points!');
                                close(f);
                              end else
                              if win2 then
                              Begin
                                challenge.contest:=challenge.contest+1;
                                fwriteln('  `2You have lost to `0'+challenge.handle+'`2!');
                                swriteln('');
                                fwriteln('  `2You are `%NOT `2the ultimate beer drinker!');swriteln('');
                                loseexp:=l.exp div 20;
                                winexp:=l.exp div 5;
                                lplayer.exp:=lplayer.exp+winexp;
                                l.exp:=l.exp-loseexp;
                                expsay:=comma(loseexp);
                                fwriteln('  `2You `%LOSE `0'+expsay+' `2experience points!');swriteln('');
                                str(challenge.account,acc);
                                expsay:=comma(winexp);
                                assign(f,'LAT_C'+acc+'.DAT');
                                rewrite(f);
                                writeln(f);
                                writeln(f,'  `%YOU WERE CHALLENGED IN A CONTEST!!');
                                writeln(f,'`2-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
                                writeln(f,'  `0'+o.handle+' `2challenged you to a beer drinking contest!');
                                writeln(f,'  `%'+o.handle+' `2fell off the bar stool unconscious!  `0You won,');
                                writeln(f,'  `2and gained `%'+expsay+' `2experience points!');
                                close(f);
                              end;
                              if shareinst then filemode:=66;
                              assign(out,'LPLYRS.DAT');
                              reset(out);
                              for i := 0 to (filesize(out)-1) do
                              Begin
                                netseek(out,i);
                                netread(out,tempo);
                                if tempo.account=challenge.account then where:=i;
                              end;
                              netseek(out,where);
                              netwrite(out,challenge);
                              netclose(out);
                              assign(lfile,lpath+'PLAYER.DAT');
                              reset(lfile);
                              netseek(lfile,o.account);
                              netwrite(lfile,l);
                              netseek(lfile,challenge.account);
                              netwrite(lfile,lplayer);
                              netclose(lfile);
                              if shareinst then filemode:=64;
                              more;
                            end;
                          end;
                        end;
                      end;
                      end;
                'X' : Begin
                        swriteln('');
                        if o.expert_m then
                        Begin
                          o.expert_m := false;
                          fwriteln('  `2EXPERT MODE `%OFF');
                        end
                        else
                        if not(o.expert_m) then
                        Begin
                          o.expert_m:=true;
                          fwriteln('  `2EXPERT MODE `%ON');
                        end;
                      end;
              end;
            until ch='R';
          end;
    'C' : Begin
            sclrscr;
            if not(exist('INN.TXT')) then
            Begin
              assign(f,'INN');
              assign(f1,'INN.TXT');
              reset(f);
              rewrite(f1);
              repeat
                readln(f,s1);
                writeln(f1,s1);
              until eof(f);
              close(f);
              close(f1);
            end;
            swriteln('');
            fwriteln('  `%The Latrine - Conversing with Attendants of the Inn');
            fwriteln('`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
            assign(f1,'INN.TXT');
            assign(f2,'TEMP2.TXT');
            reset(f1);
            repeat
              readln(f1,s1);
              fwriteln(s1);
            until eof(f1);
            close(f1);
            fwrite('  `2Socialize? [`5N`2]: ');
            repeat
              y1:=upcase(getchar);
            until y1 in ['Y','N',#13];
            if y1=#13 then y1:='N';
            CASE y1 of
              'Y' : Begin
                      fwriteln('`0I''m no Anti-social!');
                      swriteln('');
                      fwriteln('  `0(75 char. MAX)');
                      fwrite('  `2>`%');prompt(s2,75,false);
                      if s2 <> '' then
                      Begin
                        reset(f1);
                        rewrite(f2);
                        readln(f1);readln(f1);
                        for i := 1 to 14 do
                        Begin
                          readln(f1,s1);
                          writeln(f2,s1);
                        end;
                        close(f1);
                        writeln(f2,'  `%'+lh+':');
                        s2:='  `2'+s2;
                        writeln(f2,s2);
                        close(f2);
                        erase(f1);
                        rename(f2,'INN.TXT');
                        first:=false;
                      end;
                    end;
              'N' : Begin
                      first:=false;
                      fwriteln('`0You''re asking too much of me.');
                      swriteln('');more;
                    end;
            end;
          end;
  end;
  until y='R';
  outp:=o;
  player:=l;
  clrscr;
  display_menu('deeper','LMENUS.DAT');
  swriteln('');
end;
end.