program LordBull;

uses crt,dos;

  type player_info = record
  names: string[20]; {player handle in the game}
real_names: string[50] {real name/or handle from BBS} ;
hit_points  {player hit points}
,bad  {don't know - might not be used at all}
,rate: integer; {again, couldn't find this one in the source}
hit_max: integer; {hit_point max}
weapon_num: integer; {weapon number}
weapon: string[20]; {name of weapon}
seen_master: integer; {equals 5 if seen master, else 0}
fights_left: integer; {forest fights left}
human_left: integer; {human fights left}
gold: longint; {gold in hand}
bank: longint; {gold in bank}
def: integer;  {total defense points }
strength: integer; {total strength}
charm: integer; {good looking meter}
seen_dragon: integer; {seen dragon?  5 if yes else 0}
seen_violet: integer; {seen violet?  5 if yes else 0}
level: integer; {level of player}
time: word; {day # that player last played on}
arm: string[20]; {armour name}
arm_num: integer; {armour number}
dead: shortint; {player dead?  5 if yes else 0}
inn: shortint; {player sleeping at inn?  5 if yes else 0}
gem: integer; {# of gems on hand}
exp: longint; {experience}
sex: shortint; {gender, 5 if female else 0}
seen_bard: shortint; {seen bard?  5 if yes else 0}
last_alive_time: integer; {day # player was last reincarnated on}
Lays: integer; {players lays stat}
Why: integer; {not used yet}
on_now: boolean; {is player on?}
m_time: integer; {day on_now stat was last used}
time_on: string[5]; {time player logged on in Hour:Minutes format}
class: shortint; {class, should be 1, 2 or 3}
extra: integer;      {can't remember}
love: string[25]; {not used - may be used for inter-player marrages later}
married: integer; {who player is married to, should be -1 if not married}
kids: integer; {# of kids}
wins: integer; {# of times player has won game}
skillw: shortint; {number of Death Knight skill points}
skillm: shortint; {number of Mystical Skills points}
skillt: shortint; {number of Thieving Skills points}

levelw: shortint; {number of Death Knight skill uses left today}
levelm: shortint; {number of Mystical skill uses left today}
levelt: shortint; {number of Thieving skill uses left today}

inn_random: boolean; {not used yet}
married_to: integer; {same as Married, I think - don't know why it's here}
v1: longint;
kills: integer; {# of player kills}
v3: integer; {if 5, 'wierd' event in forest will happen}
v4: boolean; {has player done 'special' for that day?}
v5: shortint; {has player flirted with another player that day?  if so, 5}
  new_stat1: shortint;
  new_stat2: shortint;  {these 3 are unused right now}
  new_stat3: shortint;
  end;


   team_info=record
          name:string[30];
          playsite:array[1..100] of integer;
          alias:array[1..100] of string[30];
          playname:array[1..100] of string[30];
          password:string[8];
          treasury:longint;
      end;

   play_info=record
          name:string[30];
          real_name:string[30];
          hit_max: integer; {hit_point max}
          weapon: string[20]; {name of weapon}
          weapon_num:shortint;
          gold: longint; {gold in hand}
          bank: longint; {gold in bank}
          def: integer;  {total defense points }
          strength: integer; {total strength}
          charm: integer; {good looking meter}
          level: byte; {level of player}
          arm: string[20]; {armour name}
          arm_num:shortint;
          inn: shortint; {player sleeping at inn?  5 if yes else 0}
          gem: byte; {# of gems on hand}
          exp: longint; {experience}
          sex: shortint; {gender, 5 if female else 0}
          Lays: integer; {players lays stat}
          king: byte; {# of times player has won game}
          v2: integer; {# of player kills}
          teamnum:integer;    {Team Number - kind of a "temp" stat}
          teamname:namestr;  {Team Name}
          firston:string[6];  { First time Played Lordnet - used for
                                Dupe Checking}
      end;     



var playrec : array[1..150] of player_info;
    playfile:file of player_info;
           I:byte;
    nor,ww,ult,cha,hal,pla,mg,dk,th:string;
    nor2,ww2,ult2,cha2,hal2,pla2,mg2,dk2,th2:string;
    path:string;


function FileExists(FName: STRING): Boolean;
  Var TFile: TEXT;
      S: String;
  Begin
    s := FSEARCH(FNAME, '');
    FileExists := S <> '';
  end;

procedure readcfg;
 var data:text;
  begin
    IF NOT FILEEXISTS('lordbull.cfg') then begin
      writeln('You''re missing the LORDBULL.CFG file!');
      writeln;
      halt;
    end;
    nor := '';nor2 := '';ult:='';ult2:='';
    assign(data,'lordbull.cfg');
    reset(data);
    IF NOT EOF(DATA) THEN readln(data,path);
    IF NOT EOF(DATA) THEN readln(data,ult);
IF NOT EOF(DATA) THEN     readln(data,ult2);
IF NOT EOF(DATA) THEN     readln(data,cha);
IF NOT EOF(DATA) THEN     readln(data,cha2);
IF NOT EOF(DATA) THEN     readln(data,hal);
IF NOT EOF(DATA) THEN     readln(data,hal2);
IF NOT EOF(DATA) THEN     readln(data,pla);
IF NOT EOF(DATA) THEN     readln(data,pla2);
IF NOT EOF(DATA) THEN     readln(data,dk);
IF NOT EOF(DATA) THEN     readln(data,dk2);
IF NOT EOF(DATA) THEN     readln(data,mg);
IF NOT EOF(DATA) THEN     readln(data,mg2);
IF NOT EOF(DATA) THEN     readln(data,th);
IF NOT EOF(DATA) THEN     readln(data,th2);
IF NOT EOF(DATA) THEN     readln(data,ww);
IF NOT EOF(DATA) THEN     readln(data,ww2);
IF NOT EOF(DATA) THEN     readln(data,nor);
IF NOT EOF(DATA) THEN     readln(data,nor2);
    close(data);
  end;



procedure readin;
  begin
    IF NOT fileexists(path+'player.dat') then begin
      writeln('Player.dat does not exist where you said it did.');
      halt;
    end;
    i := 1;
    assign(playfile,path+'player.dat');
    reset(playfile);
    repeat
    read(playfile,playrec[i]);
    IF not (PLAYREC[I].names = 'X') then inc(i);
    until eof(playfile);
    dec(i);
    close(playfile);
  end;


 function convertn(s:string):string;
 var e,f,g,h,temp:string;
 l,m,p:byte;
  begin
    p := length(s);
    l := 0;
    while (POS('`',s) > 0) do begin
       inc(l);
       f := '';
       g := '';
       for m := 1 to POS('`',s)-1 do f := f + s[m];
       for m := POS('`',s)+2 to length(s) do g := g+s[m];
       s := f+g;
    end;
    temp := s;
    while (length(s) < 20) do s := s + ' ';
    IF (p < 20) then
         for m := p-(l*2) to 20 do temp := temp+' '
         else begin
           temp := '';
           for m := 1 to 20 do temp := temp + s[m];
         end;
    convertn := temp;
  end;




function convert(s:string):string;
 var f,g,h,temp,t:string;
 l,m,p:byte;
  begin
    p := length(s);
    l := p;
    IF (P > 20) then begin
      convert := convertn(s);
    end;
    t := s;
    l := 0;
    while (POS('`',s) > 0) do begin
       inc(l);
       f := '';
       g := '';
       for m := 1 to POS('`',s)-1 do f := f + s[m];
       for m := POS('`',s)+2 to length(s) do g := g+s[m];
       CASE s[(POS('`',s)+1)] of
         '1':h := '[0;34m';
         '2':h := '[0;32m';
         '3':h := '[0;36m';
         '4':h := '[0;31m';
         '5':h := '[0;35m';
         '6':h := '[0;33m';
         '7':h := '[0;37m';
         '8':h := '[1;30m';
         '9':h := '[1;34m';
         '0':h := '[1;32m';
         '!':h := '[1;36m';
         '@':h := '[1;31m';
         '#':h := '[1;35m';
         '$':h := '[1;33m';
         '%':h := '[1;37m';
       end;
       s := f+h+g;
    end;
    temp := s;
    for m := p-(l*2) to 20 do temp := temp+' ';
    temp := temp + '[0;32m';
    convert := temp;
  end;



procedure normal;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : longint;
    y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].exp;
          e := playrec[u[x]].exp;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF nor = '' then nor := 'temp.fil';
    if nor2= '' then nor2 := 'temp2.fil';
      assign(data,nor);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[1;37m                  Legend Of The Red Dragon - Player Rankings');
      writeln(data,'');
      writeln(data,'[0;32m    Name                  Experience    Level    Mastered    Status');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,nor2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'                  Legend Of The Red Dragon - Player Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                  Experience    Level    Mastered    Status');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].exp:11,'      ','[1;37m');
      write(data2,playrec[u[w]].exp:11,'      ');
      write(data,playrec[u[w]].level:2);
      write(data2,playrec[u[w]].level:2);
      write(data,'       ');
      write(data2,'       ');
      IF playrec[u[w]].skillw > 39 then write(data,'[1;32mD ') else write(data,'  ');
      IF playrec[u[w]].skillw > 39 then write(data2,'D ') else write(data2,'  ');
      IF playrec[u[w]].skillm > 39 then write(data,'[0;35mM ') else write(data,'  ');
      IF playrec[u[w]].skillm > 39 then write(data2,'D ') else write(data2,'  ');
      IF playrec[u[w]].skillt > 39 then write(data,'[1;37mT ') else write(data,'  ');
      IF playrec[u[w]].skillt > 39 then write(data2,'D ') else write(data2,'  ');
      write(data,'    ');
      write(data2,'    ');
      IF playrec[u[w]].dead = 5 then writeln(data,'[0;31mDead') else writeln(data,'[1;37mAlive');
      IF playrec[u[w]].dead = 5 then writeln(data2,'Dead') else writeln(data2,'Alive');
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;





procedure ultimate;
  label a1,a2,a4;
  var data,data2:text;
         y,a:string[40];
         w,x,l,p,z:byte;
         d,e:longint;
      u:array[1..150] of byte;
      ret:string;
  begin
    for w := 1 to (i+1) do u[w] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          str(playrec[w].exp,y);
d := (LENGTH(Y)*(playrec[w].level DIV 2)*(1+(playrec[w].lays)DIV 2)*(1+playrec[w].wins DIV 2)*(1+playrec[w].kills DIV 2)) ;
          IF u[x] = 0 then begin
             d := 0;
             goto a1;
          end;
          str(playrec[u[x]].exp,y);
e := (LENGTH(y)*(playrec[u[x]].level DIV 2)*(1+(playrec[u[x]].lays)DIV 2)*(1+playrec[u[x]].wins DIV 2)
*(1+playrec[u[x]].kills DIV 2));
          IF (D > E) then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF ult = '' then ult := 'temp.fil';
    if ult2= '' then ult2 := 'temp2.fil';
      assign(data,ult);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1m           [0;1mLegend Of The Red Dragon  Ultimate Warrior Rankings');
      writeln(data,'');
      writeln(data,'    [0;32mName                  Experience    Level    Lays   Wins     Score');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,ult2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'           Legend Of The Red Dragon  Ultimate Warrior Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                  Experience    Level    Lays   Wins     Score');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
{    for w := 1 to i do begin
d:= (LENGTH(Y)*(playrec[u[w]].level DIV 2)*((playrec[u[w]].lays)+1)*((playrec[u[w]].wins*2)+1)*(playrec[u[w]].kills+1));
      writeln(d);
      readln;
    end;}
    for w := 1 to i do begin
      str(playrec[u[w]].exp,y);
d:= (LENGTH(Y)*(playrec[u[w]].level DIV 3)*((playrec[u[w]].lays)+1 DIV 3)*((playrec[u[w]].wins div 3)+1)
*(playrec[u[w]].kills+1 div 3));
      IF D = 0 then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].exp:11,'      ','[1;37m');
      write(data2,playrec[u[w]].exp:11,'      ');
      write(data,playrec[u[w]].level:2);
      write(data2,playrec[u[w]].level:2);
      write(data,'     ');
      write(data2,'     ');
      write(data,'[1;35m',playrec[u[w]].lays:3);
      write(data2,playrec[u[w]].lays:3);
      write(data,'    ','[1;37m');
      write(data2,'    ');
      write(data,playrec[u[w]].wins:3);
      write(data2,playrec[u[w]].wins:3);
      str(d,a);
      IF a[1] = '-' then a[1] := ' ';
      writeln(data,'     [0;32m',a:6);
      writeln(data2,'     ',a:6);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
  end;


procedure Romantic;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : byte;
    y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].charm;
          e := playrec[u[x]].charm;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF cha = '' then cha := 'temp.fil';
    if cha2= '' then cha2 := 'temp2.fil';
      assign(data,cha);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m[17C[0;1mLegend Of The Red Dragon  Romantic Rankings');
      writeln(data,'');
      writeln(data,'    [0;32mName                   Experience     Level     Lays     Charm');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,cha2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'                 Legend Of The Red Dragon  Romantic Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                   Experience     Level     Lays     Charm');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF playrec[u[w]].charm = 0 then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].exp:11,'        ','[1;37m');
      write(data2,playrec[u[w]].exp:11,'        ');
      write(data,playrec[u[w]].level:2);
      write(data2,playrec[u[w]].level:2);
      write(data,'      ');
      write(data2,'      ');
      write(data,'[1;32m',playrec[u[w]].lays:3);
      write(data2,playrec[u[w]].lays:3);
      write(data,'       ','[1;37m');
      write(data2,'       ');
      writeln(data,'[1;35m',playrec[u[w]].charm:3);
      writeln(data2,playrec[u[w]].charm:3);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;



procedure wealthy;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : longint;
  y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := (playrec[w].bank);
          e := (playrec[u[x]].bank);
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF ww = '' then ww := 'temp.fil';
    if ww2= '' then ww2 := 'temp2.fil';
      assign(data,ww);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m[17C[0;1mLegend Of The Red Dragon  Wealthiest Warriors');
      writeln(data,'');
      writeln(data,'    [0;32mName                        Hand                Bank              Total');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,ww2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'                 Legend Of The Red Dragon  Wealthiest Warriors');
      writeln(data2,'');
      writeln(data2,'    Name                        Hand                Bank              Total');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF (playrec[u[w]].gold = 0) and (playrec[u[w]].bank = 0) then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].gold:11,'         ','[1;37m');
      write(data2,playrec[u[w]].gold:11,'         ');
      write(data,playrec[u[w]].bank:11);
      write(data2,playrec[u[w]].bank:11);
      write(data,'       ');
      write(data2,'       ');
      writeln(data,'[1;32m',(playrec[u[w]].gold+playrec[u[w]].bank):12);
      writeln(data2,(playrec[u[w]].gold+playrec[u[w]].bank):12);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;


procedure playerkill;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : byte;
  y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].kills;
          e := playrec[u[x]].kills;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF pla = '' then pla := 'temp.fil';
    if pla2= '' then pla2 := 'temp2.fil';
      assign(data,pla);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m[14C[0;1mLegend Of The Red Dragon  Player Killer Rankings');
      writeln(data,'');
      writeln(data,'    [0;32mName                   Level      Kills         Weapon');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,pla2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'             Legend Of The Red Dragon  Player Killer Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                   Level      Kills         Weapon');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF playrec[u[w]].kills = 0 then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,'[1;37m    ');
      write(data2,'    ');
      write(data,playrec[u[w]].level:2);
      write(data2,playrec[u[w]].level:2);
      write(data,'       ');
      write(data2,'       ');
      write(data,'[1;35m',playrec[u[w]].kills:4);
      write(data2,playrec[u[w]].kills:4);
      write(data,'       ');
      write(data2,'       ');
      writeln(data,'[1;32m',playrec[u[w]].weapon:2);
      writeln(data2,playrec[u[w]].weapon:2);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;



procedure hof;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : byte;
  y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].wins;
          e := playrec[u[x]].wins;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF hal = '' then hal := 'temp.fil';
    if hal2= '' then hal2 := 'temp2.fil';
      assign(data,hal);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m                               Heroes Of The [0;1;32mRealm');
      writeln(data,'[0;1;32m');
      write(data,'[0;1;32m     Name                       Heroic Deeds Done         Current Level');
      writeln(data,'');
      writeln(data,'[0;1;32m -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,hal2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'                               Heroes Of The Realm');
      writeln(data2,'');
      write(data2,'     Name                       Heroic Deeds Done         Current Level');
      writeln(data2,'');
      writeln(data2,' -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      for w := 1 to i do begin
         IF playrec[u[w]].wins = 0 then goto a4;
         y := playrec[u[w]].names;
         for x := LENGTH(playrec[u[w]].names) to 34 do y := y+' ';
       write(data,'   [0;32m',y);
       write(data2,'   ',y);
       write(data,'[0;1;33m',playrec[u[w]].wins);
       write(data2,playrec[u[w]].wins:2);
       writeln(data,' ':22,'[0;1m',playrec[u[w]].level:2);
       writeln(data2,' ':22,playrec[u[w]].level:2);
       a4:
    end;
    writeln(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
  end;


procedure dknights;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : byte;
  y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].skillw;
          e := playrec[u[x]].skillw;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF dk = '' then dk := 'temp.fil';
    if dk2= '' then dk2 := 'temp2.fil';
      assign(data,dk);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m[13C[0;1mLegend Of The Red Dragon [0;1;33mDeath Knights [0;1mRankings');
      writeln(data,'');
      writeln(data,'    [0;32mName                   Experience       Skill          Weapon');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,dk2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'             Legend Of The Red Dragon Death Knights Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                   Experience       Skill          Weapon');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF playrec[u[w]].skillw = 0 then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].exp:11,'        ');
      write(data2,playrec[u[w]].exp:11,'        ');
      write(data,'  [0;1;32m');
      write(data2,'  ');
      write(data,'[1;32m',playrec[u[w]].skillw:2);
      write(data2,playrec[u[w]].skillw:2);
      write(data,'          ','[0;31m');
      write(data2,'         ');
      writeln(data,playrec[u[w]].weapon);
      writeln(data2,playrec[u[w]].weapon);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;


procedure musers;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : byte;
  y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].skillm;
          e := playrec[u[x]].skillm;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF mg = '' then mg := 'temp.fil';
    if mg2= '' then mg2 := 'temp2.fil';
      assign(data,mg);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m[18C[0;1mLegend Of The Red Dragon [0;1;35mMagician [0;1mRankings');
      writeln(data,'');
      writeln(data,'    [0;32mName                   Experience       Charm      Lays     Skill');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,mg2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'                  Legend Of The Red Dragon Magician Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                   Experience       Charm      Lays     Skill');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF playrec[u[w]].skillm = 0 then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].exp:11,'        ');
      write(data2,playrec[u[w]].exp:11,'        ');
      write(data,' [0;1;33m');
      write(data2,' ');
      write(data,playrec[u[w]].charm:3,'     ');
      write(data2,playrec[u[w]].charm:3,'     ');
      write(data,'  ');
      write(data2,'  ');
      write(data,playrec[u[w]].lays:3,'     ');
      write(data2,playrec[u[w]].lays:3,'     ');
      write(data,'   [0;1m');
      write(data2,'   ');
      writeln(data,'[1;32m',playrec[u[w]].skillm:2);
      writeln(data2,playrec[u[w]].skillm:2);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;


procedure thieves;
 label a1,a2,a4;
 var data,data2:text;
     u:array[1..150] of byte;
    x,l,w:byte;
    d,e,p : byte;
  y,ret:string;
  begin
    for x := 1 to i+1 do u[x] := 0;
    l := 1;
    for w := 1 to i do begin
       IF playrec[i].names = 'X' then begin
          dec(w);
          goto a2;
       end;
       for x := 1 to l do begin
          IF u[x] = 0 then goto a1;
          d := playrec[w].skillt;
          e := playrec[u[x]].skillt;
          IF D > E then begin
            a1:
            for p := (l+1) downto (x+1) do u[p] := u[p-1];
            u[x] := w;
            inc(l);
            goto a2;
        end;
       end;
       a2:
    end;
    IF th = '' then th := 'temp.fil';
    if th2= '' then th2 := 'temp2.fil';
      assign(data,th);
      rewrite(data);
      writeln(data,'[255D[40m');
      writeln(data,'');
      writeln(data,'[0;1;32m[19C[0;1mLegend Of The Red Dragon [0;1;32mThieves [0;1mRankings');
      writeln(data,'');
      writeln(data,'    [0;32mName                   Experience              Gold         Skill');
      writeln(data,'[0;1;32m-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      assign(data2,th2);
      rewrite(data2);
      writeln(data2,'');
      writeln(data2,'                   Legend Of The Red Dragon Thieves Rankings');
      writeln(data2,'');
      writeln(data2,'    Name                   Experience               Gold         Skill');
      writeln(data2,'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    for w := 1 to i do begin
      IF playrec[u[w]].skillt = 0 then goto a4;
      IF playrec[u[w]].sex = 5 then write(data,'[1;35mF ') else write(data,'  ');
      IF playrec[u[w]].sex = 5 then write(data2,'F ') else write(data2,'  ');
      CASE playrec[u[w]].class of
      1:write(data,'[1;32mD ');
      2:write(data,'[0;35mM ');
      else write(data,'[1;34mT ');
      end;
      CASE playrec[u[w]].class of
      1:write(data2,'D ');
      2:write(data2,'M ');
      else write(data2,'T ');
      end;
      y := playrec[u[w]].names;
      ret := y;
      y := convert(y);
      write(data,'[0;32m',y);
      ret := convertn(ret);
      write(data2,ret);
      write(data,playrec[u[w]].exp:11,'        ');
      write(data2,playrec[u[w]].exp:11,'        ');
      write(data,' [0;1m');
      write(data2,'  ');
      write(data,playrec[u[w]].bank:10,'     ');
      write(data2,playrec[u[w]].bank:10,'     ');
      write(data,'      [0;1m');
      write(data2,'      ');
      writeln(data,'[1;32m',playrec[u[w]].skillt:2);
      writeln(data2,playrec[u[w]].skillt:2);
      a4:
    end;
    WRITELN(data,'');
    writeln(data2,'');
    close(data);
    close(data2);
end;




begin
  clrscr;
  writeln;
  textcolor(14);
  writeln('Reading in Config File...');
  readcfg;
  textcolor(15);
  writeln('Reading in Player Data...');
  readin;
  textcolor(14);
  writeln('Creating Normal Warriors Bulletin...');
  IF NOT (nor = '') or not (nor2 = '') then normal;
  textcolor(13);
  writeln('Creating Ultimate Warrior Bulletin...');
  IF NOT (ult = '') or not (ult2 = '') then ultimate;
  textcolor(12);
  writeln('Creating Romantic Players Bulletin...');
  IF NOT (cha = '') or not (cha2 = '') then romantic;
  textcolor(11);
  writeln('Creating Hall Of Fame Bulletin...');
  IF NOT (hal = '') or not (hal2 = '') then hof;
  textcolor(10);
  writeln('Creating Player Killers Bulletin...');
  IF NOT (pla = '') or not (pla2 = '') then playerkill;
  textcolor(9);
  writeln('Creating DeathKnight Champs Bulletin...');
  IF NOT (dk = '') or not (dk2 = '') then dknights;
  textcolor(7);
  writeln('Creating Magic Users Bulletin...');
  IF NOT (mg = '') or not (mg2 = '') then musers;
  textcolor(10);
  writeln('Creating Thieves Bulletin...');
  IF NOT (th = '') or not (th2 = '') then thieves;
  textcolor(2);
  writeln('Creating Money Makers Bulletin...');
  if not (ww = '') or not (ww2 = '') then wealthy;
end.

