/* LORDSTRC.H
** Header file containing a C translation of LORDSTRC.PAS
**
** Pascal version copyright is held by Seth Able Robinson
**
** C version - Copyright 1995 by John Hutton.  All rights reserved.
** You have my permission to include this code in your own programs
** whether commercial or noncommercial.
*/

#define BYTE unsigned char
#define WORD unsigned int
#define BOOLEAN BYTE

typedef struct 
  {
  char lnames;          /* length for names */
  char names[20];       /* array for names */
  char lreal_names;     /* length for real names */
  char real_names[50];  /* array for real names */
  int hit_points;       /* hit points */
  int bad;              /* not used */
  int rate;             /* not used */
  int hit_max;          /* maximum hit points */
  int weapon_num;       /* weapon number */
  char lweapon;         /* length of weapon name */
  char weapon[20];      /* array for weapon name */
  int seen_master;      /* 5 if seen Master, else 0 */
  int fights_left;      /* forest fights left */
  int human_left;       /* human fights left */
  long gold;            /* gold in hand */
  long bank;            /* gold in bank */
  int def;              /* total defense points */
  int strength;         /* total strength */
  int charm;            /* good looking meter */
  int seen_dragon;      /* seen dragon? 5 if yes else 0 */
  int seen_violet;      /* seen violet? 5 if yes else 0 */
  int level;            /* level of player */
  WORD time;            /* day # that player last played on */
  char larm;            /* length of armour name */
  char arm[20];         /* armour name */
  int arm_num;          /* armour number */
  char dead;            /* player dead? 5 if yes else 0 */
  char inn;             /* player sleeping at inn? 5 if yes else 0 */
  int gem;              /* # of gems on hand */
  long exp;             /* experience */
  char sex;             /* gender, 5 if female else 0 */
  char seen_bard;       /* seen bard? 5 if yes else 0 */
  int last_alive_time;  /* day # player was last reincarnated on */
  int lays;             /* players lays stat */
  int why;              /* not used yet */
  BOOLEAN on_now;       /* is player on? */
  int m_time;           /* day on_now stat wa last used */
  char ltime_on;        /* length of time_on string */
  char time_on[5];      /* time player logged on in HH:MM format */
  char class;           /* class, should be 1, 2 or 3 */
  int extra;            /* if 1, player has a horse */
  char llove;           /* length of love string */
  char love[25];        /* not used - may be for inter player marriage */
  int married;          /* who player is married to, -1 if not married */
  int kids;             /* # of kids */
  int king;             /* # of times player has won game */
  char skillw;          /* number of Death Knight skill points */
  char skillm;          /* number of Mystical Skills points */
  char skillt;          /* number of Thieving Skills points */
  char levelw;          /* number of Death Knight skill uses left today */
  char levelm;          /* number of Mystical Skill uses left today */
  char levelt;          /* number of Thieving Skill usues left today */
  BOOLEAN inn_random;   /* not used yet */
  int married_to;       /* same as Married? */
  long v1;
  int v2;               /* number of player kills */
  int v3;               /* if 5, 'weird' event in forest will happen */
  BOOLEAN v4;           /* has player done 'special' for that day? */
  char v5;              /* has player flirted with another player today 5 */
  char new_stat1;
  char new_stat2;
  char new_stat3;
  }LORD_USER_REC;

typedef struct
  {
  char lname;           /* length for name */
  char name[60];        /* name */
  long strength;            
  long gold;
  char lweapon;         /* length for name of weapon */
  char weapon[60];      /* name of weapon */
  long exp_points;
  long hit_points;
  char ldeath;          /* length for death string */
  char death[100];      /* shown when monster is killed by power move */
  }MONSTER_REC;

int armor_strength[] = { 0, 1, 3, 10, 15, 25, 35, 50, 75, 100, 150, 225,
			300, 400, 600, 1000};

int weapon_strength[] = { 0, 5, 10, 20, 30, 40, 60, 80, 120, 180, 250, 350,
			 500, 800, 1200, 1800};
