// Data.H

#ifndef __DATA_HEADER_FILE__
#define __DATA_HEADER_FILE__

#ifdef DropModule
#ifdef DataModule
#error  Both DataModule & DropModule defined!
#endif
#endif

#include "lstree.h"

char *WithLSPath( char *fname );     // Returns fname appended to "D:\Ls\"
char *WithNodePath( const char *fname );  // Returns as "D:\Ls\Node2\F.Ext"
void  CreateNodePath( void );        // Creates directories D:\Ls\NodeX

//void reset_all_mail( void );           // Called when mail DB is created...

char *set_ext( char *sout, char *sin, char *ext ); // Set extension of sin
char *set_ext( char *s, char *ext );               // Set extension of s


global char had_to_create;   // (0/1) Last call to Open() created new DB...

#define load_master() read_single(WithLSPath("Master.Dat"), &master, sizeof(master), true )
#define save_master() write_single(WithLSPath("Master.Dat"), &master, sizeof(master) )

#define load_config() read_single( WithLSPath(configf), &config, sizeof(config), true )
#define save_config() write_single( WithLSPath(configf), &config, sizeof(config) )



class TData {
 protected:
  ulong nextPos;
  int keyFirst;
  int firstopen;
  int openStyle, openShare;
  Entry ent;
  Index idx;
  int handle;
  char fname[80];
  char idx_fname[80];
  ulong high;

 public:
  int end;
  int isopen;
  int type;

  uint len;

  TData( const char far *FileName, uint setLen=0, uint setType=0,
    int OpenStyle=O_RDWR|O_BINARY, int OpenShare=SH_DENYNONE );
  TData( uint setLen=0, uint setType=0,
    int OpenStyle=O_RDWR|O_BINARY, int OpenShare=SH_DENYNONE );
  ~TData();
  void SetOpen( uint OpenStyle=0, uint OpenShare=0 );
  void SetFileName( const char *FileName );
  int Open(void);
  int CheckVersion(void);
  void Close(void);
  void Reset(void);
  ulong ReadHigh(void);                  // Read only...
  ulong GetHigh(void);                   // Read and add one...
  ulong ConfirmHigh(void);               // Recovery routine...
  int Load( ulong num, void *buf );
  int Load( unsigned char *keyword, void *buf );
  int Load( void *buf );
  int Load( unsigned char *keyword, void *buf, int offset, int maxlen, int search=0, char direction=1 );
  int Load( void );
  unsigned char *LoadKey( char direction/*0 or 1*/ );
  int LoadThisKey( void *buf );
  int Save( unsigned char *keyword, ulong num, void *buf );
  int Add( unsigned char *keyword, ulong num, void *buf );
  int Delete( ulong num, unsigned char *keyword );
  int Change( ulong num, unsigned char *keyword, unsigned char *newkey );
  int Swap( ulong numA, ulong numB );

  int Open( int Handle );    // Functions reserved for use by LsFix & Maint
  int ReInit( void );
  int ReadHeader(void);
  int WriteHeader(void);     // This function is never used by TData itself
};


/////////  Declarations...

#ifdef DataModule
#ifndef _DOOR_CODE_
TData Node( sizeof(node), 2, O_RDWR|O_BINARY, SH_COMPAT );
#else
TData Node( sizeof(node), 2, O_RDWR|O_BINARY, SH_DENYRW );
#endif
TData Security( sizeof(security), 1 );
TData User( sizeof(user), 1 );
TData File( sizeof(file), 1 );
TData Mail( sizeof(mail), 1 );
TData MailArea( sizeof(mailarea), 2 );
TData FileArea( sizeof(filearea), 2 );

#ifndef _DOOR_CODE_
TData Event( sizeof(event), 2 );
#endif

#else    // Else ifdef DataModule

extern TData Node, Security, User;
extern TData File, Mail, MailArea, FileArea;
#ifndef _DOOR_CODE_
extern TData Event;
#endif

#endif   // End ifdef DataModule

void InitDataSystem();

#define reset_node()     Node.Reset()
#define load_node(N)     Node.Load( N, &node )
#define save_node()      Node.Save( node.ID.keyword, node.ID.num, &node )
#define add_node()       Node.Add( node.ID.keyword, node.ID.num, &node )
#define delete_node()    Node.Delete( node.ID.num, node.ID.keyword )
#define open_node()      Node.Open()
#define close_node()     Node.Close()
#define version_node()   Node.CheckVersion()
#define isopen_node()    Node.isopen
#define end_node()       Node.end
#define high_node()      Node.GetHigh()
#define find_node(W)     Node.Load( W, &node )
#define next_node()      Node.Load( &node )
#define change_node(O,N) Node.Change( node.ID.num, O, N )
#define number_node(N)   Node.Change( node.ID.num, N )



#define reset_security()     Security.Reset()
#define load_security(N)     Security.Load( N, &security )
#define save_security()      Security.Save( security.name, security.num, &security )
#define load_secserch(N)     Security.Load( N, &secserch )
#define save_secserch()      Security.Save( secserch.name, secserch.num, &secserch )
#define add_security()       Security.Add( security.name, security.num, &security )
#define delete_security()    Security.Delete( security.num, security.name )
#define open_security()      Security.Open()
#define close_security()     Security.Close()
#define version_security()   Security.CheckVersion()
#define isopen_security()    Security.isopen
#define end_security()       Security.end
#define high_security()      Security.GetHigh()
#define find_security(W)     Security.Load( W, &security )
#define next_security()      Security.Load( &security )
#define key_security()       Security.LoadKey()
#define change_security(O,N) Security.Change( security.num, O, N )
#define number_security(N)   Security.Change( security.num, N )


#define reset_user()          User.Reset()
#define load_user(N)          User.Load( N, &user )
#define load_userserch(N)     User.Load( N, &userserch )
#define save_user()           User.Save( user.handle, user.num, &user )
#define save_userserch()      User.Save( userserch.handle, userserch.num, &userserch )
#define add_user()            User.Add( user.handle, user.num, &user )
#define add_userserch()       User.Add( userserch.handle, userserch.num, &userserch )
#define delete_user()         User.Delete( user.num, user.handle )
#define delete_userserch()    User.Delete( userserch.num, userserch.handle )
#define open_user()           User.Open()
#define close_user()          User.Close()
#define version_user()        User.CheckVersion()
#define isopen_user()         User.isopen
#define end_user()            User.end
#define high_user()           User.GetHigh()
#define find_user(W)          User.Load( W, &user )
#define find_userserch(W)     User.Load( W, &userserch )
#define next_user()           User.Load( &user )
#define next_userserch()      User.Load( &userserch )
#define key_user()            User.LoadKey()
#define change_user(O,N)      User.Change( user.num, O, N )
#define change_userserch(O,N) User.Change( userserch.num, O, N )
#define number_user(N)        User.Change( user.num, N )
#define number_userserch(N)   User.Change( userserch.num, N )


#define reset_mailarea()     MailArea.Reset()
#define load_mailarea(N)     MailArea.Load( N, &mailarea )
#define save_mailarea()      MailArea.Save( mailarea.ID.keyword, mailarea.ID.num, &mailarea )
#define add_mailarea()       MailArea.Add( mailarea.ID.keyword, mailarea.ID.num, &mailarea )
#define delete_mailarea()    MailArea.Delete( mailarea.ID.num, mailarea.ID.keyword )
#define open_mailarea()      MailArea.Open()
#define close_mailarea()     MailArea.Close()
#define version_mailarea()   MailArea.CheckVersion()
#define isopen_mailarea()    MailArea.isopen
#define end_mailarea()       MailArea.end
#define high_mailarea()      MailArea.GetHigh()
#define find_mailarea(W)     MailArea.Load( W, &mailarea )
#define next_mailarea()      MailArea.Load( &mailarea )
#define change_mailarea(O,N) MailArea.Change( mailarea.ID.num, O, N )
#define number_mailarea(N)   MailArea.Change( mailarea.ID.num, N )

#define reset_mail()      Mail.Reset()
#define load_mail(N)      Mail.Load( N, &mail )
#define save_mail()       Mail.Save( mail.to, mail.num, &mail )
#define add_mail()        Mail.Add( mail.to, mail.num, &mail )
//#define delete_mail()     Mail.Delete( mail.num, mail.to )
#define delete_mail()     destroy_mail( mail.num, mail.to )
#define open_mail()       Mail.Open()
#define close_mail()      Mail.Close()
#define version_mail()    Mail.CheckVersion()
#define isopen_mail()     Mail.isopen
#define end_mail()        Mail.end
#define high_mail()       Mail.GetHigh()
#define find_mail_to(W,D) Mail.Load( W, (void *)&mail, 0, 99, 2, D )
//#define find_mail_to(W,D) Mail.Load( W, (void *)&mail, 5, 99, 2, D )
//#define find_mail_area(W) Mail.Load( W, (void *)&mail, 0, 4 )
//#define find_mail(W)      Mail.Load( W, &mail )
#define next_mail()       Mail.Load( &mail )
#define key_mail(D)       Mail.LoadKey( D )
#define key_mail_load()   Mail.LoadThisKey( (void *)&mail );
#define change_mail(O,N)  Mail.Change( mail.num, O, N )
#define number_mail(N)    Mail.Change( mail.num, N )
//void mail_keyword( uchar *d );  // Figures current keyword and places in 'd'

int  load_mailbase( unsigned long fpos, unsigned int area, ulong mnum );
int  save_mailbase( unsigned long fpos, unsigned int area, ulong mnum, uchar special=0 );
int  delete_mailbase( unsigned long fpos, unsigned int area, ulong mnum );
unsigned long free_mailbase( unsigned int area );
unsigned long high_mailbase( unsigned int area );
ulong fpos_mailbase( unsigned int area, unsigned long mnum );// Data Recovery


#define reset_filearea()     FileArea.Reset()
#define load_filearea(N)     FileArea.Load( N, &filearea )
#define save_filearea()      FileArea.Save( filearea.ID.keyword, filearea.ID.num, &filearea )
#define add_filearea()       FileArea.Add( filearea.ID.keyword, filearea.ID.num, &filearea )
#define delete_filearea()    FileArea.Delete( filearea.ID.num, filearea.ID.keyword )
#define open_filearea()      FileArea.Open()
#define close_filearea()     FileArea.Close()
#define version_filearea()   FileArea.CheckVersion()
#define isopen_filearea()    FileArea.isopen
#define end_filearea()       FileArea.end
#define high_filearea()      FileArea.GetHigh()
#define find_filearea(W)     FileArea.Load( W, &filearea )
#define next_filearea()      FileArea.Load( &filearea )
#define change_filearea(O,N) FileArea.Change( filearea.ID.num, O, N )
#define number_filearea(N)   FileArea.Change( filearea.ID.num, N )


#define reset_file()     	File.Reset()
#define load_file(N)     	File.Load( N, &file )
#define save_file()      	File.Save( file.ID.keyword, file.ID.num, &file )
#define add_file()              File.Add( file.ID.keyword, file.ID.num, &file )
#define delete_file()    	File.Delete( file.ID.num, file.ID.keyword )
#define openfile()       	File.Open()
#define close_file()     	File.Close()
#define version_file()          File.CheckVersion()
#define isopen_file()    	File.isopen
#define end_file()       	File.end
#define high_file()      	File.GetHigh()
#define file_keyword(W)    	sprintf( W, "%-15.15s%i", file.filename, file.area )
#define find_file_filename(W)   File.Load( W, (void *)&file, 0, 14, true )
#define find_file_area(W)       File.Load( W, (void *)&file, 15, 6 )
#define next_file()             File.Load( &file )
#define key_file()              File.LoadKey()
#define change_file(O,N) 	File.Change( file.ID.num, O, N )
#define number_file(N)   	File.Change( file.ID.num, N )



global char eventTmp[80];
#define reset_event()     Event.Reset()
#define load_event(N)     Event.Load( N, &event )
#define save_event()      Event.Save( event.ID.keyword, event.ID.num, &event )
#define add_event()       Event.Add( event.ID.keyword, event.ID.num, &event )
#define delete_event()    Event.Delete( event.ID.num, event.ID.keyword )
#define open_event()      {sprintf( eventTmp, "Event%i.Dat", node.ID.num+1 );\
			   Event.SetFileName(WithLSPath(eventTmp)); Event.Open();}
#define close_event()     Event.Close()
#define version_event()   Event.CheckVersion()
#define isopen_event()    Event.isopen
#define end_event()       Event.end
#define high_event()      Event.GetHigh()
#define find_event(W)     Event.Load( W, &event )
#define next_event()      Event.Load( &event )

#define change_event(O,N) Event.Change( event.ID.num, O, N )
#define number_event(N)   Event.Change( event.ID.num, N )



///////// Single Record DataFiles

int read_single( char *fname, void *s, long size, uchar checkVersion=false, uchar errors=true );
int write_single( char *fname, void *s, long size );

global unsigned long _data_fpos;


#endif

// End of Data.Cpp




