#ifndef __DISPLAY_HEADER_FILE__
#define __DISPLAY_HEADER_FILE__

#include "Fos.h"    // Door Authors - This is NOT a fossil driver...

global char lookfor_string[10][10];

int display( const char *, ... );
int out_codes( const char * );
int out( const char * );

void out_long( long );             // Displays a long integer
void out_long( ulong );            // Displays an unsigned long integer

int get_OK( int seconds );   // (0/1) Waits for an OK from the modem..

#ifndef _DOOR_CODE_
int waitfor( char *, int ); // waitfor( string, seconds )  No carrier check!
int lookfor( int );              // Look for 'lookfor_string's in x seconds
#endif
char *sergets( unsigned char *s, int maxlen, char *filters=0 );
inline char *s_gets( uchar *s, int m, char *f=0 ){ return sergets(s,m,f); }

int  serial_redraw_line( int ); // Redraws a line from screen like below
void serial_redraw( void );   // Redraws the screen to the serial port only.
			      // Used mostly after popscrn() call.
			      // Checks for serial connection.

int s_in( void );
short s_out( unsigned char );
int s_ready( char giveup=1 );
void s_cls( void );
void s_locate( uchar x, uchar y );  // Locates cur.  Assumes ANSI or better.
void s_color( uchar color );        // Changes color if needed

void s_eraseline( void );
inline void s_backspace( void ){ s_out('\b'); s_out(' '); s_out('\b'); }

void init_disp( void );

void direct_out( unsigned char out );  // Use with extreme caution, no
void direct_string( char *s );         // carrier detect or data formatting
short direct_ready( void );            // of any form!  See: s_in()/s_out()
short direct_in( void );

void echo_yn( char );      // Echos yes or no depending on char (==Y or ==N)

void scanner( void );
void clear_scanner( void );

global int extended;       // Extended Return value when s_in() returns 0

//global int redirect;

#define RE_LOCAL    0
#define RE_SERIAL   1
#define RE_ECHO     2

//global int terminal;

#define TERM_ASCII   0
#define TERM_ANSI    1
#define TERM_RIP     2



// Inlines

inline short  direct_ready( void ){ return in_ready(); }
inline short  direct_in( void ){ return get_serial(); }

#endif

// End of DispF.Cpp

