#ifndef __DOOR_ROUT_HEADER__
#define __DOOR_ROUT_HEADER__

global int read_commlinks,   // Set to 1 to allow pages to come through...
  dump_commlinks;            // Set to 1 to erase all current commlinks...

#ifdef _DOOR_CODE_
void door_update( void );
#endif

void clear_pause( void );
int  pause( int allowstop=1 );

void activity( void );       // Called by s_in() after getting input

void init_update( void );    // Called by drop.cpp & door.cpp only...

void forced_update( void );  // Call this to bypass 5 second limit
void update( void );

void save_commlink( int );   // Pass destination node #

uint matches( char *a, char *b );
int  FindExactUserOnline( uchar *lookfor );    // Returns node or -1
int  FindUserOnline( uchar *lookfor );   // (-1/Node) Removes from lookfor
void PageUser( void );       // Handles user paging

void write_nodeid( void );
int  read_nodeid( int );

void status_line( void );

void online_upgrade( void );
void sysop_chat( void );

uint best_userserch( uchar *find ); // Returns true/false and loads usersrch
uint best_username( uchar *find );  // Returns true/false and loads usersrch

global int resetDoor;   // First call to update() since a door...


  // Door authors - You should never have to directly manipulate this:
struct drop
{
  long charge;          // Rate currently being charged (Credits/minute)
			// Set by menus                           -=Public

  char hour, rate;      // Last hour checked, and rate used       -=Private

  long marked[ 40 ];    // File numbers currently marked (-1 for empty slot)

  char redirect;        // Current redirect value
  char terminal;        // Current terminal value
  char lines;           // Number of lines to display before pause

  char statusline;      // 0, 1, 2, 3, or 4 line status (F1+ F2-)

    // Private: Used by Door.Cpp: update() root time unit
  ulong doorlastc;      // Last (Clock) counter for update()...
    // Private: Used by Drop.Cpp: activity() and update()
  uint inact;           // Inactivity time left before dropping
  char inact_warn;      // Flag, have we given a warning yet?
    // Used by Drop.Cpp: reset_time_warn()
  char time_warn;

  union
  {
    unsigned char settings;
    struct set
    {
      char sysop:1;  	//  Bit 0:   (0/1) Is the sysop available?
      char sound:1;     //  Bit 1:   (0/1) Is sound on or off?
      char lock:1;    	// /Bit 2:   (0/1) Is the keyboard locked?
      char screen:1;	// \Bit 3:   (0/1) Is the screen off & locked?
      char snext:1;	// /Bit 4:   (0/1) Is a sysop next?
      char lnext:1;	// |Bit 5:   (0/1) Is a local next?
      char dnext:1;	// \Bit 6:   (0/1) Is a dos next?
      char dummy:1;     // Unused (Reserved)
    } set;
  } s;

} global drop;


struct nodeid           // WRITE ACCESS OWNED BY DOOR.CPP ONLY!   -=Public
{
  char online;          // (0/1) Node in use                  } Compared
  uchar handle[ 20 ];   // User's handle                      } from 'user'
  char sex;             // (0) Unknown (1) Male (2) Female    } to 'nodeid'
  ulong usernum;        // User's position, match to fcon.num } by update()

  long baud;            // Initialized baud rate
  char connect;         // BitFlag (0) None (1) MNP+ARQ (2) ARQ



  char status[ 15 ];    // Set by menus, user's current activity
  char available:1;     // Set to 0 on door call, set to 1 by SOME doors

  char link;            // Current global link #
  char inchat;          // (0/1) Is user in a sysop-chat?
} global nodeid, readid, lastid;  // Lastid is PRIVATE to Door.Cpp


  // Door Authors - If you need to use the CommLink standard, please contact
    // LightSpeed HQ and a unique link ID and/or type ID will be granted free
    // of charge.
			// DISK ACCESS OWNED BY DOOR.CPP ONLY!
struct commlink         // Global communications system (Multi-Node)
{
  char type;            // (0) Not used, (1) Message, (2) Link, (3) HangUp
  char link;            // Link #, must match to be used (0=All)
  char from[ 20 ];      // Author's handle (Shown in messages as <from>)
  char data[ 160 ];     // Text and misc. data
} global commlink;

#endif

// End of Door.H

