// Example3.Cpp - Sending a Commlink (Page)...

#define MainModule
#include "LsDoor.H"

char *errorModule( void ){ return "Example3 Commlinks"; }


void main( void )
{
  if( !DoorInit( doorsysDISABLE ) ) exit(1);      // Get things started...
  // If you just need to send a page, call the PageUser() function and you're
  // done.
  PageUser();

  int oldRead = read_commlinks;
  read_commlinks = 0;   // Don't want an incoming to erase our workspace...

  // If you need to communicate with another node, you can setup a custom
  // CommLink type, BUT contact LightSpeed HQ before you do this in any
  // public program.  You will have a unique ID number given for your program
  // free of charge.

  commlink.type = 1;    // This will be where your unique ID goes.  Type 1
                        // is the regular pager.  Types 0 to 30 are reserved.
  commlink.link = 0;
  strcpy( commlink.from, user.handle );
  strcpy( commlink.data, "You can send whatever you need here" );
    // The commlink.data is a char string of 160 bytes.  You can put whatever
    // data you need here.  For type 1 (User to user pages) this contains the
    // text from the page.

    // node.ID.num provides the current node's number, except that the first
    // first node is always number 0.  save_commlink() also requires a
    // start-at-0 node number.

  int bestNode = node.ID.num + 3;     // bestNode = 'This Node #' + 3

  /*  You could use this method if you needed to find someone by name:
  if( (bestNode=FindUserOnline("UsersHandle")) == -1 ){
    display("\n@CU@cser not found...");
    read_commlinks = save_rdcomm;
    return;
  }
  */

  save_commlink( bestNode );   // save_commlinks() also uses start-at-0 node#
  read_commlinks = oldRead;
  display("\n@1...@WS@went just fine..." );
  display(
    "\n\n@CPlease note that the results of this example will not be apparant"
    "\nunless you are running other LightSpeed nodes which can receive the"
    "\npages sent from this example."

  exit(0);                                        // Always use exit()
}

// End of Example3.Cpp



