#ifndef __FOSSIL_HEADER_FILE__
#define __FOSSIL_HEADER_FILE__

#include "Comm.h"
#include "Util.h"

global ASYNC Com;


int init_comm( int comport, long baud, int irq, int base, short inbuffr,
  short outbuffr, int fifo, int mode, int flow );
	 // Mode = (0) AutoDetect (1) Fossil (2) Internal
	 // Fifo = (0) AutoDetect (1) 16550 (2) 8250
	 // Flow = (0) None (1) Cts/Rts (2) Xon/Xoff (3) Both

short put_serial( unsigned char wr );
int  get_serial( void );
inline int  in_ready( void ){ return async_rxcnt( &Com ); }

inline char carrier( void ){ return async_carrier( &Com ); }
void set_dtr( int dtr );
void set_baud( unsigned long newbaud );
void set_flow( int flowmode );  // = (0) None (1) CTS/RTS (2) XON/XOFF
				//   (3) CTS/RTS and XON/XOFF

void purge_in( void );

void close_fossil( void );

void disable_port( void );   // Temporarily disables port (for spawning)
void enable_port( void );    // Re-enables a port after disable_port().

void scramble_exit( void );  // Call exit() leaving DTR high...

void reset_port( void );

inline char okey_hangup(){   // Returns 1 when all transmit buffers are clear
//  return (async_txfree(&Com) && !async_txcnt(&Com));
  return !async_txcnt(&Com);
}

global int foss_active;  // READ Only variable, set by init_comm()
			 // (0) Internal Comm and (1) Fossil


#endif




