// LightSpeed data structures and main header file...

   // See SetEd.H for information...

#ifndef _DOOR_CODE_
#include "seted.h"
#else
#define MaxNodes 256		// Door authors may change this...
#endif

  // Uncomment this to enable debug calls
//#define _DEBUG_CODE_
//#define DEBUG(X) printf("\nDebug code %i\n", X ); getch();
//#define ONLINE(X) printf("\nDebug code %i - Online = %i\n",X,online); getch();

#ifdef DataModule
#ifndef _DOOR_CODE_
char editionString[40] = Edition;
#endif
short LSVersion = 1; short LSSubVersion = 40;   // v1.40
#else
#ifndef _DOOR_CODE_
extern char editionString[40];
#endif
extern int LSVersion, LSSubVersion;
#endif


/////////

//  Definition of a "Post":
//
//    A Post is any message either addressed to "ALL" or a PUBLIC message
//  directed at multiple targets ("Conversation-types").  A reply to an
//  ALL becomes public, a reply to a public-conversation remains a post.
//  Private-conversations are NOT posts, but can exist (they are private).
//  A conversation can never be public, it is always post or private.
//

/////////


//  UserFlags and SubMenu:
//
//    UserFlags Class 1:  Data is a signed long, values:
//
//      -1     ...No experation
//       0     ...Not active (Already expired, never given, etc.)
//       1+    ...Days till expires
//
//      Use "int get_flag( int )" by passing the Class 1 variable and
//     recieving a 1/0 if it is CURRENTLY active.
//
//
////
//
//    SubMenu Class 1:  Data is a signed integer, values:
//
//      -1     ...No experation
//       0     ...Not active (Already expired, never given, etc.)
//       1+    ...Minutes left till expired
//
//
//
////
//
//    Class 2:  Data is a signed char, switch:
//
//      -1     ...The user's flag/submenu must be OFF to access this.
//       0     ...This user flag/submenu is ignored.
//      +1     ...The user's flag/submenu must be ON to access this.
//

#ifndef __LIGHTSPEED_HEADER__
#define __LIGHTSPEED_HEADER__

#ifndef __LIB_HEADER__
#ifndef _DOOR_CODE_
#error Error..  Include LIB.H
#else
#include "Lib.h"
#endif
#endif

#ifdef _DOOR_CODE_REG_
#define _DOOR_CODE_
#endif

/////////  General definitions...

typedef unsigned char uchar;
typedef unsigned int  uint;
typedef unsigned long ulong;

typedef unsigned char test;

#define true    1
#define false   0



/////////  Global variables...

global uchar temp[ 100 ], tempB[ 80 ], tempC[ 80 ];

#ifdef DataModule
uchar LSDrive = 0, LSPath[ 80 ];
#else
extern uchar LSDrive, LSPath[ 80 ];  // LSPath has no drive no \

#endif

global long i, j, k, l, work;

global struct time timec;
global struct date datec;

global char terminal, redirect, online, lmaskchar, smaskchar, holdmask;
global char lterm_fast; // (0/1) Convert ansi codes -> LTerm codes
global char lterm_ext;  // (0/1) Graphics mode supported

global ulong code[ 6 ]; // See internal.cpp and menu.cpp

global int  log_fcb;    // File handle for activity log use...

global struct ffblk ffblk;

global short sysop_view_user; // User to view if Alt-S is pressed.  0 if
			      // not applicable.

global char blankline[ 90 ];   //  = "\r        ..."
global char thinline[ 90 ];    //  = "\r--------..."
global char thickline[ 90 ];   //  = "\r========..."

global test is_lord;          // Are we running as a LORD IGM?

/////////  Functions & Macros...

#define d_msg(S) d_str(S)




/////////  Record structures...


struct ID    // Data Control Block (To make file I/O access easier)
{
  unsigned long num;  // Number in the database                    -=Public
  unsigned int  code; // To reconstruct the database               -=Private
	     // This is set once by main() in each structure.
             // Door Authors: Code can be used for your own purpose, but
             // don't use it with LightSpeed's data structures.
  unsigned char keyword[20];  // Index key data                    -=Public
};



struct master
{
  unsigned char bbs_name[ 40 ];     // Name of the system
  unsigned char address[ 40 ];      // LaserLink Address
  unsigned char sysop[ 20 ];        // Sysop's handle (Local/Master sysop)
  unsigned char main_number[ 20 ];  // Main BBS Data number (LaserLink)

//  unsigned char harddrive;   // Drive letter containing LightSpeed
  unsigned char ramdrive;    // Drive letter for display or = hardrive

  char numpages;             // Number of times to beep in a page

  struct system
  {
    long calls;
    long files;
    long messages;
    long users;
  } system;

  struct records
  {
    long calls;
    long uploads;
    long messages;
    long newusers;
    struct date calls_date;
    struct date uploads_date;
    struct date messages_date;
    struct date newusers_date;
  } records;

  struct today
  {
    long calls;
    long uploads;
    long messages;
    long newusers;
    struct date when;
  } today;

  uchar months_user;      // Months since last call to delete a user

  uchar days_unprivate;   // Days old to delete an un-read private
  uchar days_unpost;      // Days old to delete an un-read post
  uchar days_unpublic;    // Days old to delete an un-read public
  uchar days_private;     // Days old to delete a read private
  uchar days_post;        // Days old to delete a read post
  uchar days_public;      // Days old to delete a read public
  uchar days_generic;     // Days old to delete a generic message

  uchar reserved[6];      // Reserved for future use...

} global master;

/////////

struct node
{
  struct ID ID;              // Data Control Block

  char comment[ 40 ];        // Sysop's note/special cases/etc.

  char laststatus;           // Last setting of statusline
  char lastcall[ 20 ];       // Last caller's handle
  struct date lastdate;      // Date of last call
  struct time lasttime;      // Time of last call

  char swap_mode;            // (0) Swap-Any (1) EMS (2) XMS (3) Disk
  char temp_dir[ 40 ];       // Drive and/or path for Swap files (Temp files)

  char driver;               // (0) Autodetect (1) Fossil (2) Internal
  char fifo;                 // (0) Autodetect (1) 16550  (2) 8250
  int  comport;              // ComPort number (0-99) 0 = Local
  int  irq;                  // (Internal Only) IRQ #
  int  base;                 // (Internal Only) Base Address
  int  inbuffer;             // (Internal Only) Input buffer
  int  outbuffer;            // (Internal Only) Output buffer
  long baud;                 // Initialized baud rate
  char reset[ 40 ];          // Modem reset command (AT Z)
  char init[ 40 ];           // Modem init command (AT M0)
  char answer[ 20 ];         // Modem answer command (AT A)
  uchar flow;                // (0) None (1) CTS/RTS (LATER=XON/XOFF)
  uchar dialmode;            // (0) Tone (1) Pulse
} global node;

/////////

struct config
{
			     // NO Control Block, 1-record-per-file

  char board;                // (0/1) Open Questionare    (2) Open Mail+Q,
			     // (3) Closed, (4) Closed Q, (5) Closed Mail

  char newquest[ 60 ];       // Path & filename of new user questionare

  char flags[ 10 ][ 10 ];    // Flag NAMES, refrence only
  char submenu[ 10 ][ 10 ];  // Submenu NAMES, refrence only

  int  newsec;               // New user security set
  long newtime;              // Time for first call
  long newcredits;           // # of credits given to new users

  char timeout;              // Minutes of inactivity before logging off

  char charges[ 24 ];        // % of settings to charge at hour (credits)
			     // Only applies to per-minute rate   (0-100)

  uint perdollar;            // # of credits given per dollar...

  uchar ripenabled;          // (0/1) Allow use of RIPterm terminal?

  uint env_size;             // Size of environment when calling Command.Com

  uchar filecredit;          // Credit (0) After Quick-Scan (1) After MAINT

  long kratio;               // KB Ratio given to new users...  (Inverted
  long dlratio;              // DL Ratio given to new users...   - to +)

} global config;

/////////

struct security
{
  ulong num;

  char name[ 10 ];           // Security level's name

  int  doorlevel;            // Security level (For doors)

  int  timeday;              // Maximum time per-day
  int  calltime;             // Maximum time per-call
  int  callsday;             // Maximum calls per-day

  int  downgrade;            // New security set after expiration date

  long freecredits;          // Free Credits given each day

  int  submenu[ 10 ];        // Class 1, Value for submenu[*] each day

  long klimit;               // Maximum K downloadable in a day
  long dllimit;              // Maximum files downloadable in a day

  long kratio;               // Number K downloadable per K uploaded
  long dlratio;              // Number files downloadable per uploaded

  uchar sysop;               // (0) No (1) Sysop (2) Master

  struct {
    uchar ularea:1;
    uchar dlarea:1;
    uchar mailarea:1;
  } a[ 1000 ];               // Maximum # of areas supported is 1,000

} global security, secserch;

////

struct user
{
  ulong num;

  uchar handle[ 20 ];        // User's id name, handle, or alias
  char real[ 20 ];           // User's real name
  uchar password[ 10 ];      // User's password
  char vphone[ 20 ];         // User's phone number in 000-000-0000 form
  char dphone[ 20 ];         // User's data number in 000-000-0000 form
  char citystate[ 20 ];      // User's city & state
  char zipcode[ 20 ];        // User's zipcode
  uchar comment[ 8 ][ 40 ];  // User Comments
  struct date bday;          // User's birthdate
  char sex;                  // User's sex (0) Unknown (1) Male (2) Female

  long credits;              // Remaining credits in user's account

  struct date expire;        // Date security expires (To security.downgrade)
  int  security;             // Number of security level
  long flags[ 10 ];          // UserFlags, class 1, see above
  int  submenu[ 10 ];        // SubMenu, class 1, see above

  int  callstoday;           // Calls today
  int  timelimit;            // TimeLimit (timeused+this=bye) for this call
  int  timeused;             // Time used TODAY

  char setterm;              // (0) AutoDetect, or 'nodeid.term = setterm-1'
  char setlines;             // 'nodeid.lines = setlines'

  char proto;                // Default protocal (NULL = Select)

  char editor;               // (0) AutoDetect, (1) Select, (2) Full, (3) Line

  ulong himail;               // Last read mail # (Private)
  ulong himailall;            // Last read mail # (To ALL)
  ulong himailpublic;         // Last read mail # (Public)

  struct time timeon;        // Time of user's last (Previous) call (Logoff)
  struct date dateon;        // Date of user's last (Previous) call (Logoff)

  long s_calls;              // Total calls to system and local/sysop logins
  long s_locals;             // Total local/sysop logins
  long s_uploads;            // Total # of uploads
  long s_downloads;          // Total # of downloads
  long s_upk;                // Total KBytes uploaded
  long s_downk;              // Total KBytes downloaded
  long s_written;            // Total messages written
  long s_read;               // Total messages read

  long kratio;               // # of KBytes ratio (Can be negative)
  long dlratio;              // # of files ratio (Can be negative)

  struct date newfiles;      // Last [N]ew files scan

  struct reg
  {
    char used;               // (0/1) Registery has been filled out

    char age[ 5 ];           // Age
    char phone[ 20 ];        // Phone number or unlisted
    char first[ 30 ];        // First/Last/No name
    char hobbies[ 60 ];      // Hobbies
    char sports[ 60 ];       // Sports
    char board[ 20 ];        // Or NULL if none
    char bbsnum[ 20 ];       // Phone number to BBS
    char looks[ 60 ];        // Appearance
    char unused[ 60 ];       //
    char movie[ 20 ];        // Favorite movie
    char tvshow[ 20 ];       // Favorite TV Show
    char music[ 20 ];        // Favorite music

    char summary[ 2 ][ 40 ]; // 2 lines of summary, NULL if not used
  } reg;

} global user, userserch;

/////////

struct mail
{
  ulong num;

  ulong area;                // Match for mailarea.ID.num

  ulong credits;             // Credits attached to this message

  uchar from[ 20 ];          // Author of message
  uchar to[ 100 ];           // Target of message, or ALL
  uchar subject[ 20 ];       // Description of message

  struct date madedate;      // Date message was written
  struct time madetime;      // Time message was written

  uchar type;                // (0) Public, (1) Private,
			     // (2) Private-LaserLink,
			     // (3) Private-Alias-Change-Request
			     // (4) Generic Broadcast
  uchar read;                // Message was received (0) No (1) Yes
  uint  replies;          // ** Number of replies or 0

  unsigned long fpos;        // Position in message base
  unsigned long lsize;    // ** Length in message base (for data recovery)
} global mail;            // ** Double-Stars are not yet supported, "reservd"

//#ifndef _DOOR_CODE_
//#ifndef _DOOR_CODE_REG_
//#include "Lite2.H"            // Header for LightSpeed BBS Software only...
//#endif
//#endif

inline char *strchr( unsigned char *str, int c ){ return strchr( (char *)str, c ); }

#endif

// End of Lite.H




