#ifndef __MAIL_HEADER_FILE__
#define __MAIL_HEADER_FILE__


#define MAIL_LINES   150      // Maximum supported lines in mail editor
   // If a value > MAIL_LINES is passed to maileditor(), it is replaced
   // by MAIL_LINES.  Door authors shouldn't touch this value.

					  // Takes 12K of RAM at 150 Lines
global uchar buffer[ MAIL_LINES ][ 80 ];  // Message buffer


void clear_buffer( char );  // Sets all spaces in buffer to NULL

inline uchar mail_to( uchar *to, uchar *user=user.handle );

int find_lowest_mailarea( void ); // Find lowest mailarea user can access...

void mail_error( ushort errNum );  // Report bad message (from, to, etc)

  // Set type to the base, if a file is attached type will be changed
int write_message( int lines=MAIL_LINES, char abort=1, char clearbuf=1,
  char type=1, int area=find_lowest_mailarea(), long credits=0 );

int  maileditor( int lines, char abort, char clearbuf=1 );
    // Lines, maximum lines in the message.
    // (0/1) Abort allowed?
    // Return (0) Aborted or (1) Save
    // Does NOT save to disk, it edits the message and leaves it in
    // the message buffer.

    // Serch = (0) Personal (1) To ALL (2) Public
int  is_new_mail( int serch );   // Search and don't show new mail
void find_new_mail( int serch ); // Search and show new mail


void search_mail( int start, char *from, char *to, char *subject, char *body,
  int area );


  // User selected (0) eXit or (1) Continue
int  show_message( int allowprevious=0 );     // Show message in the buffer

truth isMailPrivate(void);
truth isMailPublic(void);
truth isMailPost(void);

#endif

// End of Mail.H

