#ifndef __UTIL_HEADER_FILE__
#define __UTIL_HEADER_FILE__

#ifdef _DOOR_CODE_
char *errorModule( void );   // Should return program ex: LsWall or LaserLink
			     // (Data must be constant throughout program)
#endif
			     // Buffer only, no logic use by error()
global char errbuf[ 80 ];    // Used to formulate "error()" calls

global char sub[ 50 ][ 40 ]; // Replacements for @oo codes

global char substring[ 120 ];// Return value of get_substring()...

global char LSLogFile[ 80 ]; // The current activity log filename...

  // Open file with automatic lock-retry...

  // fatal = (0) Return -1 on error, (1) Error if File Not Found/Other

  // ex:  open_file( fatal, "FName.ABC", O_RDONLY, SH_DENYNONE );

int open_file( int fatal, const char *name, int access, int lock );

char updated( char *fname, struct date *newerdate, struct time *newertime );
char updated( struct ffblk *ff, struct date *newerdate, struct time *newertime );

void dvticks( ulong ticks ); // Delays for near 'ticks' ticks (18.2 per second)
inline void dvsleep( short secs ){ dvticks( 18 * secs ); }
void wait( unsigned short seconds );

int  disp_file( const char *, int=0 );    // Display file (searches paths)
int  type_file( const char *, int=0 );    // Display file (Sets extension)

char *kill_codes( char *sout, char *sin );  // Removes @x and @x@ codes
char *kill_disp_codes( char *sout, const char *sin );  // Removes @x codes
char *set_ext( char *sout, char *sin, char *ext ); // Set extension of sin
char *set_ext( char *s, char *ext );               // Set extension of s
char *kill_drive( char *s );                // Removes drive letter and colon
char *kill_path( char *s );                 // Remove everything before \
char *kill_slash( char *s );                // Removes trailing backslash
int   count_disp_bytes( const char *s ); // Returns the # of bytes in @x's

int  show_locked( char * );    // Pass filename for error-logs
void show_unlocked( void );

void error( char * );

void repair( int param );  // Invokes Upgrade.Exe with itoa(param)...

char *get_size( ulong filesize, char *t );// set t =  xxxx Megs/KBytes/Bytes
int  wildmatch( char *, char * ); // strcmpi() with * and ? recongnition

void detect_terminal( void );   // Try to detect Ansi/Ripterm/LTerm

int  years_since( struct date * );      // Return years since said-date
unsigned long date2int( struct date * );// Returns days since 1-1-1990
void int2date( struct date *, ulong );  // Fills date with days in ulong
void smooth_date( struct date * );      // Moves days>30ish as a new month
					// and month>12 into new years etc.
void smooth_time( struct time * );      // Moves min>60 into hour++ etc.
char *format_time( struct time *, char * ); // Formats time with am/pm
void string2date( char *str, struct date *dt );  // Ascii to Date{} convert
unsigned int twodigit( int n );         // Returns 19xx as xx (1963 = 63)
unsigned int fourdigit( int n, int thisyear );   // Rets xx as 19xx

  // Extracts a block from a "comma-based" string.  Illustration:
  //         "[Substring0],[Substring1],[Substring2]"
char *get_substring( char *mainstring, int subnumber, int maxlen=80 );

  // Searches for a entry in a "comma-based" string.  Like strcmpi()
uchar is_substring( char *liststring, char *search, int maxlen/*=80*/ );

	// Templates:
	//   0..  Anything less than SP goes splat...
	//   1..  Anything other than A-Z, a-z, and space go splat...
void filter( char *string, int maxlen, int style );

int  open_records( void );  // Opens Records.Dat for RdWr|Binary|Create|Apnd

void compare_records( void );   // Compares master.today with master.records

void add_log( const char * );     // Adds a line to the current activity log

void hang_up( void );

#ifndef TRIAL
void spawn( char *, char * ); // a = temp_directory,
       // b = program name (Batch files with or without extension are ok)
#endif

void new_security( void );   // Call after online security change...
int  search_user( char *, int, char );     // int = (0) Handle, (1) Real

#define show_prompt(P) if( load_prompt(P) ) display(prompt.text);

#ifndef _DOOR_MODE_
#ifndef TRIAL
void LaserLink( uchar *commandLine ); // Send commandLine: "Laser.Exe Han.."
#endif
#endif

  // Door authors - DO NOT touch the following variables.  They are reserved
  // for some of the LightSpeed companions such as MAINT and LSFIX.
#ifdef UtilModule
char Override_Locking = false;
#else
extern char Override_Locking;   // Used by companions only for file access
#endif

#endif

// End of Util.H

