/* Simple program to demonstrate using arrow keys within an OpenDoors door */
/* program. Since the arrow keys are normally used locally to adjust the   */
/* user's time up or down, you must choose different keys to adjust the    */
/* time limit. This program simply loops, displaying the word "up" if the  */
/* up arrow is pressed, "down" if the down arrow is pressed, and exiting   */
/* if the enter key is pressed.                                            */

#include "opendoor.h"

main()
   {
   int choice;
   char pressed;
   long timer;

   /* Notice call to od_init() here! */
   od_init();

   /* Reassign PageUp and PageDown to increase/decrease time         */
   /* Remember to do this after od_init() or your first call to some */
   /* OpenDoors function.                                            */
   od_control.key_lesstime = 0x5100;   /* Scan code for Page Down */
   od_control.key_moretime = 0x4900;   /* Scan code for Page Up */

   od_disp_str("Press up and down arrows keys. Press Enter when done\r\n");

   for(;;)
      {
      pressed = od_get_key(TRUE);

      /* Check for ANSI arrow key sequences */
      if(pressed==27)
         {
         timer=(*(long far *)0x46cL)+2L;
         while(timer>*(long far *)0x46cL && (pressed=od_get_key(FALSE))==0)
            {
            od_kernel();
            }

         if(pressed != '[')
            {
            continue;
            }
         else
            {
            timer=(*(long far *)0x46cL)+9L;
            while(timer>*(long far *)0x46cL && (pressed=od_get_key(FALSE))==0)
               {
               od_kernel();
               }
            if(pressed == 0) continue;
            switch(pressed)
               {
               case 'A':
                  goto up_arrow;

               case 'B':
                  goto down_arrow;
               }
            }
         }

      /* Check for doorway / local arrow key sequences */
      else if(pressed==0)
         {
         /* Get the next key from the keyboard */
         timer=(*(long far *)0x46cL)+9L;
         while(timer>*(long far *)0x46cL && (pressed=od_get_key(FALSE))==0)
            {
            od_kernel();
            }
         if(pressed == 0) continue;

         /* Respond appropriately */
         switch(pressed)
            {
            case 0x48:
up_arrow:
               od_disp_str("Up Arrow.\r\n");
               break;

            case 0x50:
down_arrow:
               od_disp_str("Down Arrow.\r\n");
               break;
            }
         }
      /* exit program if user presses CR or LF */
      else if (pressed == '\n' || pressed == '\r')
         {
         break;
         }
      }

   return(0);
   }
