;-------------------------------------------------+
;XDEF.INC                                         |
;(c)1994 by PietroArts                            |
;                                                 |
;VGA operations defines                           |
;                                                 |
;-------------------------------------------------+


FALSE	EQU 0
TRUE	EQU 1
NIL	EQU 0

B	EQU BYTE PTR
W	EQU WORD PTR
D	EQU DWORD PTR
O	EQU OFFSET
F	EQU FAR PTR
S	EQU SHORT
?X4	EQU <?,?,?,?>
?X3	EQU <?,?,?>

; ===== VGA REGISTER VALUES =====

VGA_VIDEOMEM	EQU 0A0000H ; VGA MEMORY ADDESS (DWORD!)


;----------------------------------------------------------------
;MODE 360 x 240 (+8 = logical wide because of pelpan scrolling)
;SCREENBYTEWIDE EQU	368/4
;SCREENWIDE	EQU	368
;----------------------------------------------------------------
;MODE 320 x 240
SCREENBYTEWIDE EQU	360/4
SCREENWIDE	EQU	360

;SCREENBYTEWIDE EQU	392/4
;SCREENWIDE	EQU	392




ATTRIB_CTRL	EQU 03C0H   ; VGA ATTRIBUTE CONTROLLER
AC_INDEX	EQU 03c0h	; - " -
GC_INDEX	EQU 03CEH   ; VGA GRAPHICS CONTROLLER
SC_INDEX	EQU 03C4H   ; VGA SEQUENCER CONTROLLER
SC_DATA	EQU 03C5H   ; VGA SEQUENCER DATA PORT
CRTC_INDEX	EQU 03D4H   ; VGA CRT CONTROLLER
CRTC_DATA	EQU 03D5H   ; VGA CRT CONTROLLER DATA
MISC_OUTPUT	EQU 03C2H   ; VGA MISC REGISTER
INPUT_1	EQU 03DAH   ; INPUT STATUS #1 REGISTER
INPUT_STATUS_1 EQU 03DAH   ; INPUT STATUS #1 REGISTER
INPUT_STATUS_0 EQU 03dah

DAC_WRITE_ADDR EQU 03C8H   ; VGA DAC WRITE ADDR REGISTER
DAC_READ_ADDR	EQU 03C7H   ; VGA DAC READ ADDR REGISTER
PEL_DATA_REG	EQU 03C9H   ; VGA DAC/PEL DATA REGISTER R/W

PIXEL_PAN_REG	EQU 033H    ; ATTRIB INDEX: PIXEL PAN REG
MAP_MASK	EQU 002H    ; SEQU INDEX: WRITE MAP MASK REG
READ_MAP	EQU 004H    ; GC INDEX: READ MAP REGISTER
START_DISP_HI	EQU 00CH    ; CRTC INDEX: DISPLAY START HI
START_DISP_LO	EQU 00DH    ; CRTC INDEX: DISPLAY START LO

MAP_MASK_PLANE1 EQU 00102H  ; MAP REGISTER + PLANE 1
MAP_MASK_PLANE2 EQU 01102H  ; MAP REGISTER + PLANE 2
ALL_PLANES_ON	EQU 00F02H  ; MAP REGISTER + ALL BIT PLANES

PEL_PANNING	EQU 13h
CRTC_OFFSET   equ    13h     ; CRTC offset register index

CHAIN4_OFF	EQU 00604H  ; CHAIN 4 MODE OFF
ASYNC_RESET	EQU 00100H  ; (A)SYNCHRONOUS RESET
SEQU_RESTART	EQU 00300H  ; SEQUENCER RESTART

LATCHES_ON	EQU 00008H  ; BIT MASK + DATA FROM LATCHES
LATCHES_OFF	EQU 0FF08H  ; BIT MASK + DATA FROM CPU

VERT_RETRACE	EQU 08H     ; INPUT_1: VERTICAL RETRACE BIT
PLANE_BITS	EQU 03H     ; BITS 0-1 OF XPOS = PLANE #
ALL_PLANES	EQU 0FH     ; ALL BIT PLANES SELECTED
CHAR_BITS	EQU 0FH     ; BITS 0-3 OF CHARACTER DATA

GET_CHAR_PTR	EQU 01130H  ; VGA BIOS FUNC: GET CHAR SET
ROM_8X8_LO	EQU 03H     ; ROM 8X8 CHAR SET LO POINTER
ROM_8X8_HI	EQU 04H     ; ROM 8X8 CHAR SET HI POINTER

NUM_MODES	EQU 8       ; # OF MODE X VARIATIONS

TIMER_VECT	equ	08h
DPMI_INT	equ	31h

PIC_CMD	equ	20h
NONSPEC_EOI	equ	20h
TIMER_MODE	equ	34h
TIMER_MODE1	equ	36h
TIMER_CONTROL	equ	43h
TIMER_0	equ	40h

LATCH_COUNT	equ 	00h
INT_IN_ADVANCE equ	100

