;-------------------------------------------------+
;XMAC.INC                                         |
;(c)1994 by PietroArts                            |
;                                                 |
;MACROS used throughout                           |
;                                                 |
;-------------------------------------------------+


;FUNCTION:	Macros Used Throughout
;CODED:	29/10/94 22:59
;BY:	Pietro Mokrosh
;HISTORY:	-
;DESCRIPT:
;



; (if reg<256)
;    reg = SCREENBYTEWIDE * reg

MACRO	SWMUL	reg
	mov	reg,[word ptr MulScrWideTab+reg*2]	;takes 1 Clock!
ENDM


;push word, used for pushing constants
           macro pushw ww
           mov ax,ww
           push ax
           endm


; macro to out a 16 bit value to an i/o port
           macro out_16 register, value
           ifdifi <register>, <dx> ; if dx not setup
           mov dx, register        ; then select register
           endif
           ifdifi <value>, <ax>    ; if ax not setup
           mov ax, value           ; then get data value
           endif
           out dx, ax              ; set i/o register(s)
endm


; macro to out a 8 bit value to an i/o port
           macro out_8 register, value
           ifdifi <register>, <dx> ; if dx not setup
           mov dx, register        ; then select register
           endif
           ifdifi <value>, <al>    ; if al not setup
           mov al, value           ; then get data value
           endif
           out dx, al              ; set i/o register
endm


; macros to push and pop multiple registers
macro pushx  r1, r2, r3, r4, r5, r6, r7, r8
           ifnb <r1>
           push r1                 ; save r1
           pushx r2, r3, r4, r5, r6, r7, r8
           endif
endm

       macro popx r1, r2, r3, r4, r5, r6, r7, r8
           ifnb <r1>
           pop r1                  ; restore r1
           popx r2, r3, r4, r5, r6, r7, r8
           endif
endm


; macro to clear registers to 0
       macro clr register, r2, r3, r4, r5, r6
           ifnb <register>
           xor register, register  ; set register = 0
           clr r2, r3, r4, r5, r6
           endif
endm


; macros to decrement counter & jump on condition
      macro loopx register, destination
           dec register            ; counter--
           jnz destination         ; jump if not 0
endm


     macro loopjz register, destination
           dec register            ; counter--
           jz destination          ; jump if 0
endm


;Shift Multiply Macro - Multiply number by constant (must be power of 2)
	MACRO	smul value,const
	if const eq 2
		shl value,1
	elseif const eq 4
		shl value,2
	elseif const eq 8
		shl	value,3
	elseif const eq 16
		shl value,4
	elseif const eq 32
		shl value,5
	elseif const eq 64
		shl value,6
	elseif const eq 128
		shl	value,7
	elseif const eq 256
		shl	value,8
	elseif const eq 512
		shl	value,9
	else
		display "Undefined Shift Multiply Macro for &const"
		.err
	endif
ENDM


;Shift Divide Macro - Divide number by constant (must be power of 2)
	MACRO	sdiv value,const
	if const eq 2
		shr value,1
	elseif const eq 4
		shr value,2
	elseif const eq 8
		shr	value,3
	elseif const eq 16
		shr value,4
	elseif const eq 32
		shr value,5
	elseif const eq 64
		shr value,6
	elseif const eq 128
		shr	value,7
	elseif const eq 256
		shr	value,8
	elseif const eq 512
		shr	value,9
	else
		display "Undefined Shift Divide Macro for &const"
		err
	endif
ENDM



; wait for escape key

     	macro WAITESC
              local   lab1, lab2
lab1:         in      al, 60h
              cmp     al, 1
              jne     lab1
lab2:         in      al, 60h
              cmp     al, 1
              je      lab2
              endm

;-----------------------------------------------------------------------
; Macro to wait for the vertical retrace leading edge

macro WaitVsyncStart
	LOCAL WaitNotVsync,WaitVsync
	mov     dx,INPUT_STATUS_0
WaitNotVsync:
	in      al,dx
	test    al,08h
	jnz     WaitNotVsync
WaitVsync:
	in      al,dx
	test    al,08h
	jz      WaitVsync
	endm

;-----------------------------------------------------------------------
; Macro to wait for the vertical retrace trailing edge

macro WaitVsyncEnd
	LOCAL WaitNotVsync,WaitVsync
	mov     dx,INPUT_STATUS_0
WaitVsync2:
	in      al,dx
	test    al,08h
	jz      WaitVsync2
WaitNotVsync2:
	in      al,dx
	test    al,08h
	jnz     WaitNotVsync2
	endm

