{$A+,B-,D+,E+,F-,G-,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384,0,655360}
Unit AppndDat;
Interface
Uses dos,filemisc;

Function EXESize(Fn: PathStr): longint;
Function DataAppended(Fn: PathStr): boolean;
Procedure PutConfig(Fn: PathStr; pCfgRec: pointer; RecSize: word);
Procedure GetConfig(Fn: PathStr; pCfgRec: pointer; RecSize: word);

Implementation

Function EXESize(Fn: PathStr): longint;
{ Returns size of executable code in EXE file }
type
  tSizeRec = record    { first 6 bytes of EXE header }
    mz : array[1..2] of char;
    remainder,pages: word;
  end;
var
  f : file;
  sz : tSizeRec;
begin
  assign(f,Fn);
  reset(f,1);
  if ioresult <> 0 then EXESize := 0 else begin
    blockread(f,sz,sizeof(sz));
    close(f);
    with sz do EXESize := remainder + (pred(longint(pages)) * 512);
  end;
end;

function DataAppended(Fn: pathstr) : boolean;
begin
  If fexist(Fn) then DataAppended := (fsize(Fn) > EXESize(Fn))
  else DataAppended := false;
end;

procedure PutConfig(Fn: pathstr; pCfgRec : pointer; RecSize : word);
var
  f: file;
  DataOffset: longint;
begin
  DataOffset := EXESize(Fn);
  assign(f, Fn);
  reset(f, 1);
  seek(f, DataOffset);
  blockwrite(f, pCfgRec^, RecSize);
  close(f);
end;

procedure GetConfig(Fn: pathstr; pCfgRec: pointer; RecSize: word);
var
  f : file;
  DataOffset,Fsize,Fpos: longint;
begin
  if not dataappended(Fn) then exit;
  DataOffset := EXESize(Fn);
  assign(f, Fn);
  reset(f, 1);
  if ioresult <> 0 then exit;
  seek(f, DataOffset);
  fpos := filepos(f);
  fsize := filesize(f);
  if recsize > fsize-fpos then recsize := fsize-fpos;
  blockread(f, pCfgRec^, RecSize);
  close(f);
end;

end.
