{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,R-,S-,V+,X+}
{$M 16384,0,655360}
Unit AsmMisc; { by John MD Stephenson; Copyright 1995 }
{
  Country specific case conversation and other info retrieval
  donated to the public domain by Bjrn Felten @ 2:203/208.
  Arne de.Bruijn wrote the WildComp function.
  The UnCrunch routine comes from TheDraw (pd)
  All other code is written by myself, or uncredited Public Domain.
  Note: This code is not specific to assembler, but also contains other
        miscelleneous coding, and is a place where other stuff is
        initialized.

   Notes on Assembler returns with functions

   Type                                 Return result in
   
   byte,char,shortint,boolean,bytebool  AL
   word,integer,wordbool                AX
   pointer,longint,longbool             AX:DX
   real                                 AX:BX:DX
}

{Ŀ}
{                              } Interface {                             }
{}
Uses Dos,Crt;
Const
  {
    Instead of using: textattr := blue shl 4+lightblue;
    Use: textattr := _blue+lightblue;
  }

  _Black        = Black shl 4;
  _Blue         = Blue shl 4;
  _Green        = Green shl 4;
  _Cyan         = Cyan shl 4;
  _Red          = Red shl 4;
  _Magenta      = Magenta shl 4;
  _Brown        = Brown shl 4;
  _LightGray    = LightGray shl 4;
  _DarkGray     = DarkGray shl 4;
  _LightBlue    = LightBlue shl 4;
  _LightGreen   = LightGreen shl 4;
  _LightCyan    = LightCyan shl 4;
  _LightRed     = LightRed shl 4;
  _LightMagenta = LightMagenta shl 4;
  _Yellow       = Yellow shl 4;
  _White        = White shl 4;

Const
  { Standard text }
  _40x25t        = $02;
  _80x25t        = $03;
  { Standard VGA }
  _640x480x2     = $11;
  _640x480x16    = $12;
  _320x200x256   = $13;
  { Standard VESA }
  _640x400x256   = $100;
  _640x480x256   = $101;
  _800x600x16    = $102;
  _800x600x256   = $103;
  _1024x768x16   = $104;
  _1024x768x256  = $105;
  _1280x1024x16  = $106;
  _1280x1024x256 = $107;
  { Textmode modes for VESA }
  _80x60t        = $108;
  _132x25t       = $109;
  _132x43t       = $10A;
  _132x50t       = $10B;
  _132x60t       = $10C;
  { Pretty much standard VESA }
  _320x200x32K   = $10D;
  _320x200x64K   = $10E;
  _320x200x16M   = $10F;
  _640x480x32K   = $110;
  _640x480x64K   = $111;
  _640x480x16M   = $112;
  _800x600x32K   = $113;
  _800x600x64K   = $114;
  _800x600x16M   = $115;
  _1024x768x32K  = $116;
  _1024x768x64K  = $117;
  _1024x768x16M  = $118;
  _1280x1024x32K = $119;
  _1280x1024x64K = $11A;
  _1280x1024x16M = $11B;

Type
  tRGB = record R,G,B: byte; end;
  pPalette = ^tPalette;
  tPalette = array[0..255] of tRGB;

  DelimType = record
    thousands,
    decimal,
    date,
    time: array[0..1] of Char;
  end;

  CurrType = (leads,    { symbol precedes value }
              trails,   { value precedes symbol }
              leads_,   { symbol, space, value }
              _trails,  { value, space, symbol }
              replace); { replaced }

  datefmt = (USA,Europe,Japan);

  tCountryRec = record
    DateFormat : Word;           { 0: USA, 1: Europe, 2: Japan }
    CurrSymbol : array[0..4] of Char;
    Delimiter  : DelimType;      { Separators }
    CurrFormat : CurrType;       { Way currency is formatted }
    CurrDigits : Byte;           { Digits in currency }
    Clock24hrs : Boolean;        { True if 24-hour clock }
    CaseMapCall: Procedure;      { Lookup table for ASCII > 80h }
    DataListSep: array[0..1] of Char;
    CID        : Word;
    Reserved   : array[0..7] of Char;
  end;

  tCountryInfoRec =  record
    case InfoID: byte of
      1: (IDSize     : Word;
          CountryID  : Word;
          CodePage   : Word;
          TheInfo    : tCountryRec);
      2: (UpCaseTable: pointer);
  end;

  tVGAInfoRec = record
    addrstatfunc: Pointer; { address of static funtionality table }
    CurrMode: Byte; { video mode in effect }
    NumColumns: Word; { number of columns }
    LenRegenBuffer: Word; { length of regen buffer in Bytes }
    StartRegenBuffer: Word; { starting address of regen buffer }
    CursorPos: array[0..7] of word; { (0..7) are the pages }
    CursorType: Word; { cursor "type" (start/stop scan lines) }
    CurrentPage: Byte; { active display page }
    CRTCAddr: Word; { CRTC port address }
    Reg3X8: Byte; { current setting of register (3?8) }
    Reg3X9: Byte; { current setting of register (3?9) }
    NumRows: Byte; { number of rows }
    BytesPerChar: Word; { Bytes/character }
    DispCombin: Byte; { display combination code of active display }
    AltDispDCC: Byte; { DCC of alternate display }
    NumColors: Word; { number of colors supported in current mode (0000h = mono) }
    NumPages: Byte; { number of pages supported in current mode }
    NumScalines: Byte; { number of scan lines active (0,1,2,3) = (200,350,400,480) }
    PrimaryCharBlock: Byte; { primary character block }
    SecondaryCharBlock: Byte; { secondary character block }
    MiscFlags: Byte; { miscellaneous flags }
    { Bitfields for miscellaneous flags:
      Bit(s)   Description
      0        all modes on all displays on
      1        gray summing on
      2        monochrome display attached
      3        default palette loading disabled
      4        cursor emulation enabled
      5        0 = intensity; 1 = blinking
      6        PS/2 P70 plasma display (without 9-dot wide font) active
      7        unused (0) }
    Rsvd1: Array[1..3] of Byte; { reserved (00h) }
    Videomemory: byte; { 00h = 64K, 01h = 128K, 02h = 192K, 03h = 256K }
    SavedPSF: byte; { save pointer state flags }
    Rsvd2: Array[1..13] of Byte; { reserved (00h) }
  end;

  { Used to get extended information on the disk }
  tMediaIDRec = Record
    InfoLevel: Word;
    SerialNum: LongInt;
    VolLabel : Array[0..10] of Char;
    SysName  : Array[0..7] of Char;
  end;

  { Used to save the screen with SaveScreen, And RestoreScreen }
  ScreenSaveType = record
    Screen: pointer;
    X,y,attr: byte;
    WMax,WMin: word;
    Cursor: word;
    Border: byte;
  End;

{ To modify characters }
Const
  LoadChar = False;
  SaveChar = True;

Type
  CharPic = Array[1..16] of Byte;

var
  CountryOk          : Boolean;        { Could determine country code flag }
  CountryRec         : tCountryInfoRec;
  Maxwidth,maxheight : Byte;
  ScreenSize         : Word;
  kbdHeadPtr         : Word    absolute $0040:$001A;
  kbdTailPtr         : Word    absolute $0040:$001C;
  ToggleStatus       : Byte    absolute $0040:$0017;
  TimerAddr          : Longint absolute $0040:$006C;
  HeightAddr         : Byte absolute $40:$84; { 0 based }
  WidthAddr          : Byte absolute $40:$4A; { 1 based }
  OrgCursor          : Word;          { Stores original cursor at start up }
  Share              : Boolean;       { Will say if Share is loaded or not }
  VGA                : Boolean;       { Will say if VGA or not }
Const
  ForceMono: boolean = false;

{}
Procedure Beep(Hz,Sec: word);
Procedure BlinkOff;
Procedure BlinkOn;
Procedure CallUserProc(proc: pointer);
Procedure CLI; Inline($FA);
Procedure CursorOff;
Procedure CursorOn;
Procedure FlushCache;
Procedure GetAccInfo(drive: byte; var SecPClust: byte; var BytesPSec,Clusters: word);
Procedure GetMediaInfo(drive: byte; var MediaInfo: tMediaIDRec);
Procedure GetBorder(var color: byte);
Procedure SetBorder(color: byte);
Procedure GetCursor(var cursor: word);
Procedure SetCursor(cursor: word);
Procedure GetVGAInfo(var VGAInfo: tVGAInfoRec);
Procedure PutAttrs(x,y: byte; times: word; color: byte);
Procedure PutChars(x,y: byte; chr: char; times: word; color: byte);
Procedure PutString(x,y: byte; s: string; color: byte);
Procedure ReallocateMemory(P: Pointer);
Procedure Retrace;
Procedure RestoreScreen(var screen: screensavetype);
Procedure SaveScreen(var screen: screensavetype);
Procedure ShowScreen(var orgscreen: screensavetype);
Procedure SwapInt(var x,y: integer);
Procedure SwapWord(var x,y: word);
Procedure SetColor(Color,r,g,b: Byte);
Procedure GetColor(Color: byte; var r,g,b: byte);
Procedure SetPal(var vPal: tPalette);
Procedure GetPal(var vPal: tPalette);
Procedure FadePal(old_pal, new_pal: tPalette; start_col, end_col : byte);
Procedure CyclePal(start,finish: Byte; speed: shortint);
Procedure Scroll(x1,y1,x2,y2,times: byte; newlinecolor: byte);
Procedure StuffChar(c: char);
Procedure STI; Inline($FB);
Procedure UnCrunch(var Addr1,Addr2; BlkLen: Word);
Procedure LongintReverse(var a: longint);
Procedure WordReverse(var a: word);
Procedure ColdBoot;
Procedure WarmBoot;
Procedure ModifyChar(CharNum: Byte; var Pic: CharPic; Which: Boolean);
{}
Function BeingRedirected(handle: word): boolean;
Function Execute(Name,tail: pathstr): Word;
Function GCD(m,n: longint): longint;
Function MonoProcess(color: byte): byte;
Function LoCase(c: Char): Char;
Function LoCaseStr(s: String): String;
Function SetMode(mode: word): boolean;
Function GetMode: byte;
Function UpCase(c: Char): Char;
Function UpCaseStr(s: String): String;
Function WildComp(NameStr,SearchStr: String): Boolean;
Function VgaPresent: boolean;
Function IMin(a,b: integer): integer;
inline(
  $58/     { pop   ax    }
  $5B/     { pop   bx    }
  $3B/$C3/ { cmp   ax,bx }
  $7C/$01/ { jl    +1    }
  $93);    { xchg  ax,bx }
Function IMax(a,b: integer): integer;
inline(
  $58/     { pop   ax    }
  $5B/     { pop   bx    }
  $3B/$C3/ { cmp   ax,bx }
  $7F/$01/ { jg    +1    }
  $93);    { xchg  ax,bx }
Function LMin(a,b: longint): longint;
Function LMax(a,b: longint): longint;
{}
Type
  Screentype = array[0..7999] of byte;
Var
  VidSeg    : Word;
  Screenaddr: ^ScreenType;
  LoTable   : Array[0..127] of byte;
  CRP, LTP  : Pointer;

{Ŀ}
{                            } Implementation {                          }
{}

Function BeingRedirected(handle: word): boolean; assembler;
asm
  mov ax,4400h
  mov bx,handle
  int 21h
  { bit 0 is standard input }
  cmp dx,1
  je @no
  { bit 1 is standard output }
  cmp dx,2
  je @no
  mov al,true
  jmp @exit
 @no:
  xor al, al
 @exit:
end;

Function MonoProcess(color: byte): byte;
var bg,fg: byte;
begin
  If (VidSeg=$b000) or forcemono then begin
    bg := color shr 4;
    fg := color and $F;
    if bg=fg then begin
      if bg<>$7 then bg := $0;
      fg := bg;
    end
    else if bg=$7 then begin
      if fg<>$7 then begin
        if fg and $8=0 then fg := $0
        else fg := $F;
      end;
    end
    else begin
      bg := 0;
      if fg<>$F then fg := $7;
    end;
    color := bg shl 4 or fg;
  end;
  MonoProcess := color;
end;
Procedure ModifyChar(CharNum: Byte; var Pic: CharPic; Which: Boolean);
{ Modifies a character. Great to play around with, and allows one to create
  quite the graphical mouse cursor in plain-jane 80x25 }
Begin
  Cli;
  PortW[$3C4] := $0402;
  PortW[$3C4] := $0704;
  PortW[$3CE] := $0204;
  PortW[$3CE] := $0005;
  PortW[$3CE] := $0006;
  If Which then Move(Pic,Mem[$A000:CharNum*32],SizeOf(CharPic))
  Else Move(Mem[$A000:CharNum*32],Pic,SizeOf(CharPic));
  PortW[$3C4] := $0302;
  PortW[$3C4] := $0304;
  PortW[$3CE] := $0004;
  PortW[$3CE] := $1005;
  PortW[$3CE] := $0E06;
  Sti;
End;

Procedure GetMediaInfo(drive: byte; var MediaInfo: tMediaIDRec); assembler;
asm
  push ds
  lds dx,MediaInfo
  mov ax,6900h { Dos function to get the media info }
  mov bl,drive
  int 21h
{ jc @error
  mov al,true
  jmp @exit
 @error:
  xor al,al
 @exit: }
  pop ds
end;

Procedure GetAccInfo(drive: byte; var SecPClust: byte; var BytesPSec,Clusters: word); assembler;
asm
  push ds
  mov ah, 1Ch
  mov dl, 3h
  int 21h
{ jc @error }
  les di, secpclust
  mov [es:di], al
  les di, bytespsec
  mov [es:di], cx
  les di, clusters
  mov [es:di], dx
{ mov al, true
  jmp @Exit
 @Error:
  xor al, al
 @Exit:}
  pop ds
end;

Function GCD(m,n: longint): longint;
Var r: longint;
Begin
  While m>0 do begin
    R := n mod m;
    N := m;
    M := r;
  End;
  GCD := n;
End;

Procedure LongintReverse(var a: longint);
{ Reverses the longint a from MSB to LSB, or vice versa. Only works for }
{ longint! }
begin
  a := (a and $FF000000 shr $18) or (a and $00FF0000 shr $08) or
       (a and $0000FF00 shl $08) or (a and $000000FF shl $18);
end;

Procedure WordReverse(var a: word);
{ Reverses the word a from MSB to LSB, or vice versa. Only works for word! }
begin
  a := (a and $FF00 shr $08) or (a and $00FF shl $08);
end;

Function SetMode(mode: word): boolean; assembler;
{ This function will work for more than just VESA modes, and more than
  just VESA cards also.  If it's under $100 (where vesa modes begin) it
  will use the normal video bios instead. So people without VESA cards/
  drivers still can use this for 320x200x256, etc. }
asm
  Cmp Mode, 100h
  Jb  @Normal_VGA { If it's below 100h then it's a std mode, why use VESA? }
  Mov Ax, 4F02h   { VESA set modes }
  Mov Bx, mode
  Int 10h
  Cmp Ax, 004Fh   { AL=4F VESA supported, AH=00 successful }
  Jne @Error      { Else Error }
  mov al, true
  jmp @done
 @Error:
  xor al, al    
  Jmp @done
 @Normal_VGA:
  mov ax, mode    { AH will of course be zero, as intended }
  int 10h
  Mov al, true
 @done:
end;

Function GetMode: byte; Assembler;
asm
  mov ah, 0Fh
  int 10h
End;

Procedure Beep(Hz,Sec: word); assembler;
{ Sure this doesn't need to be written in assembler! }
asm
  push hz; call sound
  push sec; call delay
  call nosound
end;

Procedure SwapInt(var x,y: integer); assembler;
{ Well, I -think- this is the fastest. Sigh! }
asm
  push ds
  lds si,x; lodsw; mov bx,ax        { bx := x }
  lds si,y; lodsw; les di,x; stosw; { x := y }
  les di,y; mov ax, bx; stosw;      { y := bx }
  pop ds
end;

Procedure SwapWord(var x,y: word); assembler;
{ Well, I -think- this is the fastest. Sigh! }
asm
  push ds
  lds si,x; lodsw; mov bx,ax        { bx := x }
  lds si,y; lodsw; les di,x; stosw; { x := y }
  les di,y; mov ax, bx; stosw;      { y := bx }
  pop ds
end;

Procedure FlushCache; Assembler;
Asm
  mov ah,0Dh     { DOS flush file buffers. }
  int 21h        { Most cache programs catch this call. }
 
  mov   ax,$4A10 { Flush SmartDrv }
  mov   bx,$0002
  int   $2F
end;

Function VgaPresent: boolean; assembler;
asm
  mov ax,$1A00
  int $10         { Check for VGA }
  cmp al,$1A
  jne @NoVGA      { No VGA Bios }
  cmp bl,7
  jb @NoVGA       { Is VGA or better? }
  cmp bl,$FF
  jnz @OK
 @NoVGA:
  xor al,al       { False }
  jmp @End
 @Ok:
  mov al,true     { True }
 @End:
end;

Procedure GetVGAInfo(var VGAInfo: tVGAInfoRec); assembler;
asm
  Mov AH,1Bh
  Mov Bx,0h
  Les Di,VGAInfo
  Int 10h
  { Should return AL = 1Bh if the function is supported, but we won't check }
end;

Procedure WarmBoot; Assembler;
Asm
  { It is best to flush SmartDrive before we reboot to save any unsaved }
  { data properly! }
  Call flushCache
  Xor  Ax,Ax
  Mov  Es,Ax
  { We'll take a warm boot }
  Mov  Word ptr Es:[472h],1234h
  Mov  Ax,0F000h
  Push Ax
  Mov  Ax,0FFF0h
  Push Ax
  Retf
End;

Procedure ColdBoot; Assembler;
Asm
  { It is best to flush SmartDrive before we reboot to save any unsaved }
  { data properly! }
  Call flushCache
  Xor  Ax,Ax
  Mov  ES,Ax
  { We'll take a cold boot }
  Mov  Word ptr Es:[472h],0000h
  Mov  Ax, 0F000h
  Push Ax
  Mov  Ax,0FFF0h
  Push Ax
  Retf
End;

Procedure CallUserProc(proc: pointer);
Begin
  if proc=nil then exit;
  Inline($FF/$5E/<proc);
end;

Procedure SetColor(color,r,g,b: Byte); Assembler;
Asm
  mov  dx, 3C8h   { Color port }
  mov  al, color  { Number of color to change }
  out  dx, al
  inc  dx         { Inc dx to write }
  mov  al, r      { Red value }
  out  dx, al
  mov  al, g      { Green }
  out  dx, al
  mov  al, b      { Blue }
  out  dx, al
End;

Procedure GetColor(Color: byte; var r,g,b: byte); Assembler;
{ This reads the values of the Red, Green and Blue DAC values of a
  certain color and returns them to you in r (red), g (green), b (blue) }
asm
  mov  dx, 3C7h
  mov  al, color
  out  dx, al
  add  dx, 2
  in   al, dx
  les  di, r
  stosb
  in   al, dx
  les  di, g
  stosb
  in   al, dx
  les  di, b
  stosb
end;

{$IFOPT G+}
Procedure SetPal(var vPal: tPalette); assembler;
Asm
  Push  ds
  Lds   si,vPal
  Mov   dx,$3C8
  Xor   ax,ax
  Out   dx,al
  Mov   dx,$3c9
  Mov   cx,3*256 { Out 3 RGB values for 256 colors }
  Rep   Outsb
  Pop   ds
End;

Procedure GetPal(var vPal: tPalette); Assembler;
Asm
  Les   di,vPala
  Mov   dx,$3C7
  Xor   ax,ax
  Out   dx,al
  Mov   dx,$3c9
  Mov   cx,3*256 { Out 3 RGB values for 256 colors }
  Rep   Insb
End;

{$ELSE}

Procedure SetPal(var vPal: tPalette);
Var loop: byte;
Begin
  For loop := 0 to 255 do with vPal[loop] do SetColor(loop,r,g,b);
End;

Procedure GetPal(var vPal: tPalette);
Var loop: byte;
Begin
  For loop := 0 to 255 do with vPal[loop] do GetColor(loop,r,g,b);
End;
{$ENDIF}

Procedure CyclePal(start,finish: Byte; speed: shortint);
Var
  count,
  loop  : Byte;
  dummy : tRGB;
  vpTemp: tPalette;
Begin
  getpal(vpTemp);

  For loop := 1 to Abs(speed) do begin
    { Forward rotations }
    if Abs(speed) = speed then begin
      dummy := vpTemp[start];
      for count := start to finish-1 do
        vpTemp[count] := vpTemp[count+1];
      vpTemp[finish] := dummy;
    end
    { Backwards rotations }
    else begin
      dummy := vpTemp[finish];
      for count := finish downto start+1 do
        vpTemp[count] := vpTemp[count-1];
      vpTemp[start] := dummy;
    End;
  End;

  setpal(vpTemp);
End;

Procedure FadePal(old_pal, new_pal: tPalette; start_col, end_col : byte);
Var
  dac,intensity: Word;
  vpTemp: tPalette;
Begin
  getpal(vpTemp);
  For intensity := 0 to 32 do Begin
    For dac := start_col to end_col do begin
      vpTemp[dac].r := ((new_pal[dac].r * intensity) div 32) +
        ((old_pal[dac].r * (32-intensity)) div 32);
      vpTemp[dac].g := ((new_pal[dac].g * intensity) div 32) +
        ((old_pal[dac].g * (32-intensity)) div 32);
      vpTemp[dac].b := ((new_pal[dac].b * intensity) div 32) +
        ((old_pal[dac].b * (32-intensity)) div 32);
    End;
    setpal(vpTemp);
    retrace;
  End;
End;

Procedure SetBorder(color : byte);  assembler;
asm
  mov ax, 1001h
  mov bh, color
  int 10h
End;

Procedure GetBorder(var color : byte); assembler;
asm
  mov ax, 1008h
  int 10h
  les DI, color
  mov [ES:DI], bh
end;

Procedure GetCursor(var cursor: word); assembler;
Asm
  mov ah, 03h
  int 10h
  les di, cursor
  mov [ES:DI], cx
End;

Procedure SetCursor(cursor: word); assembler;
Asm
  mov ah, 01h
  mov cx, cursor
  int 10h
End;

Procedure CursorOn; assembler;
asm
  mov ah, 01h
  mov cx, OrgCursor
  int 10h
end;

Procedure CursorOff; assembler;
asm
  mov ah, 01h
  mov cx, 0FFFFh
  int 10h
end;

Procedure StuffChar(c: char); assembler;
asm
  mov ah, 05h
  mov cl, c   { cl = c }
  xor ch, ch  { ch = 0 }
  int 16h
end;

Procedure BlinkOff; assembler;
{ Note that the BL is the actual register, but BH _should_ also be set to 0 }
asm
  mov ax, 1003h
  mov bx, 0000h
  int 10h
end;

Procedure BlinkOn; assembler;
{ Note that the BL is the actual register, but BH _should_ also be set to 0 }
asm
  mov ax, 1003h
  mov bx, 0001h
  int 10h
end;

Procedure Retrace; assembler;
{ waits for a vertical retrace }
  asm
    cmp vga, false
    je @exit
    mov dx, 03DAh
   @loop1:
    in al, dx
    test al, 8
    jz @loop1
   @loop2:
    in al, dx
    test al, 8
    jnz @loop2
   @exit:
  end;

Procedure UnCrunch(var Addr1,Addr2; BlkLen:Word); assembler;
{ From TheDraw, not my Procedure }
asm
  PUSH    DS             { Save data segment.}
  LDS     SI, Addr1      { Source Address}
  LES     DI, Addr2      { Destination Addr}
  MOV     CX, BlkLen     { Length of block}
  JCXZ    @Done
  MOV     DX,DI          { Save X coordinate for later.}
  XOR     AX,AX          { Set Current attributes.}
  CLD
 @LOOPA:
  LODSB                  { Get next character.}
  CMP     AL,32          { If a control character, jump.}
  JC      @ForeGround
  STOSW                  { Save letter on screen.}
 @Next:
  LOOP    @LOOPA
  JMP     @Done
 @ForeGround:
  CMP     AL,16          { If less than 16, then change the}
  JNC     @BackGround    { foreground color.  Otherwise jump.}
  AND     AH,0F0h        { Strip off old foreground.}
  OR      AH,AL
  JMP     @Next
 @BackGround:
  CMP     AL,24          { If less than 24, then change the}
  JZ      @NextLine      { background color.  If exactly 24,}
  JNC     @FlashBitToggle{ then jump down to next line.}
  SUB     AL,16          { Otherwise jump to multiple output}
  ADD     AL,AL          { routines.}
  ADD     AL,AL
  ADD     AL,AL
  ADD     AL,AL
  AND     AH,8Fh         { Strip off old background.}
  OR      AH,AL
  JMP     @Next
 @NextLine:
  ADD     DX,160         { If equal to 24,}
  MOV     DI,DX          { then jump down to}
  JMP     @Next          { the next line.}
 @FlashBitToggle:
  CMP     AL,27          { Does user want to toggle the blink}
  JC      @MultiOutput   { attribute?}
  JNZ     @Next
  XOR     AH,128         { Done.}
  JMP     @Next
 @MultiOutput:
  CMP     AL,25          { Set Z flag if multi-space output.}
  MOV     BX,CX          { Save main counter.}
  LODSB                  { Get count of number of times}
  MOV     CL,AL          { to display character.}
  MOV     AL,32
  JZ      @StartOutput   { Jump here if displaying spaces.}
  LODSB                  { Otherwise get character to use.}
  DEC     BX             { Adjust main counter.}
 @StartOutput:
  XOR     CH,CH
  INC     CX
  REP STOSW
  MOV     CX,BX
  DEC     CX             { Adjust main counter.}
  LOOPNZ  @LOOPA         { Loop if anything else to do...}
 @Done:
  POP     DS             { Restore data segment.}
end;

Procedure ReallocateMemory(P : Pointer); Assembler;
Asm
  Mov  AX, PrefixSeg
  Mov  ES, AX
  Mov  BX, word ptr P+2
  Cmp  Word ptr P,0
  Je   @OK
  Inc  BX
 @OK:
  Sub  BX, AX
  Mov  AH, 4Ah
  Int  21h
  Jc   @Out
  Les  DI, P
  Mov  Word Ptr HeapEnd,DI
  Mov  Word Ptr HeapEnd+2,ES
 @Out:
End;

Function Execute(Name,tail: pathstr): Word; Assembler;
Asm
  Push Word Ptr HeapEnd+2
  Push Word Ptr HeapEnd
  Push Word Ptr Name+2
  Push Word Ptr Name
  Push Word Ptr Tail+2
  Push Word Ptr Tail
  Push Word Ptr HeapPtr+2
  Push Word Ptr HeapPtr
  Call ReallocateMemory
  Call SwapVectors
  Call Dos.Exec
  Call SwapVectors
  Call ReallocateMemory
  Mov  AX, DosError
  Or   AX, AX
  Jnz  @Done
  Mov  AH, 4Dh
  Int  21h { Return error in will be in AX (if any) }
 @Done:
End;

Procedure Putchars(x,y: byte; chr: char; times: word; color: byte);
{ Procedure to fill a count amount of characters from position x, y }
var offst: word;
begin
  offst := (pred(y)*maxwidth+pred(x))*2;
  asm
    mov es, VidSeg    { Segment to start at       }
    mov di, offst     { Offset to start at        }
    mov al, chr       { Data to place             }
    mov ah, color     { Colour to use             }
    mov cx, times     { How many times            }
    cld               { Forward in direction      }
    rep stosw         { Store the word (cx times) }
  end;
end;

Procedure PutAttrs(x,y: byte; times: word; color: byte);
{ This Procedure is to fill a certain amount of spaces with a colour       }
{ (from cursor position) and doesn't move cursor position!                 }
var offst: word;
begin
  offst := succ((pred(y)*maxwidth+pred(x))*2);
  asm
    mov es, VidSeg
    mov di, offst
    mov cx, times
    mov ah, 0
    mov al, color
    cld
   @s1:
    stosb
    inc di    { Increase another above what the stosb already loops }
    loop @s1  { Loop until cx = 0                                   }
  end;
end;

Procedure PutString(x,y: byte; s: string; color: byte);
Begin
  { Does a direct video write -- extremely fast. }
  asm
    mov dh, y         { move X and Y into DL and DH (DX) }
    mov dl, x

    xor al, al
    mov ah, color     { load color into AH }
    push ax           { PUSH color combo onto the stack }

    mov ax, VidSeg
    push ax           { PUSH video segment onto stack }

    mov bx, 0040h     { check 0040h:0049h to get number of screen columns }
    mov es, bx
    mov bx, 004Ah
    xor ch, ch
    mov cl, es:[bx]
    xor ah, ah        { move Y into AL; decrement to convert Pascal coords }
    mov al, dh
    dec al
    xor bh, bh        { shift X over into BL; decrement again }
    mov bl, dl
    dec bl
    cmp cl, 80        { see if we're in 80-column mode }
    je @eighty_column
    mul cx            { multiply Y by the number of columns }
    jmp @multiplied
   @eighty_column:    { 80-column mode: it may be faster to perform the }
    mov cl, 4         {   multiplication via shifts and adds: remember  }
    shl ax, cl        {   that 80d = 1010000b , so one can SHL 4, copy  }
    mov dx, ax        {   the result to DX, SHL 2, and add DX in.       }
    mov cl, 2
    shl ax, cl
    add ax, dx
   @multiplied:
    add ax, bx        { add X in }
    shl ax, 1         { multiply by 2 to get offset into video segment }
    mov di, ax        { video pointer is in DI }
    lea si, s         { string pointer is in SI }
    SEGSS lodsb
    cmp al, 00h       { if zero-length string, jump to end }
    je @done
    mov cl, al
    xor ch, ch        { string length is in CX }
    pop es            { get video segment back from stack; put in ES }
    pop ax            { get color back from stack; put in AX (AH = color) }
   @write_loop:
    SEGSS lodsb       { get character to write }
    mov es:[di], ax   { write AX to video memory }
    inc di            { increment video pointer }
    inc di
    loop @write_loop  { if CX > 0, go back to top of loop }
   @done:             { end }
  end;
end;

Function WildComp(NameStr,SearchStr: String): Boolean; assembler;
{
 Compare SearchStr with NameStr, and allow wildcards in SearchStr.
 The following wildcards are allowed:
 *ABC*        matches everything which contains ABC
 [A-C]*       matches everything that starts with either A,B or C
 [ADEF-JW-Z]  matches A,D,E,F,G,H,I,J,W,V,X,Y or Z
 ABC?         matches ABC, ABC1, ABC2, ABCA, ABCB etc.
 ABC[?]       matches ABC1, ABC2, ABCA, ABCB etc. (but not ABC)
 ABC*         matches everything starting with ABC
 (for using with DOS filenames like DOS (and 4DOS), you must split the
  filename in the extention and the filename, and compare them seperately)
}
Var
  LastW,LastNFnd: word;
Asm
  cld               { Set flag: go forward through strings }
  push ds           { Save TP's datasegment }
  lds si,SearchStr  { Load pointer to SearchStr (may contain wildcards) }
  les di,NameStr    { Load pointer to NameStr }
  xor ah,ah
  lodsb             { Load length of SearchStr, and increment pointer }
  mov cx,ax         { Store in cx }
  mov al,es:[di]    { Load length of NameStr }
  inc di            { Increment pointer }
  mov bx,ax         { Store length in bx }
  xor dh,dh         { Clear searching flag }
  mov LastNFnd,0    { Set no saved position }
  or cx,cx          { SearchStr empty? }
  jnz @ChkChr       { No -> Get next char }
  or bx,bx          { NameStr empty? }
  jz @ChrAOk        { Yes (both empty) -> compare ok }
  jmp @ChrNOk       { Jump to compare failed }
  { Following the main loop }
  { Registers in loop: }
  { AH    - various }
  { AL    - current char from SearchStr }
  { BX    - Chars left in NameStr }
  { CX    - Chars left in SearchStr }
  { DH    - Flag: 1=Searching in progress) }
  { DL    - Flag: 1=first char was ! in [...] }
  { DS:SI - Pointer to next char in SearchStr }
  { ES:DI - Pointer to current char in NameStr }
  @ChkChr:
  lodsb             { Get char from SearchStr, and increment pointer }
  cmp al,'*'        { Is it a '*'? }
  jne @ChkVrg       { No -> check for '?' }
  dec cx            { Decrement SearchStr counter, and check for }
  jz @ChrAOk        { chars left, No -> compare ok }
  mov dh,1          { Set flag ??? }
  mov LastW,cx      { Save chars left in SearchStr }
  mov LastNFnd,0    { Set no saved position }
  jmp @ChkChr       { Check next char in SearchStr }
  @ChkVrg:
  cmp al,'?'        { Is it a '?' ? }
  jnz @NormChr      { No -> check for set ('[') }
  inc di            { Increment pointer NameStr (always ok) }
  or bx,bx          { NameStr already empty? }
  je @ChrOk         { Yes -> this char ok }
  dec bx            { Decrement NameStr counter }
  jmp @ChrOk        { Jump to this char ok }
  @NormChr:
  or bx,bx          { NameStr already empty? }
  je @ChrNOk        { Yes -> compare failed }
  cmp al,'['        { Is it a set ('[') }
  jne @No4DosChr    { No -> normal char compare }
  cmp word ptr [si],']?' { Is it a 'need char' ('[?]')? }
  je @SkipRange     { Yes -> No set check }
  mov ah,byte ptr es:[di]  { Store current char in NameStr }
  xor dl,dl         { Set flag normal set }
  cmp byte ptr [si],'!'    { Is it a 'not' set (first char '!')? }
  jnz @ChkRange     { No -> a normal set }
  inc si            { Set to next char in SearchStr }
  dec cx            { Decrement counter }
  jz @ChrNOk        { SearchStr empty? Yes -> compare failed }
  inc dx            { Set flag 'not' set }
  { Following the check set loop }
  { AH - Char from NameStr, checked if in set }
  { Rest same as mainloop }
  @ChkRange:
  lodsb             { Get char from SearchStr }
  dec cx            { Decrement counter }
  jz @ChrNOk        { SearchStr empty? Yes -> compare failed }
  cmp al,']'        { End of set reached ? }
  je @NChrNOk       { Yes -> Char not found in set }
  cmp ah,al         { Char in set ? }
  je @NChrOk        { Yes -> Char found in set }
  cmp byte ptr [si],'-' { Range of chars ? }
  jne @ChkRange     { No? -> Check next char }
  inc si            { Increment pointer SearchStr }
  dec cx            { Decrement SearchStr chars left }
  jz @ChrNOk        { Empty? Yes -> compare failed }
  cmp ah,al         { Compare first char from range with char from NameStr } 
  jae @ChkR2        { Is it higher or equal? Yes -> check last range char } 
  inc si            { Char not in range }
  dec cx            { Skip last in range }
  jz @ChrNOk        { SearchStr empty? Yes -> compare failed }
  jmp @ChkRange     { Check next char of set }
  @ChkR2:
  lodsb             { Get last range char }
  dec cx            { Decrement SearchStr chars left }
  jz @ChrNOk        { Empty? Yes -> compare failed }
  cmp ah,al         { Compare last char from range with char from NameStr } 
  ja @ChkRange      { In range? Yes -> check next char from set } 
  { Fall through to Char in set }
  @NChrOk:          { Char in set }
  or dl,dl          { 'not' flag set? }
  jnz @ChrNOk       { Yes -> compare failed }
  inc dx            { Set 'not' flag }
  { Fall through to Char not in set, but with 'not' flag set -> chr found } 
  @NChrNOk:         { Char not in set }
  or dl,dl          { 'not' flag set? }
  jz @ChrNOk        { No -> compare failed }
  @NNChrOk:         { Char in set }
  cmp al,']'        { This was the set terminate char (']')? }
  je @NNNChrOk      { Yes -> No need to skip to end of set }
  @SkipRange:       { Skip to end of set }
  lodsb             { Get char from SearchStr }
  cmp al,']'        { Set termination char (']')? }
  loopne @SkipRange { No -> repeat until found or out of chars }
  jne @ChrNOk       { Not found? -> out of chars -> compare failed }
  @NNNChrOk:
  dec bx            { Decrement NameStr chars left }
  inc di            { Increment NameStr pointer }
  jmp @ChrOk        { This char was ok }
  @No4DosChr:
  cmp es:[di],al    { Normal compare }
  jne @ChrNOk       { Not equal? -> compare failed }
  inc di            { Decrement NameStr chars left }
  dec bx            { Increment NameStr pointer }
  @ChrOk:           { This char was ok }
  or dh,dh          { Search in progress? }
  jz @NoStore       { No -> Skip Last found store }
  xor dh,dh         { Clear search flag: found a matching char }
  mov LastNFnd,bx   { Save last found char pos }
  @NoStore:
  dec cx            { Decrement SearchStr chars left }
  jnz @ChkChr       { Empty? No -> Process new char }
  or bx,bx          { NameStr empty? }
  jnz @ChrNOk       { No -> compare failed }
  @ChrAOk:          { Whole string compared ok }
  mov al,1          { Return true }
  jmp @EndR         { Jump to end of Procedure }
  @ChrNOk:          { Somewhere was a mismatch }
  jcxz @IChrNOk     { Because of empty SearchStr? Yes -> fail }
  or bx,bx          { Because of empty NameStr? }
  jz @IChrNOk       { Yes -> fail }
  or dh,dh          { Search in progress? }
  jz @WCNotOk       { No -> Check for second+ char search mismatch }
  inc di            { This char not the one searching for }
  dec bx            { Skip it (dec NameStr left, inc NameStr ptr) }
  jz @IChrNOk       { NameStr empty? Yes -> fail }
  @Retry:           { Start search again }
  mov ax,[LastW]    { Get pos in SearchStr after last '*' }
  sub ax,cx         { Restore state of }
  add cx,ax         { SearchStr char left counter }
  sub si,ax         { and SearchStr pointer }
  dec si            { Adjust pointer }
  jmp @ChkChr       { Get new char }
  @WCNotOk:         { Check for second+ char search mismatch }
  mov ax,LastNFnd   { Get position of last good char in NameStr }
  or ax,ax          { No saved position? }
  jz @IChrNOk       { Yes -> fail }
  mov LastNFnd,0    { Set no saved position }
  sub ax,bx         { Restore state of }
  add bx,ax         { NameStr char left counter }
  sub di,ax         { and NameStr pointer }
  mov dh,1          { Set search in progress flag }
  jmp @Retry        { And restore SearchStr }
  @IChrNOk:         { Compare failed }
  mov al,0          { Return false }
  @EndR:
  pop ds            { Restore TP's datasegment }
end;

Function Upcasestr(S : String) : String; Assembler;
Asm
  Push    DS
  Lds     SI,S
  Les     DI,@Result
  Cld
  LodSb
  StoSb
  Xor     CH,CH
  Mov     CL,AL
  JCXZ    @OUT
 @LOOP:
  LODSB
  xor ah, ah
  push ax
  call upcase
  StoSb
  Loop    @Loop
 @OUT:
  POP   DS
end;

Function Locasestr(S : String) : String; Assembler;
Asm
  PUSH    DS
  LDS     SI,S
  LES     DI,@Result
  CLD
  LODSB
  STOSB
  xor     CH,CH
  MOV     CL,AL
  JCXZ    @OUT
 @LOOP:
  LODSB
  xor ah, ah
  push ax
  call locase { So we're not duping a lot of instructions }
  STOSB
  LOOP    @LOOP
 @OUT:
  POP   DS
end;

{ Convert a character to upper case }

function UpCase; Assembler;
asm
  mov     al, c
  cmp     al, 'a'
  jb      @2
  cmp     al, 'z'
  ja      @1
  sub     al, ' '
  jmp     @2
 @1:
  cmp     al, 80h
  jb      @2
  sub     al, 7eh
  push    ds
  lds     bx,CountryRec.UpCaseTable
  xlat
  pop     ds
 @2:
end; { UpCase }

  { Convert a character to lower case }

function LoCase; Assembler;
asm
  mov     al, c
  cmp     al, 'A'
  jb      @2
  cmp     al, 'Z'
  ja      @1
  or      al, ' '
  jmp     @2
 @1:
  cmp     al, 80h
  jb      @2
  sub     al, 80h
  mov     bx,offset LoTable
  xlat
 @2:
end;                                 { LoCase }

Procedure Scroll(x1,y1,x2,y2,times: byte; newlinecolor: byte);
var loop: byte;
begin
  { Move the screen memory }
  for loop := y1+times+1 to y2 do begin
    move(mem[VidSeg:pred(loop)*maxwidth*2 + pred(x1)*2],
    mem[VidSeg:pred(loop-times)*maxwidth*2 + pred(x1)*2],(x2-x1+1)*2);
  end;

  { Clear the remaining region }
  for loop := y2-times+1 to y2 do
  putchars(x1,loop,' ',x2-x1+1,newlinecolor);
end;

Procedure SaveScreen(var screen: screensavetype);
Begin
  { If a status lines been used, increase until nolonger there }
  with screen do Begin
    getmem(screen,screensize);
    x := wherex;
    y := wherey;
    attr := TextAttr;
    WMax := WindMax;
    WMin := WindMin;
    Move(ScreenAddr^,Screen^,screensize);
    GetCursor(cursor);
    GetBorder(border);
  End;
End;

Procedure ShowScreen(var orgscreen: screensavetype);
Begin
  with orgscreen do Begin
    Move(Screen^,ScreenAddr^,screensize);
    WindMax := WMax;
    WindMin := WMin;
    gotoxy(x,y);
    TextAttr := attr;
    SetCursor(cursor);
    SetBorder(border);
  End;
End;

Procedure RestoreScreen(var screen: screensavetype);
Begin
  ShowScreen(screen);
  Freemem(screen.screen,screensize);
End;

Var oe: pointer;
Procedure FinishUp; far;
Begin
  exitproc := oe;
  cursoron;
End;

Function LMin(a,b: longint): longint;
begin
  if a<b then lmin := a
  else lmin := b;
end;

Function LMax(a,b: longint): longint;
begin
  if a>b then lmax := a
  else lmax := b;
end;

Begin
  Vga := VgaPresent;
  { Init the video addresses }
  if lastmode = 7 then VidSeg := $B000 else VidSeg := $B800;
  screenaddr := ptr(VidSeg,$0000);

  { Init the video using our -own- routines, not crt's which don't work
    on non-standard modes. Note: CRT must be patched if you want to use
    non-standard modes successfully, ie 132x60. }
  Maxwidth := widthaddr;
  Maxheight := succ(heightaddr);
  WindMax := (maxheight-1) shl 8 + (maxwidth-1);
  ScreenSize := maxheight*maxwidth*2; { For easy references to move commands. }

  GetCursor(OrgCursor);
  oe := exitproc;
  exitproc := @finishup; { To restore the cursor }

  { Init the tables for Upcasing }
  Crp := @CountryRec;
  Ltp := @LoTable;
  asm
    { Exit if Dos version < 3.0 }
    mov     ah, 30h
    int     21h
    cmp     al, 3
    jb      @1
    { Call Dos 'Get extended country information' function }
    mov     ax, 6501h
    les     di, CRP
    mov     bx,-1
    mov     dx,bx
    mov     cx,41
    int     21h
    jc      @1
    { Call Dos 'Get country dependent information' function }
    mov     ax, 6502h
    mov     bx, CountryRec.CodePage
    mov     dx, CountryRec.CountryID
    mov     CountryRec.TheInfo.CID, dx
    mov     cx, 5
    int     21h
    jc      @1
    { Build LoCase table }
    les     di, LTP
    mov     cx, 80h
    mov     ax, cx
    cld
   @3:
    stosb
    inc     ax
    loop    @3
    mov     di, offset LoTable - 80h
    mov     cx, 80h
    mov     dx, cx
    push    ds
    lds     bx, CountryRec.UpCaseTable
    sub     bx, 7eh
   @4:
    mov     ax, dx
    xlat
    cmp     ax, 80h
    jl      @5
    cmp     dx, ax
    je      @5
    xchg    bx, ax
    mov     es:[bx+di], dl
    xchg    bx, ax
   @5:
    inc     dx
    loop    @4
    pop     ds

    mov     [CountryOk], True
    jmp     @2
   @1:
    mov     [CountryOk], False
   @2:
  end;

  { Function for testing If Share is installed }
  asm
    mov ax, 1000h
    int 2Fh
    cmp al, 0FFh
    je @ShareInstalled
    mov Share, false
    jmp @exit
   @ShareInstalled:
    mov Share, true
   @Exit:
  End;
end.
