{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V+,X+}
{$M 16384,0,655360}
Unit CRCMisc;
Interface
Uses Dos,AppndDat;

Function BinCalcCrc16(Var Data; Len: word): Word;
Function BinCalcCrc32(Var Data; Len: word): Longint;
Function CRC16OfFile(Fn: PathStr): Word;
Function CRC32OfEXEFile(Fn: PathStr): Longint;
Function CRC32OfFile(Fn: PathStr): Longint;
Function CalcCrc16(St: String): Word;
Function CalcCrc32(St: String): Longint;
Function UpdateCRC16(C: Byte; Crc: Word): Word;
Function UpdateCRC32(C: byte; Crc: longint): Longint;

Implementation

Const
  Crc32table: Array[byte] of longint =
   ($00000000,$77073096,$EE0E612C,$990951BA,$076DC419,$706AF48F,$E963A535,$9E6495A3,
    $0EDB8832,$79DCB8A4,$E0D5E91E,$97D2D988,$09B64C2B,$7EB17CBD,$E7B82D07,$90BF1D91,
    $1DB71064,$6AB020F2,$F3B97148,$84BE41DE,$1ADAD47D,$6DDDE4EB,$F4D4B551,$83D385C7,
    $136C9856,$646BA8C0,$FD62F97A,$8A65C9EC,$14015C4F,$63066CD9,$FA0F3D63,$8D080DF5,
    $3B6E20C8,$4C69105E,$D56041E4,$A2677172,$3C03E4D1,$4B04D447,$D20D85FD,$A50AB56B,
    $35B5A8FA,$42B2986C,$DBBBC9D6,$ACBCF940,$32D86CE3,$45DF5C75,$DCD60DCF,$ABD13D59,
    $26D930AC,$51DE003A,$C8D75180,$BFD06116,$21B4F4B5,$56B3C423,$CFBA9599,$B8BDA50F,
    $2802B89E,$5F058808,$C60CD9B2,$B10BE924,$2F6F7C87,$58684C11,$C1611DAB,$B6662D3D,
    $76DC4190,$01DB7106,$98D220BC,$EFD5102A,$71B18589,$06B6B51F,$9FBFE4A5,$E8B8D433,
    $7807C9A2,$0F00F934,$9609A88E,$E10E9818,$7F6A0DBB,$086D3D2D,$91646C97,$E6635C01,
    $6B6B51F4,$1C6C6162,$856530D8,$F262004E,$6C0695ED,$1B01A57B,$8208F4C1,$F50FC457,
    $65B0D9C6,$12B7E950,$8BBEB8EA,$FCB9887C,$62DD1DDF,$15DA2D49,$8CD37CF3,$FBD44C65,
    $4DB26158,$3AB551CE,$A3BC0074,$D4BB30E2,$4ADFA541,$3DD895D7,$A4D1C46D,$D3D6F4FB,
    $4369E96A,$346ED9FC,$AD678846,$DA60B8D0,$44042D73,$33031DE5,$AA0A4C5F,$DD0D7CC9,
    $5005713C,$270241AA,$BE0B1010,$C90C2086,$5768B525,$206F85B3,$B966D409,$CE61E49F,
    $5EDEF90E,$29D9C998,$B0D09822,$C7D7A8B4,$59B33D17,$2EB40D81,$B7BD5C3B,$C0BA6CAD,
    $EDB88320,$9ABFB3B6,$03B6E20C,$74B1D29A,$EAD54739,$9DD277AF,$04DB2615,$73DC1683,
    $E3630B12,$94643B84,$0D6D6A3E,$7A6A5AA8,$E40ECF0B,$9309FF9D,$0A00AE27,$7D079EB1,
    $F00F9344,$8708A3D2,$1E01F268,$6906C2FE,$F762575D,$806567CB,$196C3671,$6E6B06E7,
    $FED41B76,$89D32BE0,$10DA7A5A,$67DD4ACC,$F9B9DF6F,$8EBEEFF9,$17B7BE43,$60B08ED5,
    $D6D6A3E8,$A1D1937E,$38D8C2C4,$4FDFF252,$D1BB67F1,$A6BC5767,$3FB506DD,$48B2364B,
    $D80D2BDA,$AF0A1B4C,$36034AF6,$41047A60,$DF60EFC3,$A867DF55,$316E8EEF,$4669BE79,
    $CB61B38C,$BC66831A,$256FD2A0,$5268E236,$CC0C7795,$BB0B4703,$220216B9,$5505262F,
    $C5BA3BBE,$B2BD0B28,$2BB45A92,$5CB36A04,$C2D7FFA7,$B5D0CF31,$2CD99E8B,$5BDEAE1D,
    $9B64C2B0,$EC63F226,$756AA39C,$026D930A,$9C0906A9,$EB0E363F,$72076785,$05005713,
    $95BF4A82,$E2B87A14,$7BB12BAE,$0CB61B38,$92D28E9B,$E5D5BE0D,$7CDCEFB7,$0BDBDF21,
    $86D3D2D4,$F1D4E242,$68DDB3F8,$1FDA836E,$81BE16CD,$F6B9265B,$6FB077E1,$18B74777,
    $88085AE6,$FF0F6A70,$66063BCA,$11010B5C,$8F659EFF,$F862AE69,$616BFFD3,$166CCF45,
    $A00AE278,$D70DD2EE,$4E048354,$3903B3C2,$A7672661,$D06016F7,$4969474D,$3E6E77DB,
    $AED16A4A,$D9D65ADC,$40DF0B66,$37D83BF0,$A9BCAE53,$DEBB9EC5,$47B2CF7F,$30B5FFE9,
    $BDBDF21C,$CABAC28A,$53B39330,$24B4A3A6,$BAD03605,$CDD70693,$54DE5729,$23D967BF,
    $B3667A2E,$C4614AB8,$5D681B02,$2A6F2B94,$B40BBE37,$C30C8EA1,$5A05DF1B,$2D02EF8D
   );

  Crc16table: Array[byte] of word =
   ($0000,$1021,$2042,$3063,$4084,$50A5,$60C6,$70E7,
    $8108,$9129,$A14A,$B16B,$C18C,$D1AD,$E1CE,$F1EF,
    $1231,$0210,$3273,$2252,$52B5,$4294,$72F7,$62D6,
    $9339,$8318,$B37B,$A35A,$D3BD,$C39C,$F3FF,$E3DE,
    $2462,$3443,$0420,$1401,$64E6,$74C7,$44A4,$5485,
    $A56A,$B54B,$8528,$9509,$E5EE,$F5CF,$C5AC,$D58D,
    $3653,$2672,$1611,$0630,$76D7,$66F6,$5695,$46B4,
    $B75B,$A77A,$9719,$8738,$F7DF,$E7FE,$D79D,$C7BC,
    $48C4,$58E5,$6886,$78A7,$0840,$1861,$2802,$3823,
    $C9CC,$D9ED,$E98E,$F9AF,$8948,$9969,$A90A,$B92B,
    $5AF5,$4AD4,$7AB7,$6A96,$1A71,$0A50,$3A33,$2A12,
    $DBFD,$CBDC,$FBBF,$EB9E,$9B79,$8B58,$BB3B,$AB1A,
    $6CA6,$7C87,$4CE4,$5CC5,$2C22,$3C03,$0C60,$1C41,
    $EDAE,$FD8F,$CDEC,$DDCD,$AD2A,$BD0B,$8D68,$9D49,
    $7E97,$6EB6,$5ED5,$4EF4,$3E13,$2E32,$1E51,$0E70,
    $FF9F,$EFBE,$DFDD,$CFFC,$BF1B,$AF3A,$9F59,$8F78,
    $9188,$81A9,$B1CA,$A1EB,$D10C,$C12D,$F14E,$E16F,
    $1080,$00A1,$30C2,$20E3,$5004,$4025,$7046,$6067,
    $83B9,$9398,$A3FB,$B3DA,$C33D,$D31C,$E37F,$F35E,
    $02B1,$1290,$22F3,$32D2,$4235,$5214,$6277,$7256,
    $B5EA,$A5CB,$95A8,$8589,$F56E,$E54F,$D52C,$C50D,
    $34E2,$24C3,$14A0,$0481,$7466,$6447,$5424,$4405,
    $A7DB,$B7FA,$8799,$97B8,$E75F,$F77E,$C71D,$D73C,
    $26D3,$36F2,$0691,$16B0,$6657,$7676,$4615,$5634,
    $D94C,$C96D,$F90E,$E92F,$99C8,$89E9,$B98A,$A9AB,
    $5844,$4865,$7806,$6827,$18C0,$08E1,$3882,$28A3,
    $CB7D,$DB5C,$EB3F,$FB1E,$8BF9,$9BD8,$ABBB,$BB9A,
    $4A75,$5A54,$6A37,$7A16,$0AF1,$1AD0,$2AB3,$3A92,
    $FD2E,$ED0F,$DD6C,$CD4D,$BDAA,$AD8B,$9DE8,$8DC9,
    $7C26,$6C07,$5C64,$4C45,$3CA2,$2C83,$1CE0,$0CC1,
    $EF1F,$FF3E,$CF5D,$DF7C,$AF9B,$BFBA,$8FD9,$9FF8,
    $6E17,$7E36,$4E55,$5E74,$2E93,$3EB2,$0ED1,$1EF0
   );
                                              
Function UpdateCRC32(c: byte; crc: longint): longint;
begin                                         
  UpdateCRC32 := CRC32Table[lo(crc) xor c] xor (crc shr 8);
end;                                          
                                              
Function UpdateCRC16(c: Byte; crc: Word): Word;
Begin                                         
   UpdateCRC16 := CRC16Table[hi(crc) xor c] xor (crc shl 8);
End;                                          
                                              
function CalcCrc16(st: string): word;         
var                                           
  loop: byte;                                 
  crcval: word;                               
begin                                         
  crcval := $0;                               
  for loop := 1 to length(st) do              
    crcval := updateCRC16(byte(st[loop]),crcval);
  calccrc16 := crcval;                        
end;                                          
                                              
function CalcCrc32(st: string) : longint;     
var                                           
  crcval: longint;                            
  loop: byte;                                 
begin                                         
  crcval := $FFFFFFFF;                        
  for loop := 1 to length(st) do              
    crcval := updateCRC32(byte(st[loop]),crcval);
  calccrc32 := crcval;                        
end;                                          

Function BinCalcCrc16(var data; len: word): word;
Type ByteArray = array[1..65535] of byte;
Var
  crcval: word;
  loop: word;
begin
  crcval := $0000;
  for loop := 1 to len do
    crcval := updatecrc16(ByteArray(data)[loop],crcval);
  bincalccrc16 := crcval;
end;
                                              
Function BinCalcCrc32(var data; len: word): longint;
Type ByteArray = array[1..65535] of byte;
Var
  crcval: longint;
  loop: word;
begin
  crcval := $FFFFFFFF;
  for loop := 1 to len do
    crcval := updatecrc32(ByteArray(data)[loop],crcval);
  bincalccrc32 := crcval;
end;

Function CRC32OfEXEFile(fn: pathstr): longint;
var
  crc: longint;
  numread,loop,toread: word;
  buffer: array[1..1024] of byte;
  read,size: longint;
  f: file;
begin
  size := exesize(fn);
  assign(f,fn);
  reset(f,1);
  crc := $FFFFFFFF;
  read := 0;
  repeat
    toread := sizeof(buffer);
    if toread+read > size then toread := size - read;
    blockread(f,buffer,toread,numread);
    inc(read,numread);
    for loop := 1 to numread do crc := updatecrc32(buffer[loop],crc);
  until numread = 0;
  close(f);
  CRC32OfEXEFile := crc;
end;

Function CRC32OfFile(fn: pathstr): longint;
var
  crc: longint;
  numread,loop,toread: word;
  buffer: array[1..1024] of byte;
  f: file;
begin
  assign(f,fn);
  reset(f,1);
  crc := $FFFFFFFF;
  repeat
    toread := sizeof(buffer);
    blockread(f,buffer,toread,numread);
    for loop := 1 to numread do crc := updatecrc32(buffer[loop],crc);
  until numread = 0;
  close(f);
  CRC32OfFile := crc;
end;

Function CRC16OfFile(fn: pathstr): word;
var
  crc: word;
  numread,loop,toread: word;
  buffer: array[1..1024] of byte;
  f: file;
begin
  assign(f,fn);
  reset(f,1);
  crc := $0;
  repeat
    toread := sizeof(buffer);
    blockread(f,buffer,toread,numread);
    for loop := 1 to numread do crc := updatecrc16(buffer[loop],crc);
  until numread = 0;
  close(f);
  CRC16OfFile := crc;
end;

end.
