unit MannDoor;

interface

uses
  {$IFDEF MSDOS}MannFos,{$ENDIF}
  {$IFDEF WIN32}MannSock,{$ENDIF}
  Crt, SysUtils, Windows;

type
  TEmulationType = (etANSI, etASCII);

  TDropInfo = Record
    {
     DIW Explained
     D = Found In DORINFO*.DEF
     I = Found In Info.*
     W = Found In DOOR32.SYS
    }
    Access    : LongInt;        {D W} {User's Access Level}
    Alias     : String;         { IW} {User's Alias/Handle}
    Baud      : LongInt;        {DIW} {Baud Rate}
    Clean     : Boolean;        { I } {Is LORD In Clean Mode?}
    ComNum    : LongInt;        {DIW} {Comm/Socket Number}
    ComType   : Byte;           {  W} {Comm Type (0=Local, 1=Serial, 2=Socket}
    Emulation : TEmulationType; {DIW} {User's Emulation (eANSI or eASCII)}
    Fairy     : Boolean;        { I } {Does User Have Fairy?}
    MaxTime   : LongInt;        {DIW} {User's Time Left At Start (In Seconds)}
    Node      : LongInt;        {  W} {Node Number}
    RealName  : String;         {DIW} {User's Real Name}
    RecPos    : LongInt;        { IW} {User's Userfile Record Position (Always 0 Based)}
    Registered: Boolean;        { I } {Is LORD Registered?}
  end;

  TLastKeyType = (lkNone, lkLocal, lkRemote);

  TLastKey = Record
    Chr: Char;              { Character of last key }
    Extended: Boolean;      { Was character preceded by #0 }
    Location: TLastKeyType; { Location of last key }
    Time: LongInt;          { SecToday of last key }
  end;

  TSession = Record
    Events: Boolean;     { Run Events in mKeyPressed function }
    EventsTime: LongInt; { MSecToday of last Events run }
    InChat: Boolean;     { Currently in sysop chat }
    MaxIdle: LongInt;    { Max idle before kick }
    TimeOn: LongInt;     { SecToday program was started }
  end;

  TStatusBar = Record
    Count: Byte;      { Number of statusbars in OnStatusBar procedure }
    Current: Byte;    { Currently displaying status bar }
  end;

  TSysopKeys = Record
    Chat: Char;
    Hangup: Char;
    Kick: Char;
    StatusBar: Char;
  end;

var
   {$IFDEF MSDOS}Tel: TMannFos;{$ENDIF}
   {$IFDEF WIN32}Tel: TMannSock;{$ENDIF}

   DropInfo: TDropInfo;
   LastKey: TLastKey;
   Session: TSession;
   StatusBar: TStatusBar;
   SysopKeys: TSysopKeys;

   mOnChat: Procedure;
   mOnHangup: Procedure;
   mOnLocalLogin: Procedure;
   mOnStatusBar: Procedure;
   mOnSysopHangup: Procedure;
   mOnSysopKick: Procedure;
   mOnTimeOut: Procedure;
   mOnTimeOutWarning: Procedure(AMinutes: Byte);
   mOnTimeUp: Procedure;
   mOnTimeUpWarning: Procedure(AMinutes: Byte);
   mOnUsage: Procedure;

function mCarrier: Boolean;
procedure mClearBuf;
procedure mClrEol;
procedure mClrScr;
procedure mCrlf;
procedure mCursorDown(ACount: Byte);
procedure mCursorLeft(ACount: Byte);
procedure mCursorRestore;
procedure mCursorRight(ACount: Byte);
procedure mCursorSave;
procedure mCursorUp(ACount: Byte);
procedure mDisplayFile(AFile: String);
procedure mGotoX(AX: Byte);
procedure mGotoXY(AX, AY: Byte);
procedure mGotoY(AY: Byte);
function mInput(ADefault, AChars: String; APass: Char; AShowLen, AMaxLen, AAttr: Byte): String;
function mKeyPressed: Boolean;
function mLocal: Boolean;
procedure mMore(ALine: String);
function mOpen(ASocket: LongInt): Boolean;
function mReadKey: Char;
procedure mStartUp;
procedure mTextAttr(AAttr: Byte);
procedure mTextBackground(AColour: Byte);
procedure mTextColor(AColour: Byte);
function mTimeIdle: LongInt;
function mTimeLeft: LongInt;
procedure mWrite(ALine: String);
procedure mWriteLn(ALine: String);
procedure ReadDoor32(AFile: String);
procedure ReadDorinfo(AFile: String);
procedure ReadInfo(AFile: String);

procedure OnChat;
procedure OnHangup;
procedure OnLocalLogin;
procedure OnStatusBar;
procedure OnSysopHangup;
procedure OnSysopKick;
procedure OnTimeOut;
procedure OnTimeUp;
procedure OnUsage;

implementation

uses
  mAnsi, mCrt, mStrings, mUtils;

procedure DoEvents;
begin
     if (Session.Events) and (MSecElapsed(Session.EventsTime, MSecToday) > 1000) then
     begin
          {Check For Hangup}
          if Not(mCarrier) and Assigned(mOnHangup) then
             mOnHangup;

          {Check For Idle Timeout}
          if (mTimeIdle > Session.MaxIdle) and Assigned(mOnTimeOut) then
             mOnTimeOut;

          {Check For Idle Timeout Warning}
          if ((Session.MaxIdle - mTimeIdle) mod 60 = 1) and ((Session.MaxIdle - mTimeIdle) div 60 <= 5) and (Assigned(mOnTimeOutWarning)) then
             mOnTimeOutWarning((Session.MaxIdle - mTimeIdle) div 60);

          {Check For Time Up}
          if (mTimeLeft < 1) and Assigned(mOnTimeUp) then
             mOnTimeUp;

          {Check For Time Up Warning}
          if (mTimeLeft mod 60 = 1) and (mTimeLeft div 60 <= 5) and Assigned(mOnTimeUpWarning) then
             mOnTimeUpWarning(mTimeLeft div 60);

          {Update Status Bar}
          if Assigned(mOnStatusBar) then
             mOnStatusBar;

          Session.EventsTime := MSecToday;
     end;
end;

function mCarrier: Boolean;
begin
     if (mLocal) then
        mCarrier := True
     else
         mCarrier := Tel.Connected;
end;

procedure mClearBuf;
begin
     while (KeyPressed) do
           ReadKey;
     if Not(mLocal) then
        Tel.ReadBuf;
end;

procedure mClrEol;
begin
     mWrite(aClrEol);
end;

procedure mClrScr;
begin
     mWrite(aClrScr);
end;

procedure mCrlf;
begin
     mWrite(#13#10);
end;

procedure mCursorDown(ACount: Byte);
begin
     mWrite(aCursorDown(ACount));
end;

procedure mCursorLeft(ACount: Byte);
begin
     mWrite(aCursorLeft(ACount));
end;

procedure mCursorRestore;
begin
     mWrite(aCursorRestore);
end;

procedure mCursorRight(ACount: Byte);
begin
     mWrite(aCursorRight(ACount));
end;

procedure mCursorSave;
begin
     mWrite(aCursorSave);
end;

procedure mCursorUp(ACount: Byte);
begin
     mWrite(aCursorDown(ACount));
end;

procedure mDisplayFile(AFile: String);
var
   F: Text;
   S: String;
begin
     if (FileExists(AFile)) then
     begin
          Assign(F, AFile);
          {$I-}Reset(F);{$I+}
          if (IOResult = 0) then
          begin
               while Not(EOF(F)) do
               begin
                    ReadLn(F, S);
                    if (EOF(F)) then
                       mWrite(S)
                    else
                        mWriteLn(S);
               end;
               Close(F);
          end;
     end;
end;

procedure mGotoX(AX: Byte);
begin
     mWrite(aGotoX(AX));
end;

procedure mGotoXY(AX, AY: Byte);
begin
     mWrite(aGotoXY(AX, AY));
end;

procedure mGotoY(AY: Byte);
begin
     mWrite(aGotoY(AY));
end;

function mInput(ADefault, AChars: String; APass: Char; AShowLen, AMaxLen, AAttr: Byte): String;
var
   Ch: Char;
   S: String;
   SavedAttr: Byte;
   XPos: Byte;

  procedure UpdateText;
  begin
       mGotoX(XPos);
       if (Length(S) > AShowLen) then
       begin
            if (APass = #0) then
               mWrite(Copy(S, Length(S) - AShowLen + 1, AShowLen))
            else
                mWrite(PadRight('', APass, AShowLen));
            mGotoX(XPos + AShowLen);
       end else
       begin
            if (APass = #0) then
               mWrite(S)
            else
                mWrite(PadRight('', APass, Length(S)));
            mWrite(PadRight('', ' ', AShowLen - Length(S)));
            mGotoX(XPos + Length(S));
       end;
  end;

begin
     if (Length(ADefault) > AMaxLen) then
        ADefault := Copy(ADefault, 1, AMaxLen);
     S := ADefault;

     SavedAttr := TextAttr;
     mTextAttr(AAttr);
     XPos := WhereX;

     UpdateText;

     repeat
           Ch := mReadKey;
           if (Ch = #8) and (Length(S) > 0) then
           begin
                Delete(S, Length(S), 1);
                mWrite(#8 + ' ' + #8);
                if (Length(S) >= AShowLen) then
                   UpdateText;
           end else
           if (Ch = #25) and (S <> '') then {CTRL-Y}
           begin
                S := '';
                UpdateText;
           end else
           if (Pos(Ch, AChars) > 0) and (Length(S) < AMaxLen) then
           begin
                S := S + Ch;
                if (Length(S) > AShowLen) then
                   UpdateText
                else
                if (APass = #0) then
                   mWrite(Ch)
                else
                    mWrite(APass);
           end;
     until (Ch = #27) or ((Ch = #13) and (S <> ''));

     mTextAttr(SavedAttr);
     mCrlf;

     if (Ch = #27) then
        S := ADefault;
     mInput := S;
end;

function mKeyPressed: Boolean;
begin
     DoEvents;

     if (mLocal) then
        mKeypressed := KeyPressed
     else
         mKeyPressed := KeyPressed or Tel.KeyPressed;
end;

function mLocal: Boolean;
begin
     mLocal := DropInfo.ComType = 0;
end;

procedure mMore(ALine: String);
begin
     if (ALine = '') then
        ALine := ' |0A<|02MORE|0A>';

     mWrite(ALine);
     mReadKey;

     mWrite(aCursorLeft(Length(ALine)));
     mWrite(PadLeft('', ' ', Length(ALine)));
     mWrite(aCursorLeft(Length(ALine)));
end;

function mOpen(ASocket: LongInt): Boolean;
begin
     mOpen := Tel.Open(ASocket);
end;

function mReadKey: Char;
var
   Ch: Char;
begin
     LastKey.Location := lkNone;
     repeat
           while Not(mKeyPressed) do
                 Sleep(1);
           if (KeyPressed) then
           begin
                Ch := ReadKey;
                if (Ch = #0) then
                begin
                     Ch := ReadKey;
                     if (Ch = SysopKeys.Chat) then
                     begin
                          if Not(Session.InChat) and Assigned(mOnChat) then
                             mOnChat;
                     end else
                     if (Ch = SysopKeys.Hangup) then
                     begin
                          if Assigned(mOnSysopHangup) then
                             mOnSysopHangup;
                     end else
                     if (Ch = SysopKeys.Kick) then
                     begin
                          if Assigned(mOnSysopKick) then
                             mOnSysopKick;
                     end else
                     if (Ch = SysopKeys.StatusBar) then
                     begin
                          if Assigned(mOnStatusBar) then
                          begin
                               Inc(StatusBar.Current);
                               if (StatusBar.Current > StatusBar.Count) then
                                  StatusBar.Current := 1;
                               mOnStatusBar;
                          end;
                     end else
                     begin
                          LastKey.Extended := True;
                          LastKey.Location := lkLocal;
                     end;
                end else
                begin
                     LastKey.Extended := False;
                     LastKey.Location := lkLocal;
                end;
           end else
           if Not(mLocal) and (Tel.KeyPressed) then
           begin
                Ch := Tel.ReadKey;
                LastKey.Extended := False;
                LastKey.Location := lkRemote;
           end;
     until (LastKey.Location <> lkNone);
     LastKey.Chr := Ch;
     LastKey.Time := SecToday;

     mReadKey := Ch;
end;

procedure mStartUp;
var
   DropFile: String;
   Socket: LongInt;
   I: Integer;
   Local: Boolean;
   Node: Integer;
   S: String;
begin
     DropFile := '';
     Socket := -1;
     Local := False;
     Node := 0;

     if (ParamCount > 0) then
     begin
          for I := 1 to ParamCount do
          begin
               S := ParamStr(I);
               if (Length(S) >= 2) and (S[1] in ['/', '-']) then
               begin
                    Delete(S, 1, 1);
                    Case UpCase(S[1]) of
                         'D': begin
                                   Delete(S, 1, 1);
                                   DropFile := S;
                              end;
                         'H': begin
                                   Delete(S, 1, 1);
                                   Socket := StrToIntDef(S, -1);
                              end;
                         'L': Local := True;
                         'N': begin
                                   Delete(S, 1, 1);
                                   Node := StrToIntDef(S, 0);
                              end;
                    end;
               end;
          end;
     end;

     if (Local) and (Node > 0) then
     begin
          DropInfo.Node := Node;
          if Assigned(mOnLocalLogin) then
             mOnLocalLogin;
     end else
     if (Socket >= 0) and (Node > 0) then
     begin
          {$IFDEF MSDOS}DropInfo.ComType := 1;{$ENDIF}
          {$IFDEF WIN32}DropInfo.ComType := 2;{$ENDIF}
          DropInfo.ComNum := Socket;
          DropInfo.Node := Node;
     end else
     if (DropFile <> '') then
     begin
          if (FileExists(DropFile)) and (ciPos('DOOR32.SYS', DropFile) > 0) then
             ReadDoor32(DropFile)
          else
          if (FileExists(DropFile)) and (ciPos('DORINFO', DropFile) > 0) then
             ReadDorinfo(DropFile)
          else
          if (FileExists(DropFile)) and (ciPos('INFO.', DropFile) > 0) then
             ReadInfo(DropFile)
          else
          begin
               ClrScr;
               WriteLn;
               WriteLn('  Drop File Not Found');
               WriteLn;
               Delay(1500);
               Halt;
          end;
     end else
     begin
          if Assigned(mOnUsage) then
             mOnUsage
          else
              OnUsage;
     end;

     if Not(mLocal) then
     begin
          if Not(mOpen(DropInfo.ComNum)) then
          begin
               ClrScr;
               WriteLn;
               WriteLn('  No Carrier Detected');
               WriteLn;
               Delay(1500);
               Halt;
          end;

          mClrScr;
          Window(1, 1, 80, 24);

          LastKey.Time := SecToday;

          Session.Events := True;
          Session.EventsTime := MSecToday - 500;
          Session.TimeOn := SecToday;
     end;
end;

procedure mTextAttr(AAttr: Byte);
begin
     mWrite(aTextAttr(AAttr));
end;

procedure mTextBackground(AColour: Byte);
begin
     mWrite(aTextBackground(AColour));
end;

procedure mTextColor(AColour: Byte);
begin
     mWrite(aTextColor(AColour));
end;

function mTimeIdle: LongInt;
begin
     mTimeIdle := SecElapsed(LastKey.Time, SecToday);
end;

function mTimeLeft: LongInt;
begin
     mTimeLeft := DropInfo.MaxTime - SecElapsed(Session.TimeOn, SecToday);
end;

procedure mWrite(ALine: String);
begin
     ALine := PipeToAnsi(ALine);

     aWrite(ALine);
     if Not(mLocal) then
        Tel.Write(ALine);
end;

procedure mWriteLn(ALine: String);
begin
     mWrite(ALine + #13#10);
end;

procedure OnChat;
var
   Ch: Char;
   Last: TLastKeyType;
   Attr: Byte;
begin
     Session.InChat := True;

     Attr := TextAttr;
     mTextAttr(7);

     mClrScr;
     mWriteLn('Chat Mode Initiated');
     mCrlf;

     Last := lkNone;
     repeat
           Ch := mReadKey;
           if (Ch = #8) then
              mWrite(#8 + ' ' + #8)
           else
           if (Ch = #13) then
              mCrlf
           else
           if (Ch in [#32..#126]) then
           begin
                if (Last <> LastKey.Location) then
                begin
                     Last := LastKey.Location;
                     case LastKey.Location of
                          lkLocal: mTextColor(15);
                          lkRemote: mTextColor(7);
                     end;
                end;
                mWrite(Ch);
           end;
     until (Ch = #27);
     mCrlf;
     mCrlf;
     mWriteLn('Chat Mode Terminated');
     mCrlf;

     mTextAttr(Attr);

     Session.InChat := False;
end;

procedure OnHangup;
begin
     TextAttr := 15;
     ClrScr;
     WriteLn;
     WriteLn('   Caller Dropped Carrier.  Returning To BBS...');
     Delay(1500);
     Halt;
end;

procedure OnLocalLogin;
var
   S: String;
begin
     ClrScr;
     WriteLn;
     WriteLn('  LOCAL LOGIN');
     WriteLn;
     Write('  Enter your name : ');
     S := mInput('SYSOP', CHARS_ALPHA + ' ', #0, 40, 40, 31);
     DropInfo.RealName := S;
     DropInfo.Alias := S;
end;

procedure OnStatusBar;
begin
     case StatusBar.Current of
          1: begin
                  FastWrite(#254 + '                      ' + #254 + '            ' + #254 + '           ' + #254 +
                  '             ' + #254 + '                ' + #254, 1, 25, 30);
                  FastWrite(PadRight(DropInfo.RealName, ' ', 20), 3, 25, 31);
                  FastWrite(PadRight(DropInfo.Alias, ' ', 10), 26, 25, 31);
                  FastWrite('MannDoor!', 39, 25, 31);
                  FastWrite(PadRight('Idle: ' + SecToMS(SecElapsed(LastKey.Time, SecToday)), ' ', 11), 51, 25, 31);
                  FastWrite('Left: ' + SecToHMS(mTimeLeft), 65, 25, 31);
             end;
          2: begin
                  FastWrite(PadRight(#254 + '                      ' + #254 + '             ' + #254 +
                  '                ' + #254 + '             ' + #254, ' ', 80), 1, 25, 30);
                  FastWrite('F1: Toggle StatusBar', 3, 25, 31);
                  FastWrite('Alt-C: Chat', 26, 25, 31);
                  FastWrite('Alt-H: Hang-Up', 40, 25, 31);
                  FastWrite('Alt-K: Kick', 57, 25, 31);
             end;
     end;
end;

procedure OnSysopHangup;
begin
     mTextColor(15);
     mTextBackground(0);
     mClrScr;
     mCrlf;
     mWriteLn('  The SysOp Has Disconnected You From The BBS...');
     Delay(1500);
     Tel.Close(True);
     Halt;
end;

procedure OnSysopKick;
begin
     mTextColor(15);
     mTextBackground(0);
     mClrScr;
     mCrlf;
     mWriteLn('  The SysOp Has Kicked You Back To The BBS...');
     Delay(1500);
     Tel.Close(False);
     Halt;
end;

procedure OnTimeOut;
begin
     mTextColor(15);
     mTextBackground(0);
     mClrScr;
     mCrlf;
     mWriteLn('  Idle Time Limit Exceeded.  Returning To BBS...');
     Delay(1500);
     Halt;
end;

procedure OnTimeUp;
begin
     mTextColor(15);
     mTextBackground(0);
     mClrScr;
     mCrlf;
     mWriteLn('  Your Time Has Expired.  Returning To BBS...');
     Delay(1500);
     Halt;
end;

procedure OnUsage;
begin
     ClrScr;
     WriteLn;
     WriteLn(' USAGE:');
     WriteLn;
     WriteLn(' ' + ExtractFileName(ParamStr(0)) + ' <PARAMETERS>');
     WriteLn;
     WriteLn('  -D         PATH\FILENAME OF DROPFILE');
     WriteLn('  -H         SOCKET HANDLE or COM PORT');
     WriteLn('  -L         LOCAL MODE');
     WriteLn('  -N         NODE NUMBER');
     WriteLn;
     WriteLn(' Examples:');
     WriteLn;
     WriteLn(' ' + ExtractFileName(ParamStr(0)));
     WriteLn('  -  Run In Local Mode');
     WriteLn(' ' + ExtractFileName(ParamStr(0)) + ' -H1000 -N3');
     WriteLn('  -  Open Socket Handle 1000 On Node #3');
     WriteLn(' ' + ExtractFileName(ParamStr(0)) + ' -DC:\MANNBBS\NODE1\DOOR32.SYS');
     WriteLn('  -  Load Settings From DOOR32.SYS');
     Halt;
end;

procedure ReadDoor32(AFile: String);
var
   F: Text;
   S: String;
begin
     if (FileExists(AFile)) then
     begin
          Assign(F, AFile);
          {$I-}Reset(F);{$I+}
          if (IOResult = 0) then
          begin
               ReadLn(F, S); {1 - Comm Type (0=Local, 1=Serial, 2=Telnet)}
               DropInfo.ComType := StrToIntDef(S, 0);

               ReadLn(F, S); {2 - Comm Or Socket Handle}
               DropInfo.ComNum := StrToIntDef(S, -1);

               ReadLn(F, S); {3 - Baud Rate}
               DropInfo.Baud := StrToIntDef(S, 0);

               ReadLn(F, S); {4 - BBSID (Software Name & Version}

               ReadLn(F, S); {5 - User's Record Position (1 Based)}
               DropInfo.RecPos := StrToIntDef(S, 1) - 1;

               ReadLn(F, S); {6 - User's Real Name}
               DropInfo.RealName := S;

               ReadLn(F, S); {7 - User's Handle/Alias}
               DropInfo.Alias := S;

               ReadLn(F, S); {8 - User's Access Level}
               DropInfo.Access := StrToIntDef(S, 0);

               ReadLn(F, S); {9 - User's Time Left (In Minutes)}
               DropInfo.MaxTime := StrToIntDef(S, 0) * 60;

               ReadLn(F, S); {10 - Emulation (0=Ascii, 1=Ansi, 2=Avatar, 3=RIP, 4=MaxGfx)}
               if (StrToIntDef(S, 1) = 0) then
                  DropInfo.Emulation := etASCII
               else
                   DropInfo.Emulation := etANSI;

               ReadLn(F, S); {11 - Current Node Number}
               DropInfo.Node := StrToIntDef(S, 0);

               Close(F);
          end;
     end;
end;

procedure ReadDorinfo(AFile: String);
var
   F: Text;
   S: String;
begin
     if (FileExists(AFile)) then
     begin
          Assign(F, AFile);
          {$I-}Reset(F);{$I+}
          if (IOResult = 0) then
          begin
               ReadLn(F, S); {1 - BBS Name}

               ReadLn(F, S); {2 - Sysop's First Name}

               ReadLn(F, S); {3 - Sysop's Last Name}

               ReadLn(F, S); {4 - Comm Number in COMxxx Form}
               DropInfo.ComNum := StrToIntDef(Copy(S, 4, Length(S) - 3), 0);
               if (DropInfo.ComNum <> 0) then
               begin
                    {$IFDEF MSDOS}DropInfo.ComType := 1;{$ENDIF}
                    {$IFDEF WIN32}DropInfo.ComType := 2;{$ENDIF}
               end;

               ReadLn(F, S); {5 - Baud Rate in 57600 BAUD,N,8,1 Form}
               DropInfo.Baud := StrToIntDef(Copy(S, 1, Pos(' ', S) - 1), 0);

               ReadLn(F, S); {6 - Networked?}

               ReadLn(F, S); {7 - User's First Name}
               DropInfo.RealName := S;

               ReadLn(F, S); {8 - User's Last Name}
               if (S <> '') then
                  DropInfo.RealName := DropInfo.RealName + ' ' + S;

               ReadLn(F, S); {9 - User's Location (City, State, etc.)}

               ReadLn(F, S); {10 - User's Emulation (1=Ansi)}
               if (StrToIntDef(S, 1) = 1) then
                  DropInfo.Emulation := etANSI
               else
                   DropInfo.Emulation := etASCII;

               ReadLn(F, S); {11 - User's Access Level}
               DropInfo.Access := StrToIntDef(S, 0);

               ReadLn(F, S); {12 - User's Time Left (In Minutes)}
               DropInfo.MaxTime := StrToIntDef(S, 0) * 60;

               ReadLn(F, S); {13 - Fossil?}

               Close(F);
          end;
     end;
end;

procedure ReadInfo(AFile: String);
var
   F: Text;
   S: String;
begin
     if (FileExists(AFile)) then
     begin
          Assign(F, AFile);
          {$I-}Reset(F);{$I+}
          if (IOResult = 0) then
          begin
               ReadLn(F, S); {1 - Account Number (0 Based)}
               DropInfo.RecPos := StrToIntDef(S, 0);

               ReadLn(F, S); {2 - Emulation (3=Ansi, Other = Ascii)}
               if (StrToIntDef(S, 3) = 3) then
                  DropInfo.Emulation := etANSI
               else
                   DropInfo.Emulation := etASCII;

               ReadLn(F, S); {3 - RIP YES or RIP NO}

               ReadLn(F, S); {4 - FAIRY YES or FAIRY NO}
               if (UpperCase(S) = 'FAIRY YES') then
                  DropInfo.Fairy := True
               else
                   DropInfo.Fairy := False;

               ReadLn(F, S); {5 - User's Time Left (In Minutes)}
               DropInfo.MaxTime := StrToIntDef(S, 0) * 60;

               ReadLn(F, S); {6 - User's Handle/Alias}
               DropInfo.Alias := S;

               ReadLn(F, S); {7 - User's First Name}
               DropInfo.RealName := S;

               ReadLn(F, S); {8 - User's Last Name}
               if (S <> '') then
                  DropInfo.RealName := DropInfo.RealName + ' ' + S;

               ReadLn(F, S); {9 - Comm Port}
               DropInfo.ComNum := StrToIntDef(S, 0);
               if (DropInfo.ComNum <> 0) then
               begin
                    {$IFDEF MSDOS}DropInfo.ComType := 1;{$ENDIF}
                    {$IFDEF WIN32}DropInfo.ComType := 2;{$ENDIF}
               end;

               ReadLn(F, S); {10 - Caller Baud Rate}

               ReadLn(F, S); {11 - Port Baud Rate}
               DropInfo.Baud := StrToIntDef(S, 0);

               ReadLn(F, S); {12 - FOSSIL or INTERNAL}

               ReadLn(F, S); {13 - REGISTERED or UNREGISTERED}
               if (UpperCase(S) = 'REGISTERED') then
                  DropInfo.Registered := True
               else
                   DropInfo.Registered := False;

               ReadLn(F, S); {14 - CLEAN MODE ON or CLEAN MODE OFF}
               if (UpperCase(S) = 'CLEAN MODE ON') then
                  DropInfo.Clean := True
               else
                   DropInfo.Clean := False;

               Close(F);
          end;
     end;
end;

begin
     Tel.Create;

     mOnChat := OnChat;
     mOnHangup := OnHangup;
     mOnLocalLogin := OnLocalLogin;
     mOnStatusBar := OnStatusBar;
     mOnSysopHangup := OnSysopHangup;
     mOnSysopKick := OnSysopKick;
     mOnTimeOut := OnTimeOut;
     mOnTimeOutWarning := nil;
     mOnTimeUp := OnTimeUp;
     mOnTimeUpWarning := nil;
     mOnUsage := OnUsage;

     with DropInfo do
     begin
          Access := 0;
          Alias := '';
          Baud := 0;
          Clean := False;
          ComNum := -1;
          ComType := 0;
          Emulation := etANSI;
          Fairy := False;
          MaxTime := 0;
          Node := 0;
          RealName := '';
          RecPos := -1;
          Registered := False;
     end;

     with LastKey do
     begin
          Chr := #0;
          Extended := False;
          Location := lkNone;
          Time := 0;
     end;

     with Session do
     begin
          InChat := False;
          Events := False;
          EventsTime := 0;
          MaxIdle := 300;
          TimeOn := 0;
     end;

     with StatusBar do
     begin
          Count := 2;
          Current := 1;
     end;

     with SysopKeys do
     begin
          Chat := #46;
          Hangup := #35;
          Kick := #47;
          StatusBar := #59;
     end;
end.
