{$I whichos.inc}

unit teamact;

interface

uses crt, manndoor, teamglob, teammisc, toolbox, partyu;

procedure actionmenu;

implementation

var oldteam:boolean;

procedure getaroom;
var tempstr:string;
    ch:char;
begin
  load_my_team;
  mwriteln('');
  mwrite('`2Do you want to stay for the night? [`5N`2]:`% ');
  ch := GetAkey;
  ch := upcase(ch);

  if ch in [#1,#2] then exit;

  if ch <> 'Y' then ch := 'N';
  mwriteln(ch+'');
  IF ch='N' then
  begin
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('`%  Visiting the Team House');
    mwriteln('`0`L');
    mwriteln('`2    You pass the doorguard on the way into your house,');
    mwriteln('    and feel very confident that he would protect you in');
    mwriteln('    the case of an intruder.  You feel that sleeping here');
    mwriteln('    would be much safer than staying in the Inn.  You');
    mwriteln('    never trusted that sneaky bartender anyway...');
    moreprompt;
    exit;
  end;
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('`%  Retiring...');
  mwriteln('`0`L');
  mwriteln('`2    You pass the doorguard on the way into your house,');
  mwriteln('    and feel very confident that he will protect you in');
  mwriteln('    the case of an intruder.  Walking back to your room,');
  mwriteln('    you lock the doors and windows.  Finally, you collapse');
  mwriteln('    in your bed, and wait for sleep...');
  mwriteln('');
  mwriteln('');
  mwriteln('    RETURNING TO THE MUNDANE WORLD...');
  assign(textf,igmdat^.lordpath+'out.'+IntToStr(dropinfo.recpos));
  rewrite(textf);
  writeln(textf,'`.`2is asleep in the `0'+myteam^.name+'`2 team house.');
{$ifdef FORNIX}
  writeln(textf,igmpath+'teamlord -D'+igmdat^.lordpath+'info.*');
{$else}
  writeln(textf,igmpath+'teamlord.exe -D'+igmdat^.lordpath+'info.*');
{$endif}
  close(textf);
  pl^.on_now := false;
  save_player;
  myteam^.sleep[dropinfo.recpos] := true;
  save_my_team;
  halt;
end;


procedure train;
var ch:char;
    tempstr:string;
    e:longint;
{$ifdef VIRTUALPASCAL}
    errcode : longint;
{$else}
    errcode : integer;
{$endif}
begin
  load_my_team;
  IF (myteam^.dgstr = 0) then
  begin
    mwriteln('');
    mwrite('`2You do not have a doorguard!  Would you like to purchase one? [`5Y`2]:`% ');
    ch := getAKey;

    if ch in [#1,#2] then exit;

    ch := upcase(ch);
    if ch <> 'N' then ch := 'Y';
    mwriteln(ch+'');
    if ch = 'N' then exit;
    mwriteln('');
    mwriteln('  `2A doorguard dragon will cost 10,000 gold.');
    mwriteln('');
    if (pl^.gold < 10000) then
    begin
      mwriteln('  `2You can''t afford this!');
      moreprompt;
      exit;
    end;
    mwrite('`2Pay it? [`5Y`2]:`% ');
    ch := getAKey;

    if ch in [#1,#2] then exit;

    ch := upcase(ch);
    if ch <> 'N' then ch := 'Y';
    mwriteln(ch+'');
    if ch = 'N' then exit;
    mwriteln('');
    mwriteln('  `2You take the dragon back to the house, to train it.');
    myteam^.dgstr := 1;
    myteam^.dgdef := 10;
    dec(pl^.gold,10000);
    save_my_team;
    save_player;
    moreprompt;
    mwriteln('');
    mclrscr;
  end;

  repeat
    mwriteln('');
    mwriteln('');
    mwriteln('`%    Training the doorguard');
    mwriteln('  `0`L');
    mwriteln('  `2Your little dragon could use some training to');
    mwriteln('  increase the size of his muscles - after all,');
    mwriteln('  he''s the watchman while you sleep.');
    mwriteln('');
    tempstr := commas(myteam^.dgstr);
    IF (myteam^.dgstr = 2500) then tempstr := tempstr + ' `0(`2Maximum!`2)';
    mwriteln('`0      Strength :`% '+tempstr);
    tempstr := commas(myteam^.dgdef);
    IF (myteam^.dgdef = 2500) then tempstr := tempstr + ' `0(`2Maximum!`0)';
    mwriteln('`0      Endurance:`% '+tempstr);
    mwriteln('');
    mwriteln('');
    mwriteln('        `2(`5T`2)rain Your Dragon');
    mwriteln('');
    mwriteln('        `2(`5R`2)eturn to Team Menu');
    mwriteln('');
    mwrite('  `2Your command, `0'+pl^.names+'`2?`% ');
    ch := getakey;
    if ch in [#1,#2] then exit;
    ch := upcase(ch);
    if ch <> 'T' then ch := 'R';
    mwriteln(ch+'');
    if ch = 'R' then exit;

    if (igmplay^.partied=0) or (igmplay^.partied mod 5 <> 0) then
    begin
      mwriteln('');
      mwriteln('`2  Sorry, you''ve already trained it enough today!');
      moreprompt;
      exit;
    end;

    mwriteln('');
    mwrite('`2Train the dragon in [`0E`2]ndurance or [`0S`2]trength? [`5E`2]:`% ');
    ch := getakey;
    if ch in [#1,#2] then exit;
    ch := upcase(ch);
    if ch <> 'S' then ch := 'E';
    mwriteln(ch+'');

    CASE ch of
    'E':begin
          mwriteln('');
          mwriteln('  `2Endurance training for dragons involves intensive running,');
          mwriteln('  fire-breathing, and frisbee-catching.  This process will');
          mwriteln('  increase the dragon''s endurance by 1 for every hour that');
          mwriteln('  you submit him to (up to 7 hours a training session).  Each');
          mwriteln('  training hour will cost `$20,000 `2gold.');
          mwriteln('');
          tempstr := commas(pl^.gold div 20000);
          IF pl^.gold div 20000 > 7 then tempstr := '7';
          mwrite('`2How many hours of training will you submit him to? (`$'+tempstr+'`0 max`2)`% ');
          ch := getakey;
          if ch in [#1,#2] then exit;
          if not (ch in ['0','1'..'7']) then ch := '1';
          mwriteln(ch+'');

          val(ch,e,errcode);
          IF (errcode <> 0) then e := 0;

          IF (E > pl^.gold DIV 20000) then
          begin
            mwriteln('');
            mwriteln('  `2You can''t afford that!');
            moreprompt;
            continue;
          end
          else
          if (E > 0) and (E <= pl^.gold DIV 20000) then
          begin
            mwriteln('');
            mwriteln('  `2Dragon trained! (`$'+commas(e*20000)+' `2gold spent!)');
            dec(pl^.gold,e*20000);
            inc(myteam^.dgdef,e);
            IF (myteam^.dgdef > 2500) then myteam^.dgdef := 2500;
            save_player;
            save_my_team;
            moreprompt;
          end;
        end;
    'S':begin
          mwriteln('');
          mwriteln('  `2Strength training for dragons involves pumping iron with');
          mwriteln('  tongues, running cross-country (in Siberia), and picking');
          mwriteln('  up heavy objects (such as Rush Limbaugh or the Sunday New');
          mwriteln('  York Times).  You may strength train the dragon for up to');
          mwriteln('  nine hours a training session.  Each hour of training costs');
          mwriteln('  `$25,000 `2gold, and will increase the dragon''s strength');
          mwriteln('  by 1.');
          mwriteln('');
          tempstr := commas(pl^.gold div 25000);
          IF pl^.gold div 25000 > 9 then tempstr := '9';
          mwrite('`2How many hours of training will you submit him to? (`$'+tempstr+'`0 max`2)`% ');
          ch := getakey;
          if ch in [#1,#2] then exit;
          if not (ch in ['0','1'..'9']) then ch := '1';
          val(ch,e,errcode);
          IF (errcode <> 0) then e := 0;
          IF E > pl^.gold div 25000 then
          begin
            mwriteln('');
            mwriteln('  `2You can''t afford that!');
            moreprompt;
          end
          else
          if (E > 0) and (E <= pl^.gold div 25000) then
          begin
            mwriteln('');
            mwriteln('  `2Dragon trained! (`$'+commas(e*25000)+' `2gold spent!)');
            dec(pl^.gold,e*25000);
            inc(myteam^.dgstr,e);
            IF (myteam^.dgstr > 2500) then myteam^.dgstr := 2500;
            save_player;
            save_my_team;
            moreprompt;
          end;
        end;
    end;

    if (oldteam=true) and (igmplay^.onteam=false) then exit;

  until (1=2);
end;

procedure writemail(b:byte;he,otm:string;yo:longint;win:boolean);
begin
  assign(textf,igmdat^.lordpath+'mail'+IntToStr(b)+'.dat');
  {$I-}append(textf);{$I+}
  if ioresult <> 0 then rewrite(textf);

  writeln(textf,'  `%TEAM ATTACK RESULTS!');
  writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-`2');
  IF WIN THEN
  begin
    writeln(textf,'  `2You have killed `0'+he+' `2(`0'+otm+'`2)!');
    writeln(textf,'  `2You receive `$'+commas(yo)+' `2experience!');
    writeln(textf);
    writeln(textf,'``');
  end
  else
  begin
    writeln(textf,'`.  `2You have been killed by `0'+he+' `2(`0'+otm+'`2)!');
    writeln(textf,'`.  `2You lose `$'+commas(yo)+' `2experience!');
    writeln(textf);
    writeln(textf,'``');
  end;
  writeln(textf,'');
  close(textf);
end;


procedure attack;
var logwhere : byte;
    log : array[1..20] of string;
    ch : char;
    e,o,r,ty,tempo : integer;
    l,yo2,yo : longint;
    isdead : boolean;
    hisused,
    myused : array[0..max_play] of boolean;
    powermove,
    stopme,
    stopthem,
    hitme : boolean;
    myrec,
    hisrec : array[0..max_play] of integer;
    hisnum,
    mynum : integer;
    goodpts,
    badpts : longint;
    t:array[1..10] of string;
    dead:boolean;
label asshole, landing, thebeginning;
begin
  logwhere := 0;
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('`%    Team Attacks');
  mwriteln('  `0`L');
  mwriteln('  `2You glance around at your teammates, and see their');
  mwriteln('  lust for battle.  It''s time to make a choice.');
  mwriteln('');
  mwriteln('        `2(`5A`2)ttack Another Team');
  mwriteln('');
  mwriteln('        `2(`5R`2)eturn to Team Menu');
  mwriteln('');
  mwrite('  `2Your command, `0'+pl^.names+'`2? [R] `%');

  ch := getakey;

  if ch in [#1,#2] then exit;

  ch := upcase(ch);

  if ch <> 'A' then ch := 'R';

  mwriteln(ch+'');

  if ch = 'R' then exit;

asshole:

  ty := getTeam;
  if ty = -1 then exit;

  load_team(ty);
  curteam := ty;

  load_pr_index;

  isdead := true;

  for o := 0 to max_play do
  begin
    if (team^.member[o]) and (pr^[o].dead = 0) and (pr^[o].on_now=false) then
      isdead := false;
  end;

  IF (ISDEAD=true) then
  begin
    mwriteln('');
    mwriteln('  `2Everyone on that team is dead or hiding (online now)!');
    moreprompt;
    goto asshole;
  end;

  mwriteln('');
  mwrite('`2Are you sure you want to attack `0'+team^.name+'`2? [`5N`2]:`% ');
  ch := getakey;
  if ch in [#1,#2] then exit;
  ch := upcase(ch);
  if ch <> 'Y' then ch := 'N';
  mwriteln(ch+'');
  if ch = 'N' then goto asshole;

  inc(logwhere);
  log[logwhere] := '  `%'+myteam^.name+' `2has initiated a team fight against `0'+team^.name+'`2!';

  mclrscr;
  mwriteln('                   `%Enemy Matchups!');
  mwriteln('');

  for o := 0 to max_play do
  begin
    hisused[o] := false;
    myused[o] := false;
    myrec[o] := -1;
    hisrec[o] := -1;
  end;

  o := max_play+1;

  load_my_team;

landing:

  stopme := false;
  stopthem := false;
  hitme := false;
  r := 0;
  e := max_play + 1;

  repeat
    inc(r);
    IF (e=dropinfo.recpos) then
      e := 0;

    repeat
      IF (e=max_play+1) then
        e:= dropinfo.recpos
      else
        inc(e);
      IF (hitme) and (e=dropinfo.recpos) then
        inc(e);

      IF (E=dropinfo.recpos) then
        pr^[e].on_now := false;
    until ((myteam^.member[e]=true) and (myused[e]=false) and (pr^[e].dead = 0)
          and (pr^[e].on_now=false)) or (e>=max_play);

    IF (E=dropinfo.recpos) then
      pr^[e].on_now := true;

    iF (myteam^.member[e]) then
      myused[e] := true;

    hitme := true;

    IF (E >=max_play) then
    begin
      stopme:=true;
      dec(r);
      tempo := -1;
      repeat
        inc(tempo);
        if tempo > max_play then break;
      until ((team^.member[tempo]) and (hisused[tempo]=false)
            and (pr^[tempo].dead = 0) and (pr^[tempo].on_now=false))
            or (tempo >=max_play);

      IF ( tempO >=max_play) then
        stopthem := true;
    end;

    IF (STOPME=false) THEN
    begin
      repeat
        inc(o);
        if o > max_play-1 then break;
      until ((team^.member[o]) and (hisused[o]=false) and
             (pr^[o].dead = 0) and (pr^[o].on_now=false))
             or (o >=max_play);

      IF (o >=max_play) then
        stopthem := true
      else
      If (team^.member[o]) then
        hisused[o] := true;

      IF (STOPTHEM) then
        dec(r)
      else
      begin
        mwriteln('  `0'+pr^[e].names+' `2lines up with `0'+pr^[o].names+'`2...');
        myrec[r] := e;
        hisrec[r] := o;
      end;
    end;
  until (stopme) or (stopthem) or (r=max_play-1);

  IF (STOPTHEM) THEN
    STOPME := false;

  e := 1;

  for l := 1 to r do
  begin
    mclrscr;
    if (l=e) then
    begin
      mclrscr;
      mwriteln('  `2You look over, and square off against `0'+pr^[hisrec[1]].names);
      moreprompt;
    end
    else
      mwriteln('  `0'+pr^[myrec[l]].names+' `2squares off against `0'+pr^[hisrec[l]].names);

    hisnum := hisrec[l];
    mynum := myrec[l];

    mwriteln('');
    mwriteln('');

    goodpts := pr^[mynum].hit_max;
    badpts := pr^[hisnum].hit_max;

    repeat
      IF (l=e) then
      begin

thebeginning:

        mwriteln('  `0Your Hitpoints: `2'+commas(goodpts));
        mwriteln(' ');
        mwriteln('  `0'+pr^[hisnum].names+'''s Hitpoints: `2'+commas(badpts));
        mwriteln(' ');
        mwriteln('  `2[`5A`2]ttack');
        mwriteln('  `2[`5R`2]un');
        mwriteln(' ');
        mwrite('  `2Your Choice, `0'+pr^[mynum].names+'`2? `2[`0A`2]`% ');
        ch := getakey;
        if ch in [#1,#2] then exit;
        ch := upcase(ch);
        if ch <> 'R' then ch := 'A';
        mwriteln(ch+'');

        IF ch = 'R' then
        begin
          mwriteln('');
          mwriteln('  `2RUN???  You can''t run from a rumble!');
          moreprompt;
          mwriteln('');
          mwriteln('');
          goto thebeginning;
        end;

        mwriteln('');
      end;

      powermove := false;

      if random(20) = 7 then powermove := true;

      yo := (pr^[mynum].strength-(pr^[mynum].strength DIV 5)+
            (1+Random((((pr^[mynum].strength DIV 5)+pr^[mynum].strength)
            -(pr^[mynum].strength - (pr^[mynum].strength DIV 5))))));

      If Powermove then
      begin
        dec(badpts,2*yo);
        IF (l=e) then
        begin
          mwriteln('  `@**POWER MOVE**');
          mwriteln('');
          mwriteln('  `2You hit `0'+pr^[hisnum].names+'`2 for `$'+commas(yo*2)+'`2 hit points!');
          mwriteln('');
        end;
      end
      else
      begin
        dec(badpts,yo);
        IF (l=e) then
        begin
          mwriteln('  `2You hit `0'+pr^[hisnum].names+'`2 for `$'+commas(yo)+'`2 hit points!');
          mwriteln('');
        end;
      end;

      IF (badpts > 0) then
      begin
        powermove := false;
        if random(20) = 7 then powermove := true;
        yo := (pr^[hisnum].strength-(pr^[hisnum].strength DIV 5)+
              (1+Random((((pr^[hisnum].strength DIV 5)+pr^[hisnum].strength)
              -(pr^[hisnum].strength - (pr^[hisnum].strength DIV 5))))));

        If Powermove then
        begin
          dec(goodpts,2*yo);
          if (l=e) then
          begin;
            mwriteln('  `@**POWER MOVE**');
            mwriteln('');
            mwriteln('  `%'+pr^[hisnum].names+'`0 hits you for `$'+commas(yo*2)+'`0 hit points!');
            mwriteln('');
          end;
        end
        else
        begin
          dec(goodpts,yo);
          if (l=e) then
          begin;
            mwriteln('  `%'+pr^[hisnum].names+'`0 hits you for `$'+commas(yo)+'`0 hit points!');
            mwriteln('');
          end;
        end;
      end;
    until (badpts < 1) or (goodpts < 1);

    IF (BADPTS < 1) then
    begin
      yo := pr^[hisnum].exp DIV 2;
      inc(yo, pr^[hisnum].exp DIV 10);

      IF (l=e) then
      begin
        mwriteln('  `0You have defeated `%'+pr^[hisnum].names+'`0!');
        mwriteln('');
      end
      else
      begin
        mwriteln('  `0'+pr^[mynum].names+'`2 has defeated `%'+pr^[hisnum].names+'`0!');
        mwriteln('');
      end;

      pr^[hisnum].dead := 5;
      myused[mynum] := false;
      yo2 := 0;
      if pr^[hisnum].exp > 0 then
        yo2 := pr^[hisnum].exp div 10;

      dec(pr^[hisnum].exp, yo2);

      if MaxLongInt - pr^[mynum].exp >= yo then
        inc(pr^[mynum].exp,yo)
      else
      begin
        yo := MaxLongInt - pr^[mynum].exp;
        pr^[mynum].exp := MaxLongInt;
      end;

      t[10] := commas(yo);
      t[5] := '`%'+t[10]+' `0experience!';
      writemail(mynum,pr^[hisnum].names,team^.name,yo,true);
      writemail(hisnum,pr^[mynum].names,myteam^.name,yo2,false);

      IF (l=e ) then
        mwriteln('  `0You receive '+t[5])
      else
        mwriteln('  `0'+pr^[mynum].names+'`2 received '+t[5]);
      mwriteln('');
      inc(logwhere);
      if logwhere <= 20 then
        log[logwhere] := '  `5'+pr^[mynum].names+' `2(`0'+myteam^.name+'`2) has killed `5'+pr^[hisnum].names+'`2!';

      load_enemy(hisnum);
      enemy^.exp := pr^[hisnum].exp;
      save_enemy(hisnum);
      if l<>e then
      begin
        load_enemy(mynum);
        enemy^.exp := pr^[mynum].exp;
        save_enemy(mynum);
      end;
      moreprompt;
    end {badpts < 1}
    else
    begin
      yo := pr^[mynum].exp DIV 10;
      dead := false;

      IF (l=e) then
      begin
        mwriteln('  `0You have been defeated by `%'+pr^[hisnum].names+'`0!');
        dead := true;
      end
      else
        mwriteln('  `0'+pr^[mynum].names+'`2 has been defeated by `%'+pr^[hisnum].names+'`0!');

      mwriteln('');

      yo2 := pr^[mynum].exp div 2;
      inc(yo2,pr^[mynum].exp div 10);
      if MaxLongInt - pr^[hisnum].exp >= yo2 then
        inc(pr^[hisnum].exp,yo2)
      else
      begin
        yo2 := MaxLongInt - pr^[hisnum].exp;
        pr^[hisnum].exp := MaxLongInt;
      end;

      dec(pr^[mynum].exp,yo);
      t[10] := commas(yo);
      t[5] := '`%'+t[10]+' `0experience!';

      IF (l=e) then
        mwriteln('  `0You lost '+t[5])
      else
        mwriteln('  `0'+pr^[mynum].names+'`2 lost '+t[5]);

      writemail(mynum,pr^[hisnum].names,team^.name,yo,false);
      writemail(hisnum,pr^[mynum].names,myteam^.name,yo2,true);
      pr^[mynum].dead := 5;
      mwriteln('');
      inc(logwhere);
      if logwhere <= 20 then
        log[logwhere] := '  `5'+pr^[hisnum].names+' `2(`0'+team^.name+'`2) has killed `5'+pr^[mynum].names+'`2!';

      load_enemy(hisnum);
      enemy^.exp := pr^[hisnum].exp;
      save_enemy(hisnum);

      if l=e then
      begin
        pl^.exp := pr^[mynum].exp;
        pl^.dead := pr^[mynum].dead;
        pl^.on_now := false;
        save_player;
        myteam^.sleep[mynum] := false;
        save_my_Team;
      end
      else
      begin
        load_enemy(mynum);
        enemy^.exp := pr^[mynum].exp;
        enemy^.dead := pr^[mynum].dead;
        save_enemy(mynum);
        myteam^.sleep[mynum] := false;
        save_my_team;
      end;

      IF (DEAD) then
      begin
        save_igmplay(false);
        mwriteln('');
        mwriteln('  `2Abort!  Iniatator is dead!');
        if logwhere > 0 then
        begin
          assign(textf,igmdat^.lordpath+'lognow.txt');
          {$I-}append(textf);{$I+}
          if ioresult <> 0 then rewrite(textf);
          for o := 1 to logwhere do
            writeln(textf,log[o]);
          writeln(textf,'                                `2-`0=`2-`0=`2-`0=`2-');
          close(textf);
        end;
        moreprompt;
        mwriteln('');
        mwriteln('  `2  RETURNING TO THE MUNDANE WORLD...');
        halt;
      end;

      hisused[hisnum] := false;
      moreprompt;
    end; {Goodpts < 1}
  end; {for loop}

  IF (STOPME=true) and (stopthem=false) then
    goto landing;

  if logwhere > 0 then
  begin
    assign(textf,igmdat^.lordpath+'lognow.txt');
    {$I-}append(textf);{$I+}
    if ioresult <> 0 then rewrite(textf);

    for o := 1 to logwhere do
      writeln(textf,log[o]);

    writeln(textf,'`.                                `2-`0=`2-`0=`2-`0=`2-');
    close(textf);
  end;
end;


procedure invade_steal;
var tempstr : string;
    yo : longint;
    ch : char;
begin

  IF (team^.TREASURY < 100) then
  begin
    mwriteln('  `2It appears that they have no money to steal!');
    moreprompt;
    exit;
  end;

  yo := team^.treasury div 5 + random(team^.treasury div 5);
  tempstr := commas(yo);

  mwriteln('  `2It appears that you can safely steal up to `%'+tempstr+'`2 gold!');
  mwrite('  `2Try it? [`5Y`2]:`% ');
  ch := getakey;
  if ch in [#1,#2] then exit;
  ch := upcase(ch);
  if ch <> 'N' then ch := 'Y';
  mwriteln(ch+'');

  if ch = 'Y' then
  begin
    mwriteln('');
    IF (RANDOM(pl^.level) > 4) then
    begin
      mwriteln('  `2You did it!');
      mwriteln('');

      dec(team^.treasury,yo);

      if MaxLongInt - pl^.gold >= yo then
        inc(pl^.gold,yo)
      else
        pl^.gold := MaxLongInt;

      save_team(curteam);
      save_player;

      mwriteln('  `2You now have `%'+commas(pl^.gold)+' `2gold.');
    end
    else
    begin
      mwriteln('  `2You hear a grunt over in the corner as you approach the safe.');
      mwriteln('');
      mwriteln('  `2You decide not to risk it.');
    end;
    moreprompt;
  end;
end;

procedure invade_kill_enemy;
var done : boolean;
    e,yo : longint;
    lostxp,
    lostgems : longint;
    ch : char;
begin
  done := false;

  e := -1;

  for yo := 0 to max_play-1 do
  begin
    IF (team^.sleep[yo]) and (team^.member[yo]) then
    begin
      done := true;
      e:=yo;
    end;
  end;

  IF done=false then
  begin
    mwriteln('');
    mwriteln('  `2No one is currently staying here!');
    moreprompt;
    exit;
  end;

  load_enemy(e);

  mwriteln('');
  mwriteln('  `2It appears that `0'+enemy^.names+' `2is sleeping here.');
  mwrite('  `2Kill them? [`5Y`2]:`% ');

  ch := getakey;
  if ch in [#1,#2] then exit;
  ch := upcase(ch);
  if ch <> 'N' then ch := 'Y';
  mwriteln(ch+'');

  IF ch = 'Y' then
  begin
    mwriteln('');
    IF (RANDOM(pl^.level-enemy^.level) < 2) and (random(10) > 2) then
    begin
      mwriteln('  `2You make the blow quickly, and sharply.');
      mwriteln('');
      if MaxLongInt - pl^.exp >= enemy^.exp div 5 then
        lostxp := enemy^.exp div 5
      else
        lostxp := MaxLongInt - pl^.exp;

      inc(pl^.exp,lostxp);
      dec(enemy^.exp,lostxp);

      mwriteln('  `2You gain `%'+commas(lostxp)+' `2experience!');
      mwriteln('');

      if MaxInt - pl^.gem >= enemy^.gem then
        lostgems := enemy^.gem
      else
        lostgems := MaxInt - pl^.gem;

      inc(pl^.gem,lostgems);

      mwriteln('  `2You steal `$'+commas(lostgems)+' `2gems!');

      dec(enemy^.gem,lostgems);
      enemy^.dead := 5;
      team^.sleep[e] := false;
      dec(enemy^.exp,lostxp);

      save_team(curteam);
      save_enemy(e);
      save_player;

      assign(textf,igmdat^.lordpath+'mail'+IntToStr(e)+'.dat');
      {$I-}append(Textf);{$I+}
      if ioresult <> 0 then rewrite(textf);
      writeln(textf,'  `%YOU HAVE BEEN MURDERED!');
      writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-`2');
      writeln(textf,'  `0'+pl^.names+'`2 has invaded the `%'+team^.name+' `2house!');
      writeln(textf,'  `0'+pl^.names+'`2 has murdered you!');
      writeln(textf,'  `2You lose `$'+commas(lostxp)+' `2experience!');
      writeln(textf,'  `2You lost `$'+commas(lostgems)+'  `2gems!');
      writeln(textf,'');
      writeln(textf,'``');
      close(textf);

      assign(textf,igmdat^.lordpath+'out.'+inttostr(e));
      {$I-}erase(textf);{$I+}
      if ioresult <> 0 then ;

      moreprompt;
    end
    else
    begin
      mwriteln('  `0'+enemy^.names+'`2''s eyes flash open, and you realize that you''re in trouble!');
      mwriteln('  `0'+enemy^.names+'`2 reaches under a pillow, and pulls out a dagger...');
      mwriteln('');
      case random(2) of
      0: begin
           mwriteln('  `0'+enemy^.names+'`2 hurls the dagger into your chest!');
           mwriteln('');
           mwriteln('  `2The lights begin to dim as you feel a sticky red ooze');
           mwriteln('  burn out of your ribs and onto your skin.');
           mwriteln('');
           mwriteln('  `2Darkness overwhelms your eyes, and you sink into infinity...');
           pl^.on_now := false;
           pl^.dead := 5;
           save_player;
           save_igmplay(false);
           myteam^.sleep[dropinfo.recpos] := false;
           save_my_team;

           assign(textf,igmdat^.lordpath+'mail'+IntToStr(e)+'.dat');
           {$I-}append(textf);{$I+}
           if ioresult <> 0 then rewrite(textf);
           writeln(textf,'  `%YOU HAVE BEEN ATTACKED!');
           writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-`2');
           writeln(textf,'  `0'+pl^.names+'`2 has invaded the `%'+team^.name+' `2house!');
           writeln(textf,'  `0'+pl^.names+'`2 tried to murdered you, but you were faster!');
           writeln(textf,'');
           writeln(textf,'``');
           close(textf);
           halt;
         end;
      1: begin
           pl^.hit := 1;
           save_player;
           mwriteln('  `0'+enemy^.names+'`2 hurls the dagger into your side!');
           mwriteln('');
           mwriteln('  `2The lights begin to dim as you feel a sticky red ooze');
           mwriteln('  burn out of your gut and onto your skin.');
           mwriteln('');
           mwriteln('  `2You summon your remaining power, and dash out of the house!');
           assign(textf,igmdat^.lordpath+'mail'+IntToStr(e)+'.dat');
           {$I-}append(textf);{$I+}
           if ioresult <> 0 then rewrite(textf);
           writeln(textf,'  `%YOU HAVE BEEN ATTACKED!');
           writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-`2');
           writeln(textf,'  `0'+pl^.names+'`2 has invaded the `%'+team^.name+' `2house!');
           writeln(textf,'  `0'+pl^.names+'`2 tried to murdered you, but failed!');
           writeln(textf,'');
           writeln(textf,'``');
           close(textf);
           exit;
         end;
      end;
    end;
  end
  else
  begin
    mwriteln('');
    mwriteln('  `2You decide to let `0'+enemy^.names+' `2live.');
    moreprompt;
  end;
end;

procedure invade_fight_doorgaurd;
var goodpts, badpts : longint;
    powermove : boolean;
    te : string;
    ch : char;
    yo : longint;
begin
  goodpts := pl^.hit;
  badpts := team^.dgdef;

  repeat
    powermove := false;
    te := commas(goodpts);
    mwriteln('  `0Your Hitpoints: `2'+te);
    mwriteln(' ');
    te := commas(badpts);
    mwriteln('  `0Doorguard''s Hitpoints: `2'+te);
    mwriteln(' ');
    mwriteln('  `2[`5A`2]ttack');
    mwriteln('  `2[`5R`2]un');
    mwriteln(' ');
    mwrite('  `2Your Choice, `0'+igmplay^.name+'`2? `2[`0A`2]`% ');

    ch := getakey;
    if ch in [#1,#2] then exit;
    ch := upcase(ch);

    if ch <> 'R' then ch := 'A';

    mwriteln(ch+'');

    if ch = 'R' then
    begin
      mwriteln('');
      mwriteln('  `2You try to run away, but to no avail!');
      moreprompt;
      mwriteln('');
      mwriteln('');
      continue;
    end;

    mwriteln('');
    if random(20) = 7 then powermove := true;

    yo := (pl^.strength - (pl^.strength DIV 5) +
          (1 + Random((((pl^.strength DIV 5)+pl^.strength)-
          (pl^.strength-(pl^.strength DIV 5))))));

    If Powermove then
    begin
      dec(badpts,2*yo);
      mwriteln('  `@**POWER MOVE**`2');
      mwriteln('');
      te := commas(yo * 2);
      mwriteln('  `2You hit `0'+'Doorguard'+'`2 for `$'+te+'`2 hit points!');
      mwriteln('');
    end
    else
    begin
      dec(badpts,yo);
      te := commas(yo);
      mwriteln('  `2You hit `0'+'Doorguard'+'`2 for `$'+te+'`2 hit points!');
      mwriteln('');
    end;

    if (badpts > 1) then
    begin
      powermove := false;

      if random(20) = 7 then powermove := true;

      yo := (team^.dgstr-(team^.dgstr DIV 5)+
            (1+Random((((team^.dgstr DIV 5)+team^.dgstr)-
            (team^.dgstr - (team^.dgstr DIV 5))))));

      If Powermove then
      begin
        dec(goodpts,2*yo);
        mwriteln('  `@**POWER MOVE**');
        mwriteln('');
        te := commas(yo*2);
        mwriteln('  `%'+'Doorguard'+'`0 hits you for `$'+te+'`0 hit points!');
        mwriteln('');
      end
      else
      begin
        dec(goodpts,yo);
        te := commas(yo);
        mwriteln('  `%'+'Doorguard'+'`0 hits you for `$'+te+'`0 hit points!');
        mwriteln('');
      end;
    end;
  until (badpts < 1) or (goodpts < 1);

  IF (BADPTS < 1) then
  begin
    dec(team^.dgdef,(pl^.def*10));
    dec(team^.dgstr,(pl^.strength*10));

    IF (team^.dgdef < 1) then team^.dgdef := 0;
    if (team^.dgstr < 1) then team^.dgstr := 0;

    save_team(curteam);

    pl^.hit := goodpts;
    save_player;

    assign(textf,igmdat^.lordpath+'mail'+IntToStr(team^.leader)+'.dat');
    {$I-}append(textf);{$I+}
    if ioresult<> 0 then rewrite(textf);

    writeln(textf);
    writeln(textf,'  `%YOUR DOOR GAURD IS DEAD!');
    writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-`2');
    writeln(textf,'  `0'+pl^.names+'`2 has invaded the `%'+team^.name+' house');
    writeln(textf,'  and killed your dragon door gaurd!');
    writeln(textf,'');
    writeln(textf,'``');
    close(textf);


    mwriteln('  `0You have defeated `%'+'Doorguard'+'`0!');
    moreprompt;
  end
  else
  begin
    yo := (pl^.exp DIV 10);
    dec(pl^.exp,yo);
    pl^.dead := 5;
    pl^.on_now := false;
    save_player;
    igmplay^.onnow := false;
    save_igmplay(false);
    myteam^.sleep[dropinfo.recpos] := false;
    save_my_team;
    mwriteln('  `0You have been defeated by `%'+'Doorguard'+'`0!');
    mwriteln('  `0You lost `%'+commas(yo)+' `0experience!');
    mwriteln('');
    mwriteln('`2  RETURNING TO THE MUNDANE WORLD...');

    assign(textf,igmdat^.lordpath+'lognow.txt');
    {$I-}append(textf);{$I+}
    if ioresult <> 0 then rewrite(textf);
    writeln(textf,'  `5'+pl^.names+'`2 attempted to break into the `0'+team^.name+'`2''s house!');
    writeln(textf,'  `2However, they were killed by the doorguard.');
    writeln(textf,'                                `2-`0=`2-`0=`2-`0=`2-');
    writeln(textf);
    close(textf);
    halt;
  end;
end;

procedure invade;
var numteams : integer;
    q : byte;
    triedsteal : boolean;
    instr : string;
    r : integer;
    ch : char;
begin

  if (igmplay^.invaded < 1) or (igmplay^.invaded > 200) then
  begin
    mwriteln('');
    mwriteln('`2  To be on the safe side, you decide you will wait until');
    mwriteln('  tomorrow before attempting to invade another house.');
    moreprompt;
    exit;
  end;

  assign(teamf,igmpath+'teamfile.dat');
  filemode := $20;
  filecounter := 0;
  repeat
    inc(FileCounter);
    {$I-}reset(teamf);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  numteams := filesize(teamf);
  close(teamf);

  repeat
    mwriteln('');
    mwrite('`2Which team (Q to Quit, ? to List)? ');
    instr := mInput('','qQ?0123456789',#0,numteams,numteams,15);
    mtextcolor(2);
    mtextbackground(0);

    mwriteln('');

    if (instr = '') or (instr = 'Q') then exit;

    if instr = '?' then
    begin
      r := getTeam;
      if r = -1 then exit;
    end
    else
      r := StrToIntDef(instr,0);

    if r = 0 then exit;

    if (r-1 = igmplay^.teamnum) then
    begin
      mwriteln('');
      mwriteln('  `2You can''t invade your own home!');
      moreprompt;
      r := 0;
    end;

  until (r > 0) and (r <= numteams);

  load_team(r-1);

  curteam := r - 1;

  dec(igmplay^.invaded);

  IF (team^.DGSTR > 0) and (team^.DGDEF > 0) and (random(8) <> 1) then
  begin
    mwriteln('  `2Before you can steal into the house, however, you');
    mwriteln('  chance upon an enormous dragon - the doorguard!');
    mwriteln('');
    invade_fight_doorgaurd;
  end;

  q := 1;

  triedsteal := false;

  repeat
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('  `%House Invasion...');
    mwriteln('`0`L');
    IF (Q >=10) then
    begin
      mwriteln('`2  You''re feeling kind of antsy now - you decide to leave');
      mwriteln('`2  before someone wakes up!');
      moreprompt;
      ch := 'R';
    end
    else
    begin
      mwriteln('`2  You''re in!  Now, what to do...');
      mwriteln('');
      mwriteln('`2      (`5K`2)ill an Enemy');
      mwriteln('`2      (`5S`2)teal from the Treasury');
      mwriteln('');
      mwriteln('`2      (`5R`2)un Away!');
      mwriteln('');
      mwrite('  `2Your command, `0'+pl^.names+'`2?`% ');
      ch := getakey;
      if ch in [#1,#2] then exit;
      ch := upcase(ch);
      if ch = #13 then ch := 'R';
      mwriteln(ch+'');
    end;

    CASE ch OF
    'Q',
    'R': begin
           save_team(curteam);

           assign(textf,igmdat^.lordpath+'lognow.txt');
           {$I-}append(textf);{$I+}
           if ioresult <> 0 then rewrite(textf);

           writeln(textf,'  `5'+pl^.names+'`2 broke into the `0'+team^.name+'`2''s house!');
           writeln(textf,'                                `2-`0=`2-`0=`2-`0=`2-');
           writeln(textf);
           close(textf);
         end;
    'K': begin
           invade_kill_enemy;
           inc(q);
         end;
    'S':begin
          mwriteln('');
          IF TRIEDSTEAL THEN
          BEGIN
            mwriteln('  `2You probably shouldn''t try to steal again!  You might get caught!');
            moreprompt;
            continue;
          end;

          triedsteal := true;
          invade_steal;
          inc(q);
         end;
    end; {case}

    if (oldteam=true) and (igmplay^.onteam=false) then
      exit;

  until ch in ['Q','R'];

end;


procedure actionmenu;
var ch:char;
begin
  load_my_team;

  oldteam := igmplay^.onteam;

  repeat
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('                             `%Action Options');
    mwriteln('`0`L');
    mwriteln('');
    mwriteln('         `2(`5T`2)rain Door Guard                     `2(`5G`2)et A Room');
    mwriteln('         `2(`5P`2)arty                                `2(`5I`2)nvade a House');
    mwriteln('         `2(`5A`2)ttack Team                          `2(`%Q`2)uit');
    mwriteln('');
    mwrite('  `2Your command, `0'+pl^.names+'`2?`% ');
    ch := getakey;
    if ch in [#1,#2] then exit;
    ch := upcase(ch);
    {tupdate;}
    mwriteln(ch+'');

    if (igmplay^.onteam=false) and (ch <> 'Q') then
    begin
      mwriteln('');
      mwriteln('`%You''re not on a team!');
      mwriteln('');
      moreprompt;
    end
    else
    CASE ch of
    'I':invade;
    'A':attack;
    'T':train;
    'G':getaroom;
    'P':party;
    end;

    if (oldteam=true) and (igmplay^.onteam=false) then
      exit;
  until ch = 'Q';
end;

end.
