{$I whichos.inc}

unit teambank;

interface

uses crt, manndoor, teamglob, toolbox;

procedure banking;

implementation

var tempstr,
    tempst:string;
    num:longint;
    n:integer;
{$ifdef VIRTUALPASCAL}
    errcode:longint;
{$else}
    errcode:integer;
{$endif}


procedure deposit;
begin
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('`%  Ye Olde Bank');
  mwriteln('`0`L');
  mwriteln('`2  Gold In Hand: `0'+commas(pl^.gold)+'   `2Gold In Bank: `0'+commas(pl^.bank));
  mwriteln('');
  mwriteln('`2  `0"`2How much gold would you like to deposit?`0"`2 (`01 for ALL of it`2)');
  mwrite('`2  AMOUNT:`% ');

  tempstr := mInput('','0123456789',#0,length(IntToStr(pl^.gold)),
    length(IntToStr(pl^.gold)),15);

  val(tempstr,num,errcode);

  if (num=0) or (errcode<>0) then exit;

  mwriteln('');

  IF (NUM = 1) then
  begin
    if MaxLongInt - pl^.bank >= pl^.gold then
    begin
      inc(pl^.bank,pl^.gold);
      pl^.gold := 0;
      mwriteln('  `0Done!');
    end
    else
    begin
      mwriteln('  `0"`2You don''t have enough room in your account for that!`0"`2');
    end;
  end
  else
  begin
    if MaxLongInt - pl^.bank >= num then
    begin
      inc(pl^.bank,num);
      dec(pl^.gold,num);
      mwriteln('  `0Done!');
    end
    else
    begin
      mwriteln('  `0"`2You don''t have enough room in your account for that!`0"');
    end;
  end;

  save_player;

  mwriteln('');
  moreprompt;
end;

procedure withdrawl;
begin
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('`%  Ye Olde Bank');
  mwriteln('  `0`L');
  mwriteln('`2  Gold In Hand: `0'+commas(pl^.gold)+
    '   `2Gold In Bank: `0'+commas(pl^.bank));
  mwriteln('');
  mwriteln('`2  `0"`2How much gold would you like to withdraw?`0"`2 (`01 for ALL of it`2)');
  mwrite('`2  AMOUNT:`% ');

  tempstr := mInput('','0123456789',#0,length(IntToStr(pl^.bank)),
    length(IntToStr(pl^.bank)),15);

  mtextcolor(2);
  mtextbackground(0);

  val(tempstr,num,errcode);

  IF (NUM > pl^.bank) then num := 0;

  if (num=0) or (errcode<>0) then exit;

  mwriteln('');

  IF (NUM = 1) then
  begin
    if MaxLongInt - pl^.gold >= pl^.bank then
    begin
      inc(pl^.gold,pl^.bank);
      pl^.bank := 0;
      mwriteln('  `0Done!');
    end
    else
    begin
      mwriteln('  `0"`2You can''t carry that much gold!`0"`2');
    end;
  end
  else
  begin
    if MaxLongInt - pl^.gold >= num then
    begin
      inc(pl^.gold,num);
      dec(pl^.bank,num);
      mwriteln('  `0Done!');
    end
    else
    begin
      mwriteln('  `0"`2You can''t carry that much gold!`0"`2');
    end;
  end;

  save_player;

  mwriteln('');
  moreprompt;

end;

procedure banking;
var ch:char;
begin
  repeat
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('   `%Legend of the Red Dragon - `2Bank');
    mwriteln('`0`L');
    mwriteln(' `2 A polite clerk approaches.  `5"Can I help you sir?"');
    mwriteln('');
    mwriteln('  `2(`5D`2)eposit Gold');
    mwriteln('  (`5W`2)ithdraw Gold');
    mwriteln('  (`5R`2)eturn to Main');
    mwriteln('');
    mwriteln('');
    mwriteln('  `2Gold In Hand: `0'+commas(pl^.gold)+
      '  `2Gold In Bank: `0'+commas(pl^.bank));
    mwriteln('');
    mwrite('  `2Your command, `0'+pl^.names+'`2?`% ');
    ch := getakey;
    if ch in [#1,#2] then continue;
    ch := upcase(ch);
    if ch = #13 then ch := 'R';
    mwriteln(ch+'');
    CASE CH of
    'D': deposit;
    'W': withdrawl;
    end;
  until ch in ['Q','R'];
end;


end.
