{$I whichos.inc}

unit teamcfg;

interface

uses manndoor,mstrings, toolbox, teamglob, igmtools;

const igmname : string = 'TeamLord';

procedure config;

implementation

procedure reset_config;
var ch:char;
begin
  mwriteln('  `2There was an error with teamlord.cfg');
  mwrite('  `0Recreate it? `2[`0Y`2] `%');
  ch := mreadkey;
  ch := upcase(ch);
  if ch <> 'N' then ch := 'Y';
  mwriteln(ch+'');

  if ch = 'N' then
  begin
    mwriteln('');
    mwriteln('  `%File not recreated! Exiting!');
    halt;
  end;

  assign(igmfile,igmpath+'teamlord.cfg');
  erase(igmfile);

  igmdat^.lordpath := '';
  igmdat^.maintdate := 0;
  igmdat^.installed := false;
end;

procedure config;
var ch:char;
begin
  if FileExists(igmpath+'teamlord.cfg') then
  begin
    assign(igmfile,igmpath+'teamlord.cfg');
    filecounter := 0;
    filemode := $20;
    repeat
      inc(FileCounter);
      {$I-}reset(igmfile);{$I+}
      IOError := IOResult;
      if ioerror = 5 then mwait(FileWait)
      else
      if ioerror = 2 then break;
    until (IOError = 0) or (FileCounter > FileTries);

    if (IOError<>0) and (IOError<>2) then
    begin
      reset_config;
    end;

    read(igmfile,igmdat^);
    close(igmfile);

  end;

  repeat
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('  `%TeamLord Config');
    mwriteln('');

    if igmdat^.installed = false then
    begin
      mwriteln('  `2(`%S`2) `0Set Lord Path');
      mwriteln('  `2(`%I`2) `0Install TeamLord');
      mwriteln('  `2(`%Q`2) `0Quit Config');
    end
    else
    begin
      mwriteln('  `2(`%S`2) `0Set Lord Path');
      mwriteln('  `2(`%U`2) `0Uninstall TeamLord');
      mwriteln('  `2(`%Q`2) `0Quit Config');
    end;

    mwriteln('');
    mwrite('  `2Your choice: `%');
    ch := mReadkey;
    ch := upcase(ch);

    if ch = #13 then ch := '?';

    mwriteln(ch+'');

    case ch of
    'S': begin
           mwriteln('');
           mwriteln('Enter the directory where lord.exe lives:');
           igmdat^.lordpath := minput(igmdat^.lordpath,CHARS_ALL,#0,
             70,70,15);
           if (length(igmdat^.lordpath) > 0) and
             (igmdat^.lordpath[length(igmdat^.lordpath)] <> Dirsep) then
               igmdat^.lordpath := igmdat^.lordpath + dirsep;
{$ifdef FORNIX}
           if FileExists(igmdat^.lordpath+'lord') then
{$else}
           if FileExists(igmdat^.lordpath+'lord.exe') then
{$endif}
             mwriteln('  `%VERIFIED!')
           else
             mwriteln('  `4INCORRECT!');
           mwriteln('');
           moreprompt;
         end;
    'I': begin
           if igmdat^.installed = false then
           begin
             mwriteln('');
             case igmInstall(igmdat^.lordpath, paramstr(0),igmname) of
             0: begin
                  mwriteln('  `%SUCCESS!');
                  igmdat^.installed := true;
                end;
             1: begin
                  mwriteln('  `4ERROR!');
                  mwriteln('  `23rdpaty.dat was not found in your Lord path!');
                end;
             2: begin
                  mwriteln('  `4ERROR!');
                  mwriteln('  `2This igm was found in 3rdparty.dat!');
                end;
             end;
             mwriteln('');
             moreprompt;
           end;
         end;
    'U': begin
           if igmdat^.installed = true then
           begin
             mwriteln('');
             case igmUninstall(igmdat^.lordpath,paramstr(1)) of
             0: begin
                  mwriteln('  `%SUCCESS!');
                  igmdat^.installed := false;
                end;
             1: begin
                  mwriteln('  `4ERROR!');
                  mwriteln('  `23rdparty.dat was not found in your Lord path!');
                end;
             2: begin
                  mwriteln('  `4ERROR!');
                  mwriteln('  `2This igm was not found in 3rdparty.dat!');
                end;
             end;
             mwriteln('');
             moreprompt;
           end;
         end;
    end;
  until ch = 'Q';


  assign(igmfile,igmpath+'teamlord.cfg');
  filecounter := 0;
  filemode := $11;
  repeat
    inc(FileCounter);
    {$I-}rewrite(igmfile);{$I+}
    IOError := IOResult;
    if IOError = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);
  if IOERror <> 0 then
  begin
    mwriteln('Error opening teamlord.cfg!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  write(igmfile,igmdat^);
  close(igmfile);

  mwriteln('');
  mwriteln('  `7Changes saved.');
  mwriteln('');

end;

end.
