{$I whichos.inc}

unit teamglob;

interface

uses manndoor, toolbox;

{$ifdef FORNIX}
const dirsep = '/';
{$else}
const dirsep = '\';
{$endif}

const filetries = 10;
      filewait = 1000;
      max_play = 150;

{$I player.inc}

type TIGMRec = record
       lordpath  : string;
       maintdate : longint;
       installed : boolean;
     end;

     TIGMPlay = record
       realname  : string;
       name      : string;
       onteam    : boolean;
       teamnum   : integer;
       onnow     : boolean;
       invaded   : byte;
       partied   : byte;
       left      : longint;
       recpos    : integer;
       deleted   : boolean;
     end;

     TPlayIndex_Rec = record
       real_names : string[50];
       names    : string[20];
       hit_max  : integer;
       dead     : shortint;
       strength : integer;
       on_now   : boolean;
       exp      : longint;
       level    : longint;
       class    : shortint;
     end;

     TPlayIndex = array[0..max_play] of TPlayIndex_Rec;

     TTeamRec = record
       name  : string[30];
       pass  : string[20];
       treasury : longint;
       leader : integer;
       deleted : boolean;
       dgstr : longint; {Doorgaurd's strength}
       dgdef : longint; {doorgaurd's defense}
       sleep : array[0..max_play] of boolean;
       member : array[0..max_play] of boolean;
     end;


var igmpath     : string;

    igmdat      : ^TIGMRec;
    igmfile     : file of TIGMRec;

    igmplay     : ^TIGMPlay;
    tempigmplay : ^TIGMPlay;
    igmplayfile : file of TIGMPlay;
    playpos     : integer;

    pr          : ^TPlayIndex;

    pl          : ^player_info;
    plfile      : file of player_info;
    enemy       : ^player_info;

    myteam      : ^TTeamRec;
    team        : ^TTeamRec;
    teamf       : file of TTeamRec;
    curteam     : integer;

    IOError     : integer;
    FileCounter : integer;
    textf       : text;

procedure moreprompt;
procedure cfgin;
procedure cfgout;
procedure load_pr_index;
procedure load_team(wo:integer);
procedure save_team(wo:integer);
procedure load_enemy(wo:integer);
procedure save_enemy(wo:integer);
procedure load_player;
procedure save_player;
procedure load_my_team;
procedure save_my_team;
procedure load_igmplay;
procedure save_igmplay(onnow:boolean);

function GetAKey:char;

implementation

procedure cfgin;
begin
  assign(igmfile,igmpath + 'teamlord.cfg');

  filemode := $20;
  filecounter := 0;
  repeat
    inc(FileCounter);
    {$i-}reset(igmfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamlord.cfg!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(ioerror);
  end;

  reset(igmfile);
  read(igmfile,igmdat^);
  close(igmfile);
end;

procedure cfgout;
begin
  assign(igmfile,igmpath + 'teamlord.cfg');

  filemode := $11;
  filecounter := 0;
  repeat
    inc(FileCounter);
    {$i-}reset(igmfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamlord.cfg!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(ioerror);
  end;

  reset(igmfile);
  write(igmfile,igmdat^);
  close(igmfile);
end;

procedure moreprompt;
var ch:char;
begin
  mwrite('`0<`2MORE`0>');
  ch := mReadkey;
  mwrite(#8#8#8#8#8#8+'      '+#8#8#8#8#8#8);
end;

procedure load_pr_index;
var i : integer;
    en : ^player_info;
begin
  assign(plfile,igmdat^.lordpath+'player.dat');
  filecounter := 0;
  filemode := $20;
  repeat
    inc(FileCounter);
    {$I-}reset(plfile);{$I+}
    IOError := ioresult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening player.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  new(en);

  i := 0;

  while (i<max_play) and (not eof(plfile)) do
  begin
    read(plfile,en^);
    pr^[i].real_names := en^.real_names;
    pr^[i].names := en^.names;
    pr^[i].hit_max := en^.hit_max;
    pr^[i].dead := en^.dead;
    pr^[i].strength := en^.strength;
    pr^[i].on_now := en^.on_now;
    pr^[i].exp := en^.exp;
    pr^[i].level := en^.level;
    pr^[i].class := en^.class;
  end;

  close(plfile);
  dispose(en);

end;

procedure load_team(wo:integer);
begin
  assign(teamf,igmpath+'teamfile.dat');
  filecounter := 0;
  filemode := $20;
  repeat
    inc(FileCounter);
    {$I-}reset(teamf);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(teamf,wo);
  read(teamf,team^);
  close(teamf);

end;

procedure save_team(wo:integer);
begin
  filecounter := 0;
  assign(teamf,igmpath+'teamfile.dat');
  filemode := $11;
  repeat
    inc(filecounter);
    {$I-}reset(teamf);{$I+}
    IOError := ioresult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(ioerror);
  end;

  seek(teamf,wo);
  write(teamf,team^);
  close(Teamf);

end;

procedure load_enemy(wo:integer);
begin
  assign(plfile,igmdat^.lordpath+'player.dat');
  filecounter := 0;
  filemode := $20;
  repeat
    inc(filecounter);
    {$I-}reset(plfile);{$I+}
    IOError := ioresult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (Filecounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening player.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(plfile,wo);
  read(plfile,enemy^);
  close(plfile);

end;

procedure save_enemy(wo:integer);
begin
  assign(plfile,igmdat^.lordpath+'player.dat');
  filecounter := 0;
  filemode := $11;
  repeat
    inc(filecounter);
    {$I-}reset(plfile);{$I+}
    IOError := IOResult;
    if IOError = 5 then mwait(FileWait);
  until (IOError = 0) or (Filecounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening player.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(plfile,wo);
  write(plfile,enemy^);
  close(plfile);

end;

procedure load_player;
begin
  assign(plfile,igmdat^.lordpath+'player.dat');
  filecounter := 0;
  filemode := $20;
  repeat
    inc(FileCounter);
    {$I-}reset(plfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(filewait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening player.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(plfile,dropinfo.recpos);
  read(plfile,pl^);
  close(plfile);

end;

procedure save_player;
begin
  assign(plfile,igmdat^.lordpath+'player.dat');
  filecounter := 0;
  filemode := $11;
  repeat
    inc(filecounter);
    {$I-}reset(plfile);{$I+}
    IOError := IOResult;
    if IOError = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening player.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(plfile,dropinfo.recpos);
  write(plfile,pl^);
  close(plfile);

end;

procedure load_my_team;
begin
  fillchar(myteam^,sizeof(TTeamRec),#0);
  if igmplay^.teamnum < 0 then exit;

  assign(teamf,igmpath+'teamfile.dat');
  filecounter := 0;
  filemode := $20;
  repeat
    inc(FileCounter);
    {$I-}reset(teamf);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(filewait);
  until (IOError = 0) or (filecounter > filetries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(teamf,igmplay^.teamnum);
  read(teamf,myteam^);
  close(Teamf);

end;

procedure save_my_team;
begin
  if igmplay^.teamnum < 0 then exit;

  assign(teamf,igmpath+'teamfile.dat');
  filecounter := 0;
  filemode := $11;
  repeat
    inc(FileCounter);
    {$I-}reset(teamf);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(teamf,igmplay^.teamnum);
  write(teamf,myteam^);
  close(Teamf);

end;

procedure load_igmplay;
var found : boolean;
    i : integer;
begin
  playpos := -1;
  assign(igmplayfile,igmpath+'teamplay.dat');
  filecounter := 0;
  filemode := $12;
  repeat
    inc(FileCounter);
    {$I-}reset(igmplayfile);{$I+}
    IOError := IOREsult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamplay.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  new(tempigmplay);
  found := false;
  i := -1;

  while (found=false) and (not eof(igmplayfile)) do
  begin
    inc(i);
    read(igmplayfile,tempigmplay^);
    if upstring(tempigmplay^.realname) = upstring(dropinfo.realname) then
    begin
      igmplay^ := tempigmplay^;
      found := true;
      playpos := i;
    end;
  end;

  if found=false then
  begin
    igmplay^.realname := dropinfo.realname;
    igmplay^.name := pl^.names;
    igmplay^.onteam := false;
    igmplay^.teamnum := -1;
    igmplay^.recpos := dropinfo.recpos;
    igmplay^.onnow := true;
    igmplay^.deleted := false;
    playpos := filesize(igmplayfile);
    seek(igmplayfile,playpos);
    write(igmplayfile,igmplay^);
  end;

  dispose(tempigmplay);
  close(igmplayfile);

end;

procedure save_igmplay(onnow:boolean);
begin
  if playpos < 0 then exit;

  assign(igmplayfile,igmpath+'teamplay.dat');
  filecounter := 0;
  filemode := $11;
  repeat
    inc(FileCounter);
    {$I-}reset(igmplayfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(filewait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamplay.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  igmplay^.onnow := onnow;

  seek(igmplayfile,playpos);
  write(igmplayfile,igmplay^);
  close(igmplayfile);

end;

function GetAKey:char;
var s:String;
    stime : longint;
    ch : char;
begin
  ch := #0;
  stime := mTimeLeft;

  repeat
    while (not mKeyPressed) and (stime=mtimeleft) do
      doEvents;

    if FileExists(igmpath+'tmail'+IntToStr(dropinfo.recpos)+'.dat') then
    begin
      assign(textf,igmpath+'tmail'+IntToStr(dropinfo.recpos)+'.dat');
      reset(textf);

      while not eof(Textf) do
      begin
        readln(textf,s);
        if s = '`z' then
        begin
          {player was kicked off of the team}
          ch := #1;
          igmplay^.onteam := false;
          igmplay^.teamnum := -1;
          save_igmplay(true);
        end
        else
        if s = '`x' then
        begin
          {team leader quit team, team has been disbanded}
          ch := #2;
          igmplay^.onteam := false;
          igmplay^.teamnum := -1;
          save_igmplay(true);
        end
        else
        if s = '``' then
        begin
          moreprompt;
        end
        else
        mwriteln(s);
      end;

      close(Textf);
      erase(textf);

    end;

    if (ch=#0) and (mKeypressed) then
      ch := mReadkey;

    sTime := mTimeLeft;
  until ch <> #0;

end;

end.

{

ID: $Id$

}
