{$I whichos.inc}
unit teamheal;

interface

uses manndoor, teamglob, toolbox;

procedure healers;

implementation

procedure healers;
var ch:char;
    amt:longint;
    num: longint;
    t:string;
{$ifdef VIRTUALPASCAL}
    errcode : longint;
{$else}
    errcode : integer;
{$endif}

label top;
begin

  mclrscr;

  IF (pl^.hit = pl^.hit_max) then
  begin
    mwriteln('');
    mwriteln('');
    mwriteln('  `%Legend of the Red Dragon -`2 Healers');
    mwriteln('`0`L');
    mwriteln('`0  "You look fine to us!`0" `2The healers say.');
    mwriteln('');
    moreprompt;
    exit;
  end;

  mwriteln('');
  mwriteln('');
  mwriteln('  `%Legend of the Red Dragon -`2 Healers');
  mwriteln('`0`L');
  mwriteln('   `2You enter the smoky healers hut.');
  mwriteln('   `5"What is your wish, warrior?"`2 the old');
  mwriteln('   healer asks.');
  mwriteln('');
  mwriteln('  (`5H`2)eal all possible');
  mwriteln('  (`5C`2)ertain amount healed');
  mwriteln('  (`5R`2)eturn');
  mwriteln('');
  mwriteln('  `2Hitpoints: `0(`%'+commas(pl^.hit)+
      '`2 out of `%'+commas(pl^.hit_max)+
      '`0)  `2Gold: `%'+commas(pl^.gold));
  mwriteln('  `2It costs `%'+commas(pl^.level*5)+' `2gold to heal `%1 `2hitpoint.');
  mwriteln('');
  mwrite('  `2Your command, `0'+pl^.names+'`2?`% ');

top:

  ch := getakey;

  if ch in [#1,#2] then goto top;

  ch := upcase(ch);

  mwriteln(ch+'');

  CASE CH of
  'H': begin
         {set how much they can afford}
         num := pl^.gold div (pl^.level * 5);

         {how many they need healed}
         amt := pl^.hit_max - pl^.hit;

         {if what they need is greater than what they can afford, reduce it}
         if amt > num then
           amt := num;

         {if amt < num, make sure they can afford it}
         if amt * (pl^.level * 5) > pl^.gold then
           amt := pl^.gold div (pl^.level * 5);

         inc(pl^.hit,amt);
         dec(pl^.gold,amt * (pl^.level * 5));
         save_player;
         mclrscr;
         mwriteln('');
         mwriteln('');
         mwriteln('  `%Legend of the Red Dragon -`2 Healers');
         mwriteln('`0`L');
         mwriteln('');
         mwriteln('  `%'+commas(amt)+' `2hit points are healed!');
         mwriteln('');
         moreprompt;
       end;
  'C': begin
         { set how many they can afford}
         amt := pl^.gold div (pl^.level * 5);

         { set how many they need}
         num := pl^.hit_max - pl^.hit;

         { if what they need is more than they can afford,
           set to what they can afford}
         if num > amt then
           num := amt;

         mwriteln('');
         mwriteln(' `2You can afford to heal `%'+commas(num)+ ' `2hitpoints.');
         mwrite('  `2AMOUNT:`% ');

         t := mInput('','0123456789',#0,length(IntToStr(num)),
            length(IntToStr(num)),15);

         if t = '' then exit;

         val(t,amt,errcode);

         if errcode <> 0 then exit;
         if amt = 0 then exit;

         if amt > num then
         begin
           mwriteln('');
           mwriteln('  `0"`2Sorry, but you cannot afford that.`0"`2');
           mwriteln('');
           moreprompt;
           exit;
         end;

         dec(pl^.gold,amt * (pl^.level * 5));
         inc(pl^.hit,num);

         save_player;

         mwriteln('');
         mwriteln('  `0"`2Done!`0"`2');
         mwriteln('');
         moreprompt;
       end;
  end;
end;

end.
