{$I whichos.inc}

unit teamman;

interface

uses manndoor, teamglob, toolbox;

procedure check_maint;
procedure run_maint;

implementation

procedure check_maint;
begin
  if igmdat^.maintdate < igmdate then
    run_maint;
end;

procedure run_maint;
var i : longint;
    magic_num : longint;
    tempfile: File of TIGMPlay;
begin
  mclrscr;

  mwriteln('');
  mwriteln('  `7TeamLord Maintenance - Hold on a sec');
  mwriteln('');

  igmdat^.maintdate := igmdate;
  cfgout;

  if not FileExists(igmpath+'teamplay.dat') then
    exit;

  mwriteln('  `%- `2Loading player index');
  load_pr_index;

  mwriteln('  `%- `2Opening teamplay.dat');

  assign(igmplayfile,igmpath+'teamplay.dat');
  filecounter := 0;
  filemode := $12;
  repeat
    inc(FileCounter);
    {$I-}reset(igmplayfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > 0);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamplay.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  mwriteln('  `%- `2Processing teamplay.dat (Reseting players)');

  for i := 0 to filesize(igmplayfile) - 1 do
  begin
    seek(igmplayfile,i);
    read(igmplayfile,igmplay^);

    load_enemy(igmplay^.recpos);

    if (enemy^.real_names = 'X') or (enemy^.names = 'X') then
    begin
      igmplay^.deleted := true;
    end
    else
    begin
      igmplay^.deleted := false;

      if odd(pr^[i].level) then
        magic_num := 1
      else
        magic_num := 3;

      for i := -1 to (pr^[i].level div 2) do
      begin
        magic_num := magic_num * 10;
      end;

      igmplay^.left := magic_num;

      igmplay^.invaded := 1;
      if pr^[i].class = 3 then
        inc(igmplay^.invaded,2);

      igmplay^.partied := 100 + (5 * pr^[i].level);
    end;

    seek(igmplayfile,i);
    write(igmplayfile,igmplay^);

  end;

  reset(igmplayfile);

  mwriteln('  `%- `2Purging deleted players');

  assign(tempfile,igmpath+'teamplay.tmp');
  rewrite(tempfile);

  while not eof(igmplayfile) do
  begin
    read(igmplayfile,igmplay^);
    if igmplay^.deleted=true then
    begin
      mwriteln('    `0- Deleting '+igmplay^.name);
    end
    else
    begin
      write(tempfile,igmplay^);
    end;
  end;

  close(igmplayfile);
  close(tempfile);

  erase(igmplayfile);
  rename(tempfile,igmpath+'teamplay.dat');

  mwriteln('  `%- DONE!');

  mwriteln('');
  mwriteln('  `2(Waiting a few seconds to continue)');
  mWait(100);

end;

end.
