{$I whichos.inc}

unit teammisc;

interface

uses crt, manndoor, mstrings, teamglob, toolbox;

function getTeam:integer;
procedure saveplayer;

implementation

function getTeam : integer;
var q,x:integer;
    s:string;
    instr : string;
    numteams : integer;
begin
  assign(teamf,igmpath+'teamfile.dat');
  filemode := $20;
  filecounter := 0;
  repeat
    inc(filecounter);
    {$I-}reset(teamf);{$I+}
    IOError := ioresult;
    if ioerror = 5 then mwait(filewait);
  until (IOError = 0) or (filecounter > filetries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(ioerror);
  end;

  q := 0;
  repeat
    inc(q);
    read(teamf,team^);
    IF (Q <> igmplay^.teamnum+1) then
    begin
      s := IntToStr(q);
      while length(s) < numteams do
        s := ' '+s;
      mwriteln('  `0'+s+'. `2'+team^.name);

      IF (q MOD 20) = 0 then
      begin
        mwriteln('');
        mwrite('  `2(`%Q`2)uit, `2(`%C`2)ontinue, or team number: `%`r1');
        instr := mInput('','qQcC0123456789',#0,numteams,numteams,textattr);
        mTextColor(2);
        mtextbackground(0);
        mwriteln('');

        if upcase(instr[1]) = 'Q' then
        begin
          getTeam := -1;
          close(teamf);
          exit;
        end
        else
        if (instr <> '') and (upcase(instr[1]) <> 'C') then
        begin
          x := StrToIntDef(instr,0);
          if (x > 0) and (x <= numteams) then
          begin
            if x = igmplay^.teamnum then
            begin
              mwriteln('  `2That''s your own team!');
              moreprompt;
              continue;
            end
            else
            begin
              getTeam := x;
              close(teamf);
              exit;
            end;
          end;
        end;
      end;
    end;
  until mkeypressed or eof(teamf);
  close(teamf);

  mwrite('  `2Enter team number: `%`r1');
  instr := mInput('','0123456789',#0,numteams,numteams,textattr);
  mTextColor(2);
  mtextbackground(0);
  mwriteln('');

  if instr = '' then
  begin
    getTeam := -1;
  end
  else
  begin
    x := StrToIntDef(instr,0);
    if (x > 0) and (x <= numteams) then
    begin
      if x = igmplay^.teamnum then
      begin
        mwriteln('  `2That''s your own team!');
        moreprompt;
        getTeam := -1;
      end
      else
        getTeam := x;
    end
    else
      getTeam := -1;
  end;
end;

procedure saveplayer;
begin
  assign(plfile,igmdat^.lordpath+'player.dat');
  filemode := $11;
  filecounter := 0;
  repeat
    inc(filecounter);
    {$I-}reset(plfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(filewait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening player.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(ioerror);
  end;

  seek(plfile,dropinfo.recpos);
  write(plfile,pl^);
  close(plfile);

end;

end.
