{$I whichos.inc}

unit teammng;

interface

uses manndoor, mstrings, teamglob, toolbox;

procedure management;

implementation

var tempstr:String;
    oldteam : boolean;

procedure passwordchange;
var ch:char;
begin
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('  `%Changing the team password');
  mwriteln('`0`L');
  mwriteln('');
  mwriteln('  `2This option changes the password that people must give');
  mwriteln('  when they want to join the team.');
  mwriteln('');
  mwriteln('  `2The current password is: `%'+myteam^.pass);
  mwriteln('');
    mwrite('  `0Change the password? `2[`0N`2] `%');

  ch := mreadkey;
  ch := upcase(ch);
  if ch <> 'Y' then ch := 'N';
  mwriteln(ch+'');
  mwriteln('');

  if ch = 'N' then exit;

  mwrite('  `2Enter the new password: ');
  tempstr := mInput('','0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ',#0,
    20,20,15);

  mwriteln('');
  mwriteln('');

  if tempstr = '' then
  begin
    mwriteln('  `0Password not changed');
  end
  else
  begin
    load_my_team;
    myteam^.pass := tempstr;
    save_my_team;
    mwriteln('  `0Done!');
  end;

  mwriteln('');
  moreprompt;

end;

function replace(this,that,inthis:string; doall:Boolean):string;
var i : integer;
    news : string;
begin
  i := pos(upstring(this),upstring(inthis));

  news := '';

  if i <> 0 then
  begin
    if i > 1 then
      news := copy(inthis,1,i-1);

    news := news + that;

    delete(inthis,1,i-1);
    delete(inthis,1,length(this));

    if doall then
    begin
      i := pos(upstring(this),upstring(inthis));
      while i <> 0 do
      begin
        if i > 1 then
          news := news + copy(inthis,1,i-1);
        news := news + that;

        delete(inthis,1,i-1);
        delete(inthis,1,length(this));

          i := pos(upstring(this),upstring(inthis));

      end;
    end;

    news := news + inthis;

  end
  else
    news := inthis;

  replace := news;
end;

function strip_bad(s:string):string;
var news : string;
    i : integer;
    this,that,instr:string;
begin
  news := '';

  i := 1;
  while i <= length(s) do
  begin
    if s[i] = '`' then
    begin
      inc(i);
      if s[i] in ['0','1'..'9','!','@','#','$','%'] then
      begin
        news := news + '`' + s[i];
      end
      else
      if s[i]='r' then
        inc(i);
    end
    else
      news := news + s[i];
  end;

  assign(textf,igmdat^.lordpath+'badwords.dat');
  {$I-}reset(textf);{$I+}
  if ioresult = 0 then
  begin
    while not eof(textf) do
    begin
      readln(textf,instr);
      while (length(instr) > 0) and (instr[1]=' ') do
        delete(instr,1,1);
      if length(instr) < 3 then
        continue;
      if instr[1] = ';' then
        continue;

      if pos('|',instr)=0 then
        continue;

      this := copy(instr,1,pos('|',instr)-1);
      delete(instr,1,length(this)+1);
      that := instr;

      news := replace(this,that,news,true);
    end;
  end;

  strip_bad := news;

end;


procedure sendmess;
var a:array[1..5] of string;
    c : byte;
    i : integer;
begin
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('  `%Mailing all team mates');
  mwriteln('`0`L');
  mwriteln('');
  mwriteln('  `2What do you want to send to your team mates? (5 lines max, blank quits)');
  mwriteln('');

  fillchar(a,sizeof(a),#0);

  c := 1;

  while c <= 5 do
  begin
    a[c] := '';
    a[c] := mInput('',CHARS_ALL,#0,60,60,15);
    if a[c] = '' then
      break;
    a[c] := strip_bad(a[c]);
    inc(c);
  end;

  if (c=1) and (a[c]='') then
    exit;

  load_my_Team;

  for i := 0 to max_play do
  begin
    if i=dropinfo.recpos then
      continue;
    if myteam^.member[i]=true then
    begin
      assign(textf,igmdat^.lordpath+'mail'+IntToStr(i)+'.dat');
      {$I-}append(textf);{$I+}
      if ioresult<> 0 then rewrite(textf);
      writeln(textf);
      writeln(textf,'  `%A Team Message from `0'+pl^.names);
      writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      writeln(textf);
      for c := 1 to 5 do
      begin
        if a[c] = '' then
          break
        else
          writeln(textf,a[c]);
      end;
      writeln(textf);
      writeln(textf,'`-'+IntToStr(dropinfo.recpos));
      close(Textf);
    end;
  end;

  mwriteln('');
  mwriteln('  `0Done!');
  mwriteln('');
  moreprompt;

end;

procedure revive;
var found:boolean;
    i,j:integer;
    ch : char;
    amt:longint;
begin

  load_pr_index;

  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('  `%Reviving a dead team mate');
  mwriteln('`0`L');
  mwriteln('');

  load_my_team;

  j := 0;

  for i := 0 to max_play do
  begin
    if myteam^.member[i]=true then
    begin
      if pr^[i].dead=5 then
      begin
        mwriteln('  `0'+pr^[i].names);
        inc(j);

        if j mod 10 = 0 then
        begin
          mwriteln('');
          moreprompt;
          mwriteln('');
        end;
      end;
    end;
  end;

  if j = 0 then
  begin
    mwriteln('');
    mwriteln('  `0You have no dead team mates!');
    mwriteln('');
    moreprompt;
    exit;
  end;

  mwrite('  `0Who do you wish to revive? ');
  tempstr := mInput('',CHARS_ALL,#0,20,20,15);

  if tempstr = '' then exit;

  mwriteln('');
  mwriteln('');

  j := -1;
  found := false;
  i := 0;

  while (i <= max_play) and (found=false) do
  begin
    if myteam^.member[i]=true then
    begin
      if pr^[i].dead=5 then
      begin
        mwrite('  `2Do you mean `0'+pr^[i].names+'`2? `2[`0N`2] `%');
        ch := getakey;
        if ch in [#1,#2] then exit;
        ch := upcase(ch);
        if ch <> 'Y' then ch := 'N';
        mwriteln(ch+'');
        if ch = 'Y' then
        begin
          j := i;
          found := true;
        end;
      end;
    end;
  end;

  mwriteln('');

  if found=false then
  begin
    mwriteln('  `0No matching players');
    mwriteln('');
    moreprompt;
    exit;
  end;

  amt := pr^[j].level * 100000;

  mwriteln('  `2It will cost `%'+commas(amt)+' `2gold to revive this person.');
  mwrite('  `2Do it? `2[`0N`2] `%');

  ch := getakey;
  if ch in [#1,#2] then exit;
  ch := upcase(ch);

  if ch <> 'Y' then ch := 'N';

  mwriteln(ch+'');
  mwriteln('');

  if ch = 'N' then exit;

  if amt > pl^.gold then
  begin
    mwriteln('  `0You don''t have that much gold!');
    mwriteln('');
    moreprompt;
    exit;
  end;

  load_enemy(j);

  enemy^.hit := enemy^.hit_max;
  enemy^.dead := 0;

  save_enemy(j);

  dec(pl^.gold,amt);

  save_player;

  mwriteln('  `0Done!');
  mwriteln('');
  moreprompt;


end;

procedure listteam;
var i,j : integer;
begin
  load_pr_index;

  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('  `%Your team mates');
  mwriteln('`0`L');
  mwriteln('');

  j := 0;

  for i := 0 to max_play do
  begin
    if myteam^.member[i]=true then
    begin
      inc(j);
      mwriteln('  `0'+pr^[i].names);
    end;

    if j mod 10 = 0 then
    begin
      mwriteln('');
      moreprompt;
      mwriteln('');
    end;
  end;

  if j mod 10 <> 0 then
  begin
    mwriteln('');
    moreprompt;
  end;

end;

procedure dispteams;
var i : integer;
begin
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('  `%Teams');
  mwriteln('`0`L');
  mwriteln('');

  load_pr_index;

  assign(teamf,igmpath+'teamfile.dat');
  filecounter := 0;
  filemode := $20;
  repeat
    inc(FileCounter);
    {$I-}reset(teamf);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (Filecounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  i := 0;

  while not eof(teamf) do
  begin
    inc(i);
    read(teamf,team^);
    mwriteln('  `2'+fpad(IntToStr(i),10)+': `0'+pad(team^.name,30)+
      ' `2Leader: `0'+pr^[team^.leader].names);

    if i mod 10 = 0 then
    begin
      mwriteln('');
      moreprompt;
      mwriteln('');
    end;
  end;

  close(teamf);

  if i mod 10 <> 0 then
  begin
    mwriteln('');
    moreprompt;
  end;

end;

procedure kickmember;
var i,j:integer;
    ch:char;
    done : boolean;
begin
  load_pr_index;
  mclrscr;
  mwriteln('');
  mwriteln('');
  mwriteln('  `%Kicking someone off of the team');
  mwriteln('`0`L');
  mwriteln('');

  load_my_team;

  j := 0;
  for i := 0 to max_play do
  begin
    if myteam^.member[i]=true then
    begin
      mwriteln('  `0'+pr^[i].names);
      inc(j);
    end;

    if j mod 10 = 0 then
    begin
      j := 0;
      mwriteln('');
      mwrite('  `2(`0C`2)ontinue or `2(`0S`2)top `2[`0C`2] `%');
      ch := mReadkey;
      ch := upcase(ch);
      if ch <> 'S' then ch := 'C';

      if ch = 'S' then break;
    end;
  end;

  mwriteln('');
  mwrite('  `0Who do you want to kick? ');
  tempstr := minput('',CHARS_ALL,#0,20,20,15);

  if tempstr = '' then exit;

  tempstr := upstring(rlength(tempstr));

  done := false;
  i := 0;
  j := 0;

  while (done=false) and (i < max_play) do
  begin
    if myteam^.member[i]=true then
    begin
      if pos(tempstr,upstring(rlength(pr^[i].names)))<>0 then
      begin
        mwriteln('');
        mwrite('  `2Do you mean `0'+pr^[i].names+'`2? `2[`0N`2] `%');
        ch := mReadkey;
        ch := upcase(ch);
        if ch <> 'Y' then ch := 'N';
        mwriteln(ch+'');
        if ch = 'Y' then
        begin
          j := i;
          done := true;
        end;
      end;
    end;
    inc(i);
  end;

  if (done=false) then
  begin
    mwriteln(' `0No matching players.');
    mwriteln('');
    moreprompt;
    exit;
  end;

  mwriteln('');
  mwrite('  `2Kick `0'+pr^[j].names+'`2 off of the team? `2[`0N`2] `%');
  ch := mreadkey;
  ch := upcase(ch);
  if ch <> 'Y' then ch := 'N';
  mwriteln(ch+'');
  mwriteln('');

  if j = dropinfo.recpos then
  begin
    mwriteln('  `0You can''t kick yourself off!');
    mwriteln('');
    moreprompt;
    exit;
  end;

  myteam^.sleep[j] := false;
  myteam^.member[j] := false;
  save_my_Team;

  assign(igmplayfile,igmpath+'teamplay.dat');
  filecounter := 0;
  filemode := $12;
  repeat
    inc(FileCounter);
    {$I-}reset(igmplayfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamplay.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  new(tempigmplay);

  seek(igmplayfile,j);
  read(igmplayfile,tempigmplay^);

  if tempigmplay^.onnow = true then
  begin
    assign(textf,igmpath+'tmail'+IntToStr(j)+'.dat');
    {$I-}append(textf);{$I+}
    if ioresult<>0 then rewrite(textf);
    writeln(textf,'  `%KICKED OFF THE TEAM!');
    writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    writeln(textf,'  `2You have been kicked off the `0'+myteam^.name+'`2!');
    writeln(textf,'');
    writeln(textf,'`z');
    writeln(textf,'``');
    close(textf);
  end
  else
  begin
    tempigmplay^.onteam := false;
    tempigmplay^.teamnum := -1;
    seek(igmplayfile,j);
    write(igmplayfile,tempigmplay^);

    assign(textf,igmdat^.lordpath+'mail'+IntToStr(j)+'.dat');
    {$I-}append(textf);{$I+}
    if ioresult<>0 then rewrite(textf);
    writeln(textf);
    writeln(textf,'  `%KICKED OFF THE TEAM!');
    writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    writeln(textf,'  `2You have been kicked off the `0'+myteam^.name+'`2!');
    writeln(textf,'');
    writeln(textf,'``');
    close(textf);
  end;

  close(igmplayfile);
  dispose(tempigmplay);

end;


procedure exitteam;
var ch:char;
    i : integer;
begin
  mwriteln('');
  mwriteln('');
  mwriteln(' `2This option allows you to quit your current team.');
  mwriteln('');
  mwriteln('  If you are the team leader, doing this will DISBAND the team!');
  mwriteln('');
  mwrite('  `0Are you sure you want to do this? `2[`%N`2] : `%');

  ch := getakey;
  if ch in [#1,#2] then exit;
  ch := upcase(ch);
  if ch <> 'Y' then ch := 'N';

  mwriteln(ch+'');
  mwriteln('');

  if ch = 'N' then exit;

  load_my_Team;

  assign(igmplayfile,igmpath+'teamplay.dat');
  filecounter := 0;
  filemode := $12;
  repeat
    inc(FileCounter);
    {$I-}reset(igmplayfile);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mWait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if IOError <> 0 then
  begin
    mwriteln('Error opening teamplay.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  if myteam^.leader = dropinfo.recpos then
  begin
    new(tempigmplay);
    myteam^.deleted := true;

    for i := 0 to max_play do
    begin
      if i = dropinfo.recpos then continue;

      if myteam^.member[i]=true then
      begin
        seek(igmplayfile,i);
        read(igmplayfile,tempigmplay^);
        if tempigmplay^.onnow = true then
        begin
          assign(textf,igmpath+'tmail'+IntToStr(i)+'.dat');
          {$I-}append(textf);{$I+}
          if ioresult<>0 then rewrite(textf);
          writeln(textf,'  `%TEAM DISBANDED!');
          writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
          writeln(textf,'');
          writeln(textf,'  `2The team you are on (`0'+myteam^.name+'`2) has been disbanded by');
          writeln(textf,'  `0'+pl^.names+'`2!');
          writeln(textf,'');
          writeln(textf,'`x');
          writeln(textf,'``');
          close(textf);
        end
        else
        begin
          myteam^.member[i] := false;
          myteam^.sleep[i] := false;
          tempigmplay^.onteam := false;
          tempigmplay^.teamnum := -1;
          seek(igmplayfile,i);
          write(igmplayfile,tempigmplay^);

          assign(textf,igmdat^.lordpath+'mail'+IntToStr(i)+'.dat');
          {$I-}append(Textf);{$I+}
          if ioresult<> 0 then rewrite(textf);
          writeln(textf);
          writeln(textf,'  `%Mail From TeamLord');
          writeln(textf,'`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
          writeln(textf,'  `0'+pl^.names+' `2has disbanded the team your were on!');
          writeln(textf,'  `2You are no longer on a team!');
          writeln(textf,'');
          writeln(textf,'``');
          close(Textf);
        end;
      end;

    end;
    dispose(tempigmplay);
    save_my_team;
  end;

  i := igmplay^.teamnum;

  igmplay^.onteam := false;
  igmplay^.teamnum := -1;

  seek(igmplayfile,dropinfo.recpos);
  write(igmplayfile,igmplay^);

  close(igmplayfile);

  myteam^.member[dropinfo.recpos] := false;
  myteam^.sleep[dropinfo.recpos] := false;

  assign(teamf,igmpath+'teamfile.dat');
  filecounter := 0;
  filemode := $11;
  repeat
    inc(FileCounter);
    {$I-}reset(teamf);{$I+}
    IOError := IOResult;
    if ioerror = 5 then mwait(FileWait);
  until (IOError = 0) or (FileCounter > FileTries);

  if ioerror <> 0 then
  begin
    mwriteln('Error opening teamfile.dat!');
    mwriteln('IOError: '+IntToStr(IOError));
    runerror(IOError);
  end;

  seek(teamf,i);
  write(teamf,myteam^);
  close(teamf);

  mwriteln('  `0Done!`2');
  mwriteln('');
  moreprompt;

end;

procedure treasury;
var ch:char;
    amt,num:longint;
    magicnum : longint;
{$ifdef VIRTUALPASCAL}
    errcode : longint;
{$else}
    errcode : integer;
{$endif}
begin
  load_my_team;
  repeat
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('  `%Team Treasury');
    mwriteln('  `0`L');
    mwriteln('');
    mwriteln('');
    mwriteln('`%  Treasury');
    mwriteln('`0-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
    mwriteln('`2    You walk to the back of the team''s house, and find');
    mwriteln('    the safe.  You spin in the combination, and it pops open.');
    mwriteln('');
    mwriteln('  `2(`5D`2)eposit Gold');
    mwriteln('  (`5W`2)ithdraw Gold');
    mwriteln('  (`5R`2)eturn');
    mwriteln('');
    mwriteln('');
    mwriteln('  `2Gold In Hand: `0'+commas(pl^.gold)+
      '  `2Gold In Safe: `0'+commas(myteam^.treasury));
    mwriteln('');
    mwrite('  `2Your choice, `0'+pl^.names+'`2?`% ');

    ch := getakey;
    if ch in [#1,#2] then exit;
    ch := upcase(ch);
    mwriteln(ch+'');

    mwriteln('');

    case ch of
    'D': begin
           mwrite('  `2Deposit how much: ');
           tempstr := mInput('','0123456789',#0,length(IntToStr(pl^.gold)),
             length(IntToStr(pl^.gold)),15);

           mwriteln('');
           mwriteln('');

           if tempstr = '' then continue;

           val(tempstr,amt,errcode);

           if (amt=0) or (Errcode<>0) then continue;

           if amt > pl^.gold then
           begin
             mwriteln('  `0You don''t have that much gold!`2');
             mwriteln('');
             moreprompt;
             continue;
           end;

           if MaxLongInt - myteam^.treasury < amt then
           begin
             mwriteln('  `0There''s not enough room for that much gold!`2');
             mwriteln('');
             moreprompt;
             continue;
           end;
           inc(myteam^.treasury,amt);
           dec(pl^.gold,amt);

           save_my_Team;
           save_player;

           mwriteln('  `0Done!`2');
           mwriteln('');
           moreprompt;

         end;
    'W': begin
           if myteam^.treasury < 1 then
           begin
             mwriteln('  `0Your team doesn''t have anything to withdraw!`2');
             mwriteln('');
             moreprompt;
             continue;
           end;

           mwrite('  `2Withdraw how much? ');
           tempstr := mInput('','0123456789',#0,length(IntToStr(myteam^.treasury)),
             length(IntToStr(myteam^.treasury)),15);

           mwriteln('');
           mwriteln('');

           if tempstr = '' then continue;

           if odd(pl^.level) then
             magicnum := 1
           else
             magicnum := 3;
{$R-}

           for num := -1 to (pl^.level div 2) do
             magicnum := magicnum * 10;

           if (myteam^.leader = dropinfo.recpos) and
              (igmplay^.left=magicnum) then
           begin
             if MaxLongInt - igmplay^.left >= igmplay^.left then
             begin
               inc(igmplay^.left,igmplay^.left);
             end
             else
               igmplay^.left := MaxLongInt;

             if MaxLongInt - magicnum >= magicnum then
               inc(magicnum,magicnum)
             else
               magicnum := MaxLongInt;

           end
           else
           if igmplay^.left > magicnum then
             igmplay^.left := magicnum;

{$R+}

           val(tempstr,amt,errcode);

           if (amt=0) or (Errcode<>0) then continue;

           if amt > myteam^.treasury then
           begin
             mwriteln('  `0Your team doesn''t have that much gold!`2');
             mwriteln('');
             moreprompt;
             continue;
           end;

           if MaxLongInt - pl^.gold < amt then
           begin
             mwriteln('  `0You don''t have room for that much gold!`2');
             mwriteln('');
             moreprompt;
             continue;
           end;

           if num <= igmplay^.left then
           begin
             inc(pl^.gold,amt);
             dec(myteam^.treasury,amt);
             dec(igmplay^.left,amt);
             save_my_team;
             save_player;
             mwriteln('  `0Done!`2');
           end
           else
           begin
             mwriteln('');
             mwriteln('  `2Too much!  At your level, you can only take');
             mwriteln('  `%'+commas(igmplay^.left)+'`2 gold today!');
             mwriteln('                          `5- `0Team Regulations');
           end;

           save_igmplay(true);
           mwriteln('');
           moreprompt;

         end;
    end;

  until ch in ['R','Q'];
end;

procedure management;
var ch:char;
    leadname:string;
begin
  load_my_Team;
  if myteam^.leader = dropinfo.recpos then
    leadname := 'You!'
  else
  begin
    load_enemy(myteam^.leader);
    leadname := enemy^.names;
  end;

  oldteam := igmplay^.onteam;

  repeat
    mclrscr;
    mwriteln('');
    mwriteln('');
    mwriteln('  `%Management Options');
    mwriteln('`0`L');
    mwriteln('');
    mwriteln('  `2Team Leader: `0'+leadname);
    mwriteln('');
    mwriteln('         `2(`5Y`2)e Team Treasury                     `2(`5P`2)assword Change');
    mwriteln('         `2(`5E`2)xit Team                            `2(`5K`2)ick Off Team');
    mwriteln('         `2(`5D`2)isplay Teams                        `2(`5L`2)ist Team Mates');
    mwriteln('         `2(`5R`2)evive Team Mate                     `2(`5S`2)end Team Message');
    mwriteln('         `2(`%Q`2)uit to the Realm');
    mwriteln('');
    mwrite('  `2Your command, `0'+pl^.names+'`2?`% ');

    ch := getakey;
    if ch in [#1,#2] then exit;
    ch := upcase(ch);

    mwriteln(ch+'');
    mwriteln('');

    CASE UPCASE(CH) of
    'Y': treasury;
    'E': begin
           exitteam;
           if igmplay^.onteam=false then exit;
         end;
    'K': begin
           if myteam^.leader <> dropinfo.recpos then
           begin
             mwriteln('  `2Only the team leader can do that!');
             mwriteln('');
             moreprompt;
           end
           else
             kickmember;
         end;
    'D': dispteams;
    'L': listteam;
    'R': revive;
    'S': sendmess;
    'P': begin
           if myteam^.leader <> Dropinfo.recpos then
           begin
             mwriteln('  `2Only the team leader can do that!');
             mwriteln('');
             moreprompt;
           end
           else
             passwordchange;
         end;
    end;

    if (oldteam=true) and (igmplay^.onteam=false) then
      exit;
  until ch = 'Q';
end;

end.
