{$I whichos.inc}

unit toolbox;

interface

uses dos;

function IntToStr(l:longint):string;
function StrToIntDef(s:string; def:longint):longint;
function commas(l:longint):string;
function rlength(s:String):string;
function pad(s:string; len:byte):string;
function fpad(s:string; len:byte):string;
function fileexists(fname:string):boolean;
function upstring(s:String):string;
function igmdate:longint;

implementation

function IntToStr(l:longint):string;
var s: string;
begin
  str(l,s);
  IntToStr := s;
end;

function StrToIntDef(s:string; def:longint):longint;
var l, Code: Longint;
begin
  Val( s, l, Code );
  if Code <> 0 then
    StrToIntDef := def
  else
    StrToIntDef := l;
end;

function commas(l:longint):String;
var s1,s2:string;
    i:byte;
begin
  s1 := IntToStr(l);

  s2 := '';

  for i := length(s1) downto 1 do
  begin
    s2 := s1[i] + s2;
    if (i mod 3 = 0) and (i > 1) then
      s2 := ',' + s2;
  end;

  commas := s2;
end;

function rlength(s:String):string;
var s2:string;
    i : byte;
begin
  i := 1;
  s2 := '';
  while i <= length(s) do
  begin
    if s[i] = '1' then
    begin
      inc(i);
      if s[i] = 'r' then
        inc(i);
    end
    else
      s2 := s2 + s[i];
    inc(i);
  end;
  rlength := s2;
end;

function pad(s:string; len:byte):string;
begin
  while length(rlength(s)) < len do
    s := s + ' ';
  pad := s;
end;

function fpad(s:string; len:byte):string;
begin
  while length(rlength(s)) < len do
    s := ' ' + s;
  fpad := s;
end;

function fileexists(fname:string):boolean;
var sr:searchrec;
begin
  findfirst(fname,AnyFile,sr);
  FileExists := (DosError = 0);
  {$ifdef VIRTUALPASCAL}
  findclose(sr);
  {$endif}
end;

function upstring(s:String):string;
var b: byte;
begin
  for b := 1 to length(s) do
    s[b] := upcase(s[b]);
  upstring := s;
end;

function igmdate:longint;
var y,m,d,dow:longint;
begin
  getdate(y,m,d,dow);
  igmdate := (y * 10000) + (m * 100) + d;
  {result = 20061004 .. oct (10) 4th, 2006}
end;

end.
