PROGRAM CHANEDIT;  { The Changeling's P. D. Editor Utility }

  { Started creation using VALEDIT source code 05/07/2007. }
  { ================================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

    {$I CHANGVAR.INC}     {January 2011 Non-Beta development}
{ ============================================================= }

CONST Version: STRING = 'v1.10';  {01/13/09: v1.10}

      Compile_Date: STRING[22] = 'December 24, 2010.';

      Release_Date: STRING[24] = 'December 24th, 2010.';  {01/13/09}
          {12/30/09: renamed Version_Date to Release_Date.}
          {12/30/09: All code in program is fully tested.}
      { ------------------------------------------------ }

      CfgName: STRING = 'CHANEDIT.CFG';

      DudePlayer_FN: STRING = 'CHANPLAY.DAT';

      RealName    = '1';   LordName   = '2';   PlayNum   = '3';
      Visits      = '4';   Adoptions  = '5';   Lays      = '6';
      FairyRescue = '7';   HitMax     = '8';   Strength  = '9';
      Defense     = '0';   Charm      = 'A';   Forest    = 'B';
      Gems        = 'C';   Gold       = 'D';   Wisdom    = 'E';
      { ------------------------------------------------------- }

      { Q - Quit/Save Changes.   S - Search for Player. }
      { * - New Day for Player.  X - Delete Player Record  }
      { ------------------------------------------------------- }

      OneBillion: LONGINT = 1000000000;  {05/07/2007}

      Max_Visits: BYTE = 20;  {08/10/2008}
      { ================================================= }

VAR TSearch: Dude_Player;   { for player searches }

    TCEdit: Dude_Player;

    Editor_Path: STRING;      { File Vars for CHANPLAY.DAT access }
        {09/29/07: Changed Change_FN to Editor_Path.}

    Editor_File:  FILE OF Dude_Player;

    IGMDir: STRING;

    RecordNum   : BYTE;

    Debug_Mode: BOOLEAN;  {Added 07/22/07}
           {01/17/10: Renamed DebugVar to Debug_Mode.}

      { TempNum, Used, Found: Accessed from CHANGVAR.INC.   Used }
      { in record Seek process.  }
    { ================================================================================== }

PROCEDURE READ_CONFIG;
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter dir. path to Changeling IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

  { VALEDIT: When run from compiler, verified that value of IGMDir is known at this point. }
END;       { Read_Config ------------------------------------------------- }


PROCEDURE READ_WARRIORS_FILE;    { Reads the IGM's CHANPLAY.DAT file. }
BEGIN
  Editor_Path:= S2U(IGMDIR+DudePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TCEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


PROCEDURE WRITE_WARRIORS_FILE;      { Writes IGM's CHANPLAY.DAT file }
BEGIN
  Editor_Path:= S2U(IGMDIR+DudePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TCEdit);

  CLOSE(Editor_File);
END;     { WRITE_WARRIORS_FILE   ------------------------------ }


     {10/15/07: Renamed Search to SEARCH_PLAYER.}
PROCEDURE SEARCH_PLAYER(Num:INTEGER);
      { Reads CHANPLAY.DAT. Does search on player record number }
BEGIN
  Editor_Path:= S2U(IGMDIR+DudePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }

    
FUNCTION Get(b:CHAR):STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TCEdit.RealName;

     LordName : Get:='`$'+TCEdit.LordName;

     PlayNum  : Get:='`@'+N2S(TCEdit.PlayNum);  {Contains player's LORD player #.}

     Visits   : IF TCEdit.Visits = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TCEdit.Visits);

     Adoptions: IF TCEdit.Adoptions = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TCEdit.Adoptions);
          {09/29/07: Changed Kids to Adoptions.}

     Lays     : IF TCEdit.Lays = 0
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+N2S(TCEdit.Lays);

     FairyRescue: IF TCEdit.Fairy_Rescue THEN Get:= '`@Yes! '
                    ELSE Get:= '`0Nope!';  {Boolean VAR}
          {09/29/07: Changed Rescue to FairyRescue.}

     HitMax   : IF TCEdit.HitMax = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.HitMax);

     Strength : IF TCEdit.Strength = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Strength);

     Defense  : IF TCEdit.Defense = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Defense);

     Charm    : IF TCEdit.Charm = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Charm);

     Forest   : IF TCEdit.Forest = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Forest);

     Gems     : IF TCEdit.Gems = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Gems);

     Gold     : IF TCEdit.Gold = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Gold);

     Wisdom   : IF TCEdit.Wisdom = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TCEdit.Wisdom);
  END;

  CursorOff;   {Added 10/15/07.  needed to fix bug found by Dennis Collins}
               { in 2006 when he checked on KLBEDIT. }

    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }



{ 1 }PROCEDURE Do_RealName;          {VERIFIED 05/07/07}
BEGIN
  TCEdit.RealName:=
    PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TCEdit.RealName,FALSE);

  WRITE_WARRIORS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


{ 2 }PROCEDURE Do_LordName;           {VERIFIED 05/07/07}
BEGIN
  TCEdit.LordName:=
    PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TCEdit.LordName,FALSE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


    { In normal usage, don't allow users to change LORD Player Numbers. }
    { 07/22/07: Renamed Do_PlayNum to DO_PLAYER_NUMBER.}

{ 3 }PROCEDURE DO_PLAYER_NUMBER;              {VERIFIED 05/07/07}
BEGIN
  TCEdit.PlayNum:=
    PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TCEdit.PlayNum,0,160,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXy(52,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(52,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;               {VERIFIED 05/07/07}
BEGIN       {rewrote 08/10/08 to use 0-20 range}
  TCEdit.Visits:=
    PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TCEdit.Visits,0,Max_Visits,TRUE);
             {rewrote 08/10/08 using Max_Visits const.}

  WRITE_WARRIORS_FILE;
  CwriteXY(22,6,Replicate(5,' '));
  CwriteXY(22,6,Get(Visits));
END;


{ 5 }PROCEDURE DO_ADOPTIONS;                 {VERIFIED 05/07/07}
BEGIN
  TCEdit.Adoptions:=
    PromptNum(0,0,'Enter # of Adoptions (0-20)?',' Adoptions Change',TCEdit.Adoptions,0,20,TRUE);

          {09/29/07: Changed Kids to Adoptions.}
  WRITE_WARRIORS_FILE;
  CWriteXY(58,6,Replicate(6,' '));
  CWriteXY(58,6,Get(Adoptions));
END;


{ 6 }PROCEDURE DO_LAYS;                 {VERIFIED 05/07/07}
BEGIN
  TCEdit.Lays:=
    PromptNum(0,0,'Enter # of Lays (0-20)?',' Lays Change ',TCEdit.Lays,0,20,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(Lays));
END;


{ 7 }PROCEDURE DO_FAIRY_RESCUE;                 {VERIFIED 05/07/07}
BEGIN
  IF TCEdit.Fairy_Rescue = TRUE THEN TCEdit.Fairy_Rescue:= FALSE
    ELSE IF TCEdit.Fairy_Rescue = FALSE THEN TCEdit.Fairy_Rescue:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(58,7,Replicate(6,' '));
  CWriteXY(58,7,Get(FairyRescue));
END;


{ 8 }PROCEDURE DO_MAX_HITPOINTS;               {VERIFIED 05/07/07}
BEGIN
  TCEdit.HitMax:=
    PromptNum(0,0,'Enter HitMax Points (0-16,000)?',' HitMax Potions Change ',TCEdit.HitMax,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,8,Replicate(6,' '));
  CwriteXY(22,8,Get(HitMax));
END;


{ 9 }PROCEDURE DO_STRENGTH;                 {VERIFIED 05/07/07}
BEGIN
  TCEdit.Strength:=
    PromptNum(0,0,'Enter Strength Points  (0-16,000)?',' Strength Points Potions Change ',TCEdit.Strength,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,8,Replicate(6,' '));
  CWriteXY(58,8,Get(Strength));
END;


{ 0 }PROCEDURE DO_DEFENSE;    {VERIFIED 05/07/07}
BEGIN
  TCEdit.Defense:=
    PromptNum(0,0,'Enter Defense Points (0-16,000)?',' Defense Points Change',TCEdit.Defense,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,9,Replicate(8,' '));
  CWriteXY(22,9,Get(Defense));
END;


{ A }PROCEDURE DO_CHARM;    {VERIFIED 05/07/07}
BEGIN
  TCEdit.Charm:=
    PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Points Change',TCEdit.Adoptions,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,9,Replicate(8,' '));
  CWriteXY(58,9,Get(Charm));
END;


{ B }PROCEDURE DO_FOREST;      {VERIFIED 05/07/07}
BEGIN
  TCEdit.Forest:=
    PromptNum(0,0,'Enter # of Forest Fights (0-16,000)?',' Forest Fights Change', TCEdit.Forest,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,10,Replicate(4,' '));
  CwriteXY(22,10,Get(Forest));
END;


{ C }PROCEDURE DO_GEMS;      {VERIFIED 05/07/07}
BEGIN
  TCEdit.Gems:=
    PromptNum(0,0,'Enter # of Gems (0-16,000)?',' Gems Change', TCEdit.Gems,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(58,10,Replicate(4,' '));
  CwriteXY(58,10,Get(Gems));
END;


{ D }PROCEDURE DO_GOLD;               {VERIFIED 05/07/07}
BEGIN
  TCEdit.Gold:=
    PromptNum(0,0,'Enter Gold Found/Lost (0-1 Billion)?',' Gold Found/Lost Change', TCEdit.Gold,0,OneBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,11,Replicate(14,' '));   ;  {01/30/08: changed 12 to 14. cover negative # resets}
  CwriteXY(22,11,Get(Gold));
END;


{ E }PROCEDURE DO_WISDOM;               {VERIFIED 05/07/07}
BEGIN
  TCEdit.Wisdom:=
    PromptNum(0,0,'Enter Wisdom Gained/Lost (0-1 Billion)?',' Wisdom Gained/Lost Change', TCEdit.Wisdom,0,OneBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,12,Replicate(12,' '));  {11/17/07: changed 6 to 12}
  CwriteXY(22,12,Get(Wisdom));
END;


{ No point in having Delete Player in this IGM. DeletePlayer process was removed. }

{ note: To use Y, N responses via keyboard, one has to use
  the ALT key. Or simply use the mouse to click on the option wanted. }


{ * }PROCEDURE DO_NEW_DAY;     {VERIFIED 05/07/07}
BEGIN
  CWGotoXY(5,24);
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

  IF (TCEdit.PlayNum > 160) THEN
    BEGIN
      TCEdit.PlayNum:= 160;
      PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Visits > 0 THEN
    BEGIN
      TCEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Adoptions < 0 THEN
    BEGIN
      TCEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Reset negative Adoptions field to Zero.');
    END;

  IF TCEdit.Adoptions > 0 THEN
    BEGIN
      TCEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Resetting the Adoptions field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Lays < 0 THEN
    BEGIN
      TCEdit.Lays:= 0;
      PromptOK('Advisory:',' Reset negative Lay Points field to Zero.');
    END;

  IF TCEdit.Lays > 0 THEN
    BEGIN
      TCEdit.Lays:= 0;
      PromptOK('Advisory:',' Resetting the Lay Points field to Zero.');
    END;

  { --------------------------------------------------- }
  TCEdit.Fairy_Rescue:= FALSE;

  { --------------------------------------------------- }
  IF TCEdit.HitMax < 0 THEN
    BEGIN
      TCEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative HitMax Points field to Zero.');
    END;

  IF TCEdit.HitMax > 0 THEN
    BEGIN
      TCEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the HitMax Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Strength < 0 THEN
    BEGIN
      TCEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TCEdit.Strength > 0 THEN
    BEGIN
      TCEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Defense < 0 THEN
    BEGIN
      TCEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TCEdit.Defense > 0 THEN
    BEGIN
      TCEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Charm < 0 THEN
    BEGIN
      TCEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TCEdit.Charm > 0 THEN
    BEGIN
      TCEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Forest < 0 THEN
    BEGIN
      TCEdit.Forest:= 0;
      PromptOK('Advisory:',' Reset negative Forest Fights field to Zero.');
    END;

  IF TCEdit.Forest > 0 THEN
    BEGIN
      TCEdit.Forest:= 0;
      PromptOK('Advisory:',' Resetting the Forest Fights field to Zero.');
    END;
  { --------------------------------------------------- }

  IF TCEdit.Gems < 0 THEN
    BEGIN
      TCEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems field to Zero.');
    END;

  IF TCEdit.Gems > 0 THEN
    BEGIN
      TCEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting the Gems field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Gold < 0 THEN
    BEGIN
      TCEdit.Gold:= 0;
      PromptOK('Advisory:',' Reset negative Gold field to Zero.');
    END;

  IF TCEdit.Gold > 0 THEN
    BEGIN
      TCEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Gold field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TCEdit.Wisdom < 0 THEN
    BEGIN
      TCEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Gained/Lost field to Zero.');
    END;

  IF TCEdit.Wisdom > 0 THEN
    BEGIN
      TCEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting the Wisdom Gained/Lost field to Zero.');
    END;

END;     { DO_NEW_DAY  ================================== }


FUNCTION  MaxPlayers: WORD; { Gets the number of customer records }
BEGIN
  MaxPlayers:= 1;

  Editor_Path:= S2U(IGMDIR+DudePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MaxPlayers:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MaxPlayers  --------------------------------------------- }


FUNCTION GetRecordNum:STRING;
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MaxPlayers);
    { First record # displayed will be 1, not 0. }
END;     { GetRecordNum ---------------------------------------------- }


       {01/20/10: Changed ShowMenu to SHOW_MENU.}
PROCEDURE SHOW_MENU;
BEGIN
  ClrScr;

  CWriteln('`%    ** `$The Changeling''s `0Player Database Editor `!'+Version+' `%**');  {Line 1}
		 {Edited wording 01/17/10}

  CWriteln('`@    CHANPLAY.DAT `%Record Number: '+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
    CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);                 {Line 6}
    CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Kids Adopted  `%: '+Get(Adoptions));
          {09/29/07: Changed Kids to Adoptions.}
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
    CWrite('`#(`%6`#) `!Lay Points   `%: '+Get(Lays));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Fairy Rescue? `%: '+Get(FairyRescue));
          {09/29/07: Changed Rescue to FairyRescue.}
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
    CWrite('`#(`%8`#) `!Max HitPoints`%: '+Get(HitMax));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Strength Pts  `%: '+Get(Strength));
  { -------------------------------------------- }

  CWGotoXY(3,9);                 {Line 9}
    CWrite('`#(`%0`#) `!Defense Pts  `%: '+Get(Defense));

  CWGotoXY(38,9);
  CWriteLN('`#(`%A`#) `!Charm Points  `%: '+Get(Charm));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10}
    CWrite('`#(`%B`#) `!Forest Fights`%: '+Get(Forest));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Gems Found    `%: '+Get(Gems));
  { -------------------------------------------- }

  CWGotoXY(3,11);                 {Line 11}
  CWriteLn('`#(`%D`#) `!Gold Found   `%: '+Get(Gold));

  CWGotoXY(3,12);
  CWriteLN('`#(`%E`#) `!Wisdom Points`%: '+Get(Wisdom));
  { -------------------------------------------- }

  CWriteLn(' ');  {Blank Line, Line #13}

  { --------------------------------------------------------------- }
  CWGotoXY(3,14);
	 CWrite('`2(`0S`2) `%Search by Name');      {01/17/10 edit}

  CWGotoXY(40,14);
  CWriteln('`2(`0]`2) `%Advance One Record');
  { -------------------------------------------- }

  CWGotoXY(3,15);
    CWrite('`2(`0[`2) `%Back Up One Record');

  CWGotoXY(40,15);
  CWriteln('`2(`0*`2) `%Reset Player Stats');
  { -------------------------------------------- }

  CWGotoXY(3,16);      {Added 01/17/10}
  CWriteLn('`2(`0X`2) `%Delete Current Player');   {Added 01/17/10}
         {01/20/10: Changed "Delete Player Record" to "Delete Current Player".}

  CWriteln(' ');  {Blank Line, Line #17.}

  CWGotoXY(3,18);   {Edited 01/17/10}
  Cwrite('`$    Input key to change, or `%Q `$to Quit and Save.');

  IF Debug_Mode THEN    {Added 01/17/10: verified 2:20 am}
    CWrite('  `@[Debug Mode] ');

END;     { SHOW_MENU  ------------------------------------------------------ }


{ Added 01/17/10 using modified OT20EDIT.PAS code: }

{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 01/17/10: verified 2:20 am}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TCEdit.LordName+' known'
     +' as '+NoColor(TCEdit.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TCEdit.RealName:= 'X';
      TCEdit.LordName:= '* DELETED *';

      TCEdit.PlayNum:= 160;

        { Note: PlayNum 160 should not be in use by any valid players.}

      TCEdit.Visits:= 0;      {Enabled 05/10/08}

      TCEdit.Adoptions:= 0;
      TCEdit.Lays:= 0;

      TCEdit.HitMax:= 0;
      TCEdit.Strength:= 0;
      TCEdit.Defense:= 0;
      TCEdit.Charm:= 0;
      TCEdit.Forest:= 0;

      TCEdit.Gems:= 0;
      TCEdit.Gold:= 0;
      TCEdit.Wisdom:= 0;

      TCEdit.Fairy_Rescue:= FALSE;
      { ================================================= }

      WRITE_WARRIORS_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

      SHOW_MENU;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }


      {01/17/10: Changed menu key from X to S for Player Search.}
{ S }PROCEDURE DO_PLAYER_SEARCH;
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+DudePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no CHANPLAY.DAT file exists then we can't search }
     { and couldn't have made it to here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);
        {10/15/07: Renamed Search to SEARCH_PLAYER.}

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
       YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
           RecordNum:= Counter; { LORD Player # to display matches the counter }

           READ_WARRIORS_FILE;
           SHOW_MENU;
           Exit; { bail out of loop since we got who we want }
         END;
     END;

    Inc(Counter);
  UNTIL Counter=MaxPlayers;
      { End of repeat loop, repeats until we get }
      { to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;   { DO_PLAYER_SEARCH ====================================== }


PROCEDURE RUN_EDITOR;       {VERIFIED 05/07/07}
  VAR Code: CHAR;   {10/15/07: Renamed CH to Code.}
BEGIN
  SHOW_MENU;

  REPEAT
	 Code:= AInput('1234567890ABCDEQSX][*');
			 {01/17/10: Added S code for Player Search feature to use}

    CASE Code OF
      '1' : Do_RealName;

      '2' : Do_LordName;

      '3' : BEGIN               {Edited 07/22/07: VERIFIED 07/23/07}
              CWGotoXY(1,20);   {Show text on Line 20. 07/23/07 edit}

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see ');
              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
              DELAY(3000);

              IF Debug_Mode THEN   {Added 07/22/07: VERIFIED 07/23/07}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the `#Player Number `0field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(3000);

                  DO_PLAYER_NUMBER;
                END;

              SHOW_MENU;
            END;

      '4' : DO_VISITS;

      '5' : DO_ADOPTIONS;

      '6' : DO_LAYS;

      '7' : DO_FAIRY_RESCUE;

      '8' : DO_MAX_HITPOINTS;

      '9' : DO_STRENGTH;

      '0' : DO_DEFENSE;

      'A' : DO_CHARM;

      'B' : DO_FOREST;

      'C' : DO_GEMS;

      'D' : DO_GOLD;

      'E' : DO_WISDOM;

      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'S' : DO_PLAYER_SEARCH;
            {01/17/10: Changed from option X to S for Player_Search}

      { ------------------------ Added 01/17/10 --------------- }
		'X' : BEGIN               {Created 01/17/10: verified 2:20 am}
              CWGotoXY(1,20);   {Show text on Line 20}

              CWriteLn('  `0The `@Delete Player Record `0option is only usable when `$CHANEDIT ');
				  CWriteLn('  `0is executed in `%Debug Mode, `0using the `!/Debug `0parameter. ');
				  CWriteLn('  `!This option should only be used with `@EXTREME `!caution!!         ');
                      {01/20/10: rewrote wording of third line}

				  IF Debug_Mode THEN   {Created 01/17/10: verified 2:20 am}
					 BEGIN
						BLANK(1);
						CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is allowed ');
						CWriteLn('  `0to `#Delete this Record.  `0Do this only if absolutely necessary! ');
						DELAY(3000);

                  DO_PLAYER_DELETION;
                END;

              SHOW_MENU;
            END;

      ']' : BEGIN
              Inc(RecordNum);
              IF RecordNum > (MaxPlayers - 1) THEN RecordNum:= 0;  {05/07/04 edit}

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '[' : BEGIN
              IF RecordNum=0
                THEN RecordNum:= (MaxPlayers - 1)
                ELSE Dec(RecordNum);

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '*' : BEGIN
              DO_NEW_DAY;

              SHOW_MENU;

              WRITE_WARRIORS_FILE;
            END;

    END;       {CASE Code - ending}
  UNTIL Code = 'Q';
END;       { RUN_EDITOR ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;          {VERIFIED 05/07/07}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' The Changeling''s Player Database Editor Credits: ',
      'CHANEDIT.EXE '+Version+'.  Copyright 2007-2011 by Donald Tidmore. |'
            {12/21/09: updated copyright info for 2010.}

      +'** Dedicated to my friends Jason Brown and Charlie Wardick.  ** ||'

      {  +'** Compile Date:  '+Compile_Date+'.  ** Non-Beta development.  ||'  }

      +'v1.10 released officially on:  '+Release_Date+'  ||'
			 {Added 04/30/08}

      +'Database Path: '+Editor_Path);       {Compile_Date ends with period.}

			{ 09/29/07: Changed "Utility Path" to "Database Path". }
			{ 09/29/07: Changed Change_FN to Editor_Path. }
END; { EXIT_SCREEN ============================================ }


BEGIN    { Main CHANEDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Gold Tool-Kit process}
  UseLordColors:= TRUE;

  Debug_Mode:= FALSE;   {Added 07/22/07}

  IF S2U(ParamStr(1)) = '/DEBUG'  {Added 07/22/07}
    THEN Debug_Mode:= TRUE;

  ReadVars.ReadHelp:= NIL;  { removes the HELP button in the prompts. }   {Gold Tool-Kit process}

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
      {Gold toolkit process}

  RecordNum:= 0;

  IF Exist('CHANPLAY.DAX') THEN DeleteFile('CHANPLAY.DAX');

  READ_CONFIG;  {process existing CHANEDIT.cfg file.}

  Editor_Path:= S2U(IGMDIR+DudePlayer_FN);
		  {09/29/07: Changed Change_FN to Editor_Path.}

  IF Exist(Editor_Path) THEN READ_WARRIORS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0CHANEDIT `!could not locate the `@Changeling''s ');
      CWriteLn('  `#CHANPLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0CHANEDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);
      CWriteLn(' ');   {12/18/09}

      CWriteLn('  `#Problem Solving Note: `%Make sure the `!CHANEDIT.CFG `%file contains ');
                     {12/18/09: verified 12/30/09}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}

      CWriteLn(' ');    {12/18/09}
      CWriteLn('  `!Terminating `0CHANEDIT `!after 3 seconds delay.  ');

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { CHANEDIT.pas }


{ First stage code editing finished 01:28 am 05/07/2007. }

{ 03/10/09: Archived all old comments into ChgRemov.txt file. }

    { 04/30/08 note: All code in program is fully tested. }
    { v1.00 status: Officially released on Apr. 30th, 2008. }

    { 08/10/08: reopened CHANEDIT for short term development. }
    { v1.10 status: Officially released on Mar. 10th, 2009. }

