PROGRAM CONVBANK;   {Created for me by Stephen Gibbs Oct. 2005}

USES Crt,Dos;       {Released v1.20 on Sept. 18th, 2007.}

     {$I BankVars.inc}    {February 2009 non-beta edit}
{ ======================================================== }

CONST Compile_Date: STRING = 'September 18, 2007.';

      Release_Date: STRING = 'September 18th, 2007.';  {07/12/07}

      VersionC: STRING = 'v1.20';
    { ======================================================== }

{ ========== Added 01/26/2007 ========== v1.50 IGM structure: }
TYPE OLD_BANK_PLAYER = RECORD
       RealName      : STRING[50];  { player's real name. used for verification }
       LordName      : STRING[20];  { LORD Name}
       PlayNum       : BYTE;        { Player Number - used as Index field}
       Visits        : BYTE;        { how many visits to IGM made today }
       Deposits      : LONGINT;     { Gold Deposited today. }
       WithDrawn     : LONGINT;     { Gold Withdrawn today. }
       GoldBank      : LONGINT;     { Amount player has in Gold account. }
       Gold_Int      : LONGINT;     { Gold Interest received today by customer. }
       Gems_Deposits : LONGINT;     { 10/14/04: Total gems deposited today. }
       Gems_Withdrawn: LONGINT;     { 10/14/04: Total gems withdrawn today. }
       GemsBank      : LONGINT;     { 10/14/04: Gems in Bank account }
       Paid_Interest : BOOLEAN;     { 10/14/04: Was Gold Interest paid today? }
       Gems_TCount   : BYTE;        { 07/11/05: Gems Transfers Counter. }
       Gold_TCount   : BYTE;        { 07/11/05: Gold Transfers Counter. }
       Gems_Transfers: LONGINT;     { 07/11/05: Gems Transfers Amount. }
       Gold_Transfers: LONGINT;     { 07/11/05: Gold Transfers Amount. }
       Charm         : INTEGER;     { 07/11/05: Charm gained/lost from Flirting. }
       Flirt_Gordon  : BOOLEAN;     { 07/18/05: Has player flirted with Gordon today? }
       Flirt_Sam     : BOOLEAN;     { 07/18/05: Has player flirted with Samantha today? }
       Wisdom        : LONGINT;     { 07/18/05: Wisdom gained/lost from flirting.}
     END;  {RECORD}               { Used with Banking_File, TBank }
    { ============================================================================== }

CONST chr254 = chr(254);
    { ======================================================== }

VAR Old_Data_File, New_Warriors_File: FILE;

    Old_BankRec : Old_Bank_PLayer;
    New_BankRec : Bank_Player;

    Records_Count      : WORD;

    Bank_Path  : STRING[128];          { Added 11/22/05 }

    OldFile_FN : STRING;  {11/22/05: Path/filename for KB15PLAY.DAT.}

    BankPlay_FN : STRING;  {11/22/05: Path/filename for new BANKPLAY.DAT File.}

    Skip_Count: BYTE;      { 01/31/07: Total Skipped records. }
    Valid_Count: BYTE;     { 01/31/07: Total Records Converted. }

    Skip_Record: BOOLEAN;  { Skip writing current record to database?  01/31/07}
    { ======================================================== }


   { Added EXIST, Local_Pause from CONVHITS.PAS 11/22/05 }

FUNCTION  Exist(Filename:STRING):boolean;    {returns true if file exists}
  VAR Inf: SearchRec;                    {Copied from Chaswigm.pas library unit 10/21/05}
BEGIN
  Findfirst(Filename,AnyFile,Inf);
  Exist := (DOSError = 0);
end; { Exist ======================================================================= }


PROCEDURE LOCAL_PAUSE;
  VAR MKey: CHAR;
BEGIN;                     { For Local mode screen usage only. }
  WriteLn('     <PAUSE> ');
  MKey:= ReadKey;          { Readkey: not usable remotely. }
END;   { LOCAL_PAUSE ===================================================== }


{ Added from Chasware.pas 01/31/07. Permanent usage }
{ --------------------------------------------------------- }
FUNCTION  s2u(s:STRING):STRING;{string to all uppercase}
VAR x  : Integer;
	 Len: BYTE ABSOLUTE s;
BEGIN
  FOR x:=1 TO Len DO S[x] := UpCase(s[x]);
  s2u:=s;
END;  { S2U ===================================================== }


(*  {Disabled 01/31/07. not currently needed}
FUNCTION  N2S(n:LongInt):STRING;{number to string - same as angel int2str}
VAR v: STRING;             {Added for temp usage 01/28/07}
BEGIN
  Str(n,v);
  N2S:=v;
END;{n2s}   *)


(*  {Disabled 01/31/07. not currently needed}
FUNCTION  Comma(FS:LongInt):STRING;{returns longint input as string with commas inserted}
VAR Count:Byte;                 {Added for temp usage 01/28/07}
    NS:STRING;
    NFS:STRING;
BEGIN
  NFS:=n2s(FS);
  NS:='';
  FOR Count:=1 TO Length(NFS) DO
  BEGIN
   IF ((((Length(NFS)-Count) MOD 3)=0) AND (Length(NFS)<>Count)) THEN NS:=NS+NFS[Count]+',' ELSE NS:=NS+NFS[Count];
  END;
  Comma:=NS;
END;{Comma}   *)


BEGIN
  clrscr;

  Records_Count := 0;  {01/31/07: Renamed Count to Records_Count.}

  Valid_Count:= 0;    {01/31/07: Initialize Records Converted Counter}
  Skip_Count:= 0;     {01/31/07: Initialize Skipped Records Counter.}

  WriteLn(' ');
  WriteLn(chr254 + ' Running K.L.BANK v1.50 to v1.60/v1.70 Database Conversion Utility.');
      {01/26/07. Edited 09/17/07}

  WriteLn(chr254 + ' CONVBANK.EXE '+VersionC+':  Compile Date:  '+Compile_Date);
  WriteLn(chr254 + ' ** CONVBANK v1.20 was officially released on:  '+Release_Date);  {09/17/07 edit}

  WriteLn(' ');
  WriteLn(chr254 + ' CONVBANK.EXE reads your KB15PLAY.DAT file, and converts its ');   {edited 01/31/07}
  WriteLn(chr254 + ' records to use KLBank v1.70''s''s player database format.  ');    {edited 01/31/07}
  WriteLn(chr254 + ' It writes them to the IGM''s new database file BANKPLAY.DAT. ');  {edited 01/31/07}

  WriteLn(chr254 + ' Deleted records are NOT written to the new file.');    {added 01/31/07}

  WriteLn(' ');
  WriteLn(chr254 + ' Searching now for an KB15PLAY.DAT File to process.');

  Bank_Path:= Copy(ParamStr(0),1,Length(ParamStr(0))-12);
      { Subtracts 12 to delete the "CONVBANK.EXE" part. }

  OldFile_FN:= Bank_Path+'KB15PLAY.DAT';
      {01/31/07: Renamed Database_FN to OldFile_FN.}

  BankPlay_FN:= Bank_Path+'BANKPLAY.DAT';

  WriteLn(chr254 + '   Looking in directory: '+Bank_Path);
  WriteLn(chr254 + '   Searching for file:   '+OldFile_FN);
  WriteLn(' ');

  IF NOT Exist(OldFile_FN) THEN  {Can not find the KB15PLAY.DAT File}
    BEGIN
      WriteLn(chr254 + ' ERROR:  Could Not Find Kiteria''s LORD Bank Database File ...');
      WriteLn(chr254 + ' The file KB15PLAY.DAT is missing from this directory.');
      WriteLn(' ');

      WriteLn(chr254 + ' To use CONVBANK to convert your v1.50 BANKPLAY.DAT File ');   {01/26/07}
      WriteLn(chr254 + ' into a new BANKPLAY.DAT file, which is compatible with ');
      WriteLn(chr254 + ' Kiteria''s LORD Bank v1.70, rename your existing ');     {01/26/07. Edited 09/17/07}
      WriteLn(chr254 + ' BANKPLAY.DAT File to KB15PLAY.DAT.  Then re-run CONVBANK. '); {01/26/07}
      WriteLn(' ');

      HALT(1);
    END;            {VERIFIED}

  WriteLn(chr254 + ' Located KB15PLAY.DAT File. Processing database records now.');
  WriteLn(chr254 + '   Creating file:  '+BankPlay_FN);
  WriteLn(' ');

  WriteLn(chr254 + '  CONVBANK.EXE will pause screen after displaying each batch of ');  {edited 01/31/07}
  WriteLn(chr254 + '  20 records, so user can monitor the records processed. Records '); {edited 01/31/07}
  WriteLn(chr254 + '  with no valid LORD Character AND Real Names are NOT converted.');  {edited 01/31/07}

  WriteLn(' ');
  WriteLn(chr254 + '    Four seconds delay for time to read above text.');   {01/31/07}

  WriteLn(' ');
  DELAY(4000);   {01/31/07: Changed delay from 2 to 4 seconds.}

  { 11/22/05: Replaced old FindFirst code block. }

  FileMode := 64;

  ASSIGN(Old_Data_File,'KB15PLAY.DAT');
  RESET(Old_Data_File,SizeOf(Old_BankRec));

  ASSIGN(New_Warriors_File,'BANKPLAY.DAT');
  REWRITE(New_Warriors_File,SizeOf(New_BankRec));

       {01/31/07: Renamed Old_Database_File to Old_Data_File.}
       {01/31/07: Renamed New_Database_File to New_Warriors_File.}

  WHILE NOT EOF (Old_Data_File) DO
    BEGIN
      BlockRead(Old_Data_File,Old_BankRec,1);

      WITH Old_BankRec DO
        BEGIN
          INC(Records_Count);

          WriteLn(chr254 + '   Processing old record of '+LordName);

          New_BankRec.RealName       := RealName;
          New_BankRec.LordName       := LordName;
          New_BankRec.PlayNum        := PlayNum;
          New_BankRec.Visits         := Visits;
          New_BankRec.Gems_TCount    := Gems_TCount;     {Relocated VAR. 01/26/07}
          New_BankRec.Gold_TCount    := Gold_TCount;     {Relocated VAR. 01/26/07}
          New_BankRec.Charm          := Charm;           {Relocated VAR. 01/26/07}

          New_BankRec.Gems_Int       := 0;               {New/Relocated VAR. 01/26/07}

          New_BankRec.Gold_Int       := Gold_Int;        {Relocated VAR. 01/26/07}
          New_BankRec.Gems_Deposits  := Gems_Deposits;   {Relocated VAR. 01/26/07}
          New_BankRec.Gems_Withdrawn := Gems_WithDrawn;  {Relocated VAR. 01/26/07}

          New_BankRec.Gold_Deposits  := Deposits;        {Renamed VAR. 01/26/07}
          New_BankRec.Gold_WithDrawn := WithDrawn;       {Renamed VAR. 01/26/07}

          New_BankRec.Gems_Transfers := Gems_Transfers;  {Relocated VAR. 01/26/07}
          New_BankRec.Gold_Transfers := Gold_Transfers;  {Relocated VAR. 01/26/07}

          New_BankRec.GemsBank       := GemsBank;        {Relocated VAR. 01/26/07}
          New_BankRec.GoldBank       := GoldBank;        {Relocated VAR. 01/26/07}
          New_BankRec.Wisdom         := Wisdom;          {Relocated VAR. 01/26/07}

          New_BankRec.Flirt_Gordon   := Flirt_Gordon;    {Relocated VAR. 01/26/07}
          New_BankRec.Flirt_Sam      := Flirt_Sam;       {Relocated VAR. 01/26/07}

          New_BankRec.Paid_CharmTax  := FALSE;           {New VAR. 01/26/07. edited 01/28/07}
          New_BankRec.Paid_GemsInt   := FALSE;           {New VAR. 01/26/07}

          New_BankRec.Paid_GoldInt   := Paid_Interest;   {Renamed/Relocated VAR. 01/26/07}

          (*  {Disabled after testing use 08:12 pm 01/29/2007.}
          { =================================================== }
          WriteLn(chr254 + ' LordName:  '+LordName+'  GoldBank:  '+COMMA(GoldBank));  {01/28/07 debug}
          WriteLn(chr254 + '   GemsBank:  '+COMMA(GemsBank)+'  Gems_Int:  '+COMMA(New_BankRec.Gems_Int));  {01/28/07 debug}
          DELAY(1500);    {01/28/07 debug}
          WriteLn(' ');  {01/28/07 debug}
          { =================================================== }   *)
        END;   {With Old_BankRec - ending}

      { -------------------------------------------------- }
      IF (S2U(Old_BankRec.RealName) = 'X')           {Added 01/31/07: untested}
         AND (S2U(Old_BankRec.LordName) = 'X') THEN
        BEGIN
          Skip_Record:= TRUE;
          INC(Skip_Count);
        END
      ELSE
        BEGIN                    {01/31/07 code: untested}
          Skip_Record:= FALSE;
          INC(Valid_Count);
        END;

      IF NOT Skip_Record THEN     {01/31/07 code}
        BlockWrite(New_Warriors_File,New_BankRec,1);
      { -------------------------------------------------- }

         { 11/22/05: Pause screen after each 20 records }
      IF Records_Count = 20 THEN Local_Pause;
      IF Records_Count = 40 THEN Local_Pause;
      IF Records_Count = 60 THEN Local_Pause;
      IF Records_Count = 80 THEN Local_Pause;
      IF Records_Count = 100 THEN Local_Pause;
      IF Records_Count = 120 THEN Local_Pause;
      IF Records_Count = 140 THEN Local_Pause;
    END;  {WITH - ending}

  CLOSE(Old_Data_File);
  CLOSE(New_Warriors_File);

  { ------------------- Replaced code 01/31/07 --------------- }
  WriteLn(' ');
  WriteLn(chr254 + '  FINISHED:  Processed ',Records_Count,' old database records.');
  Writeln(' ');

  IF Skip_Count > 0 THEN    {Show only if records were skipped}
    BEGIN
      WriteLn(chr254 + '  NOTES:  Skipped writing ',Skip_Count,' database records which ');
      WriteLn(chr254 + '          do not belong to valid users of the IGM.');
      WriteLn(' ');
    END;

  WriteLn(chr254 + '  SUMMARY: Converted ',Valid_Count,' old database records from KB15PLAY.DAT ');  {01/31/07}
  WriteLn(chr254 + '           file, and wrote them to the new BANKPLAY.DAT file.');  {01/31/07}
  WriteLN(' ');
  { --------------------------------------------------------- }

  WriteLn(chr254 + ' CONVBANK.EXE '+VersionC+': Copyright 2005-2009 by Donald Tidmore.');  {01/26/07}

  WriteLn(' ');            {Added version. 11/22/05}

  HALT(0);   {Added 01/31/07}
END.  {Ending of CONVBANK.PAS program }

{ 09/17/07: Switched program name back to CONVBANK.EXE from }
{ CONVKB11.EXE/PAS;  archived old comments to kb-remov.txt file. }

{ Fixed indentation, entire file, 03:38 pm 11/22/05 }

