PROGRAM CONVLORE;   {Created on Apr. 06, 2006. }

USES Crt, Dos;       {v1.10 officially released Dec. 28th, 2007}

     {$I ROLVARS.INC}      {February 2009 non-beta edit}
{ ======================================================== }

CONST Compile_Date: STRING = 'December 28, 2007.';

      Release_Date: STRING = 'December 28th, 2007.';  {12/28/07}

      VersionC: STRING = 'v1.10';
   { ======================================================== }

TYPE OLD_LORE_PLAYER = RECORD    { Used 03/15/2006 Layout }
       RealName     : STRING[50];   { player's real name. used for verification }
       LordName     : STRING[20];   { LORD Name}
       PlayNum      : BYTE;         { 03/15/06: Player Number - used as Index field}
       Visits       : BYTE;         { 03/15/06: Visits made to IGM today. }
       Adoptions    : BYTE;         { 03/15/06: Kids adopted today. }
       Enemy_Kills  : BYTE;         { # of monsters/campers killed today}
       Igm_Fights   : BYTE;         { 03/15/06: # of Realm fights unused today  }
       Skill_Pts    : BYTE;         { 03/15/06: Skill Points gained }
       HitMax       : INTEGER;      { 03/15/06: Max Hit-points}
       Strength     : INTEGER;      { 03/15/06: Strength points}
       Defense      : INTEGER;      { 03/15/06: Defense points }
       Charm        : INTEGER;      { 03/15/06: Charm points}
       Gems         : INTEGER;      { 03/15/06: Gems gained/lost }
       Potions      : INTEGER;      { Number of healing potions  }
       Gold         : LONGINT;      { 03/15/06: Gold Coins }
       Wisdom       : LONGINT;      { 03/15/06: Exp. Points "Wisdom" }
       TGems        : LONGINT;      { 03/15/06: Gems invested in Treasury  }
       TGold        : LONGINT;      { Gold invested in Treasury  }
       Who_Attack   : STRING[20];   { who attacked the camper? }
       Camp_Attack  : BOOLEAN;      { was player attacked in their camp today?  }
       Camp_Dead    : BOOLEAN;      { Did player win or lose camp fight?  }
       Dead         : BOOLEAN;      { Did player Die in IGM fight today? }
       OldMan_Fight : BOOLEAN;      { did player fight the old man?  }
       Sleeping     : BOOLEAN;      { Is player camping (sleeping) in a Realm?  }
       Next_Time    : WORD;         { Day # of next game play (will revive stats)  }
     END;                      {Enabled 05/01/07}

CONST chr254 = chr(254);
	 { ======================================================== }

VAR Old_Data_File, New_Warriors_File: FILE;

    Old_Rec : OLD_LORE_PLAYER;    {12/09/06: uses 03/15/06 format}
    New_Rec : REALM_PLAYER;       {12/09/06: uses 12/09/06 format}

    Records_Count: BYTE;  {12/09/06: Total records processed.}
    Skip_Count: BYTE;     {12/09/06: Total Skipped records.}
    Valid_Count: BYTE;    {12/09/06: Total Records Converted.}

    Realm_Path  : STRING[128];

    OldFile_FN : STRING;  { Path/filename for ROLP192.DAT.}

    ROLPLAY_FN : STRING;  { Path/filename for new ROLPLAY.DAT File.}

    Skip_Record: BOOLEAN;  { Skip writing current record to database? }
    { ======================================================== }

FUNCTION  Exist(Filename:STRING):boolean;    {returns true if file exists}
  VAR Inf: SearchRec;                    {Copied from Chaswigm.pas library unit 10/21/05}
BEGIN
  Findfirst(Filename,AnyFile,Inf);
  Exist := (DOSError = 0);
END; { Exist ================================================= }


{ Added from Chasware.pas 02/02/07. Permanent usage }
{ --------------------------------------------------------- }
FUNCTION  s2u(s:STRING):STRING;{string to all uppercase}
VAR x  : Integer;
	 Len: BYTE ABSOLUTE s;
BEGIN
  FOR x:=1 TO Len DO S[x] := UpCase(s[x]);
  s2u:=s;
END;  { S2U ===================================================== }


PROCEDURE LOCAL_PAUSE;
  VAR MKey: CHAR;
BEGIN;                     { For Local mode screen usage only. }
  WriteLn('     <PAUSE> ');
  MKey:= ReadKey;          { Readkey: not usable remotely. }
END;   { LOCAL_PAUSE ===================================================== }


BEGIN
  clrscr;

  Records_Count:= 0;  { Initialize Total Records Processed Counter}
  Valid_Count:= 0;    { Initialize Total Records Converted Counter}
  Skip_Count:= 0;     { Initialize Total Skipped Records Counter.}

  WriteLn(' ');
  WriteLn(chr254 + '  Running R.O.L. v1.92-v2.00 Player Database Conversion Utility.');  {12/09/06}

  WriteLn(' ');

  WriteLn(chr254 + '  CONVLORE.EXE '+VersionC+':  Compile Date:  '+Compile_Date);

  WriteLn(chr254 + '  `$'+VersionC+' `!Officially released on `0'+Release_Date);   {12/28/07}

  WriteLn(' ');
  WriteLn(chr254 + '  CONVLORE.EXE reads your ROLP192.DAT file, and converts its ');
  WriteLn(chr254 + '  records to use ROL v2.00''s player database format.  It ');
  WriteLn(chr254 + '  writes them to the IGM''s new database file ROLPLAY.DAT. ');

  WriteLn(chr254 + '  Deleted records are NOT written to the new file.'); {added 01/31/07}

  WriteLn(' ');
  WriteLn(chr254 + '  Searching now for an ROLP192.DAT File to process.');

  Realm_Path:= Copy(ParamStr(0),1,Length(ParamStr(0))-12);
		{ Subtracts 12 to delete the "CONVLORE.EXE" part. }

  OldFile_FN:= Realm_Path+'ROLP192.DAT';   {12/09/06}

  ROLPLAY_FN:= Realm_Path+'ROLPLAY.DAT';   {12/09/06}

  WriteLn(chr254 + '    Looking in directory: '+Realm_Path);         {12/09/06}
  WriteLn(chr254 + '    Searching for file:   '+OldFile_FN);       {12/09/06}
  WriteLn(' ');

  IF NOT Exist(OldFile_FN) THEN  {Can not find the ROLP192.DAT File}
    BEGIN
      WriteLn(chr254 + '  ERROR:  Could Not Find the Realm of Lore Database File ...');
      WriteLn(chr254 + '  The file ROLP192.DAT is missing from this directory.');
      WriteLn(' ');

      WriteLn(chr254 + '  To use CONVLORE to convert your ROL2PLAY.DAT file ');
      WriteLn(chr254 + '  into a new database file, needed by ROL v1.94+ betas ');    {12/09/06}
      WriteLn(chr254 + '  and ROL v2.00, rename your current database file ');
      WriteLn(chr254 + '  to ROLP192.DAT.  Then re-run CONVLORE again. ');

      WriteLn(' ');
      WriteLn(chr254 + '  WARNING: ** This WILL OVER-WRITE any existing ROLPLAY.DAT file!! **'); {12/09/06}
      WriteLn(chr254 + '  Use ROL2EDIT.EXE v1.10 to verify all new records.  ');

      WriteLn(' ');

      HALT(1);
    END;

  WriteLn(chr254 + '  Located ROLP192.DAT File. Processing database records now.');  {12/09/06}
  WriteLn(chr254 + '    Creating file:  '+ROLPLAY_FN);
  WriteLn(' ');

  WriteLn(chr254 + '  CONVLORE.EXE will pause screen after displaying each batch of ');
  WriteLn(chr254 + '  20 records, so user can monitor the records processed. Records ');  {12/09/06}
  WriteLn(chr254 + '  with no valid LORD Character AND Real Names are NOT converted.');   {12/09/06}

  WriteLn(' ');            {12/09/06}
  WriteLn(chr254 + '    Four seconds delay for time to read above text.');  {11/18/06}

  WriteLn(' ');
  DELAY(4000);   {01/31/07: Dropped delay from 5 to 4 seconds.}

  FileMode:= 64;

  ASSIGN(Old_Data_File,'ROLP192.DAT');
  RESET(Old_Data_File,SizeOf(Old_Rec));

  ASSIGN(New_Warriors_File,'ROLPLAY.DAT');
  REWRITE(New_Warriors_File,SizeOf(New_Rec));

  WHILE NOT EOF (Old_Data_File) DO
    BEGIN
      BlockRead(Old_Data_File,Old_Rec,1);

      WITH Old_Rec DO
        BEGIN
          INC(Records_Count);     { Total Records processed counter}

          WriteLn(chr254 + '   Processing old record of '+LordName+'.  Record #', Records_Count);

          New_Rec.RealName       := RealName;
          New_Rec.LordName       := LordName;
          New_Rec.PlayNum        := PlayNum;        {added 12/09/06}
          New_Rec.Visits         := Visits;         {added 12/09/06}
          New_Rec.Adoptions      := Adoptions;      {added 12/09/06}

          New_Rec.Enemy_Kills    := Enemy_Kills;    {moved to here 12/09/06}
          New_Rec.IGM_Fights     := IGM_Fights;     {moved to here 12/09/06}

          New_Rec.Skill_Pts      := Skill_Pts;    {added 12/09/06}
          New_Rec.HitMax         := HitMax;       {added 12/09/06}
          New_Rec.Strength       := Strength;     {added 12/09/06}
          New_Rec.Defense        := Defense;      {added 12/09/06}
          New_Rec.Charm          := Charm;        {added 12/09/06}
          New_Rec.Gems           := Gems;         {added 12/09/06}
          New_Rec.Potions        := Potions;      {added 12/09/06}
          New_Rec.Gold           := Gold;         {added 12/09/06}
          New_Rec.Wisdom         := Wisdom;       {added 12/09/06}

          New_Rec.TGems          := TGems;        {moved to here 12/09/06}
          New_Rec.TGold          := TGold;        {moved to here 12/09/06}
          New_Rec.Who_Attack     := Who_Attack;   {moved to here 12/09/06}
          New_Rec.Camp_Attack    := Camp_Attack;  {moved to here 12/09/06}
          New_Rec.Camp_Dead      := Camp_Dead;    {moved to here 12/09/06}
          New_Rec.Dead           := Dead;         {moved to here 12/09/06}
          New_Rec.OldMan_Fight   := OldMan_Fight; {moved to here 12/09/06}
          New_Rec.Sleeping       := Sleeping;     {moved to here 12/09/06}

          New_Rec.Next_Time      := Next_Time;    {moved to here 12/09/06}
          { -------------------------------------- }

          { Incorporate new numeric/Boolean Database variables: }
          New_Rec.Pellets        := 0;
          New_Rec.Gems_Int       := 0;
          New_Rec.Gold_Int       := 0;

          New_Rec.Paid_GemsInt   := FALSE;
          New_Rec.Paid_GoldInt   := FALSE;
          New_Rec.Fairy_Rescue   := FALSE;
        END;  {With Old_Rec - ending}

      IF (S2U(Old_Rec.RealName) = 'X')
         AND (S2U(Old_Rec.LordName) = 'X') THEN
        BEGIN
          Skip_Record:= TRUE;
          INC(Skip_Count);
        END
      ELSE
        BEGIN
          Skip_Record:= FALSE;
          INC(Valid_Count);

          (*   { 12/09/06: temporary debug code statement. Verified usage }
              WriteLn(chr254 + ' TGold:  '+COMMA(Old_Rec.TGold)+'.  TGems:  '+COMMA(Old_Rec.TGems));
              DELAY(2000);          *)
        END;

      IF NOT Skip_Record THEN
        BlockWrite(New_Warriors_File,New_Rec,1);

           {  Pause screen after each 20 records }
      IF Records_Count = 20 THEN Local_Pause;
      IF Records_Count = 40 THEN Local_Pause;
      IF Records_Count = 60 THEN Local_Pause;
      IF Records_Count = 80 THEN Local_Pause;
      IF Records_Count = 100 THEN Local_Pause;
      IF Records_Count = 120 THEN Local_Pause;
      IF Records_Count = 140 THEN Local_Pause;
    END;  {WITH - ending}

  CLOSE(Old_Data_File);
  CLOSE(New_Warriors_File);

  WriteLn(' ');
  WriteLn(chr254 + '  FINISHED:  Processed ',Records_Count,' old database records.');
  Writeln(' ');

  IF Skip_Count > 0 THEN    {Show only if records were skipped}
    BEGIN
      WriteLn(chr254 + '  NOTES:  Skipped writing ',Skip_Count,' database records which ');
      WriteLn(chr254 + '          do not belong to valid users of the IGM.');
      WriteLn(' ');
    END;

  WriteLn(chr254 + '  SUMMARY: Converted ',Valid_Count,' old database records from ROLP192.DAT ');  {12/09/06}
  WriteLn(chr254 + '           file, and wrote them to the new ROLPLAY.DAT file.');  {12/09/06}
  WriteLN(' ');

  WriteLn(chr254 + '  CONVLORE.EXE '+VersionC+': Copyright 2006-2009 by Donald Tidmore.');
  WriteLn(' ');

  HALT(0);
END.  {Ending of CONVLORE.PAS program }

       { Officially released v1.00 on Nov. 18, 2006.}
       { Created v1.10 on Dec. 09, 2006. }


