PROGRAM CONVOUTS;   {Created on May 21th, 2008. }

USES Crt, Dos, Chasware;
        {added Chasware 05/26/2008. Access to N2S etc}

     {$I OUTVARS2.INC}     {January 2011 Non-beta development}
{ ======================================================== }

CONST VersionC: STRING = 'v1.00';

      Compile_Date: STRING[22] = 'December 25, 2010.';

      Release_Date: STRING[24] = 'December 25th, 2010.';  {12/31/09}

          {07/16/09: v0.87.  10/08/09: v0.88 beta}
          {10/20/09: v0.90 beta used.  11/01/09: v1.100, non-beta}
   { ======================================================== }

TYPE TAVERN16_PLAYER = RECORD    { Uses v1.60 layout }
       Real_Name:   STRING[50];   { Player's real name: used for verification }
       Drunk_Meter: SHORTINT;     { How drunk are they? }
       Captured:    BOOLEAN;      { Is Player in the Dungeon? }
       Dance:       BOOLEAN;      { Has Player danced yet? }
       DrinkPunch:  BOOLEAN;      { Has Player drunk the punch yet? }
       Sleeping:    BOOLEAN;      { Is Player Sleeping here? }
       Switch_Muse: BOOLEAN;      { Has Player switched music? }
       UnderAttack: BOOLEAN;      { Is sleeping player under attack currently? 11/22/03 }
       UsedBack:    BOOLEAN;      { Has Player used the Back room (Kitchen)? }
       FairyFood:   BOOLEAN;      { Has player bought Fairy Food yet? }
       Cocktail     : BOOLEAN;     { 01/26/05: Has player bought Red Dragon Cocktail yet? }
       LordName     : STRING[20];  { 01/26/05: player's LORD Name }
       Skill_Points : BYTE;        { 01/26/05: # of Skill Points gained today. }
       HitMax       : INTEGER;     { 01/26/05: Max HitPoints  }
       Strength     : INTEGER;     { 01/26/05: Strength Points  }
       Defense      : INTEGER;     { 01/26/05: Defense Points  }
       Charm        : INTEGER;     { 01/26/05: Charm points  }
       Gems         : INTEGER;     { 01/26/05: Gems }
       Forest       : INTEGER;     { 01/26/05: Forest Fights }
       Wisdom       : LONGINT;     { 01/26/05: Experience points }
       Gold         : LONGINT;     { 01/26/05: Gold Coins  }
       Adoptions    : INTEGER;     { 02/02/05: Kids adopted/lost today }
     END;    {Usage of this format ended on 05/26/2008.}

{ Accessed from OUTVARS2.INC file: TAVERN_PLAYER structure }
{ is using OUT2PLAY.DAT file for awhile, until I am ready }
{ to switch to OUTSPLAY.DAT sometime in Fall 2008. }
{ ================================================ }


CONST chr254 = chr(254);
	 { ======================================================== }

VAR Old_Data_File, New_Customers_File: FILE;

    Old_Rec : TAVERN16_PLAYER;    {05/21/08}
    New_Rec : TAVERN_PLAYER;       {05/21/08}

    Records_Count: BYTE;  {05/21/08: Total records processed.}
    Skip_Count: BYTE;     {05/21/08: Total Skipped records.}
    Valid_Count: BYTE;    {05/21/08: Total Records Converted.}

    Tavern_Path  : STRING[128];

    OldFile_FN : STRING;  { Path/filename for OUTS166.DAT.}

    Out2Play_FN : STRING;  { Path/filename for new OUT2PLAY.DAT File.}

    Skip_Record: BOOLEAN;  { Skip writing current record to database? }
    { ======================================================== }

    {05/26/08: Removed EXIST, S2U Procs. Access from Chasware.pas Unit}

(*
FUNCTION  Exist(Filename:STRING):boolean;    {returns true if file exists}
  VAR Inf: SearchRec;                    {Copied from Chaswigm.pas library unit 10/21/05}
BEGIN
  Findfirst(Filename,AnyFile,Inf);
  Exist := (DOSError = 0);
END; { Exist ================================================= }   *)


(*  { Added from Chasware.pas 02/02/07. Permanent usage }
{ --------------------------------------------------------- }
FUNCTION  s2u(s:STRING):STRING;{string to all uppercase}
VAR x  : Integer;
	 Len: BYTE ABSOLUTE s;
BEGIN
  FOR x:=1 TO Len DO S[x] := UpCase(s[x]);
  s2u:=s;
END;  { S2U ===================================================== }  *)


PROCEDURE LOCAL_PAUSE;
  VAR MKey: CHAR;
BEGIN;                     { For Local mode screen usage only. }
  WriteLn('     <PAUSE> ');
  MKey:= ReadKey;          { Readkey: not usable remotely. }
END;   { LOCAL_PAUSE ===================================================== }


BEGIN
  clrscr;

  Records_Count:= 0;  { Initialize Total Records Processed Counter}
  Valid_Count:= 0;    { Initialize Total Records Converted Counter}
  Skip_Count:= 0;     { Initialize Total Skipped Records Counter.}

  WriteLn(' ');
  WriteLn(chr254 + '  Running O.T. v1.6 to v1.67.7 Beta Player Database Conversion Utility.');  {05/21/08}

  WriteLn(chr254 + '  Also covers O.T. v1.61-v1.66 betas conversion to v1.67.7 Beta. ');  {added 09/21/08}

  WriteLn(' ');

  WriteLn(chr254 + '  CONVOUTS.EXE '+VersionC+':  Compile Date:  '+Compile_Date);

  WriteLn(chr254 + '  '+VersionC+' Officially released on '+Release_Date);   {12/31/09}
           {edited 12/31/09 for v1.10 release of CONVOUTS.}

  WriteLn(' ');
  WriteLn(chr254 + '  CONVOUTS.EXE reads your OUTS166.DAT file, and converts its ');
  WriteLn(chr254 + '  records to use O.T. v1.67.7 Beta''s player database format.  It ');
  WriteLn(chr254 + '  writes them to the IGM''s new database file OUT2PLAY.DAT. ');

  WriteLn(chr254 + '  Deleted records are NOT written to the new file.'); {added 01/31/07}

  WriteLn(' ');
  WriteLn(chr254 + '  Searching now for an OUTS166.DAT File to process.');

  Tavern_Path:= Copy(ParamStr(0),1,Length(ParamStr(0))-12);
      { Subtracts 12 to delete the "CONVOUTS.EXE" part. }

  OldFile_FN:= Tavern_Path+'OUTS166.DAT';   {05/21/08}

  Out2Play_FN:= Tavern_Path+'OUT2PLAY.DAT';   {05/21/08}

  WriteLn(chr254 + '    Looking in directory: '+Tavern_Path);         {05/21/08}
  WriteLn(chr254 + '    Searching for file:   '+OldFile_FN);       {05/21/08}
  WriteLn(' ');

  IF NOT Exist(OldFile_FN) THEN  {Can not find the OUTS166.DAT File}
    BEGIN
      WriteLn(chr254 + '  ERROR:  Could Not Find the Outlands Tavern Database File ...');
      WriteLn(chr254 + '  The file OUTS166.DAT is missing from this directory.');
      WriteLn(' ');

      WriteLn(chr254 + '  To use CONVOUTS to convert your OUTLANDS.DAT file ');
      WriteLn(chr254 + '  into a new database file, needed by O.T. v1.66.1+ betas ');    {05/21/08}
      WriteLn(chr254 + '  rename your current database file to OUTS166.DAT. ');
      WriteLn(chr254 + '  Then re-run CONVOUTS again. ');

      WriteLn(' ');
      WriteLn(chr254 + '  WARNING: ** This WILL OVER-WRITE any existing OUT2PLAY.DAT file!! **'); {05/21/08}
      WriteLn(chr254 + '  Use OUTSEDIT.EXE v1.01+ Beta to verify all new records.  ');

      WriteLn(' ');

      HALT(1);
    END;

  WriteLn(chr254 + '  Located OUTS166.DAT File. Processing database records now.');  {05/21/08}
  WriteLn(chr254 + '    Creating file:  '+Out2Play_FN);
  WriteLn(' ');

  LOCAL_PAUSE;   {Added 05/26/08}

  WriteLn(chr254 + '  CONVOUTS.EXE will pause screen after displaying each batch of ');
  WriteLn(chr254 + '  20 records, so user can monitor the records processed. Records ');  {05/21/08}
  WriteLn(chr254 + '  with no valid LORD Character AND Real Names are NOT converted.');   {05/21/08}

  WriteLn(' ');            {05/21/08}
  WriteLn(chr254 + '    Four seconds delay for time to read above text.');  {11/18/06}

  WriteLn(' ');
  DELAY(4000);   {01/31/07: Dropped delay from 5 to 4 seconds.}

  FileMode:= 64;

  ASSIGN(Old_Data_File,'OUTS166.DAT');
  RESET(Old_Data_File,SizeOf(Old_Rec));

  ASSIGN(New_Customers_File,'OUT2PLAY.DAT');
  REWRITE(New_Customers_File,SizeOf(New_Rec));

  WHILE NOT EOF (Old_Data_File) DO
    BEGIN
      BlockRead(Old_Data_File,Old_Rec,1);

      WITH Old_Rec DO
        BEGIN
          INC(Records_Count);     { Total Records processed counter}

          WriteLn(chr254 + '   Processing old record of '+LordName+'.  Record #', Records_Count);

          New_Rec.Drunk_Meter    := Drunk_Meter;   {05/26/08}
          New_Rec.Captured       := Captured;      {05/26/08}
          New_Rec.Dance          := Dance;         {05/26/08}
          New_Rec.Sleeping       := Sleeping;      {05/26/08}

          New_Rec.Cocktail       := Cocktail;      {05/26/08}
          New_Rec.LordName       := LordName;
          New_Rec.Skill_Points   := Skill_Points;  {05/26/08}
          New_Rec.HitMax         := HitMax;        {05/21/08}

          New_Rec.Strength       := Strength;      {05/21/08}
          New_Rec.Defense        := Defense;       {05/21/08}
          New_Rec.Charm          := Charm;         {05/21/08}
          New_Rec.Gems           := Gems;          {05/21/08}

          New_Rec.Forest         := Forest;        {05/26/08}
          New_Rec.Adoptions      := Adoptions;     {05/21/08}
          New_Rec.Gold           := Gold;          {05/21/08}
          New_Rec.Wisdom         := Wisdom;        {05/21/08}

          { Process database fields with new VAR names: }
          { ------------------------------------------- }
          New_Rec.RealName       := Real_Name;   {05/26/08 edit}
          New_Rec.Drunk_Punch    := DrinkPunch;    {05/26/08}
          New_Rec.Switched_Book  := Switch_Muse;   {05/26/08}
          New_Rec.Under_Attack   := UnderAttack;   {05/26/08}
          New_Rec.Used_Kitchen   := UsedBack;      {05/26/08}
          New_Rec.Fairy_Food     := FairyFood;     {05/26/08}

          { -------------------------------------- }
          { Incorporate new numeric Database variables: }

          New_Rec.PlayNum        := 160;     {edited 05/26/08}
          New_Rec.Visits         := 0;       {edited 05/26/08}
        END;  {With Old_Rec - ending}

      { =========== Remove DELETED RECORDS from file ========= }
      IF (S2U(Old_Rec.Real_Name) = 'X')
         AND (S2U(Old_Rec.LordName) = 'X') THEN
        BEGIN
          Skip_Record:= TRUE;

          INC(Skip_Count);
        END
      ELSE
        BEGIN
          Skip_Record:= FALSE;

          INC(Valid_Count);

                   { 05/21/08: temporary debug code statement. Verified usage }
          WriteLn(chr254 + ' Retained record for player:  '+New_Rec.LordName);  {05/26/08}

          WriteLn(chr254 + ' PlayNum:  '+N2S(New_Rec.PlayNum)+'.  Visits:  '+N2S(New_Rec.Visits));
          DELAY(2000);
        END;

      IF NOT Skip_Record THEN
        BlockWrite(New_Customers_File,New_Rec,1);

           {  Pause screen after each 20 records }
      IF Records_Count = 20 THEN Local_Pause;
      IF Records_Count = 40 THEN Local_Pause;
      IF Records_Count = 60 THEN Local_Pause;
      IF Records_Count = 80 THEN Local_Pause;
      IF Records_Count = 100 THEN Local_Pause;
      IF Records_Count = 120 THEN Local_Pause;
      IF Records_Count = 140 THEN Local_Pause;
    END;  {WITH - ending}

  CLOSE(Old_Data_File);
  CLOSE(New_Customers_File);

  WriteLn(' ');
  WriteLn(chr254 + '  FINISHED:  Processed ',Records_Count,' old database records.');
  Writeln(' ');

  IF Skip_Count > 0 THEN    {Show only if records were skipped}
    BEGIN
      WriteLn(chr254 + '  NOTES:  Skipped writing ',Skip_Count,' database records which ');
      WriteLn(chr254 + '          do not belong to valid users of the IGM.');
      WriteLn(' ');
    END;

  WriteLn(chr254 + '  SUMMARY: Converted ',Valid_Count,' old database records from OUTS166.DAT ');  {05/21/08}
  WriteLn(chr254 + '           file, and wrote them to the new OUT2PLAY.DAT file.');  {05/21/08}
  WriteLN(' ');

  WriteLn(chr254 + '  CONVOUTS.EXE '+VersionC+': Copyright 2008-2010 by Donald Tidmore.');
      {12/29/09: Updated Copyright info for 2010}
  WriteLn(' ');

  HALT(0);
END.  {Ending of CONVOUTS.PAS program }


{ v0.10: First successful compilation/test done 05/26/2008 at 01:14 am }
{ v0.25: Changed version number 1:16 am 05/26/2008 }

{ Changed program to use OUT2PLAY.DAT 05/26/2008 8:42 pm. }
{ OUTLANDS.EXE was rewritten to use OUT2PLAY.DAT. 05/26/08 }

   {05/26/2008: use v0.25 beta} {06/02/08: use v0.30 beta.}
   {07/04/08: used v0.40 beta}  {08/31/08: use v0.50 beta.}
{09/21/08: v0.65 beta. 11/03/08: v0.70}
{01/01/09: v0.75.  03/01/09: v0.80. 05/01/09: v0.85}
     {09/21/08: all code is verified}

