{ OutVars2.INC: For Outlands Tavern IGM. Created 05/25/2008 }
{ ** For temporary usage with OUTLANDS.EXE development.     }
{ ========================================================= }

TYPE CONFIG_INFO = RECORD       {OUTLANDS.EXE Layout: TAVERN2.DAT}
       LordPath     : STRING[100];  { Line 1. LORD Path. }
       IGMPath      : STRING[100];  { Line 2. IGM Dir. Path. 07/15/07 }
       Sysop_Name   : STRING[60];   { Line 3. Sysop's First & Last Names. 10/31/09 }
       Sysop_Handle : STRING[20];   { Line 4. Sysop's LORD Name/Handle. }
       BBS_Name     : STRING[60];   { Line 5. BBS or Web-Site Name. 10/31/09 }
       Max_Visits   : BYTE;         { Line 6. Max Visits/Day. 07/20/07}
       Adopted_Day  : INTEGER;      { Line 7. Max Adoptions/Day. 08/10/08. }
       Kidnap_Day   : INTEGER;      { Line 8. Max Kids Stolen/Day. 08/10/08 }
     END;

   {08/10/08: Added Adopted_Day and Kidnap_Day config vars.}
   {10/31/09: Revised Sysop_Name & BBS_Name to allow 60-digit values.}
   { ============================================================ }

    { Enabled 05/26/08 12:10 am for temporary usage }
    { Structure to use with temporary OUT2PLAY.DAT file. }

TYPE TAVERN_PLAYER = RECORD    {05/26/08: OUT2PLAY.DAT config layout}
       RealName    : STRING[50];  { player's real name. used for verification }
       LordName    : STRING[20];  { Player's LORD Name. }
       PlayNum     : BYTE;        { Player's record number. Req'd by LIST_CUSTOMERS }
       Visits      : BYTE;        { 08/31/07: Visits counter. }

       Drunk_Meter : SHORTINT;    { How drunk are they?  Can be negative values. }
                                  { 05/26/08: moved Drunk_Meter here}

       Skill_Points: SHORTINT;    { 01/26/05: # of Skill Points gained today. }
                                  { 05/26/08: moved Skill_Points here}
                                  { 05/26/08: Changed to SHORTINT since field }
                                  { uses negative values, which BYTE can't handle. }

       HitMax   : INTEGER;        { 01/26/05: Max HitPoints  }
       Strength : INTEGER;        { 01/26/05: Strength Points  }
       Defense  : INTEGER;        { 01/26/05: Defense Points  }
       Charm    : INTEGER;        { 01/26/05: Charm points  }
       Gems     : INTEGER;        { 01/26/05: Gems }
       Forest   : INTEGER;        { 01/26/05: Forest Fights }
       Adoptions: INTEGER;        { 02/02/05: Kids adopted/lost today }

       { Kids_Stolen: INTEGER; }  { 08/10/08: Kids Stolen today }

       Gold     : LONGINT;        { 01/26/05: Gold Coins  }
       Wisdom   : LONGINT;        { 01/26/05: Experience points }
                                  { 05/26/08: moved Wisdom below Gold. }

       { Had_Breakfast: BOOLEAN;  }   { 07/29/08: Has player bought Breakfast today. edited 10/10/09 }

       Captured   : BOOLEAN;      { Is Player in the Dungeon? }
       Dance      : BOOLEAN;      { Has Player danced yet? }
       Drunk_Punch: BOOLEAN;      { Has Player drunk the punch yet? 11/13/07 rename}
       Fairy_Food : BOOLEAN;      { Has player bought Fairy Food yet? 11/13/07 rename}
       Cocktail   : BOOLEAN;      { 01/26/05: Has player bought Red Dragon Cocktail yet? }
                                  { 05/26/08: Relocated Cocktail, Fairy_Food }
       Sleeping     : BOOLEAN;    { Is Player Sleeping here? }
       Switched_Book: BOOLEAN;    { Has Player switched music book? 11/13/07 rename}
       Under_Attack : BOOLEAN;    { Is sleeping player under attack currently? 11/13/07 rename }
       Used_Kitchen : BOOLEAN;    { Has Player used the Kitchen? 11/13/07 rename}
     END;  {RECORD}          { Used with Customers_File, TOuts }

  { 07/29/08: For use in next version: Breakfast variable. }
  {    Consider changing CAPTURED to PRISONER possibly also. }
  { 08/10/08: Added Kids_Stolen INTEGER var place-holder entry. }
  { =========================================================== }


(*  {Used by Outlands Tavern v1.6; v1.61 - v1.66 Betas}
    { Structure used by current OUTLANDS.DAT file }

TYPE OLD_TAVERN_PLAYER= RECORD     { Revised/resorted entries 07/17/04 }
       Real_Name:   STRING[50];   { Player's real name: used for verification }
       Drunk_Meter: SHORTINT;     { How drunk are they? }
       Captured:    BOOLEAN;      { Is Player in the Dungeon? }
       Dance:       BOOLEAN;      { Has Player danced yet? }
       DrinkPunch:  BOOLEAN;      { Has Player drunk the punch yet? }
       Sleeping:    BOOLEAN;      { Is Player Sleeping here? }
       Switch_Muse: BOOLEAN;      { Has Player switched music? }
       UnderAttack: BOOLEAN;      { Is sleeping player under attack currently? 11/22/03 }
       UsedBack:    BOOLEAN;      { Has Player used the Back room (Kitchen)? }
       FairyFood:   BOOLEAN;      { Has player bought Fairy Food yet? }
       { ------------------------ 12 variables Added 01/26/2005: ----------------------- }
       Cocktail     : BOOLEAN;     { 01/26/05: Has player bought Red Dragon Cocktail yet? }
       LordName     : STRING[20];  { 01/26/05: player's LORD Name }
       Skill_Points : BYTE;        { 01/26/05: # of Skill Points gained today. }
       HitMax       : INTEGER;     { 01/26/05: Max HitPoints  }
       Strength     : INTEGER;     { 01/26/05: Strength Points  }
       Defense      : INTEGER;     { 01/26/05: Defense Points  }
       Charm        : INTEGER;     { 01/26/05: Charm points  }
       Gems         : INTEGER;     { 01/26/05: Gems }
       Forest       : INTEGER;     { 01/26/05: Forest Fights }
       Wisdom       : LONGINT;     { 01/26/05: Experience points }
       Gold         : LONGINT;     { 01/26/05: Gold Coins  }
       { ------------------------- Added 02/02/2005: ------------ }
       Adoptions    : INTEGER;     { 02/02/05: Kids adopted/lost today }
            { For use in Red Dragon Cocktail event, RHP Script events. }
            { Fairy_Rescue: Not used by IGM at Jason's request years ago. }
     END;   { ================================================================ }
                       *)

TYPE TAVERN_STUFF = RECORD     {OUTSTIME.DAT}
       Last_Year, Last_Month, Last_Day: WORD;
     END; {RECORD}            { Use with TimeUse_File, TStuff }
     { ====================================================== }


CONST Lord_Log: STRING[10] = 'LOGNOW.TXT';

      LordLine = '  `$=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-';  {06/02/05}
  { ========================================================== }

VAR TStuff: TAVERN_STUFF;
    TimeUse_File: FILE OF TAVERN_STUFF;
    Year, Month, Day, DayOfWeek: WORD;

    { ------------------------------------------------------ }
    Config_File: TEXT;

    { ANGEL-based IGMs do not work right if either TConfig or }
    { TPlayer are defined in the IGM's INCLUDE file. }
    { Config_FN: can not be used from here. 09/03/07 notes. }
    { Removed Config_FN and Stuff_FN from INC file. 09/03/07. }
    { ------------------------------------------------------ }

    TPlayerX: TAVERN_PLAYER;   { Use in LIST_CUSTOMERS }

    Tavern_File:  FILE OF TAVERN_PLAYER;
          { Tavern_File: For accessing OUT2PLAY.DAT file }

    Tavern_FN : STRING;        { File Variable for OUT2PLAY.DAT }

    Outs_Num: WORD;            { Used in record Seek process.  }
    TempNum: WORD;             { Used in record Seek process.  }
    Tavern_Index: BYTE;        { Used in record Seek process.  }
    Used, Found: BOOLEAN;      { Used for accessing OUT2PLAY.DAT.  }

    Sysop_User: BOOLEAN;       { Enabled 09/02/07 }
    { ========================================================== }

     { Type       Range                     Format
       -----------------------------------------------------
       SHORTINT   -128..127                 Signed 8-bit
       INTEGER    -32768..32767             Signed 16-bit
       LONGINT    -2147483648..2147483647   Signed 32-bit
       BYTE       0..255                    Unsigned 8-bit
       Word       0..65535                  Unsigned 16-bit    }
     { ================================================================ }

{ IGM Analysis section: Created 07/15/2007 - First draft. }

{ =============================== }  { =============================== }
{        IGM Variable Info:       }  {        IGM Variable Info:       }
{ GEMTRADE usage:   OUTLANDS use: }  { GEMTRADE usage:   OUTLANDS use:  }
{ ------------------------------- }  { ------------------------------- }
{   Handling of date changes:     }  {   Handling of player database:  }
{ ------------------------------- }  { ------------------------------- }
{ Trade_Stuff        TAVERN_STUFF }  { Trade_Player    TAVERN_PLAYER   }
{ TStuff             TStuff       }  { TDrinks           TPlayer         }
{ JACKTIME.DAT       OUTSTIME.DAT }  { JACKPLAY.DAT      OUT2PLAY.DAT  }
{ JACKBACK.DAT       OUT2BACK.DAT }  { Both igms use Restore_FN.       }
{ TimeUse_File       TimeUse_File }  { Trades_File       Tavern_File   }
{ Last_Year, Last_Month, Last_Day }  { Trader_FN         Tavern_FN     }
{ Stuff_FN           Stuff_FN     }  { =============================== }
{ =============================== }  { JACKTIME          OUTSTIME      }
{ --- Record Seek Variables: ---- }  { --- Both use RESET_IGM_FILES.   }
{ Camp_Index         Tavern_Index }  { --- Both will use RUN_IGM       }
{ Trade_Num          Outs_Num     }  { --- Both use USED_STUFF         }
{ =============================== }  { =============================== }
{    IGM Program Files:           }  { ---- IGM Config Files/Vars:     }
{ GEMTRADE.EXE      OUTLANDS.EXE  }  { GEMTRADE.CFG      TAVERN2.DAT   }
{ JACKEDIT.EXE      OUTSEDIT.EXE  }  { Config_Info       Config_Info   }
{                                 }  { ------------------------------- }
{ ANGEL             DDIGM         }  
{    OUTLANDS: Convert to ANGEL.  }  { O.T. will not use Config file }
{ =============================== }  { Conversion files/variables.   }
{
{ --- IGM Install/Remove VARs --- }  { ------------------------------- }
{ GEMTRADE.EXE     OUTLANDS v2.00 }
{ -- Both use GamePath_FN.        }  { INIT_TRADER_VALUES              }
{ CampCFG_FN        OutsCfg_FN    }  {           INIT_CUSTOMER_VALUES  }
{ JackPlay_FN       Out2Play_FN   }  { ------------------------------- }
{ CampTime_FN       OutsTime_FN   }  {   LORD Player.dat Handling:     }
{ JackUse_FN        Usage_FN      }  { TLordRec.         TLordRec.*    }
{ -- Both use Program_Path.       }  { Lord_Info=RECORD  Lord_Info     }
{ ------------------------------- }  { LordFile          LordFile      }
{   Write_Usage_Reports usage:    }  { PLAYER.DAT        PLAYER.DAT    }
{ JACK-USE.TXT      OT-USAGE.TXT  }  { PlayerDataFN      PlayerDataFN  }
{ WUR_File          Reports_File  }  { ------------------------------- }
{ Reports_FN        Reports_FN    }  { LIST_TRADERS    LIST_CUSTOMERS  }
{ ------------------------------- }  { -- Trader_FN     - Tavern_FN    }
{ JACKPLAY.DAT      OUT2PLAY.DAT  }  { -- Traders_File  - Tavern_File  }
{ Drinks_File      Customers_File }
{ Drinks_FN         Tavern_FN     }  { Player database editor vars:    }
{ TDrinksX          TReportsX     }  { GemPlayer_FN     OutsPlayer_FN  }
{ ------------------------------- }  { TGEdit           TOTEdit        }
{ N/A               OUTSCONV.TXT  }  { Peddler_FN       Customers_FN   }
                                     { - Editor_File, TSearch, CFGName }

{ -------- LORD Mail/News File access Variables:  }
{ Lognow.txt access: -- Both will use Lord_News_File, LogNow_FN.  }
{ MAIL files access: -- Both will use Lord_Mail_File, Mail_Path.  }
{ ===================================================================== }

{ -------- OUTLANDS IGM: RHP Language variables/files: ------- }
{ IGM uses OT-EXTRA.CFG file.  RHPCfg_File variables. }

{  End of INC file:  Created Outvars.inc on July 15th, 2007. }

{ Current Data Files: OUTLANDS.ANS, OT-EXTRA.CFG, TAVERN2.DAT, }
{ OUTSTIME.DAT, OUTLANDS.DAT, OUTSCONV.TXT, OT-USAGE.TXT, and }
{ OTDEBUG.TXT.  Debug Log is not currently in use. IGM uses   }
{ player database editor files OUTSEDIT.EXE, OUTSEDIT.CFG. }

{ Data file changes: OUT2PLAY.DAT. }

{ Revised OUTVARS2.INC file on:  December 25, 2010 at 07:00 pm. }

