PROGRAM CONVSKEL;   {Created on Sept. 04th, 2008. }

USES Crt, Dos, Chasware;

     {$I BONESVAR.INC}     {January 2011 Non-beta development}
{ ======================================================== }

CONST VersionC: STRING = 'v1.10';

      Compile_Date: STRING[22] = 'December 26, 2010.';

      Release_Date: STRING[24] = 'December 26th, 2010.';  {12/31/09}
   { ======================================================== }

TYPE BONES080_PLAYER = RECORD       {** 10/12/08 structure rewrite }
       RealName     : STRING[50];   { player's real name. used for verification }
       LordName     : STRING[20];   { LORD Name}
       PlayNum      : BYTE;         { Player Number - used as Index field}
       Visits       : BYTE;         { Visits made to IGM today. }
       Adoptions    : BYTE;         { 09/04/08: Kids adopted today. }
       IGM_Fights   : BYTE;         { 09/08/08: Realm Fights Left. }
       Pellets      : BYTE;         { 09/04/08: Power Pellets. }
       Skills       : BYTE;         { 09/13/08: Skill Points gained. }
       Enemy_Kills  : INTEGER;      { 09/13/08: Monsters/Campers killed today }
       HitMax       : INTEGER;      { Max Hit-points}
       Strength     : INTEGER;      { Strength points}
       Defense      : INTEGER;      { Defense points }
       Charm        : INTEGER;      { Charm points}
       Gems         : INTEGER;      { Gems gained/lost }
       Potions      : INTEGER;      { 09/04/08: Healing Potions. }
       Gems_Int     : LONGINT;      { Gems Interest }
       Gold_Int     : LONGINT;      { Gold Interest }
       GemsBank     : LONGINT;      { Gems in Treasury }
       GoldBank     : LONGINT;      { Gold in Treasury }
       Gold         : LONGINT;      { Gold Coins Gain/Loss }
       Wisdom       : LONGINT;      { Exp. Points Gain/Loss }
       Camp_Attack  : BOOLEAN;      { 09/13/08: Was player attacked in their camp today?  }
       Camp_Dead    : BOOLEAN;      { 09/13/08: Did player win or lose camp fight?  }
       Fairy_Rescue : BOOLEAN;      { 09/13/08: Was Fairy Rescue used today?  }
       Fought_OldMan: BOOLEAN;      { 09/13/08: did player fight the Old Man?  }
       Paid_GemsInt : BOOLEAN;      { 09/04/08: Was Gems Interest paid today? }
       Paid_GoldInt : BOOLEAN;      { 09/04/08: Was Gold Interest paid today? }
       Sleeping     : BOOLEAN;      { 09/04/08: Asleep in Camp? }
       Was_Killed   : BOOLEAN;      { 09/13/08: Was killed in Camp }
       Who_Attack   : STRING[20];   { 09/13/08: Who attacked the camper? }
       Next_Time    : WORD;         { 09/13/08: Day of next LORD Game play. }
    END;      {Layout revisions:  09/04/08, 09/08/08, 09/13/08}

  { 10/12/08: Changed IGM_Fights & Pellets from BYTE to INTEGER. }
  { =================================================================== }


CONST chr254 = chr(254);
	 { ======================================================== }

VAR Old_Data_File, New_Customers_File: FILE;

    Old_Rec : BONES080_PLAYER;       {10/12/08 edit}
    New_Rec : SKELETON_PLAYER;       {09/04/08}

    Records_Count: BYTE;  {09/04/08: Total records processed.}
    Skip_Count: BYTE;     {09/04/08: Total Skipped records.}
    Valid_Count: BYTE;    {09/04/08: Total Records Converted.}

    Bones_Path  : STRING[128];

    OldFile_FN : STRING;  { Path/filename for BONES080.DAT.}

    SkelPlay_FN : STRING;  { Path/filename for new SKELPLAY.DAT File.}

    Skip_Record: BOOLEAN;  { Skip writing current record to database? }
    { ======================================================== }


PROCEDURE LOCAL_PAUSE;
  VAR MKey: CHAR;
BEGIN;                     { For Local mode screen usage only. }
  WriteLn('     <PAUSE> ');
  MKey:= ReadKey;          { Readkey: not usable remotely. }
END;   { LOCAL_PAUSE ===================================================== }


BEGIN
  clrscr;

  Records_Count:= 0;  { Initialize Total Records Processed Counter}
  Valid_Count:= 0;    { Initialize Total Records Converted Counter}
  Skip_Count:= 0;     { Initialize Total Skipped Records Counter.}

  WriteLn(' ');
  WriteLn(chr254 + '  Running L.S. v0.80 to v0.81 Beta Player Database Conversion Utility.');
                         {10/12/08 edit}
  WriteLn(' ');

  WriteLn(chr254 + '  CONVSKEL.EXE '+VersionC+':  Compile Date:  '+Compile_Date);

  WriteLn(chr254 + '  '+VersionC+' Officially released on '+Release_Date);   {12/31/09}
           {edited 12/31/09 for v1.00 release of CONVSKEL.}
           {10/08/08: added statement from CONVLORE.PAS file.}

  WriteLn(' ');
  WriteLn(chr254 + '  CONVSKEL.EXE reads your BONES080.DAT file, and converts its ');
  WriteLn(chr254 + '  records to use L.S. v0.81 Beta''s player database format.  It ');
  WriteLn(chr254 + '  writes them to a new SKELPLAY.DAT database file. ');   {10/12/08 edit}

  WriteLn(chr254 + '  Deleted records are NOT written to the new file.'); {added 01/31/07}

  WriteLn(' ');
  WriteLn(chr254 + '  Searching now for an BONES080.DAT File to process.');
                           {10/12/08 edit}

  Bones_Path:= Copy(ParamStr(0),1,Length(ParamStr(0))-12);
      { Subtracts 12 to delete the "CONVSKEL.EXE" part. }

  OldFile_FN:= Bones_Path+'BONES080.DAT';   {10/12/08 edit}

  SkelPlay_FN:= Bones_Path+'SKELPLAY.DAT';   {09/04/08}

  WriteLn(chr254 + '    Looking in directory: '+Bones_Path);         {09/04/08}
  WriteLn(chr254 + '    Searching for file:   '+OldFile_FN);       {09/04/08}
  WriteLn(' ');

  IF NOT Exist(OldFile_FN) THEN  {Can not find the BONES080.DAT File}   {10/12/08 edit}
    BEGIN
      WriteLn(chr254 + '  ERROR:  Could Not Find the LORD Skeleton Database File ...');  
      WriteLn(chr254 + '  The file BONES080.DAT is missing from this directory.');    {10/12/08 edit}
      WriteLn(' ');

      WriteLn(chr254 + '  To use CONVSKEL to convert your current SKELPLAY.DAT file ');
      WriteLn(chr254 + '  to use the new database structure, needed by L.S. v0.81+ ');  {10/12/08 edit}  {09/04/08}
      WriteLn(chr254 + '  betas, rename your current database file to BONES080.DAT. '); {10/12/08 edit}
      WriteLn(chr254 + '  Then re-run the CONVSKEL.EXE utility again. ');   {10/12/08 edit}

      WriteLn(' ');
      WriteLn(chr254 + '  WARNING: ** This WILL OVER-WRITE any existing SKELPLAY.DAT file!! **'); {09/04/08}
      WriteLn(chr254 + '  Use SKELEDIT.EXE v1.02+ Beta to verify all new records.  ');   {10/12/08 edit}

      WriteLn(' ');

      HALT(1);
    END;

  WriteLn(chr254 + '  Located BONES080.DAT File. Processing database records now.');  {10/12/08 edit}
  WriteLn(chr254 + '    Creating file:  '+SkelPlay_FN);
  WriteLn(' ');

  LOCAL_PAUSE;   {09/04/08}

  WriteLn(chr254 + '  CONVSKEL.EXE will pause screen after displaying each batch of ');
  WriteLn(chr254 + '  20 records, so user can monitor the records processed. Records ');  {09/04/08}
  WriteLn(chr254 + '  with no valid LORD Character AND Real Names are NOT converted.');   {09/04/08}

  WriteLn(' ');            {09/04/08}
  WriteLn(chr254 + '    Four seconds delay for time to read above text.');  {11/18/06}

  WriteLn(' ');
  DELAY(4000);

  FileMode:= 64;

  ASSIGN(Old_Data_File,'BONES080.DAT');        {10/12/08 edit}
  RESET(Old_Data_File,SizeOf(Old_Rec));

  ASSIGN(New_Customers_File,'SKELPLAY.DAT');
  REWRITE(New_Customers_File,SizeOf(New_Rec));

  WHILE NOT EOF (Old_Data_File) DO
    BEGIN
      BlockRead(Old_Data_File,Old_Rec,1);

      WITH Old_Rec DO
        BEGIN
          INC(Records_Count);     { Total Records processed counter}

          WriteLn(chr254 + '   Processing old record of '+LordName+'.  Record #', Records_Count);

          New_Rec.RealName  := RealName;
          New_Rec.LordName  := LordName;
          New_Rec.PlayNum   := PlayNum;
          New_Rec.Visits    := Visits;

          New_Rec.Adoptions   := Adoptions;    {10/12/08 edit}
          New_Rec.Enemy_Kills := Enemy_Kills;  {10/12/08 edit}
          New_Rec.Skills      := Skills;       {10/12/08 edit}
          New_Rec.HitMax      := HitMax;

          New_Rec.Strength    := Strength;
          New_Rec.Defense     := Defense;
          New_Rec.Charm       := Charm;
          New_Rec.Gems        := Gems;

          New_Rec.IGM_Fights  := IGM_Fights;   {10/12/08 edit}
          New_Rec.Pellets     := Pellets;      {10/12/08 edit}
          New_Rec.Potions     := Potions;      {10/12/08 edit}
          New_Rec.Gems_Int    := Gems_Int;

          New_Rec.Gold_Int    := Gold_Int;
          New_Rec.GemsBank    := GemsBank;
          New_Rec.GoldBank    := GoldBank;
          New_Rec.Gold        := Gold;       {10/12/08 edit}

          New_Rec.Wisdom      := Wisdom;     {10/12/08 edit}
          New_Rec.Camp_Attack   := Camp_Attack;  {10/12/08 edit}
          New_Rec.Camp_Dead     := Camp_Dead;    {10/12/08 edit}
          New_Rec.Fairy_Rescue  := Fairy_Rescue;   {10/12/08 edit}

          New_Rec.Fought_OldMan := Fought_OldMan;  {10/12/08 edit}
          New_Rec.Paid_GemsInt  := Paid_GemsInt;   {10/12/08 edit}
          New_Rec.Paid_GoldInt  := Paid_GoldInt;   {10/12/08 edit}
          New_Rec.Sleeping      := Sleeping;       {10/12/08 edit}

          New_Rec.Was_Killed    := Was_Killed;     {10/12/08 edit}
          New_Rec.Who_Attack    := Who_Attack;     {10/12/08 edit}
          New_Rec.Next_Time     := Next_Time;      {10/12/08 edit}

        END;  {With Old_Rec - ending}

          { Rewrote entire section 10/12/08. }

      { =========== Remove DELETED RECORDS from file ========= }
      IF (S2U(Old_Rec.RealName) = 'X')
          AND (S2U(Old_Rec.LordName) = 'X') THEN
        BEGIN
          Skip_Record:= TRUE;

          INC(Skip_Count);
        END
      ELSE
        BEGIN
          Skip_Record:= FALSE;

          INC(Valid_Count);

          WriteLn(chr254 + ' Retained record for player:  '+New_Rec.LordName);  {09/04/08}

          WriteLn(chr254 + ' GemsBank: '+COMMA(New_Rec.GemsBank)+'.  GoldBank:  '+COMMA(New_Rec.GoldBank));
             {09/04/08: non-debug}

          IF New_Rec.Sleeping       {Added 10/12/08: untested}
            THEN  WriteLn(chr254 + '   Player is SLEEPING in this IGM.')            {untested}
            ELSE  WriteLn(chr254 + '   Player is NOT Asleep in this IGM.');    {untested}

          DELAY(2000);  {09/21/08: dropped to 2 sec from 3 sec}
        END;

      IF NOT Skip_Record THEN
        BlockWrite(New_Customers_File,New_Rec,1);

           {  Pause screen after each 20 records }
      IF Records_Count = 20 THEN Local_Pause;
      IF Records_Count = 40 THEN Local_Pause;
      IF Records_Count = 60 THEN Local_Pause;
      IF Records_Count = 80 THEN Local_Pause;
      IF Records_Count = 100 THEN Local_Pause;
      IF Records_Count = 120 THEN Local_Pause;
      IF Records_Count = 140 THEN Local_Pause;
    END;  {WITH - ending}

  CLOSE(Old_Data_File);
  CLOSE(New_Customers_File);

  WriteLn(' ');
  WriteLn(chr254 + '  FINISHED:  Processed ',Records_Count,' old database records.');
  Writeln(' ');

  IF Skip_Count > 0 THEN    {Show only if records were skipped}
    BEGIN
      WriteLn(chr254 + '  NOTES:  Skipped writing ',Skip_Count,' database records which ');
      WriteLn(chr254 + '          do not belong to valid users of the IGM.');
      WriteLn(' ');
    END;

  WriteLn(chr254 + '  SUMMARY: Converted ',Valid_Count,' old database records from BONES080.DAT ');  {10/12/08 edit}
  WriteLn(chr254 + '           file, and wrote them to the new SKELPLAY.DAT file.');  {09/04/08}
  WriteLN(' ');

  WriteLn(chr254 + '  CONVSKEL.EXE '+VersionC+': Copyright 2008-2011 by Donald Tidmore.');
      {12/29/09: Updated Copyright info for 2010}
  WriteLn(' ');

  HALT(0);
END.  {Ending of CONVSKEL.PAS program }

    { CONVSKEL.PAS was created on Sept. 08, 2008. }

{ v0.10: Adapted CONVOUTS.PAS to create CONVSKEL.EXE code file. }
{ Finished initial coding session at 1:31 am 09/04/2008. }
{ First compilation done successfully at 01:50 am. 09/04/08. }
{ Tested program successfully. 09/08/08 early morning. v0.10. }

{ 10/08/08: moved old comments to LRS-ARCH.TXT file. }

{ ConvSkel v1.00 released on 10/09/2008. }

{  Release_Date: STRING = 'October 09th, 2008.';  }   {10/08/08}
{  09/21/08: v0.45 beta. 10/08/08: v1.00; official release}
{  Added INC file statement info to USES section 09/08/08.  }
{ =============================================== }

{ Started second development cycle (v1.02 beta) 10/12/2008. }
         {10/12/08: v1.02 Beta.  11/03/08: v1.04}

               {01/01/09: v1.06.  03/01/09: v1.08 beta.}
               {05/01/09: v1.09 beta. 10/08/09: v1.10 Beta}

