PROGRAM DOOFEDIT;     {Doofus the Gnome P. D. Editor Utility}

   { Accesses Gnome_Player record structure via GnomeVar.inc file.      }
   { ================================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, LordLock, ChasWare;

     {$I GnomeVar.inc}

   { January 2011 Beta }
{ ============================================================= }

CONST Version = 'v1.17 Beta';
           {01/04/10: use v1.14 beta. 01/18/10: use v1.15 beta}
           {03/06/10: use v1.16 beta. 05/16/10: use v1.17 beta}

      Compile_Date : STRING = 'December 26, 2010.';    {Disabled 02/24/06}
         {01/18/10: All code in program is fully tested.}
      { ------------------------------------------------ }

      CFGName: STRING = 'DOOFEDIT.CFG';  {keep as insurance code}

      GnomePlayer_FN = 'DG2PLAY.DAT';

      RealName = '1';     LordName  = '2';    PlayNum  = '3';
      Visits   = '4';     Fairies   = '5';    Horses   = '6';
      HitMax   = '7';     Strength  = '8';    Defense  = '9';
      Charm    = '0';     Forest    = 'A';    Elixirs  = 'B';
      GemsTraded  = 'C';  Adoptions = 'D';    Kids_Lost = 'E';
      Gems_Stolen = 'F';  Grizelda  = 'G';
      { ------------------------------------------------------- }

      { Q - Quit/Save Changes.   S - Search for Player.  }
      { * - New Day for Player.  X - Delete Player Record }
      { ------------------------------------------------------- }

      Max_Kids: INTEGER = 16000;
         {Changed Max_Kids from 10,000 to 16,000. 06/20/09}

      Max_Elixirs: INTEGER = 16000;  {07/29/05: Max Elixirs Bought per day is 8,000.}
         {Changed Max_Elixirs from 8,000 to 16,000. 06/20/09}

      Max_Visits: BYTE = 20;  {Added 11/11/2009}
    { ======================================================== }

VAR TSearch : Gnome_Player;   { for player searches }
    { ---------------------------------------------------- }

    TDGEdit:  Gnome_Player;
       { 07/07/06: Changed from TDEdit to TDGEdit.  DG for Doofus Gnome. }

    Editor_File:  FILE OF Gnome_Player;

    IGMDir      : STRING[80];
    RecordNum   : BYTE;

    { 07/07/06: Changed Gnome_FN to Doofus_FN. }
    Doofus_FN: STRING;   {07/22/05: Directory path to DOOFEDIT.EXE, DG2PLAY.DAT files.}

    Debug_Mode: BOOLEAN;  {Added 11/17/09 from VIO2EDIT code}
           {01/17/10: Renamed DebugVar to Debug_Mode.}

      { TempNum, Used, Found: Accessed from GnomeVar.inc.   Used in record Seek process.  }
      { TDEDIT, Editor_File, IGMDir, and RecordNum values moved }
      { here from DOOFUNIT.PAS file on 08/20/2005. }
    { ======================================================== }


   {Renamed ReadConfig to READ_CONFIG. 11/17/09.}
PROCEDURE READ_CONFIG;
VAR  F : TEXT;

  PROCEDURE MakeConfig;                    {VERIFIED 07/16/05}
      VAR IGMLoc:STRING[80];
  BEGIN
   IGMLoc:= PromptStr(0,0,60,'Enter directory path to Doofus IGM',' Installation ','',FALSE);

   Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;   {VERIFIED 07/16/05}

  ASSIGN(F,CfgName);
  RESET(F);
  Readln(F,IGMDir);
  CLOSE(F);
END;       { ---------------------------------------------------- }


PROCEDURE READ_GNOME_FILE;  { Reads the IGM's DG2PLAY.DAT file. }   {VERIFIED 07/22/05}
BEGIN
  Doofus_FN:= S2U(IGMDir+GnomePlayer_FN);  {07/22/05}
      {07/07/06: Added S2U function to Doofus_FN statement.}

  ASSIGN(Editor_File,Doofus_FN);   {07/22/05: revised to use Gnome_FN}
  Lockfile(Doofus_FN);              {07/22/05: revised to use Gnome_FN}
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TDGEdit);

  UnLockFile(Doofus_FN);              {07/22/05: revised to use Gnome_FN}
  CLOSE(Editor_File);          { 07/07/06: Changed Gnome_FN to Doofus_FN. }
END;     { ---------------------------------------------------- }


   { Moved to here 08/20/05 from DOOFUNIT.PAS file. }
PROCEDURE WRITE_GNOME_FILE; { Writes IGM's DG2PLAY.DAT file }
BEGIN
  Doofus_FN:= S2U(IGMDir+GnomePlayer_FN);  {07/22/05}
    {07/07/06: Added S2U to statement.}

  ASSIGN(Editor_File,Doofus_FN);    {07/22/05: revised to use Gnome_FN}
  LOCKFILE(Doofus_FN);             {07/22/05: revised to use Gnome_FN}
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TDGEdit);

  UNLOCKFILE(Doofus_FN);           {07/22/05: revised to use Gnome_FN}
  CLOSE(Editor_File);              { 07/07/06: Changed Gnome_FN to Doofus_FN. }
END;     { WRITE_GNOME_FILE   ------------------------------ }


PROCEDURE Search(Num:Integer);                       {VERIFIED 07/22/05}
      { Reads DG2PLAY.DAT. Does search on player record number }
BEGIN
  Doofus_FN:= S2U(IGMDir+GnomePlayer_FN);  {07/22/05}
    {07/07/06: Added S2U to statement.}

  ASSIGN(Editor_File,Doofus_FN);             {07/22/05: revised to use Gnome_FN}
  Lockfile(Doofus_FN);                   {07/22/05: revised to use Gnome_FN}
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  UnLockFile(Doofus_FN);                  {07/22/05: revised to use Gnome_FN}
  CLOSE(Editor_File);        { 07/07/06: Changed Gnome_FN to Doofus_FN. }
END;     { Search  --------------------------------------------- }


   { Moved to here 08/20/05 from DOOFUNIT.PAS file. }
FUNCTION Get(b:CHAR):STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TDGEdit.RealName;

     LordName : Get:='`$'+TDGEdit.LordName;        {moved entry up to here 07/11/05}

     PlayNum  : Get:='`@'+N2S(TDGEdit.PlayNum);  {Contains player's LORD player #.}

     Visits   : IF TDGEdit.Visits = 0              {Revised/Verified 07/30/05}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TDGEdit.Visits);

     Fairies  : IF TDGEdit.Fairies = 0              {Revised/Verified 07/30/05}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TDGEdit.Fairies);

     Horses   : IF TDGEdit.Horses = 0              {Revised/Verified 07/30/05}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TDGEdit.Horses);

     HitMax    : IF TDGEdit.HitMax = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.HitMax);

     Strength  : IF TDGEdit.Strength = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Strength);

     Defense   : IF TDGEdit.Defense = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Defense);

     Charm     : IF TDGEdit.Charm = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Charm);

     Forest    : IF TDGEdit.Forest = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Forest);

     Elixirs   : IF TDGEdit.Elixirs = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Elixirs);

     GemsTraded: IF TDGEdit.GemsTraded = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.GemsTraded);

     Adoptions : IF TDGEdit.Adoptions = 0              {Revised/Verified 07/30/05}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Adoptions);

     Kids_Lost : IF TDGEdit.Kids_Lost = 0              {Revised 09/15/05 - Verified}
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TDGEdit.Kids_Lost);

     Gems_Stolen : IF TDGEdit.Gems_Stolen = 0              {Revised/Verified 07/30/05}
                     THEN  Get:= '`#None'
                     ELSE  Get:= '`$'+COMMA(TDGEdit.Gems_Stolen);

     Grizelda    : IF TDGEdit.Grizelda
                     THEN Get:= '`0Yes! '    {Added 09/15/05: verified}
                     ELSE Get:= '`#Nope!';
  END;  {CASE}

  CursorOff;   {07/07/06: needed to fix bug found by Dennis Collins.}
    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }


{ 1 }PROCEDURE DoRealName;          {VERIFIED 07/22/05}
BEGIN
  TDGEdit.RealName:=
  PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TDGEdit.RealName,FALSE);

  WRITE_GNOME_FILE;
  CWriteXy(24,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(24,4,Get(RealName));
END;


{ 2 }PROCEDURE DoLordName;           {VERIFIED 07/22/05}
BEGIN
  TDGEdit.LordName:=
  PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TDGEdit.LordName,FALSE);

  WRITE_GNOME_FILE;
  CwriteXY(24,5,Replicate(20,' '));
  CwriteXY(24,5,Get(LordName));
END;


   {Renamed DO_PlayNum to DO_PLAYER_NUMBER 11/17/09.}
   { In normal usage, Player Number is not change-able by user. }
{ 3 }PROCEDURE DO_PLAYER_NUMBER;              {VERIFIED 07/22/05}
BEGIN
  TDGEdit.PlayNum:=
    PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TDGEdit.PlayNum,0,160,TRUE);

  WRITE_GNOME_FILE;
  CWriteXy(54,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(54,5,Get(PlayNum));
END;


{ 4 }PROCEDURE Do_Visits;               {VERIFIED. Max value used in IGM is 10.}
BEGIN
  TDGEdit.Visits:=
  PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TDGEdit.Visits,0,Max_Visits,TRUE);
        {rewrote 11/11/09 to use 0-20 range, Max_Visits const.}

  WRITE_GNOME_FILE;
  CwriteXY(24,6,Replicate(5,' '));
  CwriteXY(24,6,Get(Visits));
END;


{ 5 }PROCEDURE Do_Fairies;               {REVISED 07/29/05: verified}
BEGIN
  TDGEdit.Fairies:=
  PromptNum(0,0,'Enter Fairy Trades (0-25)?',' Fairy Trades Change ',TDGEdit.Fairies,0,25,TRUE);
   { 07/07/06: Changed Max_Fairies to 25. }

  WRITE_GNOME_FILE;
  CwriteXY(58,6,Replicate(5,' '));
  CwriteXY(58,6,Get(Fairies));
END;


{ 6 }PROCEDURE Do_Horses;                  {REVISED 07/29/05: verified}
BEGIN
  TDGEdit.Horses:=
  PromptNum(0,0,'Enter Horse Trades (0-25)?',' Horse Trades Change ',TDGEdit.Horses,0,25,TRUE);
   { 07/07/06: Changed Max_Horses to 25. }

  WRITE_GNOME_FILE;
  CWriteXY(24,7,Replicate(5,' '));
  CWriteXY(24,7,Get(Horses));
END;


{ 7 }PROCEDURE Do_HitMax;                 {VERIFIED 07/22/05}
BEGIN
  TDGEdit.HitMax:=
  PromptNum(0,0,'Enter Max Hit-Points (0-16,000)?',' Max Hit-Points Change ',TDGEdit.HitMax,0,16000,TRUE);
                  {Changed 0 to 8,000 range to 0 to 16,000. 06/20/09}

  WRITE_GNOME_FILE;
  CWriteXY(58,7,Replicate(6,' '));
  CWriteXY(58,7,Get(HitMax));
END;


{ 8 }PROCEDURE DO_Strength;                 {VERIFIED 07/22/05}
BEGIN
  TDGEdit.Strength:=
  PromptNum(0,0,'Enter Strength Points (0-16,000)?',' Strength Points Change ',TDGEdit.Strength,0,16000,TRUE);
                  {Changed 0 to 8,000 range to 0 to 16,000. 06/20/09}

  WRITE_GNOME_FILE;
  CWriteXY(24,8,Replicate(6,' '));
  CWriteXY(24,8,Get(Strength));
END;


{ 9 }PROCEDURE DO_Defense;                 {VERIFIED 07/22/05}
BEGIN
  TDGEdit.Defense:=
  PromptNum(0,0,'Enter Defense Points (0-16,000)?',' Defense Points Change ',TDGEdit.Defense,0,16000,TRUE);
                  {Changed 0 to 8,000 range to 0 to 16,000. 06/20/09}

  WRITE_GNOME_FILE;
  CWriteXY(58,8,Replicate(6,' '));
  CWriteXY(58,8,Get(Defense));
END;


{ 0 }PROCEDURE DO_Charm;               {VERIFIED 07/22/05}
BEGIN
  TDGEdit.Charm:=
  PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Points Change ',TDGEdit.Charm,0,16000,TRUE);
                  {Changed 0 to 8,000 range to 0 to 16,000. 06/20/09}

  WRITE_GNOME_FILE;
  CwriteXY(24,9,Replicate(6,' '));
  CwriteXY(24,9,Get(Charm));
END;


{ A }PROCEDURE DO_Forest;                 {revised/verified 09/19/05}
BEGIN
  TDGEdit.Forest:=
    PromptNum(0,0,'Enter Forest Fights Gain/Loss (-8,000 - 16,000)?',' Forest Fights Change ',TDGEdit.Forest,-8000,16000,TRUE);
                                  {Changed -2000 to 8000 range to -8000 to 16000. 06/20/09}

  WRITE_GNOME_FILE;
  CWriteXY(58,9,Replicate(6,' '));
  CWriteXY(58,9,Get(Forest));
END;


{ B }PROCEDURE Do_Elixirs;              {Revised 07/29/05: verified}
BEGIN
  TDGEdit.Elixirs:=
    PromptNum(0,0,'Enter Elixirs Bought (0-16,000)?',' Elixirs Bought Change',TDGEdit.Elixirs,0,Max_Elixirs,TRUE);
        {Changed -2000 to 8000 range to -8000 to 16000. 06/20/09}
        {Changed Max_Elixirs from 8,000 to 16,000. 06/20/09}

  WRITE_GNOME_FILE;
  CwriteXY(24,10,Replicate(6,' '));
  CwriteXY(24,10,Get(Elixirs));
END;


{ C }PROCEDURE DO_GemsTraded;             {REVISED 07/29/05: verified}
BEGIN
  TDGEdit.GemsTraded:=             { Allow field to be edited in 0 to 300,000 range. }
  PromptNum(0,0,'Enter Gems Traded (0-300,000)?',' Gems Traded Change ',TDGEdit.GemsTraded,0,300000,TRUE);

  WRITE_GNOME_FILE;
  CWriteXY(58,10,Replicate(6,' '));
  CWriteXY(58,10,Get(GemsTraded));
END;


{ D }PROCEDURE Do_Adoptions;       {Revised 12/27/05: verified}
BEGIN
  TDGEdit.Adoptions:=    { Max Adoptions/Day used by IGM is 10,000. }
    PromptNum(0,0,'Enter # of Adoptions (0-10,000)?',' Adoptions Today Change ',TDGEdit.Adoptions,0,100000,TRUE);
         { 07/07/06: Changed 9,000 to 10,000. Changed Max_Kids to 10,000.}
         {Changed Max_Kids from 10,000 to 16,000. 06/20/09}

  WRITE_GNOME_FILE;
  CwriteXY(24,11,Replicate(5,' '));  {5 digits for 0-16,000 data range.}
  CwriteXY(24,11,Get(Adoptions));
END;


{ E }PROCEDURE Do_Kids_Lost;  {VERIFIED 12/27/05: verified}
BEGIN
  TDGEdit.Kids_Lost:=
  PromptNum(0,0,'Enter Kids Lost Today (0-32,000)?',' Kids Lost Change', TDGEdit.Kids_Lost,0,32000,TRUE);
                { 07/07/06: Changed 6,400 to 32,000. }

  WRITE_GNOME_FILE;
  CwriteXY(60,11,Replicate(6,' '));
  CwriteXY(60,11,Get(Kids_Lost));
END;        {12/27/05: updated IGM to allow Grizelda to steal up}
            {to maximum of 6,400 kids/day.  20% of 32,000 }


{ F }PROCEDURE Do_Gems_Stolen;               {VERIFIED 07/22/05}
BEGIN
  TDGEdit.Gems_Stolen:=
  PromptNum(0,0,'Enter Gems Stolen (0-32,000)?',' Gems Stolen Change',TDGEdit.Gems_Stolen,0,32000,TRUE);
               { 07/07/06: Changed 5,000 to 32,000. }

  WRITE_GNOME_FILE;
  CwriteXY(24,12,Replicate(9,' '));  {08/16/05: Fixed data location error.}
  CwriteXY(24,12,Get(Gems_Stolen));
END;


{ G }PROCEDURE Do_Grizelda;        {Added 09/15/05: verified}
BEGIN
  IF TDGEdit.Grizelda = TRUE THEN TDGEdit.Grizelda:= FALSE
   ELSE IF TDGEdit.Grizelda = FALSE THEN TDGEdit.Grizelda:= TRUE;

  WRITE_GNOME_FILE;
  CwriteXY(60,12,Replicate(5,' '));
  CwriteXY(60,12,Get(Grizelda));
END;


   { Moved to here 08/20/05 from DOOFUNIT.PAS file. }
FUNCTION  MaxPlayers:Word; { Gets the number of customer records }
BEGIN
  MaxPlayers:=1;

  Doofus_FN:= IGMDir+GnomePlayer_FN;  {07/22/05}

  IF NOT Exist(Doofus_FN) THEN Exit;   {07/22/05: revised to use Gnome_FN}

  ASSIGN(Editor_File,Doofus_FN);       {07/22/05: revised to use Gnome_FN}
  LOCKFILE(Doofus_FN);            {07/22/05: revised to use Gnome_FN}
  RESET(Editor_File);

  MaxPlayers:= FileSize(Editor_File);

  UNLOCKFILE(Doofus_FN);          {07/22/05: revised to use Gnome_FN}
  CLOSE(Editor_File);       { 07/07/06: Changed Gnome_FN to Doofus_FN. }
END;     { MaxPlayers  --------------------------------------------- }


    { Replaced with KLBEDIT.PAS file code on 09/12/05 }
FUNCTION GetRecordNum:STRING;     {Revised to include MaxPlayers data. VERIFIED 07/15/05}
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MaxPlayers);
    { 08/30/05: Changed so that first record # displayed will be 1, not 0.}
END;     { GetRecordNum ---------------------------------------------- }


{ No point in having Delete Player in this IGM. DeletePlayer process was removed. }

{ note: To use Y, N responses via keyboard, one has to use
  the ALT key. Or simply use the mouse to click on the option wanted. }


   { Moved to here 08/20/05 from DOOFUNIT.PAS file. }
       {01/20/10: Changed ShowMenu to SHOW_MENU.}

PROCEDURE SHOW_MENU;
BEGIN
  ClrScr;

  CWriteln('`%    ** `@Doofus the Gnome''s `0Player Database Editor `$'+Version+' `%**');  {Line 1}

  CWriteln('`$    DG2PLAY.DAT `!Record Number:  `#'+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name      `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
    CWrite('`#(`%2`#) `!LORD Name      `%: '+Get(LordName));

  CWGotoXY(47,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);                 {Line 6}
    CWrite('`#(`%4`#) `!Visits Today   `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Fairies Bought`%: '+Get(Fairies));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
    CWrite('`#(`%6`#) `!Horses Bought  `%: '+Get(Horses));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Max Hit-Points`%: '+Get(HitMax));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
    CWrite('`#(`%8`#) `!Strength Pts.  `%: '+Get(Strength));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Defense Pts.  `%: '+Get(Defense));
  { -------------------------------------------- }

  CWGotoXY(3,9);                 {Line 9}
    CWrite('`#(`%0`#) `!Charm Points   `%: '+Get(Charm));

  CWGotoXY(38,9);
  CWriteLN('`#(`%A`#) `!Forest Fights `%: '+Get(Forest));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10}
    CWrite('`#(`%B`#) `!Elixirs Bought `%: '+Get(Elixirs));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Gems Traded   `%: '+Get(GemsTraded));
  { -------------------------------------------- }

  CWGotoXY(3,11);                 {Line 11}
    CWrite('`#(`%D`#) `!Adoptions      `%: '+Get(Adoptions));

  CWGotoXY(35,11);
  CWriteLN('`#(`%E`#) `!Kids Lost        `%: '+Get(Kids_Lost));  {09/15/05}
      {06/20/09: Deleted 2 blank spaces before colon}
  { -------------------------------------------- }

  CWGotoXY(3,12);                 {Line 12}
    CWrite('`#(`%F`#) `!Gems Stolen    `%: '+Get(Gems_Stolen));

  CWGotoXY(35,12);
  CWriteLN('`#(`%G`#) `!Saw Grizelda Today?`%: '+Get(Grizelda));  {09/15/05}

    { 09/19/05: Fixed glitch. Was using Kids_Lost instead of Grizelda here. }
  { -------------------------------------------- }

  CWriteLn(' ');  {Blank Line, Line #13}

  { --------------------------------------------------------- }
  CWGotoXY(3,14);
    CWrite('`2(`0S`2) `%Search By Name');       {Edited 01/17/10}

  CWGotoXY(40,14);
  CWriteLn('`2(`0]`2) `%Advance One Record');
  { --------------------------------------------------------- }

  CWGotoXY(3,15);
  CWriteln('`2(`0[`2) `%Back Up One Record');

  CWGotoXY(40,15);
  CWriteln('`2(`0*`2) `%New Day For Player');
  { --------------------------------------------------------- }

  CWGotoXY(3,16);      {Added 01/17/10}
  CWriteLn('`2(`0X`2) `%Delete Current Player');   {Added 01/17/10}
         {01/20/10: Changed "Delete Player Record" to "Delete Current Player".}

  CWriteln(' ');  {Blank Line, Line #17.}  {edited 01/17/10}

  CWGotoXY(3,18);   {Edited 01/17/10}
  Cwrite('`$    Input key to change, or `%Q `$to Quit and Save.');

  IF Debug_Mode THEN    {Added 01/17/10: Verified 01/18/10}
    CWrite('  `@[Debug Mode] ');

END;     { SHOW_MENU  ------------------------------------------------------ }


   {Renamed DO_PlayerSearch to DO_PLAYER_SEARCH. 11/17/09.}
   {01/17/10: Changed menu code from X to S for Player Search.}

{ S }PROCEDURE DO_PLAYER_SEARCH;     {VERIFIED 07/22/05}
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN         { 07/07/06: Changed Gnome_FN to Doofus_FN. }
  Doofus_FN:= IGMDir+GnomePlayer_FN;  {Added 07/22/05}

  IF NOT Exist(Doofus_FN) THEN Exit;     {07/22/05: revised to use Gnome_FN}
     { if no DG2PLAY.DAT then we can't search and
       couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    Search(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in
      either field of record.  If YES, then execute the next section,
      otherwise increment counter and move on.  Note: Using FUNCTION NoColor
      to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
		BEGIN
		  YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');
        IF YN=1 THEN {1 means YES answer}
          BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_GNOME_FILE;
            SHOW_MENU;
            Exit; { bail out of loop since we got who we want }
          END;
      END;
    Inc(Counter);
  UNTIL Counter=MaxPlayers; { End of repeat loop, repeats until we get
										to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;  { DO_PLAYER_SEARCH =============================== }


{ Added 01/17/10 using modified OT20EDIT.PAS code: }

{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 01/17/10: Verified 01/18/10}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TDGEdit.LordName+' known'
     +' as '+NoColor(TDGEdit.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TDGEdit.RealName:= 'X';
      TDGEdit.LordName:= '* DELETED *';

      TDGEdit.PlayNum:= 160;

        { Note: PlayNum 160 should not be in use by any valid players.}

      TDGEdit.Visits:= 0;

      TDGEdit.Fairies:= 0;
      TDGEdit.Horses:= 0;

      TDGEdit.HitMax:= 0;
      TDGEdit.Strength:= 0;
      TDGEdit.Defense:= 0;
      TDGEdit.Charm:= 0;
      TDGEdit.Forest:= 0;

      TDGEdit.Elixirs:= 0;
      TDGEdit.GemsTraded:= 0;
      TDGEdit.Adoptions:= 0;
      TDGEdit.Kids_Lost:= 0;
      TDGEdit.Gems_Stolen:= 0;

      TDGEdit.Grizelda:= FALSE;
      { ========================================== }

      WRITE_GNOME_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

      SHOW_MENU;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }


{ * }PROCEDURE Do_NewDay;           {VERIFIED 07/22/05}
BEGIN
  CWGotoXY(5,24);
  CWriteLn('  `0Running "Do New Day for Player" process.');

  IF (TDGEdit.PlayNum > 160) THEN
    BEGIN
      TDGEdit.PlayNum:= 160;
      PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
    END;

  { 10/01/05: Removed code for handling negative values }
  { in PlayNum, Visits, Fairies, and Horses, since BYTE }
  { Vars can't be set to negative numbers.              }

  { --------------------------------------------------- }
  IF TDGEdit.Visits > 0 THEN
    BEGIN
      TDGEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Fairies > 0 THEN
    BEGIN
      TDGEdit.Fairies:= 0;
      PromptOK('Advisory:',' Resetting the Fairies Bought field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Horses > 0 THEN
    BEGIN
      TDGEdit.Horses:= 0;
      PromptOK('Advisory:',' Resetting the Horses Bought field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.HitMax < 0 THEN
    BEGIN
      TDGEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max HitPoints field to 0.');
    END;

  IF TDGEdit.HitMax > 0 THEN
    BEGIN
      TDGEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the Max HitPoints field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Strength < 0 THEN
    BEGIN
      TDGEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to 0.');
    END;

  IF TDGEdit.Strength > 0 THEN
    BEGIN
      TDGEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Defense < 0 THEN
    BEGIN
      TDGEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to 0.');
    END;

  IF TDGEdit.Defense > 0 THEN
    BEGIN
      TDGEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Charm < 0 THEN
    BEGIN
      TDGEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to 0.');
    END;

  IF TDGEdit.Charm > 0 THEN
    BEGIN
      TDGEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Forest < 0 THEN
    BEGIN
      TDGEdit.Forest:= 0;
      PromptOK('Advisory:',' Reset negative Forest Potions field to 0.');
    END;

  IF TDGEdit.Forest > 0 THEN
    BEGIN
      TDGEdit.Forest:= 0;
      PromptOK('Advisory:',' Resetting the Forest Potions field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Elixirs < 0 THEN
    BEGIN
      TDGEdit.Elixirs:= 0;
      PromptOK('Advisory:',' Reset negative Elixirs Bought field to 0.');
    END;

  IF TDGEdit.Elixirs > 0 THEN
    BEGIN
      TDGEdit.Elixirs:= 0;
      PromptOK('Advisory:',' Resetting the Elixirs Bought field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.GemsTraded < 0 THEN
    BEGIN
      TDGEdit.GemsTraded:= 0;
      PromptOK('Advisory:',' Reset negative Gems Traded field to 0.');
    END;

  IF TDGEdit.GemsTraded > 0 THEN
    BEGIN
      TDGEdit.GemsTraded:= 0;
      PromptOK('Advisory:',' Resetting the Gems Traded field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Adoptions < 0 THEN
    BEGIN
      TDGEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Reset negative Adoptions field to 0.');
    END;

  IF TDGEdit.Adoptions > 0 THEN
    BEGIN
      TDGEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Resetting the Adoptions field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Kids_Lost < 0 THEN    {revised 09/15/05: verified 09/22/05}
    BEGIN
      TDGEdit.Kids_Lost:= 0;
      PromptOK('Advisory:',' Reset negative Kids Lost field to 0.');
    END;

  IF TDGEdit.Kids_Lost > 0 THEN    {revised 09/15/05: verified 09/19/05}
    BEGIN
      TDGEdit.Kids_Lost:= 0;
      PromptOK('Advisory:',' Resetting the Kids Lost field to 0.');
    END;

  { --------------------------------------------------- }
  IF TDGEdit.Gems_Stolen < 0 THEN
    BEGIN
      TDGEdit.Gems_Stolen:= 0;
      PromptOK('Advisory:',' Reset negative Gems Stolen field to 0.');
    END;

  IF TDGEdit.Gems_Stolen > 0 THEN
    BEGIN
      TDGEdit.Gems_Stolen:= 0;
      PromptOK('Advisory:',' Resetting the Gems Stolen field to 0.');
    END;

  TDGEdit.Grizelda:= FALSE;
END;     { Do_NewDay  =============================================== }

{Note: DOOFEDIT does not have/use a Do_NewDay_Testing process.}


   {Renamed RunEditor to RUN_EDITOR. 11/17/09.}
PROCEDURE RUN_EDITOR;            {Fully verified 04:57 pm 07/22/05}
  VAR Ch:CHAR;
BEGIN
  SHOW_MENU;

  REPEAT
    Ch:= AInput('1234567890ABCDEFGQSX][*');  {08/20/05: Added missing X code.}
                                  {09/15/05: Added G code}
          {01/17/10: Added S code for Player Search feature to use}

    CASE Ch OF
      '1' : DoRealName;

      '2' : DoLordName;

      '3' : BEGIN      {Rewrote using VIO2EDIT code 11/17/09.}
              CWGotoXY(1,20);
                 {01/18/10: Changed from Line 25 to Line 20}

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see ');
              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
              DELAY(3000);

              IF Debug_Mode THEN   {11/17/09 edit: VERIFIED}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the `#Player Number `0field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(3000);

                  DO_PLAYER_NUMBER;
                END;

              SHOW_MENU;
            END;

      '4' : Do_Visits;

      '5' : Do_Fairies;

      '6' : Do_Horses;

      '7' : Do_HitMax;

      '8' : Do_Strength;

      '9' : Do_Defense;

      '0' : Do_Charm;

      'A' : Do_Forest;

      'B' : Do_Elixirs;

      'C' : Do_GemsTraded;

      'D' : Do_Adoptions;        {Revised 12/27/05}

      'E' : Do_Kids_Lost;        {Revised 12/27/05}

      'F' : Do_Gems_Stolen;

      'G' : Do_Grizelda; {09/15/05}

      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'S' : DO_PLAYER_SEARCH;     {Renamed DO_PlayerSearch to DO_PLAYER_SEARCH. 11/17/09.}

      'X' : BEGIN               {Created 01/17/10: Verified 01/18/10}
              CWGotoXY(1,21);   {Show text on Line 21. 01/20/10 edit}

              CWriteLn('  `0The `@Delete Player Record `0option is only usable when `$DOOFEDIT ');
              CWriteLn('  `0is executed in `%Debug Mode, `0using the `!/Debug `0parameter. ');
              CWriteLn('  `!This option should only be used with `@EXTREME `!caution!!         ');
                      {01/20/10: rewrote wording of third line}
              DELAY(3000);

              IF Debug_Mode THEN   {Created 01/17/10: Verified 01/18/10}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to `#Delete the current Player Record.  `0Do this  ');
                  CWriteLn('  `0with `@CAUTION, `0and only to deal with `@cheating players. ');
                  DELAY(3000);

                  DO_PLAYER_DELETION;
                END;

              SHOW_MENU;
            END;

      ']' : BEGIN
              Inc(RecordNum);
              IF RecordNum > (MaxPlayers - 1) THEN RecordNum:= 0;  {02/14/04 edit}
              READ_GNOME_FILE;
              SHOW_MENU;
            END;

      '[' : BEGIN
              IF RecordNum=0 THEN RecordNum:= (MaxPlayers - 1)
                             ELSE Dec(RecordNum);

              READ_GNOME_FILE;
              SHOW_MENU;
            END;

      '*' : BEGIN         {08/20/05: Added BEGIN/END lines.}
              Do_NewDay;  {10/01/05: renamed DoNewDay to Do_NewDay.}

              SHOW_MENU;      {08/20/05: Moved out of Do_NewDay proc. to here.}

              WRITE_GNOME_FILE;    {08/20/05: Moved out of Do_NewDay proc. to here.}
            END;

    END;       {CASE CH - ending}
  UNTIL Ch='Q';
END;       { ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;             {Fully verified 04:57 pm 07/22/05}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally  }
  { Note #2. PromptOK can handle a maximum of six data lines.      }

  Doofus_FN:= S2U(IGMDir);  {capitalize IGM path info. 07/07/06}
    { Edited 06/20/09 to use IGMDIR. Was showing incomplete info }
    {   'c:\bp7\lordprog\gnome\units\dg2play.' for some reason.  }
    {   Changed to only show the IGM path data. }

        {Section edited 06/20/09. All edits verified OK.}

  PromptOK(' Doofus the Gnome''s Player Database Editor Credits: ',
      'DOOFEDIT.EXE '+Version+'.  Copyright 2005-2011 by Donald Tidmore. |'

      +'** Dedicated in memory of Gordon Lewicky. ** |'
      +'** Secondary dedication to Shannon Talley. ** ||'
                 {added second | symbol 02/21/06}

      +'Compile Date:  '+Compile_Date+'  January 2011 Beta. |'
            {07/07/2006. re-enabled 07/22/09}

      (*   +'v1.10 released officially on:  '+Vers11_Date+' |'   {07/07/2006}  *)

      +'IGM Path: '+Doofus_FN);      {Added 4th line on 08/12/05}
END; { EXIT_SCREEN ======================================================================== }


BEGIN    { Main DOOFEDIT.pas BEGIN/END structure }     {VERIFIED 07/22/05}
  ClrScr;     {moved up to here 11/17/09}

  CursorOff;                  {Gold toolkit process}
  UseLordColors:= TRUE;

  Debug_Mode:= FALSE;   {11/17/09 code}

  IF S2U(ParamStr(1)) = '/DEBUG'  {11/17/09 code}
    THEN Debug_Mode:= True;

  ReadVars.ReadHelp:= NIL;
        { removes the HELP button in the prompts. }
        {Gold toolkit process}

  WinNoClose:= TRUE;
         { removes the prompt window close button }
         { in upper left.  Gold toolkit process }

  RecordNum:= 0;

  IF Exist('DG2PLAY.DAX') THEN DeleteFile('DG2PLAY.DAX');
     {Fixed omission 12/10/09}

  READ_CONFIG;
         {Renamed ReadConfig to READ_CONFIG. 11/17/09.}

  { ===================== Added 08/12/2005 ================== }
  Doofus_FN:= S2U(IGMDir+GnomePlayer_FN);  {07/22/05 code}
     {07/07/06: Added S2U to capitalize directory path and filename.}

  IF Exist(Doofus_FN) THEN READ_GNOME_FILE   {08/12/05 code block}
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0DOOFEDIT `!could not locate `@Doofus the Gnome''s ');
      CWriteLn('  `!DG2PLAY.DAT file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0DOOFEDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Doofus_FN);

      CWriteLn(' ');   {12/18/09}
      CWriteLn('  `#Problem Solving Note: `%Make sure the `!DOOFEDIT.CFG `%file contains ');  {12/18/09: VERIFIED}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}

      CWriteLn(' ');
      CWriteLn('  `!Terminating `0DOOFEDIT `!immediately.  ');
      HALT;
    END;
  { =========================================================== }

  CursorHalf;   { 07/07/06: Can't get rid of cursor when program first executes }
                { so I'll just try making it half-size instead.  It does not }
                { show up every time Doofedit is run, but it does it enough }
                { to be frustrating that one can't get rid of all the time. }

    { 07/07/06: regardless of where CursorOff is located, the blinking }
    { cursor still is determined to show up when program is executed.  }

  RUN_EDITOR;

  EXIT_SCREEN;  {12/27/05: renamed ExitScreen to Exit_Screen}

  ResetStartUpMode;     {Gold toolkit process}
END. { DOOFEDIT.pas }

   { Prepared and officially released v1.10 on Jul. 17th, 2006. }

   { Edited & tested revisions 06/20/2009.}
   { 06/20/09 note: IGM not put back into development officially yet. }

      {  Vers11_Date : STRING = 'Jul. 17th, 2006.';  } {07/07/06}
                {11/29/09: use v1.13 beta}
                 {Minor editing 12/10/09}

