PROGRAM FO2EDIT;  { Forest Outhouse Player Database Editor Utility }

  { Created program using LC2EDIT code on Apr. 17th, 2009. }
  { ====================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

     {$I HouseVar.INC}         {January 2011 Beta}
	  { =================================================================================== }

CONST Version: STRING = 'v0.73 Beta';   {12/29/09: v0.68 beta}
         {01/20/10: use v0.70 beta. Added Delete Player code}
         {03/01/10: v0.72 beta}
         {11/30/10: changed to v0.73 beta}

      Compile_Date: STRING = 'December 24, 2010.';
            {12/30/09: All code in program is fully tested.}
      { ------------------------------------------------ }

      CfgName: STRING = 'FO2EDIT.CFG';

      OH2Player_FN: STRING = 'OH2PLAY.DAT';

      RealName    = '1';   LordName   = '2';   PlayNum   = '3';
      Visits      = '4';   HitMax     = '5';   Strength  = '6';
      Defense     = '7';   Charm      = '8';   Forest    = '9';
      Gems        = '0';   Gold       = 'A';   Wisdom    = 'B';
      Adoptions   = 'C';   SkillUses  = 'D';   Searches  = 'E';
      Lays        = 'F';   FRescue    = 'G';   Genie     = 'H';
      KidsCount   = 'I';   LWCount    = 'J';   SkillPts  = 'K';
      KidsLost    = 'L';   {04/24/09: Added KidsLost}

      {04/24/09: Changed structure to use FBattles instead of Forest,}
      { for the Forest Fights field. Added field for Kids Lost. }
      { ------------------------------------------------------- }

      { Q - Quit/Save Changes.   S - Search for Player. }
      { * - New Day for Player.  Delete Player not used by IGM. }

      { # - Used to test New Day's handling of Negative numbers }
      { ------------------------------------------------------- }

      TwoBillion: LongInt = 2000000000;

      Max_Visits: BYTE = 20;   {08/03/08}
{ ============================================================ }

VAR TSearch: FOREST_PLAYER;   { for player searches }

    TFOEdit: FOREST_PLAYER;

    Editor_Path: STRING;      { File Vars for OH2PLAY.DAT access }

    Editor_File:  FILE OF FOREST_PLAYER;

    IGMDir: STRING;

    RecordNum   : BYTE;

    Debug_Mode: BOOLEAN;
          {01/20/10: Renamed DebugVar to Debug_Mode.}

      { TempNum, Used, Found: Accessed from HouseVar.INC.   Used }
      { in record Seek process.  }
    { ================================================================================== }

PROCEDURE READ_CONFIG;      {Edited 04/17/09: Verified 04/17/09}
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;          {Verified 04/17/09}
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter path to Forest Outhouse IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;      {Verified 04/17/09}

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

  { FO2EDIT: When run from compiler, verified that value of IGMDir is known at this point. }
END;       { Read_Config ------------------------------------------------- }


PROCEDURE READ_WARRIORS_FILE;    { Reads the IGM's OH2PLAY.DAT file. }
BEGIN
  Editor_Path:= S2U(IGMDIR+OH2Player_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TFOEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


PROCEDURE WRITE_WARRIORS_FILE;      { Writes IGM's OH2PLAY.DAT file }
BEGIN
  Editor_Path:= S2U(IGMDIR+OH2Player_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TFOEdit);

  CLOSE(Editor_File);
END;     { WRITE_WARRIORS_FILE   ------------------------------ }


PROCEDURE SEARCH_PLAYER(Num:INTEGER);
                   { Does search on player record number }
BEGIN
  Editor_Path:= S2U(IGMDIR+OH2Player_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }

    
FUNCTION Get(b:CHAR): STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TFOEdit.RealName;

     LordName : Get:='`$'+TFOEdit.LordName;

     PlayNum  : Get:='`@'+N2S(TFOEdit.PlayNum);
                  { Contains player's LORD player #. }

     Visits   : IF TFOEdit.Visits = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.Visits);

     HitMax   : IF TFOEdit.HitMax = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.HitMax);

     Strength : IF TFOEdit.Strength = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Strength);

     Defense  : IF TFOEdit.Defense = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Defense);

     Charm    : IF TFOEdit.Charm = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Charm);

     Forest   : IF TFOEdit.FBattles = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.FBattles);

     Gems     : IF TFOEdit.Gems = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Gems);

     Gold     : IF TFOEdit.Gold = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Gold);

     Wisdom   : IF TFOEdit.Wisdom = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Wisdom);

     Adoptions: IF TFOEdit.Adoptions = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TFOEdit.Adoptions);

     SkillUses: IF TFOEdit.Skill_Uses = 0
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+N2S(TFOEdit.Skill_Uses);

     Searches : IF TFOEdit.Searches_Left = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.Searches_Left);

     Lays     : IF TFOEdit.Lays = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.Lays);

     FRescue  : IF TFOEdit.Fairy_Rescue THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';
                  { Used for IGM's FairyRescue boolean VAR}

     { ------------------- Apr. 17, 2009 coding --------------- }
     Genie    : IF TFOEdit.Genie_Count = 0   {Added 04/17/09}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.Genie_Count);

     KidsCount: IF TFOEdit.LostKid_Count = 0   {Added 04/17/09}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.LostKid_Count);

     LWCount  : IF TFOEdit.LostWar_Count = 0   {Added 04/17/09}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.LostWar_Count);

     SkillPts : IF TFOEdit.Skill_Points = 0   {Added 04/17/09}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.Skill_Points);

     KidsLost : IF TFOEdit.Kids_Lost = 0   {Added 04/24/09}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TFOEdit.Kids_Lost);
  END;  {CASE}

  CursorOff;   {10/15/07.  needed to fix bug found by Dennis Collins}
               { in 2006 when he checked on KLBEDIT. }

    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }


{ 1 }PROCEDURE DO_REAL_NAME;          {Verified 04/17/09}
BEGIN
  TFOEdit.RealName:=
  PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TFOEdit.RealName,FALSE);

  WRITE_WARRIORS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


{ 2 }PROCEDURE DO_LORD_NAME;            {Verified 04/17/09}
BEGIN
  TFOEdit.LordName:=
  PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TFOEdit.LordName,FALSE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


  { In normal usage, don't allow users to change LORD Player Numbers. }
{ 3 }PROCEDURE DO_PLAYER_NUMBER;       {Edited 04/17/09: Verified 04/17/09}
BEGIN
  TFOEdit.PlayNum:=
  PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TFOEdit.PlayNum,0,160,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXy(58,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(58,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;               {Edited 04/17/09: Verified 04/17/09}
BEGIN
  TFOEdit.Visits:=
    PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TFOEdit.Visits,0,Max_Visits,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,6,Replicate(5,' '));
  CwriteXY(22,6,Get(Visits));
END;   {IGM's Max Visits/Day Limit is 20, as of mid-July.}


{ 5 }PROCEDURE DO_MAX_HITPOINTS;                 {Verified 04/17/09}
BEGIN
  TFOEdit.HitMax:=
  PromptNum(0,0,'Enter # of Max HitPoints (0-16,000)?',' Max HitPoints Today Change',TFOEdit.HitMax,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,6,Replicate(6,' '));
  CWriteXY(58,6,Get(HitMax));
END;


{ 6 }PROCEDURE DO_STRENGTH_POINTS;                 {Verified 04/17/09}
BEGIN
  TFOEdit.Strength:=
  PromptNum(0,0,'Enter # of Strength (0-16,000)?',' Strength Change ',TFOEdit.Strength,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(Strength));
END;


{ 7 }PROCEDURE DO_DEFENSE_POINTS;               {Verified 04/17/09}
BEGIN
  TFOEdit.Defense:=
  PromptNum(0,0,'Enter Defense Points (0-16,000)?',' Defense Change ',TFOEdit.Defense,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(58,7,Replicate(6,' '));
  CwriteXY(58,7,Get(Defense));
END;


{ 8 }PROCEDURE DO_CHARM_POINTS;               {Verified 04/17/09}
BEGIN
  TFOEdit.Charm:=
  PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Change ',TFOEdit.Charm,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,8,Replicate(6,' '));
  CwriteXY(22,8,Get(Charm));
END;


{ 9 }PROCEDURE DO_FOREST_FIGHTS;               {Verified 04/17/09}
BEGIN
  TFOEdit.FBattles:=
    PromptNum(0,0,'Enter Forest Fights (0-16,000)?',' Forest Fights Change', TFOEdit.FBattles,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(58,8,Replicate(6,' '));
  CwriteXY(58,8,Get(Forest));
END;


{ 0 }PROCEDURE DO_GEMS;      {Verified 04/17/09}
BEGIN
  TFOEdit.Gems:=
   PromptNum(0,0,'Enter # of Gems (0-16,000)?',' Gems Change', TFOEdit.Gems,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,9,Replicate(9,' '));   {12/02/09: changed 6 to 9}
  CwriteXY(22,9,Get(Gems));
END;


{ A }PROCEDURE DO_GOLD_COINS;               {Verified 04/17/09}
BEGIN
  TFOEdit.Gold:=
    PromptNum(0,0,'Enter Gold Coins (0-2 Billion)?',' Gold Found/Lost Change', TFOEdit.Gold,0,TwoBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(51,9,Replicate(14,' '));
  CwriteXY(51,9,Get(Gold));
END;


{ B }PROCEDURE DO_WISDOM_POINTS;               {Verified 04/17/09}
BEGIN
  TFOEdit.Wisdom:=
    PromptNum(0,0,'Enter Wisdom Points (0-2 Billion)?',' Wisdom Points Change', TFOEdit.Wisdom,0,TwoBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,10,Replicate(14,' '));
  CwriteXY(22,10,Get(Wisdom));
END;


{ C }PROCEDURE DO_ADOPTIONS;                 {Verified 04/17/09}
BEGIN                         {Edited 01/28/09}
  TFOEdit.Adoptions:=
   PromptNum(0,0,'Enter # of Adoptions (-50 to 125)?',' Adoptions Change',TFOEdit.Adoptions,-50,125,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,10,Replicate(7,' '));   {01/28/09: Changed 6 to 7}
  CWriteXY(58,10,Get(Adoptions));
END;


{ D }PROCEDURE DO_SKILL_USES;                 {Verified 04/17/09}
BEGIN
  TFOEdit.Skill_Uses:=
  PromptNum(0,0,'Enter # of Skill Use Points (0-50)?',' Skill Use Points Change',TFOEdit.Skill_Uses,0,50,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,11,Replicate(6,' '));
  CWriteXY(22,11,Get(SkillUses));
END;


{ E }PROCEDURE DO_SEARCHES_LEFT;                 {Verified 04/17/09}
BEGIN
  TFOEdit.Searches_Left:=
    PromptNum(0,0,'Enter # of Searches Left (0-250)?',' Forest Searches Left Change',TFOEdit.Searches_Left,0,250,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,11,Replicate(6,' '));
  CWriteXY(58,11,Get(Searches));
END;


{ F }PROCEDURE DO_LAYS;                 {Verified 04/17/09}
BEGIN
  TFOEdit.Lays:=
    PromptNum(0,0,'Enter # of Lays (0-50)?',' Lay Points Change',TFOEdit.Lays,0,50,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,12,Replicate(6,' '));
  CWriteXY(22,12,Get(Lays));
END;


{ G }PROCEDURE DO_FAIRY_RESCUE;                 {Verified 04/17/09}
BEGIN
  IF TFOEdit.Fairy_Rescue = TRUE THEN TFOEdit.Fairy_Rescue:= FALSE
    ELSE IF TFOEdit.Fairy_Rescue = FALSE THEN TFOEdit.Fairy_Rescue:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(58,12,Replicate(6,' '));
  CWriteXY(58,12,Get(FRescue));
END;


{ ==================== Apr. 17, 2009 coding: ================== }
{ H }PROCEDURE DO_GENIE_COUNT;         {Created 04/17/09: Verified 04/17/09}
BEGIN
  TFOEdit.Genie_Count:=
    PromptNum(0,0,'Enter # of Sexy Genie Events (0-50)?',' Genie Events Change',TFOEdit.Genie_Count,0,50,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,13,Replicate(6,' '));
  CWriteXY(22,13,Get(Genie));
END;


{ I }PROCEDURE DO_LOST_KID_COUNT;       {Created 04/17/09: Verified 04/17/09}
BEGIN
  TFOEdit.LostKid_Count:=
    PromptNum(0,0,'Enter # of Orphan Events Count (0-250)?',' Lost Kids Events Change',TFOEdit.LostKid_Count,0,250,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,13,Replicate(6,' '));
  CWriteXY(58,13,Get(KidsCount));
END;


{ J }PROCEDURE DO_LOST_WARRIOR_COUNT;         {Created 04/17/09: Verified 04/17/09}
BEGIN
  TFOEdit.LostWar_Count:=
    PromptNum(0,0,'Enter # of Warrior Events Count (0-50)?',' Orphan Events Count Change',TFOEdit.LostWar_Count,0,50,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,14,Replicate(6,' '));
  CWriteXY(22,14,Get(LWCount));
END;


{ K }PROCEDURE DO_SKILL_POINTS;       {Created 04/17/09: Verified 04/17/09}
BEGIN
  TFOEdit.Skill_Points:=
    PromptNum(0,0,'Enter # of Skill Points (0-250)?',' Skill Points Change',TFOEdit.Skill_Points,0,250,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,14,Replicate(6,' '));
  CWriteXY(58,14,Get(SkillPts));
END;


{ L }PROCEDURE DO_KIDS_LOST;       {Created 04/24/09: VERIFIED 12/30/09}
BEGIN
  TFOEdit.Kids_Lost:=
    PromptNum(0,0,'Enter # of Kids Lost (0-500)?',' Kids Lost Change',TFOEdit.Kids_Lost,0,500,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,15,Replicate(6,' '));
  CWriteXY(22,15,Get(KidsLost));
END;


{ note: To use Y, N responses via keyboard, one has to use the }
{ ALT key. Or simply use the mouse to click on the option wanted. }

{ * }PROCEDURE DO_NEW_DAY;     {Verified 04/17/09}
BEGIN
  CWGotoXY(5,19);    {Write data on Line #19. 12/04/07}
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

  IF (TFOEdit.PlayNum > 160) THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN                            {Enabled 12/31/07}
      TFOEdit.PlayNum:= 160;
      PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
    END;

  { --------------------------------------------------- }
        {BYTE field; Values can't be negative}
  IF TFOEdit.Visits > 0 THEN       {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;

  { --------------------------------------------------- }
        {BYTE field; Values can't be negative}
  IF TFOEdit.Searches_Left > 0 THEN    {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Searches_Left:= 0;
      PromptOK('Advisory:',' Resetting the Forest Searches Left field to Zero.');
    END;

  { --------------------------------------------------- }
  { Lays is BYTE format, so can't be negative, in new format. }

  IF TFOEdit.Lays > 0 THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Lays:= 0;
      PromptOK('Advisory:',' Resetting the Lay Points field to Zero.');
    END;

  { --------------------------------------------------- }
  { Skill_Uses is BYTE. Value can't be negative }

  IF TFOEdit.Skill_Uses > 0 THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Skill_Uses:= 0;
      PromptOK('Advisory:',' Resetting the Skill Use Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.HitMax < 0 THEN       {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max HitPoints field to Zero.');
    END;

  IF TFOEdit.HitMax > 0 THEN       {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the Max HitPoints field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.Strength < 0 THEN     {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TFOEdit.Strength > 0 THEN     {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.Defense < 0 THEN      {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TFOEdit.Defense > 0 THEN      {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.Charm < 0 THEN        {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TFOEdit.Charm > 0 THEN        {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.FBattles < 0 THEN       {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.FBattles:= 0;
      PromptOK('Advisory:',' Reset negative Forest Fights field to Zero.');
    END;

  IF TFOEdit.FBattles > 0 THEN       {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.FBattles:= 0;
      PromptOK('Advisory:',' Resetting the Forest Fights field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.Gems < 0 THEN         {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems field to Zero.');
    END;

  IF TFOEdit.Gems > 0 THEN         {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting the Gems field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.Gold < 0 THEN         {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Gold:= 0;
      PromptOK('Advisory:',' Reset negative Gold Coins field to Zero.');
    END;

  IF TFOEdit.Gold > 0 THEN         {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Gold Coins field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TFOEdit.Wisdom < 0 THEN       {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Points field to Zero.');
    END;

  IF TFOEdit.Wisdom > 0 THEN       {Edited 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting the Wisdom Points field to Zero.');
    END;

  { --------------------------------------------------- }
  { Note: ADOPTIONS is INTEGER type, so it can be negative. }

  IF TFOEdit.Adoptions < 0 THEN   {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Reset negative Adoptions field to Zero.');
    END;

  IF TFOEdit.Adoptions > 0 THEN   {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Resetting the Adoptions field to Zero.');
    END;

  { Boolean variables: All get reset to FALSE: }

  TFOEdit.Fairy_Rescue:= FALSE;     {12/03/07}
      { used only when IGM executes RHP Scripts. }

  { ================== Apr. 17, 2009 coding =================== }
  { Genie_Count is BYTE. Value can't be negative }

  IF TFOEdit.Genie_Count > 0 THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Genie_Count:= 0;
      PromptOK('Advisory:',' Resetting the Genie Events Count field to Zero.');
    END;

  { LostKid_Count is BYTE. Value can't be negative }

  IF TFOEdit.LostKid_Count > 0 THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.LostKid_Count:= 0;
      PromptOK('Advisory:',' Resetting the Orphan Events Count field to Zero.');
    END;

  { LostWar_Count is BYTE. Value can't be negative }

  IF TFOEdit.LostWar_Count > 0 THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.LostWar_Count:= 0;
      PromptOK('Advisory:',' Resetting the Warrior Events Count field to Zero.');
    END;

  { Skill_Points is BYTE. Value can't be negative }

  IF TFOEdit.Skill_Points > 0 THEN  {Coded 04/17/09: Verified 04/17/09}
    BEGIN
      TFOEdit.Skill_Points:= 0;
      PromptOK('Advisory:',' Resetting the Skill Points field to Zero.');
    END;

  { ==================== Added 04/24/2009 =========================== }
  { Note: KIDS_LOST is BYTE type, so it can't EVER be negative. }
  { 04/25/09: Changed field from INTEGER to BYTE in INC file.   }

  IF TFOEdit.Kids_Lost > 0 THEN     {Edited 04/24/09: VERIFIED}
    BEGIN
      TFOEdit.Kids_Lost:= 0;
      PromptOK('Advisory:',' Resetting the Kids Lost field to Zero.');
    END;

END;     { DO_NEW_DAY  ================================== }


FUNCTION  MAX_PLAYERS: WORD; { Gets the number of customer records }
BEGIN
  MAX_PLAYERS:= 1;

  Editor_Path:= S2U(IGMDIR+OH2Player_FN);

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MAX_PLAYERS:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MAX_PLAYERS  --------------------------------------------- }


FUNCTION GetRecordNum: STRING;
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MAX_PLAYERS);
    { First record # displayed will be 1, not 0. }
END;     { GetRecordNum ---------------------------------------------- }


       {01/20/10: Changed ShowMenu to SHOW_MENU.}
PROCEDURE SHOW_MENU;
BEGIN
  ClrScr;

  CWritelnC('`%    ** `$Forest Outhouse''s `0Player Database Editor `!'+Version+' `%**');  {Line 1}
  CWritelnC('`@    OH2PLAY.DAT `%Record Number:  `$'+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
	 CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);        {Line 6, column 1. temp coding}
	 CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Max HitPoints `%: '+Get(HitMax));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
	 CWrite('`#(`%6`#) `!Strength Pts `%: '+Get(Strength));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Defense Points`%: '+Get(Defense));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
   CWrite('`#(`%8`#) `!Charm Points `%: '+Get(Charm));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Forest Fights `%: '+Get(Forest));
  { -------------------------------------------- }

  CWGotoXY(3,9);                 {Line 9. Coded 12/02/2007}
    CWrite('`#(`%0`#) `!Gems Found   `%: '+Get(Gems));

  CWGotoXY(34,9);
  CWriteLN('`#(`%A`#) `!Gold Coins `%: '+Get(Gold));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10. Coded 12/02/2007}
	 CWrite('`#(`%B`#) `!Wisdom Points`%: '+Get(Wisdom));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Kids Adopted  `%: '+Get(Adoptions));
  { -------------------------------------------- }

  CWGotoXY(3,11);                 {Line 11. Coded 12/03/2007}
	 CWrite('`#(`%D`#) `!Skill Use Pts`%: '+Get(SkillUses));

  CWGotoXY(38,11);
  CWriteLN('`#(`%E`#) `!Searches Left `%: '+Get(Searches));
  { -------------------------------------------- }

  CWGotoXY(3,12);                 {Line 12. Coded 12/03/2007}
	 CWrite('`#(`%F`#) `!Lay Points   `%: '+Get(Lays));

  CWGotoXY(38,12);
  CWriteLN('`#(`%G`#) `!Fairy Rescue? `%: '+Get(FRescue));
  { -------------------------------------------- }

  { =================== START: Apr. 17, 2009 code: ============ }
  CWGotoXY(3,13);                 {Line 13. Coded 04/17/09}
   CWrite('`#(`%H`#) `!Genie Count  `%: '+Get(Genie));

  CWGotoXY(38,13);
  CWriteLN('`#(`%I`#) `!FindKid Count `%: '+Get(KidsCount));  {04/24/09 edit}
  { -------------------------------------------- }

  CWGotoXY(3,14);                 {Line 14. Coded 04/17/09}
    CWrite('`#(`%J`#) `!Warrior Count`%: '+Get(Genie));

  CWGotoXY(38,14);
  CWriteLN('`#(`%K`#) `!Skill Points  `%: '+Get(SkillPts));
  { -------------------------------------------- }

  CWGotoXY(3,15);
  CWriteLN('`#(`%L`#) `!Kids Lost    `%: '+Get(KidsLost));  {Added 04/24/09}
  { ------------------------------------------------------------- }

  CWriteLn(' ');  {Blank Line, Line #16}

  { --------------------------------------------------------------- }
  CWGotoXY(3,17);
    CWrite('`2(`0S`2) `%Search for Player');
       {01/20/10: Changed "Search by Name" to "Search for Player".}

  CWGotoXY(40,17);
    CWrite('`2(`0]`2) `%Advance One Record');
  { -------------------------------------------- }

  CWGotoXY(3,18);
	 CWrite('`2(`0[`2) `%Back Up One Record');

  CWGotoXY(40,18);
  CWriteln('`2(`0*`2) `%Reset Player Stats');
  { -------------------------------------------- }
  { ================= End of 04/17/09 rewrites =========== }

  CWGotoXY(3,19);      {Added 01/20/10}
  CWriteLn('`2(`0X`2) `%Delete Current Player');   {Added 01/20/10}
       {01/20/10: Changed "Delete Player Record" to "Delete Current Player".}

  CWriteln(' ');  {Blank Line, Line #20.}  {01/20/10}

  CWGotoXY(3,21);   {Edited 01/20/10}
  Cwrite('`$    Input key to change, or `%Q `$to Quit and Save.');

  IF Debug_Mode THEN    {Added 01/20/10: VERIFIED 01/20/10 5:06 pm}
    CWrite('  `@[Debug Mode] ');

END;     { SHOW_MENU  ----------------------------------------- }


{ S }PROCEDURE DO_PLAYER_SEARCH;
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+OH2Player_FN);

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no OH2PLAY.DAT then we can't search and }
     { couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
		 YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_WARRIORS_FILE;
            SHOW_MENU;
            Exit; { bail out of loop since we got who we want }
          END;
     END;

    INC(Counter);
  UNTIL Counter=MAX_PLAYERS; { End of repeat loop, repeats until we get
										to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;   { DO_PLAYER_SEARCH ====================================== }


{ Added 01/20/10 using modified OT20EDIT.PAS code: }

{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 01/20/10: VERIFIED 01/20/10 5:06 pm}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TFOEdit.LordName+' known'
     +' as '+NoColor(TFOEdit.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TFOEdit.RealName:= 'X';
      TFOEdit.LordName:= '* DELETED *';

      TFOEdit.PlayNum:= 160;

        { Note: PlayNum 160 should not be in use by any valid players.}

      TFOEdit.Visits:= 0;

      TFOEdit.Genie_Count:= 0;
      TFOEdit.Kids_Lost:= 0;

      TFOEdit.Lays:= 0;
      TFOEdit.LostKid_Count:= 0;

      TFOEdit.LostWar_Count:= 0;
      TFOEdit.Searches_Left:= 0;
      TFOEdit.Skill_Uses:= 0;
      TFOEdit.Skill_Points:= 0;

      TFOEdit.HitMax:= 0;
      TFOEdit.Strength:= 0;
      TFOEdit.Defense:= 0;
      TFOEdit.Charm:= 0;
      TFOEdit.FBattles:= 0;

      TFOEdit.Adoptions:= 0;
      TFOEdit.Gems:= 0;
      TFOEdit.Gold:= 0;
      TFOEdit.Wisdom:= 0;

      TFOEdit.Fairy_Rescue:= FALSE;
      { ========================================== }

      WRITE_WARRIORS_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

      SHOW_MENU;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }



{01/20/10: Deleted disabled DO_NEWDAY_TESTING process}
  {Disabled DO_NEWDAY_TESTING 12/30/2009. not in use currently}



PROCEDURE RUN_EDITOR;       {Verified 04/17/09}
  VAR Code: CHAR;
BEGIN
  SHOW_MENU;

  REPEAT
    Code:= AInput('1234567890ABCDEFGHIJKLQSX][*');
       {04/17/09: Added H,I,J and K codes.}  {04/24/09: Added L code}
       {01/20/10: Deleted # key. Added X key.}

    CASE Code OF          {All usable components Verified 04/17/09}
      '1' : DO_REAL_NAME;

      '2' : DO_LORD_NAME;

      '3' : BEGIN               {enabled usage 12/31/07}
              CWGotoXY(1,21);   {Show text on Line 21. 01/20/10 edit}

              CWriteLn('                                                                      ');  {09/13/08. needed here}
                {Writes blank line to screen. Line #21. 01/20/10}

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see ');
              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
              DELAY(3000);

              IF Debug_Mode THEN   {Coded 04/17/09: Verified 04/17/09}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the `#Player Number `0field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(3000);

                  DO_PLAYER_NUMBER;
                END;

              SHOW_MENU;
            END;

      '4' : DO_VISITS;

      '5' : DO_MAX_HITPOINTS;

      '6' : DO_STRENGTH_POINTS;

      '7' : DO_DEFENSE_POINTS;

      '8' : DO_CHARM_POINTS;

      '9' : DO_FOREST_FIGHTS;

      '0' : DO_GEMS;

      'A' : DO_GOLD_COINS;

      'B' : DO_WISDOM_POINTS;

      'C' : DO_ADOPTIONS;

      'D' : DO_SKILL_USES;

      'E' : DO_SEARCHES_LEFT;

      'F' : DO_LAYS;

      'G' : DO_FAIRY_RESCUE;
      { ================================================== }

      'H' : DO_GENIE_COUNT;       {Coded 04/17/09}

      'I' : DO_LOST_KID_COUNT;    {Coded 04/17/09}

      'J' : DO_LOST_WARRIOR_COUNT;   {Coded 04/17/09}

      'K' : DO_SKILL_POINTS;   {Coded 04/17/09}

      'L' : DO_KIDS_LOST;   {Coded 04/24/09: VERIFIED 12/30/09}

      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'S' : DO_PLAYER_SEARCH;   {Revised 04/17/09}

      {01/20/10: Deleted statement for disabled DO_NEWDAY_TESTING}

      { ------------------------ Added 01/20/10 --------------- }
      'X' : BEGIN               {Created 01/20/10: VERIFIED 01/20/10 5:06 pm}
              CWGotoXY(1,21);   {Start on Line 21}

              CWriteLn('                                                                      ');  {09/13/08. needed here}
                {Writes blank line to screen. Line #21. 01/20/10}

              CWriteLn('  `0The `@Delete Player Record `0option is only usable when `$FO2EDIT ');
              CWriteLn('  `0is executed in `%Debug Mode, `0using the `!/Debug `0parameter. ');
              CWriteLn('  `!This option should only be used with `@EXTREME `!caution!!  ');
                      {01/20/10: rewrote wording of third line}

              DELAY(4000);     {wording layout verified}

              IF Debug_Mode THEN   {Created 01/20/10: VERIFIED 01/20/10 5:06 pm}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is allowed ');
                  CWriteLn('  `0to `#Delete this Record.  `0Do this only if absolutely necessary! ');
                  DELAY(3000);

                  DO_PLAYER_DELETION;
                END;

              SHOW_MENU;
            END;
      { ------------------------------------------------------ }

      ']' : BEGIN
              INC(RecordNum);
              IF RecordNum > (MAX_PLAYERS - 1) THEN RecordNum:= 0;  {05/07/04 edit}

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '[' : BEGIN                      {Edited 04/17/09: verified}
              IF RecordNum=0
                THEN RecordNum:= (MAX_PLAYERS - 1)
                ELSE Dec(RecordNum);

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '*' : BEGIN               {Verified 04/17/09}
              DO_NEW_DAY;

              SHOW_MENU;

              WRITE_WARRIORS_FILE;
            END;

    END;       {CASE Code - ending}
  UNTIL Code = 'Q';
END;       { RUN_EDITOR ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;          {Verified 04/17/09}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' Forest Outhouse''s Player Database Editor Credits: ',
      'FO2EDIT.EXE '+Version+'.  Copyright 2009-2011 by Donald Tidmore. ||'
                 {12/29/09: Updated Copyright info for 2010}

      +'** Dedicated to my friend Paul Romine. ** ||'  {04/17/09}

      +'** Compile Date:  '+Compile_Date+'  January 2011 Beta. ||'

      +'Database Path: '+Editor_Path);       {Compile_Date ends with period.}
END; { EXIT_SCREEN ============================================ }


BEGIN    { Main FO2EDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Gold Tool-Kit process}
  UseLordColors:= TRUE;

  Debug_Mode:= FALSE;   {07/22/07 Code}

  IF S2U(ParamStr(1)) = '/DEBUG'  {07/22/07 Code}
    THEN Debug_Mode:= True;

  ReadVars.ReadHelp:= NIL;  { removes the HELP button in the prompts. }   {Gold Tool-Kit process}

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
      {Gold toolkit process}

  RecordNum:= 0;

  IF Exist('OH2PLAY.DAX') THEN DeleteFile('OH2PLAY.DAX');
     {Fixed glitch referring to SKELPLAY.DAX 12/10/09}

  READ_CONFIG;  {process existing FO2EDIT.cfg file.}

  Editor_Path:= S2U(IGMDIR+OH2Player_FN);

  IF Exist(Editor_Path) THEN READ_WARRIORS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0FO2EDIT `!could not locate the `@Forest Outhouse''s ');
      CWriteLn('  `#OH2PLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0FO2EDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);

      CWriteLn(' ');   {12/18/09}
      CWriteLn('  `#Problem Solving Note: `%Make sure the `!FO2EDIT.CFG `%file contains ');
                       {12/18/09: verified 12/30/09}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}

      CWriteLn(' ');
      CWriteLn('  `!Terminating `0FO2EDIT `!after 3 seconds delay.  ');

      CWriteLn('  `0This version is `@NOT `0usable with `#Forest Outhouse `%v2.50.');

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { FO2EDIT.pas }


{ Finished first round code editing 04/17/09 10:31 pm. }
{ 04/17/09: 11:00 pm. Finished first compilation testing round. }
{   Changed from v0.10 alpha to v0.20 Beta. 04/17/09 }

{v0.25: testing of player structure changes 04/24/09}

          {05/03/09: v0.32 Beta.  06/30/09: v0.35 beta}

          { 07/29/09: use v0.45 Beta.  08/24/09: v0.55 Beta }
          { 10/03/09: used v0.58 beta.  11/03/09: use v0.60 beta }

          { 11/30/09: changed to v0.65 Beta.}
             {12/10/09: minor editing}

