PROGRAM HAGEDIT;  { Nice Hag Player Database Editor Utility }

  { Started creation using CHANEDIT source code 09/08/2008. }
  { ================================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

     {$I HAGVARS.INC}    {** January 2011 Non-Beta development}

     {01/22/10: all code is verified}
{ =================================================================================== }

CONST Version: STRING = 'v1.00';

      Compile_Date: STRING = 'December 31, 2010.';

      Release_Date: STRING = 'December 31th, 2010.';
          {Added Release_Date statement 12/24/08}
         {12/30/09: All code in program is fully tested.}
      { ------------------------------------------------ }

      CfgName: STRING = 'HAGEDIT.CFG';

      HagPlayer_FN: STRING = 'HAGPLAY.DAT';

      RealName = '1';   LordName = '2';   PlayNum  = '3';
      Visits   = '4';   HitMax   = '5';   Strength = '6';
      Defense  = '7';   Charm    = '8';   Gold     = '9';
      Gems     = '0';   Potions  = 'A';   Wisdom   = 'B';
      { ------------------------------------------------------- }

      { Q - Quit/Save Changes.   X - Search for Player. }
      { * - New Day for Player.  DELETE PLAYER: not needed. }
      { ------------------------------------------------------- }

      OneBillion: LONGINT = 1000000000;  {09/08/2008}

      Max_Visits: BYTE = 20;  {08/10/2008}
      { ================================================= }

VAR TSearch: HAG_PLAYER;   { for player searches }

    TNHEdit: HAG_PLAYER;

    Editor_Path: STRING;      { File Vars for HAGPLAY.DAT access }

    Editor_File:  FILE OF HAG_PLAYER;

    IGMDir: STRING;

    RecordNum   : BYTE;

    DebugVar: BOOLEAN;  {07/22/07}

      { TempNum, Used, Found: Accessed from HAGVARS.INC.   Used }
      { in record Seek process.  }
    { ================================================================================== }

PROCEDURE READ_CONFIG;
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter dir. path to Nice Hag IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

END;       { Read_Config ------------------------------------------------- }


PROCEDURE READ_WARRIORS_FILE;    { Reads the IGM's HAGPLAY.DAT file. }
BEGIN
  Editor_Path:= S2U(IGMDIR+HagPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TNHEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


PROCEDURE WRITE_WARRIORS_FILE;      { Writes IGM's HAGPLAY.DAT file }
BEGIN
  Editor_Path:= S2U(IGMDIR+HagPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TNHEdit);

  CLOSE(Editor_File);
END;     { WRITE_WARRIORS_FILE   ------------------------------ }


PROCEDURE SEARCH_PLAYER(Num:INTEGER);
      { Reads HAGPLAY.DAT. Does search on player record number }
BEGIN
  Editor_Path:= S2U(IGMDIR+HagPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }

    
FUNCTION Get(b:CHAR):STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TNHEdit.RealName;

     LordName : Get:='`$'+TNHEdit.LordName;

     PlayNum  : Get:='`@'+N2S(TNHEdit.PlayNum);  {Contains player's LORD player #.}

     Visits   : IF TNHEdit.Visits = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TNHEdit.Visits);

     HitMax   : IF TNHEdit.HitMax = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.HitMax);

     Strength : IF TNHEdit.Strength = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Strength);

     Defense  : IF TNHEdit.Defense = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Defense);

     Charm    : IF TNHEdit.Charm = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Charm);

     Gold     : IF TNHEdit.Gold = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Gold);
         {12/25/08: replaced FOREST stat with GOLD stat.}

     Gems     : IF TNHEdit.Gems = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Gems);

     Potions  : IF TNHEdit.Elixirs = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Elixirs);

     Wisdom   : IF TNHEdit.Wisdom = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TNHEdit.Wisdom);
  END;

  CursorOff;   {10/15/07.  needed to fix bug found by Dennis Collins}
               { in 2006 when he checked on KLBEDIT. }

    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }
                

{ 1 }PROCEDURE Do_RealName;          {Created/Verified 09/08/08}
BEGIN
  TNHEdit.RealName:=
    PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TNHEdit.RealName,FALSE);

  WRITE_WARRIORS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


{ 2 }PROCEDURE Do_LordName;           {Created/Verified 09/08/08}
BEGIN
  TNHEdit.LordName:=
    PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TNHEdit.LordName,FALSE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


    { In normal usage, don't allow users to change LORD Player Numbers. }

{ 3 }PROCEDURE DO_PLAYER_NUMBER;              {Created/Verified 09/08/08}
BEGIN
  TNHEdit.PlayNum:=
    PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TNHEdit.PlayNum,0,160,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXy(52,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(52,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;               {Created/Verified 09/08/08}
BEGIN       {uses 0-20 range}
  TNHEdit.Visits:=
    PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TNHEdit.Visits,0,Max_Visits,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,6,Replicate(5,' '));
  CwriteXY(22,6,Get(Visits));
END;


{ 5 }PROCEDURE DO_HITMAX;                 {Created/Verified 09/08/08}
BEGIN
  TNHEdit.HitMax:=
    PromptNum(0,0,'Enter # of HitMax (0-16,000)?',' HitMax Points Change',TNHEdit.HitMax,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,6,Replicate(6,' '));
  CWriteXY(58,6,Get(HitMax));
END;


{ 6 }PROCEDURE DO_STRENGTH;                 {Created/Verified 09/08/08}
BEGIN
  TNHEdit.Strength:=
    PromptNum(0,0,'Enter # of Strength (0-16,000)?',' Strength Points Change ',TNHEdit.Strength,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(Strength));
END;


{ 7 }PROCEDURE DO_DEFENSE;                 {Created/Verified 09/08/08}
BEGIN
  TNHEdit.Defense:=
    PromptNum(0,0,'Enter # of Defense (0-16,000)?',' Defense Points Change ',TNHEdit.Defense,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,7,Replicate(6,' '));
  CWriteXY(58,7,Get(Defense));
END;


{ 8 }PROCEDURE DO_CHARM;               {Created/Verified 09/08/08}
BEGIN
  TNHEdit.Charm:=
    PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Points Change ',TNHEdit.Charm,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,8,Replicate(6,' '));
  CwriteXY(22,8,Get(Charm));
END;


{ 9 }PROCEDURE DO_Gold;   {Created/Verified 09/08/08}
BEGIN                      {12/25/08: renamed DO_FOREST to DO_GOLD}
  TNHEdit.Gold:=
    PromptNum(0,0,'Enter Gold Coins Gain/Loss (0-1 Billion)?',' Gold Coins Change ',TNHEdit.Gold,0,OneBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(50,8,Replicate(14,' '));  {12/25/08: changed 6 to 14}
  CWriteXY(50,8,Get(Gold));
END;         {12/25/08: changed 58 to 50. verified 11:58 pm}


{ 0 }PROCEDURE DO_GEMS_CHANGE;    {Created/Verified 09/08/08}
BEGIN
  TNHEdit.Gems:=
    PromptNum(0,0,'Enter Gems Change (0-16,000)?',' Gems Change',TNHEdit.Gems,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,9,Replicate(8,' '));
  CWriteXY(22,9,Get(Gems));
END;


{ A }PROCEDURE DO_ELIXIR_POTIONS;    {Created/Verified 09/08/08}
BEGIN
  TNHEdit.Elixirs:=
    PromptNum(0,0,'Enter Elixir Potions (0-16,000)?',' Elixirs Change',TNHEdit.Elixirs,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,9,Replicate(8,' '));
  CWriteXY(58,9,Get(Potions));
END;


{ B }PROCEDURE DO_WISDOM;      {Created/Verified 09/08/08}
BEGIN
  TNHEdit.Wisdom:=
    PromptNum(0,0,'Enter Wisdom Gained/Lost (0-1 Billion)?',' Wisdom Gained/Lost Change', TNHEdit.Wisdom,0,OneBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,10,Replicate(14,' '));
  CwriteXY(22,10,Get(Wisdom));
END;


{ No point in having Delete Player in this IGM. DeletePlayer process was removed. }

{ note: To use Y, N responses via keyboard, one has to use
  the ALT key. Or simply use the mouse to click on the option wanted. }


{ * }PROCEDURE DO_NEW_DAY;     {Created/Verified 09/08/08}
BEGIN
  CWGotoXY(5,24);
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

  IF (TNHEdit.PlayNum > 160) THEN
    BEGIN
      TNHEdit.PlayNum:= 160;
      PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Visits > 0 THEN
    BEGIN
      TNHEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.HitMax < 0 THEN
    BEGIN
      TNHEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max Hitpoints field to Zero.');
    END;

  IF TNHEdit.HitMax > 0 THEN
    BEGIN
      TNHEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the Max Hitpoints field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Strength < 0 THEN
    BEGIN
      TNHEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TNHEdit.Strength > 0 THEN
    BEGIN
      TNHEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Defense < 0 THEN
    BEGIN
      TNHEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TNHEdit.Defense > 0 THEN
    BEGIN
      TNHEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Charm < 0 THEN
    BEGIN
      TNHEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TNHEdit.Charm > 0 THEN
    BEGIN
      TNHEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to Zero.');
    END;

  { --------------------------------------------------- }
         {12/25/08: replaced FOREST stat with GOLD stat.}
  IF TNHEdit.Gold < 0 THEN
    BEGIN
      TNHEdit.Gold:= 0;
      PromptOK('Advisory:',' Reset negative Gold Coins field to Zero.');
    END;

  IF TNHEdit.Gold > 0 THEN
    BEGIN
      TNHEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Gold Coins field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Gems < 0 THEN
    BEGIN
      TNHEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems amount to Zero.');
    END;

  IF TNHEdit.Gems > 0 THEN
    BEGIN
      TNHEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting the Gems amount to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Elixirs < 0 THEN
    BEGIN
      TNHEdit.Elixirs:= 0;
      PromptOK('Advisory:',' Reset negative Elixir Potions field to Zero.');
    END;

  IF TNHEdit.Elixirs > 0 THEN
    BEGIN
      TNHEdit.Elixirs:= 0;
      PromptOK('Advisory:',' Resetting the Elixir Potions field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TNHEdit.Wisdom < 0 THEN
    BEGIN
      TNHEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Points field to Zero.');
    END;

  IF TNHEdit.Wisdom > 0 THEN
    BEGIN
      TNHEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting the Wisdom Points field to Zero.');
    END;
  { --------------------------------------------------- }

END;     { DO_NEW_DAY  ================================== }


FUNCTION  MaxPlayers: WORD; { Gets the number of customer records }
BEGIN
  MaxPlayers:= 1;

  Editor_Path:= S2U(IGMDIR+HagPlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MaxPlayers:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MaxPlayers  --------------------------------------------- }


FUNCTION GetRecordNum:STRING;
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MaxPlayers);
    { First record # displayed will be 1, not 0. }
END;     { GetRecordNum ---------------------------------------------- }


PROCEDURE ShowMenu;
BEGIN
  ClrScr;

  CWritelnC('`%** `$Nice Hag `0Player Database Editor `!'+Version+' `%**');  {Line 1}
  CWritelnC('`@HAGPLAY.DAT `%Record Number: '+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
    CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);                 {Line 6}
    CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Hitmax Points `%: '+Get(HitMax));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
    CWrite('`#(`%6`#) `!Strength Pts `%: '+Get(Strength));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Defense Pts   `%: '+Get(Defense));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
    CWrite('`#(`%8`#) `!Charm Points `%: '+Get(Charm));

  CWGotoXY(34,8);         {12/25/08: changed 38 to 34. verified}
  CWriteLN('`#(`%9`#) `!Gold Coins`%: '+Get(Gold));
         {12/25/08: replaced FOREST stat with GOLD stat.}
  { -------------------------------------------- }

  CWGotoXY(3,9);                 {Line 9}
    CWrite('`#(`%0`#) `!Gems Change  `%: '+Get(Gems));  {12/25/08 edit}

  CWGotoXY(38,9);
  CWriteLN('`#(`%A`#) `!Elixir Potions`%: '+Get(Potions));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10}
  CWriteLN('`#(`%B`#) `!Wisdom Points`%: '+Get(Wisdom));
  { -------------------------------------------- }

  CWriteLn(' ');  {Blank Line, Line #11}

  { --------------------------------------------------------------- }
  CWGotoXY(3,12);
    CWrite('`2(`0X`2) `%Search by Name');

  CWGotoXY(40,12);
  CWriteln('`2(`0]`2) `%Advance One Record');
  { -------------------------------------------- }

  CWGotoXY(3,13);
    CWrite('`2(`0[`2) `%Back Up One Record');

  CWGotoXY(40,13);
  CWriteln('`2(`0*`2) `%Reset Player Stats');
  { -------------------------------------------- }

  CWriteln(' ');  {Blank Line, Line #14.}

  CWGotoXY(3,15);
  Cwrite('`$    Input key to change, or `%Q `$to Quit and Save.');
END;     { ShowMenu  ------------------------------------------------------ }


{ X }PROCEDURE DO_PLAYER_SEARCH;
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+HagPlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no HAGPLAY.DAT then we can't search and
       couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
       YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_WARRIORS_FILE;
            ShowMenu;
            Exit; { bail out of loop since we got who we want }
          END;
     END;

    Inc(Counter);
  UNTIL Counter=MaxPlayers; { End of repeat loop, repeats until we get
										to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;   { DO_PLAYER_SEARCH ====================================== }


PROCEDURE RUN_EDITOR;       {verified 09/08/08}
  VAR Code: CHAR;
BEGIN
  ShowMenu;

  REPEAT
    Code:= AInput('1234567890ABQX][*');

    CASE Code OF
      '1' : Do_RealName;

      '2' : Do_LordName;

      '3' : BEGIN
              CWGotoXY(1,17);   {Show text on Line 17. 09/08/08

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see ');
              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
              DELAY(3000);

              IF DebugVar THEN   {07/22/07: verified 09/08/08}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the Player Number field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(3000);

                  DO_PLAYER_NUMBER;
                END;

              ShowMenu;
            END;

      '4' : DO_VISITS;

      '5' : DO_HITMAX;

      '6' : DO_STRENGTH;

      '7' : DO_DEFENSE;

      '8' : DO_CHARM;

      '9' : DO_Gold;   {12/25/08: renamed DO_FOREST to DO_GOLD}

      '0' : DO_GEMS_CHANGE;   {12/25/08: renamed DO_GEMS to DO_GEMS_CHANGE}

      'A' : DO_ELIXIR_POTIONS;

      'B' : DO_WISDOM;


      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'X' : DO_PLAYER_SEARCH;

      ']' : BEGIN
              Inc(RecordNum);
              IF RecordNum > (MaxPlayers - 1) THEN RecordNum:= 0;  {05/07/04 edit}

              READ_WARRIORS_FILE;
              ShowMenu;
            END;

      '[' : BEGIN
              IF RecordNum=0
                THEN RecordNum:= (MaxPlayers - 1)
                ELSE Dec(RecordNum);

              READ_WARRIORS_FILE;
              ShowMenu;
            END;

      '*' : BEGIN
              DO_NEW_DAY;

              ShowMenu;

              WRITE_WARRIORS_FILE;
            END;

    END;       {CASE Code - ending}
  UNTIL Code = 'Q';
END;       { RUN_EDITOR ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;          {verified 09/08/08}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' The Nice Hag''s Player Database Editor Credits: ',
      'HAGEDIT.EXE '+Version+'.  Copyright 2008-2011 by Donald Tidmore. |'

      +'** Dedicated to my friend Shannon Talley. ** ||'  {12/24/08}

      {  +'** Compile Date:  '+Compile_Date+'  ** Non-Beta development. ||'  }

      +'Released officially on:  '+Release_Date+' ||'     {Added 12/24/08}

      +'Database Path: '+Editor_Path);       {Compile_Date ends with period.}

END; { EXIT_SCREEN ============================================ }


BEGIN    { Main HAGEDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Gold Tool-Kit process}
  UseLordColors:= TRUE;

  DebugVar:= FALSE;   {07/22/07}

  IF S2U(ParamStr(1)) = '/DEBUG'  {07/22/07}
    THEN DebugVar:= True;

  ReadVars.ReadHelp:= NIL;  { removes the HELP button in the prompts. }   {Gold Tool-Kit process}

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
      {Gold toolkit process}

  RecordNum:= 0;

  IF Exist('HAGPLAY.DAX') THEN DeleteFile('HAGPLAY.DAX');

  READ_CONFIG;  {process existing HAGEDIT.CFG file.}

  Editor_Path:= S2U(IGMDIR+HagPlayer_FN);

  IF Exist(Editor_Path) THEN READ_WARRIORS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0HAGEDIT `!could not locate the `@Nice Hag''s ');
      CWriteLn('  `#HAGPLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0HAGEDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);
      CWriteLn(' ');

      CWriteLn('  `#Problem Solving Note: `%Make sure the `!HAGEDIT.CFG `%file contains ');
                     {12/18/09: verified 12/30/09}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}
      CWriteLn(' ');    {12/18/09}

      CWriteLn('  `6Only for usage with `!The Nice Hag `0v2.31+ Betas. '); {09/08/08}

      CWriteLn(' ');    {12/30/09}
      CWriteLn('  `!Terminating `0HAGEDIT `!after 3 seconds delay.  ');

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { HAGEDIT.pas }


{ First stage code editing finished 01:46 am 09/08/2008. }

{ Finished primary tests of HAGEDIT.EXE 3:39 am 09/08/2008. }

    {09/21/08: Changed v0.10 to v0.30 beta}
    {11/03/08: Changed to v0.40 beta.  12/02/08: v0.50}
    {12/24/08: v1.00 used temporarily}
    {12/25/08: reverted to v0.60 beta. database layout changes}

             {02/08/09: v0.70 beta - 03/03/09: v0.75 beta}
             {06/30/09: v0.90 beta. 09/12/09: v1.00, non-beta}

