PROGRAM LC2EDIT;  { LORD Cavern Player Database Editor Utility }

  { Started beta cycle #2 on Dec. 31th, 2007. }
  { ================================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

     {$I CAVEVARS.INC}         {January 2011 Beta}
	  { =================================================================================== }

CONST Version: STRING = 'v1.17 Beta';
         {01/20/10: use v1.15 beta. Added Delete Player code}
         {03/06/10: use v1.16 beta}
         {11/30/10: changed to v1.17 beta}

      Compile_Date: STRING = 'December 26, 2010.';
      { ------------------------------------------------ }

      CfgName: STRING = 'LC2EDIT.CFG';

      CavePlayer_FN: STRING = 'CAVEPLAY.DAT';
          { 12/31/07: revised to use CAVEPLAY.DAT format/file. }

      RealName    = '1';   LordName   = '2';   PlayNum   = '3';
      Visits      = '4';   HitMax     = '5';   Strength  = '6';
      Defense     = '7';   Charm      = '8';   Forest    = '9';
      Gems        = '0';   Gold       = 'A';   Wisdom    = 'B';
      Adoptions   = 'C';   SkillUses  = 'D';   Searches  = 'E';
      Lays        = 'F';   FRescue    = 'G';   KidsLost  = 'H'; {04/25/09}
      Fairy_Count = 'I';    {coded 11/30/09}
      { ------------------------------------------------------- }

      { Q - Quit/Save Changes.   S - Search for Player. }
      { * - New Day for Player.  Delete Player not used by IGM. }

      { # - Used to test New Day's handling of Negative numbers }
      { ------------------------------------------------------- }

      TwoBillion: LongInt = 2000000000;

      Max_Visits: BYTE = 20;   {08/03/08}
      { ==================================================== }

VAR TSearch: CAVERN_PLAYER;   { for player searches }

    TLCEdit: CAVERN_PLAYER;

    Editor_Path: STRING;      { File Vars for CAVEPLAY.DAT access }

    Editor_File:  FILE OF CAVERN_PLAYER;

    IGMDir: STRING;

    RecordNum   : BYTE;

    Debug_Mode: BOOLEAN;
          {01/20/10: Renamed DebugVar to Debug_Mode.}

		{ TempNum, Used, Found: Accessed from CAVEVARS.INC.   Used }
		{ in record Seek process.  }
    { ================================================================================== }

PROCEDURE READ_CONFIG;      {Created 12/03/07: VERIFIED 12/04/07}
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;          {VERIFIED 12/04/07}
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter path to LORD Cavern IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;      {VERIFIED 12/04/07}

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

  { LC2EDIT: When run from compiler, verified that value of IGMDir is known at this point. }
END;       { Read_Config ------------------------------------------------- }


PROCEDURE READ_WARRIORS_FILE;    { Reads the IGM's CAVEPLAY.DAT file. }
BEGIN                        { Rewrote 12/31/07 to use Caveplay.dat }
  Editor_Path:= S2U(IGMDIR+CavePlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TLCEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


PROCEDURE WRITE_WARRIORS_FILE;      { Writes IGM's CAVEPLAY.DAT file }
BEGIN                        { Rewrote 12/31/07 to use Caveplay.dat }
  Editor_Path:= S2U(IGMDIR+CavePlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TLCEdit);

  CLOSE(Editor_File);
END;     { WRITE_WARRIORS_FILE   ------------------------------ }


PROCEDURE SEARCH_PLAYER(Num:INTEGER);
                   { Does search on player record number }
BEGIN              { Rewrote 12/31/07 to use Caveplay.dat }
  Editor_Path:= S2U(IGMDIR+CavePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }

    
FUNCTION Get(b:CHAR): STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TLCEdit.RealName;
        {12/31/07: renamed Real_Name VAR to RealName.}

     LordName : Get:='`$'+TLCEdit.LordName;

     PlayNum  : Get:='`@'+N2S(TLCEdit.PlayNum);   {Enabled 12/31/07}
                  { Contains player's LORD player #. }

     Visits   : IF TLCEdit.Visits = 0   {used by LORDCAVE v1.7}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TLCEdit.Visits);

     HitMax   : IF TLCEdit.HitMax = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.HitMax);

     Strength : IF TLCEdit.Strength = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Strength);

     Defense  : IF TLCEdit.Defense = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Defense);

     Charm    : IF TLCEdit.Charm = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Charm);

     Forest   : IF TLCEdit.Forest = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Forest);

     Gems     : IF TLCEdit.Gems = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Gems);

     Gold     : IF TLCEdit.Gold = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Gold);

     Wisdom   : IF TLCEdit.Wisdom = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Wisdom);

     { ================== Coded 12/02/07: =================== }
     Adoptions: IF TLCEdit.Adoptions = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TLCEdit.Adoptions);

     SkillUses: IF TLCEdit.Skill_Uses = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TLCEdit.Skill_Uses);

     Searches : IF TLCEdit.Search_Left = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TLCEdit.Search_Left);

     Lays     : IF TLCEdit.Lays = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TLCEdit.Lays);

     FRescue  : IF TLCEdit.Fairy_Rescue
                  THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';
            { Used for IGM's Fairy_Rescue boolean VAR}
            { 08/18/08: Renamed FairyRescue to Fairy_Rescue. }

     KidsLost : IF TLCEdit.Kids_Lost = 0   {Added 04/25/09}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TLCEdit.Kids_Lost);

     { -------------------- Added 11/30/09 ------------------------ }
     Fairy_Count : IF TLCEdit.Fairies = 0    {Coded 11/30/09: verified}
                     THEN  Get:= '`#None'   {verified 12/05/09}
                     ELSE  Get:= '`$'+N2S(TLCEdit.Fairies);
  END;  {CASE}

  CursorOff;   {10/15/07.  needed to fix bug found by Dennis Collins}
					{ in 2006 when he checked on KLBEDIT. }

	 { When program's user would change a setting in a dialog box, when }
	 { they returned to the main screen, the cursor would be back on the }
	 { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }


{ 1 }PROCEDURE DO_REAL_NAME;          {VERIFIED 12/04/07}
BEGIN
  TLCEdit.RealName:=
  PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TLCEdit.RealName,FALSE);

  WRITE_WARRIORS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


{ 2 }PROCEDURE DO_LORD_NAME;            {VERIFIED 12/04/07}
BEGIN
  TLCEdit.LordName:=
  PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TLCEdit.LordName,FALSE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


  { Coding done 12/03/07.  Usage enabled 12/31/07. }
  { In normal usage, don't allow users to change LORD Player Numbers. }

{ 3 }PROCEDURE DO_PLAYER_NUMBER;       {VERIFIED Jan. 2008}
BEGIN
  TLCEdit.PlayNum:=
  PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TLCEdit.PlayNum,0,160,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXy(58,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(58,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;               {VERIFIED 12/28/07}
BEGIN
  TLCEdit.Visits:=                {Revised 07/27/08}
	 PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TLCEdit.Visits,0,Max_Visits,TRUE);
				 {08/03/08: revised to use Max_Visits const.}

  WRITE_WARRIORS_FILE;
  CwriteXY(22,6,Replicate(5,' '));
  CwriteXY(22,6,Get(Visits));
END;   {IGM's Max Visits/Day Limit is 20, as of mid-July 2008.}


{ 5 }PROCEDURE DO_MAX_HITPOINTS;                 {VERIFIED 12/04/07}
BEGIN
  TLCEdit.HitMax:=
  PromptNum(0,0,'Enter # of Max HitPoints (0-16,000)?',' Max HitPoints Today Change',TLCEdit.HitMax,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,6,Replicate(6,' '));
  CWriteXY(58,6,Get(HitMax));
END;


{ 6 }PROCEDURE DO_STRENGTH_POINTS;                 {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Strength:=
  PromptNum(0,0,'Enter # of Strength (0-16,000)?',' Strength Change ',TLCEdit.Strength,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(Strength));
END;


{ 7 }PROCEDURE DO_DEFENSE_POINTS;               {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Defense:=
  PromptNum(0,0,'Enter Defense Points (0-16,000)?',' Defense Change ',TLCEdit.Defense,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(58,7,Replicate(6,' '));
  CwriteXY(58,7,Get(Defense));
END;


{ 8 }PROCEDURE DO_CHARM_POINTS;               {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Charm:=
  PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Change ',TLCEdit.Charm,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,8,Replicate(6,' '));
  CwriteXY(22,8,Get(Charm));
END;


{ 9 }PROCEDURE DO_FOREST_FIGHTS;               {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Forest:=
    PromptNum(0,0,'Enter Forest Fights (0-16,000)?',' Forest Fights Change', TLCEdit.Forest,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(58,8,Replicate(6,' '));
  CwriteXY(58,8,Get(Forest));
END;


{ 0 }PROCEDURE DO_GEMS;      {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Gems:=
   PromptNum(0,0,'Enter # of Gems (0-16,000)?',' Gems Change', TLCEdit.Gems,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,9,Replicate(6,' '));
  CwriteXY(22,9,Get(Gems));
END;


{ A }PROCEDURE DO_GOLD_COINS;               {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Gold:=
    PromptNum(0,0,'Enter Gold Coins (0-2 Billion)?',' Gold Found/Lost Change', TLCEdit.Gold,0,TwoBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(51,9,Replicate(14,' '));
  CwriteXY(51,9,Get(Gold));
END;


{ B }PROCEDURE DO_WISDOM_POINTS;               {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Wisdom:=
    PromptNum(0,0,'Enter Wisdom Points (0-2 Billion)?',' Wisdom Points Change', TLCEdit.Wisdom,0,TwoBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,10,Replicate(14,' '));
  CwriteXY(22,10,Get(Wisdom));
END;


{ C }PROCEDURE DO_ADOPTIONS;                 {VERIFIED 12/04/07}
BEGIN                         {Edited 01/28/09}
  TLCEdit.Adoptions:=
	 PromptNum(0,0,'Enter # of Adoptions (-50 to 125)?',' Adoptions Change',TLCEdit.Adoptions,-50,125,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(58,10,Replicate(7,' '));   {01/28/09: Changed 6 to 7}
  CWriteXY(58,10,Get(Adoptions));
END;


{ D }PROCEDURE DO_SKILL_USES;                 {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Skill_Uses:=
  PromptNum(0,0,'Enter # of Skill Use Points (0-50)?',' Skill Use Points Change',TLCEdit.Skill_Uses,0,50,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,11,Replicate(6,' '));
  CWriteXY(22,11,Get(SkillUses));
END;


  { 12/31/07 layout: Search_Left is now a BYTE format var. }
  { Editing range changed to 0-250 in LCSETUP, LC2EDIT, etc. }

{ E }PROCEDURE DO_SEARCHES_LEFT;                 {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Search_Left:=
    PromptNum(0,0,'Enter # of Searches Left (0-250)?',' Cave Searches Left Change',TLCEdit.Search_Left,0,250,TRUE);
              {New format uses INTEGER for Search_Left field.}

  WRITE_WARRIORS_FILE;
  CWriteXY(58,11,Replicate(6,' '));
  CWriteXY(58,11,Get(Searches));
END;


{ F }PROCEDURE DO_LAYS;                 {VERIFIED 12/04/07}
BEGIN
  TLCEdit.Lays:=
    PromptNum(0,0,'Enter # of Lays (0-50)?',' Lay Points Change',TLCEdit.Lays,0,50,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,12,Replicate(6,' '));
  CWriteXY(22,12,Get(Lays));
END;


{ G }PROCEDURE DO_FAIRY_RESCUE;                 {VERIFIED 12/04/07}
BEGIN
  IF TLCEdit.Fairy_Rescue = TRUE THEN TLCEdit.Fairy_Rescue:= FALSE
	 ELSE IF TLCEdit.Fairy_Rescue = FALSE THEN TLCEdit.Fairy_Rescue:= TRUE;
		  { 08/18/08: Renamed FairyRescue to Fairy_Rescue. }

  WRITE_WARRIORS_FILE;
  CWriteXY(58,12,Replicate(6,' '));
  CWriteXY(58,12,Get(FRescue));
END;


{ H }PROCEDURE DO_KIDS_LOST;       {Created 04/25/09: verified}
BEGIN
  TLCEdit.Kids_Lost:=
	 PromptNum(0,0,'Enter # of Kids Lost (0-255)?',' Kids Lost Change',TLCEdit.Kids_Lost,0,255,TRUE);
		  {04/27/09: Changed 0-500 range to 0-255. Field is BYTE.}

  WRITE_WARRIORS_FILE;
  CWriteXY(22,13,Replicate(6,' '));
  CWriteXY(22,13,Get(KidsLost));
END;


{ I }PROCEDURE DO_FAIRY_COUNT;       {Created 11/30/09: verified}
BEGIN                           {Implemented full usage 12/05/09}
  TLCEdit.Fairies:=
	 PromptNum(0,0,'Enter # of Fairies Received (0-10)?',' Fairy Counter Change',TLCEdit.Fairies,0,10,TRUE);
			  {Field is BYTE.  Range is 0-10}

  WRITE_WARRIORS_FILE;
  CWriteXY(58,13,Replicate(6,' '));
  CWriteXY(58,13,Get(Fairy_Count));
END;


{ note: To use Y, N responses via keyboard, one has to use }
{ the ALT key. Or simply use the mouse to click on the option wanted. }


{ * }PROCEDURE DO_NEW_DAY;     {VERIFIED 12/04/07}
BEGIN
  CWGotoXY(5,19);    {Write data on Line #19. 12/04/07}
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

  TLCEdit.PlayNum:= 200;  {04/24/08 debug}

  IF (TLCEdit.PlayNum > 160) THEN  {Created 12/04/07}
	 BEGIN                            {Enabled 12/31/07}
		TLCEdit.PlayNum:= 160;
		PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
	 END;

  { --------------------------------------------------- }
		  {BYTE field; Values can't be negative}
  IF TLCEdit.Visits > 0 THEN       {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;

  { --------------------------------------------------- }
        {BYTE field; Values can't be negative}
  IF TLCEdit.Search_Left > 0 THEN    {rewrote 12/31/07: VERIFIED Jan. 2008}
	 BEGIN                            {Moved up to here 12/31/07}
		TLCEdit.Search_Left:= 0;
		PromptOK('Advisory:',' Resetting the Cave Searches Left field to Zero.');
	 END;

  { --------------------------------------------------- }
  { Lays is BYTE format, so can't be negative, in new format. }

  IF TLCEdit.Lays > 0 THEN  {Coded 12/03/07: VERIFIED 12/04/07}
	 BEGIN                            {Moved up to here 12/31/07}
		TLCEdit.Lays:= 0;
		PromptOK('Advisory:',' Resetting the Lay Points field to Zero.');
	 END;

  { --------------------------------------------------- }
  { Skill_Uses is BYTE. Value can't be negative }

  IF TLCEdit.Skill_Uses > 0 THEN  {Coded 12/03/07: VERIFIED 12/04/07}
    BEGIN                            {Moved up to here 12/31/07}
      TLCEdit.Skill_Uses:= 0;
      PromptOK('Advisory:',' Resetting the Skill Use Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.HitMax < 0 THEN       {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max HitPoints field to Zero.');
    END;

  IF TLCEdit.HitMax > 0 THEN       {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the Max HitPoints field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.Strength < 0 THEN     {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TLCEdit.Strength > 0 THEN     {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.Defense < 0 THEN      {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TLCEdit.Defense > 0 THEN      {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.Charm < 0 THEN        {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TLCEdit.Charm > 0 THEN        {VERIFIED 12/28/07}
    BEGIN
		TLCEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.Forest < 0 THEN       {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Forest:= 0;
      PromptOK('Advisory:',' Reset negative Forest Fights field to Zero.');
    END;

  IF TLCEdit.Forest > 0 THEN       {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Forest:= 0;
      PromptOK('Advisory:',' Resetting the Forest Fights field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.Gems < 0 THEN         {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems field to Zero.');
    END;

  IF TLCEdit.Gems > 0 THEN         {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting the Gems field to Zero.');
	 END;

  { --------------------------------------------------- }
  IF TLCEdit.Gold < 0 THEN         {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Gold:= 0;
      PromptOK('Advisory:',' Reset negative Gold Coins field to Zero.');
    END;

  IF TLCEdit.Gold > 0 THEN         {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Gold Coins field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLCEdit.Wisdom < 0 THEN       {Created 12/04/07: VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Points field to Zero.');
    END;

  IF TLCEdit.Wisdom > 0 THEN       {VERIFIED 12/28/07}
    BEGIN
      TLCEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting the Wisdom Points field to Zero.');
    END;

  { --------------------------------------------------- }
  { Note: ADOPTIONS is INTEGER type, so it can be negative. }

  IF TLCEdit.Adoptions < 0 THEN   {Coded 12/02/07: VERIFIED 12/28/07}
	 BEGIN
		TLCEdit.Adoptions:= 0;
		PromptOK('Advisory:',' Reset negative Adoptions field to Zero.');
	 END;

  IF TLCEdit.Adoptions > 0 THEN   {Coded 12/02/07: VERIFIED 12/04/07}
	 BEGIN
		TLCEdit.Adoptions:= 0;
		PromptOK('Advisory:',' Resetting the Adoptions field to Zero.');
	 END;

  { Boolean variables: All get reset to FALSE: }

  TLCEdit.Fairy_Rescue:= FALSE;     {12/03/07}
		{ used only when IGM executes RHP Scripts. }
		  { 08/18/08: Renamed FairyRescue to Fairy_Rescue. }

  { ==================== Added 04/25/2009 =========================== }
  { Note: KIDS_LOST is BYTE type, so it can't EVER be negative. }
  { 04/25/09: Changed field from INTEGER to BYTE in INC file.   }

  IF TLCEdit.Kids_Lost > 0 THEN     {Edited 04/25/09: verified}
    BEGIN
      TLCEdit.Kids_Lost:= 0;

		PromptOK('Advisory:',' Resetting the Kids Lost field to Zero.');
	 END;

  { -------------------- Added 11/30/09 ------------------------- }
  { Fairies is BYTE format, so can't be negative, in new format. }

  IF TLCEdit.Fairies > 0 THEN  {Coded 11/30/09: verified}
	 BEGIN
		TLCEdit.Fairies:= 0;
		PromptOK('Advisory:',' Resetting the Fairies Received counter field to Zero.');
	 END;

END;     { DO_NEW_DAY  ================================== }


  {12/03/07: renamed MaxPlayers to MAX_PLAYERS.}
FUNCTION  MAX_PLAYERS: WORD; { Gets the number of customer records }
BEGIN
  MAX_PLAYERS:= 1;

  Editor_Path:= S2U(IGMDIR+CavePlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MAX_PLAYERS:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MAX_PLAYERS  --------------------------------------------- }


FUNCTION GetRecordNum: STRING;
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MAX_PLAYERS);
    { First record # displayed will be 1, not 0. }
END;     { GetRecordNum ---------------------------------------------- }


       {01/20/10: Changed ShowMenu to SHOW_MENU.}
PROCEDURE SHOW_MENU;
BEGIN
  ClrScr;

  CWritelnC('`%    ** `$LORD Cavern''s `0Player Database Editor `!'+Version+' `%**');  {Line 1}
  CWritelnC('`@    CAVEPLAY.DAT `%Record Number:  `$'+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
	 CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

	{ Not usable until IGM is actually using VISITS field}

  CWGotoXY(3,6);        {Line 6, column 1. temp coding}
	 CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Max HitPoints `%: '+Get(HitMax));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
	 CWrite('`#(`%6`#) `!Strength Pts `%: '+Get(Strength));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Defense Points`%: '+Get(Defense));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
   CWrite('`#(`%8`#) `!Charm Points `%: '+Get(Charm));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Forest Fights `%: '+Get(Forest));
  { -------------------------------------------- }

  { Note: All lines from here to the end of SHOW_MENU }
  { process were written in 12/02/2007 coding sessions. }

  CWGotoXY(3,9);                 {Line 9. Coded 12/02/2007}
    CWrite('`#(`%0`#) `!Gems Found   `%: '+Get(Gems));

  CWGotoXY(34,9);
  CWriteLN('`#(`%A`#) `!Gold Coins `%: '+Get(Gold));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10. Coded 12/02/2007}
	 CWrite('`#(`%B`#) `!Wisdom Points`%: '+Get(Wisdom));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Kids Adopted  `%: '+Get(Adoptions));
  { -------------------------------------------- }

  CWGotoXY(3,11);                 {Line 11. Coded 12/03/2007}
	 CWrite('`#(`%D`#) `!Skill Use Pts`%: '+Get(SkillUses));

  CWGotoXY(38,11);
  CWriteLN('`#(`%E`#) `!Searches Left `%: '+Get(Searches));
  { -------------------------------------------- }

  CWGotoXY(3,12);                 {Line 12. Coded 12/03/2007}
	 CWrite('`#(`%F`#) `!Lay Points   `%: '+Get(Lays));

  CWGotoXY(38,12);
  CWriteLN('`#(`%G`#) `!Fairy Rescue? `%: '+Get(FRescue));
  { -------------------------------------------- }

  { ================= Start of 04/25/09 rewrites ================== }
  CWGotoXY(3,13);
  CWrite('`#(`%H`#) `!Kids Lost    `%: '+Get(KidsLost));  {Added 04/25/09}

  CWGotoXY(38,13);   {11/30/09}
  CWriteLn('`#(`%I`#) `!Fairy Counter `%: '+Get(Fairy_Count));  {11/30/09}
  { ------------------------------------------------------------- }

  CWriteLn(' ');  {Blank Line, Line #14}

  { --------------------------------------------------------------- }
  CWGotoXY(3,15);
   CWrite('`2(`0S`2) `%Search for Player');
       {01/20/10: Changed "Search by Name" to "Search for Player".}

  CWGotoXY(40,15);
	 CWrite('`2(`0]`2) `%Advance One Record');
  { -------------------------------------------- }

  CWGotoXY(3,16);
	 CWrite('`2(`0[`2) `%Back Up One Record');

  CWGotoXY(40,16);
  CWriteln('`2(`0*`2) `%Reset Player Stats');
  { -------------------------------------------- }
  { ================= End of 04/25/09 rewrite area =========== }

  CWGotoXY(3,17);      {Added 01/20/10}
  CWriteLn('`2(`0X`2) `%Delete Current Player');   {Added 01/20/10}
       {01/20/10: Changed "Delete Player Record" to "Delete Current Player".}

  BLANK(1);   {Blank line.  #18}

  CWGotoXY(3,19);    {Line #19}
  Cwrite('`$    Input key to change, or `%Q `$to quit and save.');

  IF Debug_Mode THEN    {Added 01/20/10: VERIFIED 01/20/10 4:59 pm}
    CWrite('  `@[Debug Mode] ');

END;     { SHOW_MENU  ----------------------------------------- }


       { 12/02/07: Changed X menu code to S for DO_PLAYER_SEARCH. }
{ S }PROCEDURE DO_PLAYER_SEARCH;
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+CavePlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no CAVEPLAY.DAT then we can't search and
       couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
		 YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_WARRIORS_FILE;
            SHOW_MENU;
            Exit; { bail out of loop since we got who we want }
          END;
     END;

    INC(Counter);
  UNTIL Counter=MAX_PLAYERS; { End of repeat loop, repeats until we get
										to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;   { DO_PLAYER_SEARCH ====================================== }


{ Added 01/20/10 using modified OT20EDIT.PAS code: }

{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 01/20/10: VERIFIED 01/20/10 4:59 pm}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TLCEdit.LordName+' known'
     +' as '+NoColor(TLCEdit.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TLCEdit.RealName:= 'X';
      TLCEdit.LordName:= '* DELETED *';

      TLCEdit.PlayNum:= 160;

        { Note: PlayNum 160 should not be in use by any valid players.}

      TLCEdit.Visits:= 0;

      TLCEdit.Fairies:= 0;
      TLCEdit.Kids_Lost:= 0;
      TLCEdit.Lays:= 0;
      TLCEdit.Search_Left:= 0;
      TLCEdit.Skill_Uses:= 0;

      TLCEdit.HitMax:= 0;
      TLCEdit.Strength:= 0;
      TLCEdit.Defense:= 0;
      TLCEdit.Charm:= 0;
      TLCEdit.Forest:= 0;

      TLCEdit.Gems:= 0;
      TLCEdit.Adoptions:= 0;
      TLCEdit.Gold:= 0;
      TLCEdit.Wisdom:= 0;

      TLCEdit.Fairy_Rescue:= FALSE;
      { ========================================== }

      WRITE_WARRIORS_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

		SHOW_MENU;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }


  {Disabled Do_Newday_Testing 08:06 pm 12/28/07 after verification}
  {01/10/10: Deleted disabled DO_NEWDAY_TESTING process}



PROCEDURE RUN_EDITOR;       {VERIFIED 12/04/07}
  VAR Code: CHAR;
BEGIN
  SHOW_MENU;

  REPEAT
   Code:= AInput('1234567890ABCDEFGHIQSX][*');
				{Added # 12/28/07 for use with DO_NEWDAY_TESTING.}
				{04/25/09: Added H code for Kids_Lost stat}
				{12/05/09: added I code for Fairy_Count stat}
        {01/20/10: Deleted # key. Added X key.}

	 CASE Code OF          {All usable components verified 12/28/07}
		'1' : DO_REAL_NAME;

		'2' : DO_LORD_NAME;

		'3' : BEGIN               {enabled usage 12/31/07}
            CWGotoXY(1,21);   {Show text on Line 21, as of 04/27/09}

            CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see ');
            CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
            DELAY(3000);

            IF Debug_Mode THEN   {coded 07/22/07: VERIFIED 12/28/07}
              BEGIN
                BLANK(1);
                CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                CWriteLn('  `0allowed to modify the `#Player Number `0field.  Do so with ');
                CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                DELAY(3000);

                DO_PLAYER_NUMBER;
              END;

              SHOW_MENU;
            END;

      '4' : DO_VISITS;

      '5' : DO_MAX_HITPOINTS;

      '6' : DO_STRENGTH_POINTS;

      '7' : DO_DEFENSE_POINTS;

      '8' : DO_CHARM_POINTS;

      '9' : DO_FOREST_FIGHTS;

      '0' : DO_GEMS;

      'A' : DO_GOLD_COINS;

      'B' : DO_WISDOM_POINTS;

      'C' : DO_ADOPTIONS;

      'D' : DO_SKILL_USES;       {Coded 12/03/07}

      'E' : DO_SEARCHES_LEFT;    {Coded 12/03/07}

      'F' : DO_LAYS;             {Coded 12/03/07}

      'G' : DO_FAIRY_RESCUE;     {Coded 12/03/07}

      'H' : DO_KIDS_LOST;   {Coded 04/25/09: verified 04/27/09}

      'I' : DO_FAIRY_COUNT;   {Added/Implemented 12/05/09}

      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'S' : DO_PLAYER_SEARCH;   {revised 12/02/07}

      {01/20/10: Deleted statement for disabled DO_NEWDAY_TESTING}

        { ------------------------ Added 01/20/10 --------------- }
      'X' : BEGIN               {Created 01/20/10: VERIFIED 01/20/10 4:59 pm}
              CWGotoXY(1,21);   {Start on Line 21}

              CWriteLn('                                                                      ');  {09/13/08. needed here}
                  {Writes blank line to screen. Line #21. 01/20/10}

              CWriteLn('  `0The `@Delete Player Record `0option is only usable when `$LC2EDIT ');
              CWriteLn('  `0is executed in `%Debug Mode, `0using the `!/Debug `0parameter. ');
              CWriteLn('  `!This option should only be used to deal with `@cheating players. ');
              DELAY(4000);     {wording layout verified}

              IF Debug_Mode THEN   {Created 01/20/10: VERIFIED 01/20/10 4:59 pm}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is allowed ');
                  CWriteLn('  `0to `#Delete this Record.  `0Do this only if absolutely necessary! ');
                  DELAY(3000);

                  DO_PLAYER_DELETION;
                END;

              SHOW_MENU;
            END;
      { ------------------------------------------------------ }

      ']' : BEGIN               {VERIFIED 12/28/07}
              INC(RecordNum);
              IF RecordNum > (MAX_PLAYERS - 1) THEN RecordNum:= 0;  {05/07/04 edit}

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '[' : BEGIN                      {VERIFIED 12/28/07}
              IF RecordNum=0
                THEN RecordNum:= (MAX_PLAYERS - 1)
                ELSE Dec(RecordNum);

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '*' : BEGIN                    {VERIFIED 12/28/07}
              DO_NEW_DAY;

              SHOW_MENU;

              WRITE_WARRIORS_FILE;
            END;

    END;       {CASE Code - ending}
  UNTIL Code = 'Q';
END;       { RUN_EDITOR ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;          {VERIFIED 12/04/07}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' LORD Cavern''s Player Database Editor Credits: ',
      'LC2EDIT.EXE '+Version+'.  Copyright 2007-2011 by Donald Tidmore. ||'
           {12/29/09: Updated Copyright info for 2010}

      +'** Dedicated to my friend Gary Hartzell. ** ||'  {12/28/07}

      +'** Compile Date:  '+Compile_Date+'  January 2011 Beta. ||'
                {re-enabled 12/31/07}

      {  +'v1.00 Released officially on:  December 28th, 2007.' ||' }  {Added 12/28/07}

      +'Database Path: '+Editor_Path);       {Compile_Date ends with period.}
END; { EXIT_SCREEN ============================================ }


BEGIN    { Main LC2EDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Gold Tool-Kit process}
  UseLordColors:= TRUE;

  Debug_Mode:= FALSE;   {07/22/07 Code}

  IF S2U(ParamStr(1)) = '/DEBUG'  {07/22/07 Code}
    THEN Debug_Mode:= True;

  ReadVars.ReadHelp:= NIL;  { removes the HELP button in the prompts. }   {Gold Tool-Kit process}

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
		{Gold toolkit process}

  RecordNum:= 0;

  IF Exist('CAVEPLAY.DAX') THEN DeleteFile('CAVEPLAY.DAX');
     {Fixed glitch referring to SKELPLAY.DAX 12/10/09}


  READ_CONFIG;  {process existing LC2EDIT.cfg file.}

  Editor_Path:= S2U(IGMDIR+CavePlayer_FN);

  IF Exist(Editor_Path) THEN READ_WARRIORS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0LC2EDIT `!could not locate the `@LORD Cavern''s ');
      CWriteLn('  `#CAVEPLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0LC2EDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);

      CWriteLn(' ');   {12/18/09}
      CWriteLn('  `#Problem Solving Note: `%Make sure the `!LC2EDIT.CFG `%file contains ');
                     {12/18/09: verified 12/30/09}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}

      CWriteLn(' ');
      CWriteLn('  `!Terminating `0LC2EDIT `!after 3 seconds delay.  ');

      CWriteLn(' ');   {12/30/09}
      CWriteLn('  `0This version is `@NOT `0usable with `#LORD Cavern `%v1.7.');
               {Added 12/31/07: verified Jan. 2008}

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { LC2EDIT.pas }

{ First stage code editing finished 11:38 pm 12/03/2007. }
{ All Player Database variables used by IGM are fully coded. }

  { Started creation using OUTSEDIT source code 12/03/2007. }
  { Lc2Edit v1.00 officially released on Dec. 28th, 2007 }

{ used v0.10 beta for primary testing. Changed to v0.20 Beta 12/04/07 }
{ 12:19 am after testing all menu codes, and screen placement of }
{ user's data values.  Testing done using LORD Cavern v1.7 data file. }

          {Program Created 12/03/07}
          { 12/26/07: Used v0.50 beta.  12/28/07. Used v1.00 }
        {12/31/07: used v1.02 beta}
        {06/01/08: used v1.04.  07/01/08: v1.05 beta.}

{09/30/08: v1.07.  01/28/09: Changed to v1.08 beta}
{03/03/09: v1.09 beta.}
{08/19/08: v1.06: Fairy_Rescue VAR rename}
{09/01/08: Deleted release_Date entry}
          {04/25/09: used v1.10 beta. 11/03/09: v1.10, non-beta}
          {11/30/09: use v1.11 Beta.  12/05/09: use v1.12 beta}

            {12/18/09: v1.13 beta. used Dec 15 compile date}
         {12/30/09: All code in program is fully tested.}
          {01/16/10: use v1.14 beta}

