  { Started creation using OUTSEDIT v1.00 files on 05/10/2008. }
  { ================================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

     {$I TAVEVARS.INC}    {January 2011 Beta}
     { =================================================================================== }

CONST Version: STRING = 'v0.85 beta';
            {03/28/10: v0.84 beta.  12/25/10: v0.85 beta}

      Compile_Date: STRING = 'December 25, 2010.';
         {01/18/10: All code in program is fully tested.}
      { ------------------------------------------------ }

      CfgName: STRING = 'OT20EDIT.CFG';

      OutsPlayer_FN: STRING = 'OUTSPLAY.DAT';

      RealName    = '1';   LordName   = '2';   PlayNum   = '3';
      Visits      = '4';   HitMax     = '5';   Strength  = '6';

      { Note: PLAYNUM & VISITS vars are not used in OUTSEDIT }
      { since Outlands Tavern currently does not use them.   }

      Defense     = '7';   Charm      = '8';   Forest    = '9';
      Gems        = '0';   Gold       = 'A';   Wisdom    = 'B';
      { ------------------------------------------------------- }
      Adoptions   = 'C';   SkillPts   = 'D';   Meter      = 'E';
      Dungeon     = 'F';   RDCocktail = 'G';   Dance      = 'H';
      Punch       = 'I';   FairyFood  = 'J';   Sleeping   = 'K';
      Music       = 'L';   Attacked   = 'M';   Kitchen    = 'N';

      Breakfast = 'O';     Kidnap = 'P';     {08/10/08 for later usage}
      Level     = 'R';    {08/10/08}

      { 05/26/08: Renamed Cocktail constant to RDCocktail due }
      { to problems getting the G key to toggle values. Problem fixed. }

      { Q - Quit/Save Changes.   S - Search for Player. }
      { * - New Day for Player.  X - Delete Player }

      { # - Used to test New Day's handling of Negative numbers }
      { ------------------------------------------------------- }

      TwoBillion: LongInt = 2000000000;

      Max_Visits: BYTE = 20;  {Added 08/01/08}
      { ================================================= }

VAR TSearch: TAVERN_PLAYER;   { for player searches }

    TOTEdit: TAVERN_PLAYER;

    Editor_Path: STRING;      { File Vars for OUTSPLAY.DAT access }

    Editor_File: FILE OF TAVERN_PLAYER;

    IGMDir: STRING;

    RecordNum: BYTE;

    Debug_Mode: BOOLEAN;
           {01/17/10: Renamed DebugVar to Debug_Mode.}

      { TempNum, Used, Found: Accessed from TAVEVARS.INC.   Used }
      { in record Seek process.  }
    { ================================================================================== }

PROCEDURE READ_CONFIG;      {Created/verified 11/29/07}
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;          {verified 11/29/07}
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter path to Outlands Skeleton IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;      {verified 11/29/07}

  FileMode:= $12;    {Added 08/01/08}

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

  { OT20EDIT: When run from compiler, verified that value of IGMDir is known at this point. }
END;       { Read_Config ------------------------------------------------- }


PROCEDURE READ_CUSTOMERS_FILE;    { Reads the IGM's OUTSPLAY.DAT file. }
BEGIN
  Editor_Path:= S2U(IGMDIR+OutsPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TOTEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


PROCEDURE WRITE_CUSTOMERS_FILE;      { Writes IGM's OUTSPLAY.DAT file }
BEGIN
  Editor_Path:= S2U(IGMDIR+OutsPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TOTEdit);

  CLOSE(Editor_File);
END;     { WRITE_CUSTOMERS_FILE   ------------------------------ }


PROCEDURE SEARCH_PLAYER(Num:INTEGER);
      { Reads OUTSPLAY.DAT. Does search on player record number }
BEGIN
  Editor_Path:= S2U(IGMDIR+OutsPlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }

    
FUNCTION Get(b:CHAR): STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TOTEdit.RealName;

     LordName : Get:='`$'+TOTEdit.LordName;

     PlayNum  : Get:='`@'+N2S(TOTEdit.PlayNum);   {Enabled 05/10/08}
                      {Contains player's LORD player #.}

     Visits   : IF TOTEdit.Visits = 0      {Enabled 05/10/08}
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TOTEdit.Visits);

     HitMax   : IF TOTEdit.HitMax = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.HitMax);

     Strength : IF TOTEdit.Strength = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Strength);

     Defense  : IF TOTEdit.Defense = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Defense);

     Charm    : IF TOTEdit.Charm = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Charm);

     Forest   : IF TOTEdit.Forest = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Forest);

     Gems     : IF TOTEdit.Gems = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Gems);

     Gold     : IF TOTEdit.Gold = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Gold);

     Wisdom   : IF TOTEdit.Wisdom = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Wisdom);

     { ================== Coded 12/02/07: =================== }
     Adoptions: IF TOTEdit.Adoptions = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TOTEdit.Adoptions);

     SkillPts : IF TOTEdit.Skill_Points = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TOTEdit.Skill_Points);

     Meter    : IF TOTEdit.Drunk_Meter = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TOTEdit.Drunk_Meter);

     Dungeon  : IF TOTEdit.Captured THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     RDCocktail : IF TOTEdit.Cocktail THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Dance    : IF TOTEdit.Dance THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Punch    : IF TOTEdit.Drunk_Punch THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     FairyFood: IF TOTEdit.Fairy_Food THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Sleeping : IF TOTEdit.Sleeping THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Music    : IF TOTEdit.Switched_Book THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Attacked : IF TOTEdit.Under_Attack THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Kitchen  : IF TOTEdit.Used_Kitchen THEN Get:= '`@Yes! '
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Breakfast: Get:= '`$N/A yet';  {01/17/10 temp code}

     Kidnap   : Get:= '`$N/A yet';  {01/17/10 temp code}

     Level    : Get:= '`$N/A yet';  {01/17/10 temp code}

     (*  { =============== 08/10/08: for later usage ========= }
     BreakFast: IF TOTEdit.Had_Breakfast THEN Get:= '`@Yes! '     {05/26/08 rewrite}
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Kidnap   : IF TOTEdit.Kids_Stolen = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TOTEdit.Kids_Stolen);

     Level    : Get:= '`$'+N2S(TOTEdit.Level);
     { ================================================== }   *)

  END;  {CASE}

  CursorOff;   {10/15/07.  needed to fix bug found by Dennis Collins}
               { in 2006 when he checked on KLBEDIT. }

    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }



{ 1 }PROCEDURE DO_REAL_NAME;          {VERIFIED 12/03/07}
BEGIN
  TOTEdit.RealName:=
  PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TOTEdit.RealName,FALSE);

  WRITE_CUSTOMERS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


{ 2 }PROCEDURE DO_LORD_NAME;            {VERIFIED 12/03/07}
BEGIN
  TOTEdit.LordName:=
  PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TOTEdit.LordName,FALSE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


  { ##### Coding done 11/29/07. Enabled 05/10/08 ##### }

  { In normal usage, don't allow users to change LORD Player Numbers. }

{ 3 }PROCEDURE DO_PLAYER_NUMBER;      {05/10/08: VERIFIED 05/10/08}
BEGIN
  TOTEdit.PlayNum:=
  PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TOTEdit.PlayNum,0,160,TRUE);

  WRITE_CUSTOMERS_FILE;
  CWriteXy(58,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(58,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;     {05/10/08: VERIFIED 05/10/08}
BEGIN
  TOTEdit.Visits:=
    PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TOTEdit.Visits,0,Max_Visits,TRUE);
          {revised 08/01/08 to use Max_Visits const.}

  WRITE_CUSTOMERS_FILE;              {Edited 08/01/08}
  CwriteXY(22,6,Replicate(5,' '));
  CwriteXY(22,6,Get(Visits));
END;   {IGM's Max Visits/Day Limit is 15.}


{ 5 }PROCEDURE DO_MAX_HITPOINTS;                 {VERIFIED 12/03/07}
BEGIN
  TOTEdit.HitMax:=
  PromptNum(0,0,'Enter # of Max HitPoints (0-16,000)?',' Max HitPoints Today Change',TOTEdit.HitMax,0,16000,TRUE);

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,6,Replicate(6,' '));
  CWriteXY(58,6,Get(HitMax));
END;


{ 6 }PROCEDURE DO_STRENGTH_POINTS;                 {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Strength:=
  PromptNum(0,0,'Enter # of Strength (0-16,000)?',' Strength Change ',TOTEdit.Strength,0,16000,TRUE);

  WRITE_CUSTOMERS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(Strength));
END;


{ 7 }PROCEDURE DO_DEFENSE_POINTS;               {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Defense:=
  PromptNum(0,0,'Enter Defense Points (0-16,000)?',' Defense Change ',TOTEdit.Defense,0,16000,TRUE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(58,7,Replicate(6,' '));
  CwriteXY(58,7,Get(Defense));
END;


{ 8 }PROCEDURE DO_CHARM_POINTS;               {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Charm:=
  PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Change ',TOTEdit.Charm,0,16000,TRUE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(22,8,Replicate(6,' '));
  CwriteXY(22,8,Get(Charm));
END;


{ 9 }PROCEDURE DO_FOREST_FIGHTS;               {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Forest:=
    PromptNum(0,0,'Enter Forest Fights (0-16,000)?',' Forest Fights Change', TOTEdit.Forest,0,16000,TRUE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(58,8,Replicate(6,' '));
  CwriteXY(58,8,Get(Forest));
END;


{ 0 }PROCEDURE DO_GEMS;      {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Gems:=
   PromptNum(0,0,'Enter # of Gems (0-16,000)?',' Gems Change', TOTEdit.Gems,0,16000,TRUE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(22,9,Replicate(6,' '));
  CwriteXY(22,9,Get(Gems));
END;


{ A }PROCEDURE DO_GOLD_COINS;               {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Gold:=
    PromptNum(0,0,'Enter Gold Coins (0-2 Billion)?',' Gold Found/Lost Change', TOTEdit.Gold,0,TwoBillion,TRUE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(51,9,Replicate(12,' '));
  CwriteXY(51,9,Get(Gold));
END;


{ B }PROCEDURE DO_WISDOM_POINTS;               {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Wisdom:=
    PromptNum(0,0,'Enter Wisdom Points (0-2 Billion)?',' Wisdom Points Change', TOTEdit.Wisdom,0,TwoBillion,TRUE);

  WRITE_CUSTOMERS_FILE;
  CwriteXY(22,10,Replicate(12,' '));
  CwriteXY(22,10,Get(Wisdom));
END;


{ C }PROCEDURE DO_ADOPTIONS;                 {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Adoptions:=
  PromptNum(0,0,'Enter # of Adoptions (0-250)?',' Adoptions Change',TOTEdit.Adoptions,0,250,TRUE);
    {06/12/08: changed range from 0-100 to 0-250.}

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,10,Replicate(6,' '));
  CWriteXY(58,10,Get(Adoptions));
END;


{ D }PROCEDURE DO_SKILL_POINTS;                 {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Skill_Points:=
  PromptNum(0,0,'Enter # of Skill Points (0-10)?',' Skill Points Change',TOTEdit.Skill_Points,0,10,TRUE);

  WRITE_CUSTOMERS_FILE;
  CWriteXY(22,11,Replicate(6,' '));
  CWriteXY(22,11,Get(SkillPts));
END;


{ E }PROCEDURE DO_DRUNK_METER;                 {VERIFIED 12/03/07}
BEGIN
  TOTEdit.Drunk_Meter:=
    PromptNum(0,0,'Enter Drunk Level amount (-110 to 127)?',' Drunk Meter Change',TOTEdit.Drunk_Meter,-110,127,TRUE);
         {08/10/08: changed range to -110 to 127.}

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,11,Replicate(6,' '));
  CWriteXY(58,11,Get(Meter));
END;


{ F }PROCEDURE DO_Captured;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Captured = TRUE THEN TOTEdit.Captured:= FALSE
    ELSE IF TOTEdit.Captured = FALSE THEN TOTEdit.Captured:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(24,12,Replicate(6,' '));
  CWriteXY(24,12,Get(Dungeon));
END;


{ G }PROCEDURE DO_Cocktail;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Cocktail = TRUE THEN TOTEdit.Cocktail:= FALSE
    ELSE IF TOTEdit.Cocktail = FALSE THEN TOTEdit.Cocktail:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,12,Replicate(6,' '));
  CWriteXY(58,12,Get(RDCocktail));
END;


{ H }PROCEDURE DO_Dance;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Dance = TRUE THEN TOTEdit.Dance:= FALSE
    ELSE IF TOTEdit.Dance = FALSE THEN TOTEdit.Dance:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(24,13,Replicate(6,' '));
  CWriteXY(24,13,Get(Dance));
END;


       {05/26/08: Renamed Do_Drink_Punch to DO_DRUNK_PUNCH.}
{ I }PROCEDURE DO_DRUNK_PUNCH;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Drunk_Punch = TRUE THEN TOTEdit.Drunk_Punch:= FALSE
    ELSE IF TOTEdit.Drunk_Punch = FALSE THEN TOTEdit.Drunk_Punch:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,13,Replicate(6,' '));
  CWriteXY(58,13,Get(Punch));
END;


{ J }PROCEDURE DO_Fairy_Food;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Fairy_Food = TRUE THEN TOTEdit.Fairy_Food:= FALSE
    ELSE IF TOTEdit.Fairy_Food = FALSE THEN TOTEdit.Fairy_Food:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(24,14,Replicate(6,' '));
  CWriteXY(24,14,Get(FairyFood));
END;


{ K }PROCEDURE DO_Sleeping;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Sleeping = TRUE THEN TOTEdit.Sleeping:= FALSE
    ELSE IF TOTEdit.Sleeping = FALSE THEN TOTEdit.Sleeping:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,14,Replicate(6,' '));
  CWriteXY(58,14,Get(Sleeping));
END;


{ L }PROCEDURE DO_SWITCH_MUSIC;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Switched_Book = TRUE THEN TOTEdit.Switched_Book:= FALSE
    ELSE IF TOTEdit.Switched_Book = FALSE THEN TOTEdit.Switched_Book:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(24,15,Replicate(6,' '));
  CWriteXY(24,15,Get(Music));
END;


{ M }PROCEDURE DO_Under_Attack;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Under_Attack = TRUE THEN TOTEdit.Under_Attack:= FALSE
    ELSE IF TOTEdit.Under_Attack = FALSE THEN TOTEdit.Under_Attack:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,15,Replicate(6,' '));
  CWriteXY(58,15,Get(Attacked));
END;


{ N }PROCEDURE DO_USED_KITCHEN;                 {VERIFIED 12/03/07}
BEGIN
  IF TOTEdit.Used_Kitchen = TRUE THEN TOTEdit.Used_Kitchen:= FALSE
    ELSE IF TOTEdit.Used_Kitchen = FALSE THEN TOTEdit.Used_Kitchen:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(24,16,Replicate(6,' '));
  CWriteXY(24,16,Get(Kitchen));
END;


(*     { ======== Added 08/10/08: for later usage =========== }

{ O }PROCEDURE DO_HAD_BREAKFAST;       {08/10/08: not enabled}
BEGIN
  IF TOTEdit.Had_Breakfast = TRUE THEN TOTEdit.Had_Breakfast:= FALSE
    ELSE IF TOTEdit.Had_Breakfast = FALSE THEN TOTEdit.Had_Breakfast:= TRUE;

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,16,Replicate(6,' '));   {Line 16, second column}
  CWriteXY(58,16,Get(Breakfast));
END;              *)


(*     { ======== Added 08/10/08: for later usage =========== }

{ P }PROCEDURE DO_KIDS_STOLEN;      {08/10/08: not enabled}
BEGIN
  TOTEdit.Kids_Stolen:=
    PromptNum(0,0,'Enter # of Kids Stolen Today (0-500)?',' Kids Stolen Change',TOTEdit.Kids_Stolen,0,500,TRUE);

  WRITE_CUSTOMERS_FILE;
  CWriteXY(24,17,Replicate(6,' '));   {Line 17, first column}
  CWriteXY(24,17,Get(Kidnap));
END;               *)


(*     { ======== Added 08/10/08: for later usage =========== }

{01/17/10: Renamed DO_LEVEL to DO_GAME_LEVEL.}
{ R }PROCEDURE DO_GAME_LEVEL;           {08/10/08: Not enabled yet}
BEGIN
  TOTEdit.Level:=
    PromptNum(0,0,'Enter LORD Level (1-12)?',' Game Level Change',TOTEdit.Level,1,12,TRUE);

  WRITE_CUSTOMERS_FILE;
  CWriteXY(58,17,Replicate(6,' '));   {Line 17, second column}
  CWriteXY(58,17,Get(Level));
END;
{ ======================================================== }  *)


{ note: To use Y, N responses via keyboard, one has to use
  the ALT key. Or simply use the mouse to click on the option wanted. }


{ * }PROCEDURE DO_NEW_DAY;        {VERIFIED 12/03/07}
BEGIN
  CWGotoXY(5,24);
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

  IF (TOTEdit.PlayNum > 160) THEN   {05/10/08: verified}
    BEGIN
      TOTEdit.PlayNum:= 160;
      PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Visits > 0 THEN        {05/10/08: VERIFIED 05/10/08}
    BEGIN
      TOTEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.HitMax < 0 THEN
    BEGIN
      TOTEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max HitPoints field to Zero.');
    END;

  IF TOTEdit.HitMax > 0 THEN      {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the Max HitPoints field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Strength < 0 THEN
    BEGIN
      TOTEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TOTEdit.Strength > 0 THEN    {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Defense < 0 THEN
    BEGIN
      TOTEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TOTEdit.Defense > 0 THEN     {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Charm < 0 THEN
    BEGIN
      TOTEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TOTEdit.Charm > 0 THEN       {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Forest < 0 THEN
    BEGIN
      TOTEdit.Forest:= 0;
      PromptOK('Advisory:',' Reset negative Forest Fights field to Zero.');
    END;

  IF TOTEdit.Forest > 0 THEN      {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Forest:= 0;
      PromptOK('Advisory:',' Resetting the Forest Fights field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Gems < 0 THEN
    BEGIN
      TOTEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems field to Zero.');
    END;

  IF TOTEdit.Gems > 0 THEN        {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting the Gems field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Gold < 0 THEN
    BEGIN
      TOTEdit.Gold:= 0;
      PromptOK('Advisory:',' Reset negative Gold Coins field to Zero.');
    END;

  IF TOTEdit.Gold > 0 THEN        {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Gold Coins field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Wisdom < 0 THEN
    BEGIN
      TOTEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Points field to Zero.');
    END;

  IF TOTEdit.Wisdom > 0 THEN      {VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting the Wisdom Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Adoptions < 0 THEN   {Coded 12/02/07: VERIFIED 12/28/07}
    BEGIN
      TOTEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Reset negative Adoptions field to Zero.');
    END;

  IF TOTEdit.Adoptions > 0 THEN   {Coded 12/02/07: VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Resetting the Adoptions field to Zero.');
    END;

  { --------------------------------------------------- }
  { Skill_Points is BYTE. Value can't be negative }

  IF TOTEdit.Skill_Points > 0 THEN  {Coded 12/02/07: VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Skill_Points:= 0;
      PromptOK('Advisory:',' Resetting the Skill Points field to Zero.');
    END;

  { --------------------------------------------------- }
  { Drunk Meter has valid values that are negative. }
  { Will have to analyze igm for this section's coding: }
  { Drunk_Meter is SHORTINT var type currently. Can be negative amount }

  IF TOTEdit.Drunk_Meter > 0 THEN   {Coded 12/02/07: VERIFIED 12/03/07}
    BEGIN
      TOTEdit.Drunk_Meter:= 0;
      PromptOK('Advisory:',' Resetting the Drunk Meter field to Zero.');
    END;

  { Boolean variables: All get reset to FALSE: }

  TOTEdit.Cocktail:= FALSE;     {12/02/07}

  TOTEdit.Dance:=    FALSE;     {12/02/07}

  TOTEdit.Drunk_Punch:= FALSE;   {12/02/07}

  TOTEdit.Fairy_Food:= FALSE;    {12/02/07}

  TOTEdit.Switched_Book:= FALSE;  {12/02/07}

  TOTEdit.Used_Kitchen:= FALSE;     {12/02/07}

  IF (TOTEdit.Under_Attack) AND (TOTEdit.Captured) THEN   {Added/Verified 12/28/07}
    BEGIN
      TOTEdit.Under_Attack:= FALSE;
      PromptOK('Advisory:',' Reset invalid value of Under Attack variable.');
    END;   {Under_Attack VAR is not used with players in the Dungeon}

  IF (TOTEdit.Sleeping) AND (TOTEdit.Captured) THEN   {Added/Verified 12/28/07}
    BEGIN
      TOTEdit.Captured:= FALSE;
      PromptOK('Advisory:',' Reset invalid value of In the Dungeon variable.');
    END;    {Sleeping VAR is not used with players in the Dungeon}


  { Should NOT be changed by New Day process: Captured, Sleeping, }
  { and Under_Attack. }

  (* { ================== 08/10/08: for later usage =========== }

  TOTEdit.Breakfast:= FALSE;     {08/10/08: not enabled}

  { --------------------------------------------------- }
  IF TOTEdit.Kids_Stolen < 0 THEN      {08/10/08: not enabled}
    BEGIN
      TOTEdit.Kids_Stolen:= 0;
      PromptOK('Advisory:',' Reset negative Kids Stolen field to Zero.');
    END;

  IF TOTEdit.Kids_Stolen > 0 THEN      {08/10/08: not enabled}
    BEGIN
      TOTEdit.Kids_Stolen:= 0;
      PromptOK('Advisory:',' Resetting the Kids Stolen field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TOTEdit.Level < 1 THEN            {08/10/08: not enabled}
    BEGIN
      TOTEdit.Level:= 1;

      PromptOK('Advisory:',' Reset invalid LORD Level field to 1.');
    END;

  IF TOTEdit.Level > 12 THEN            {08/10/08: not enabled}
    BEGIN                              
      TOTEdit.Level:= 12;
      PromptOK('Advisory:',' Reset over-range LORD Level field to 12.');
    END;
  { =================================================== }   *)

END;     { DO_NEW_DAY  ================================== }


FUNCTION  MaxPlayers: WORD; { Gets the number of customer records }
BEGIN
  MaxPlayers:= 1;

  Editor_Path:= S2U(IGMDIR+OutsPlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MaxPlayers:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MaxPlayers  --------------------------------------------- }


FUNCTION GetRecordNum: STRING;
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MaxPlayers);
    { First record # displayed will be 1, not 0. }
END;     { GetRecordNum ---------------------------------------------- }


PROCEDURE ShowMenu;          {VERIFIED 12/03/07}
BEGIN
  ClrScr;

  CWritelnC('`%** `$Outlands Skeleton''s `0Player Database Editor `!'+Version+' `%**');  {Line 1}

  CWritelnC('`@OUTSPLAY.DAT `%Record Number: '+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
    CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);        {Line 6, column 1}  {Fixed glitch 05/29/08}
  CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Max HitPoints `%: '+Get(HitMax));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
    CWrite('`#(`%6`#) `!Strength Pts `%: '+Get(Strength));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Defense Points`%: '+Get(Defense));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
   CWrite('`#(`%8`#) `!Charm Points `%: '+Get(Charm));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Forest Fights `%: '+Get(Forest));
  { -------------------------------------------- }

  { Note: All lines from here to the end of SHOWMENU }
  { process were written in 12/02/2007 coding sessions. }

  CWGotoXY(3,9);                 {Line 9. Coded 12/02/2007}
    CWrite('`#(`%0`#) `!Gems Found   `%: '+Get(Gems));

  CWGotoXY(34,9);
  CWriteLN('`#(`%A`#) `!Gold Coins `%: '+Get(Gold));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10. Coded 12/02/2007}
   CWrite('`#(`%B`#) `!Wisdom Points`%: '+Get(Wisdom));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Kids Adopted  `%: '+Get(Adoptions));
  { -------------------------------------------- }

  CWGotoXY(3,11);                 {Line 11. Coded 12/02/2007}
   CWrite('`#(`%D`#) `!Skill Points `%: '+Get(SkillPts));

  CWGotoXY(38,11);
  CWriteLN('`#(`%E`#) `!Drunk Meter # `%: '+Get(Meter));
  { -------------------------------------------- }

  CWGotoXY(3,12);                 {Line 12. Coded 12/02/2007}
    CWrite('`#(`%F`#) `!In the Dungeon?`%: '+Get(Dungeon));

  CWGotoXY(38,12);
  CWriteLN('`#(`%G`#) `!Had Cocktail? `%: '+Get(RDCocktail));
  { -------------------------------------------- }

  CWGotoXY(3,13);                 {Line 13. Coded 12/02/2007}
    CWrite('`#(`%H`#) `!Had Dance yet? `%: '+Get(Dance));

  CWGotoXY(38,13);
  CWriteLN('`#(`%I`#) `!Drunk Punch?  `%: '+Get(Punch));
  { -------------------------------------------- }

  CWGotoXY(3,14);                 {Line 14. Coded 12/02/2007}
   CWrite('`#(`%J`#) `!Had Fairy Food?`%: '+Get(FairyFood));

  CWGotoXY(38,14);
  CWriteLN('`#(`%K`#) `!Asleep in IGM?`%: '+Get(Sleeping));
  { -------------------------------------------- }

  CWGotoXY(3,15);                 {Line 14. Coded 12/02/2007}
   CWrite('`#(`%L`#) `!Switched Music?`%: '+Get(Music));

  CWGotoXY(38,15);
  CWriteLN('`#(`%M`#) `!Under Attack? `%: '+Get(Attacked));
  { -------------------------------------------- }


  (*  {Disabled 01/18/10}
  CWGotoXY(3,16);                 {Line 14. Coded 12/02/2007}
  CWriteLN('`#(`%N`#) `!Used Kitchen?  `%: '+Get(Kitchen));       *)
  { -------------------------------------------- }

  { Partially enabled 01/18/10 so menu entries show up on-screen. }

   { For later usage. 08/10/08 place-holder entry }

  CWGotoXY(3,16);           {Line 14. Coded 12/02/2007}
  CWrite('`#(`%N`#) `!Used Kitchen?  `%: '+Get(Kitchen));

  CWGotoXY(38,16);          {08/10/08: not enabled}
  CWriteLN('`#(`%O`#) `#Had Breakfast?`%: '+Get(Breakfast));

  CWGotoXY(3,17);           {08/10/08: not enabled}
  CWrite('`#(`%P`#) `#Kids Stolen    `%: '+Get(Kidnap));

  CWGotoXY(38,17);          {08/10/08: not enabled}
  CWriteLN('`#(`%R`#) `#Game Level #  `%: '+Get(Level));
  { -------------------------------------------- }


  CWriteLn(' ');  {Blank Line, Line #18}  {edited 01/17/10}

  { --------------------------------------------------------------- }
  CWGotoXY(3,19);                             {edited 01/17/10}
   CWrite('`2(`0S`2) `%Search by Name');

  CWGotoXY(40,19);   {12/02/07 coding}        {edited 01/17/10}
  CWriteLn('`2(`0X`2) `%Delete Player Record');
  { -------------------------------------------- }

  CWGotoXY(3,20);    {12/02/07 coding}      {edited 01/17/10}
  CWrite('`2(`0]`2) `%Advance One Record');

  CWGotoXY(40,20);   {12/02/07 coding}      {edited 01/17/10}
  CWriteLn('`2(`0[`2) `%Back Up One Record');
  { -------------------------------------------- }

  (*  {replaced code 01/17/10}
  CWGotoXY(3,21);    {12/02/07 coding}      {edited 01/17/10}
  CWrite('`2(`0*`2) `%Reset Player Stats');

  CWGotoXY(40,21);   {Added 12/28/07}       {edited 01/17/10}
  CWriteLn('`2(`0#`2) `%New Day Process Testing');
  { -------------------------------------------- }      *)

  CWGotoXY(3,21);    {12/02/07 coding}      {edited 01/17/10}
  CWriteLn('`2(`0*`2) `%Reset Player Stats');
     {Changed CWrite to CWriteLn 01/17/10}

  BLANK(1);   {Blank line.  #22. 12/02/07 coding}  {edited 01/17/10}

  CWGotoXY(3,23);   {Edited 01/17/10}
  Cwrite('`$    Input key to change, or `%Q `$to Quit and Save.');

  IF Debug_Mode THEN    {Added 01/17/10: VERIFIED 01/18/10 7:45 pm}
    CWrite('  `@[Debug Mode] ');

END;     { ShowMenu  ----------------------------------------- }


       { 12/02/07: Changed X menu code to S for DO_PLAYER_SEARCH. }
{ S }PROCEDURE DO_PLAYER_SEARCH;       {VERIFIED}
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+OutsPlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no OUTSPLAY.DAT then we can't search and
       couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
       YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_CUSTOMERS_FILE;
            ShowMenu;
            Exit; { bail out of loop since we got who we want }
          END;
     END;

    Inc(Counter);
  UNTIL Counter=MaxPlayers; { End of repeat loop, repeats until we get
										to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;   { DO_PLAYER_SEARCH ====================================== }


{ Added 12/02/07 using modified ROL2EDIT.PAS code: }

{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 12/02/07: VERIFIED}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TOTEdit.LordName+' known'
     +' as '+NoColor(TOTEdit.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TOTEdit.RealName:= 'X';
      TOTEdit.LordName:= '* DELETED *';

      TOTEdit.PlayNum:= 160;   {Enabled 05/10/08}

        { Note: PlayNum 160 should not be in use by any valid players.}

      TOTEdit.Visits:= 0;      {Enabled 05/10/08}

      TOTEdit.Adoptions:= 0;      {Added 12/02/07}
      TOTEdit.Skill_Points:= 0;       {Added 12/02/07}
      TOTEdit.Drunk_Meter:= 0;       {Added 12/02/07}
      TOTEdit.HitMax:= 0;    {Added 12/02/07}

      TOTEdit.Strength:= 0;       {Added 12/02/07}
      TOTEdit.Defense:= 0;    {Added 12/02/07}
      TOTEdit.Charm:= 0;       {Added 12/02/07}
      TOTEdit.Gems:= 0;         {Added 12/02/07}

      TOTEdit.Gold:= 0;    {Added 12/02/07}
      TOTEdit.Wisdom:= 0;       {Added 12/02/07}

      TOTEdit.Captured:= FALSE;      {Added 12/02/07}
      TOTEdit.Cocktail:= FALSE;      {Added 12/02/07}
      TOTEdit.Dance:= FALSE;      {Added 12/02/07}
      TOTEdit.Drunk_Punch:= FALSE;      {Added 12/02/07}

      TOTEdit.Fairy_Food:= FALSE;      {Added 12/02/07}
      TOTEdit.Sleeping:= FALSE;      {Added 12/02/07}
      TOTEdit.Switched_Book:= FALSE;      {Added 12/02/07}
      TOTEdit.Under_Attack:= FALSE;      {Added 12/02/07}
      TOTEdit.Used_Kitchen:= FALSE;      {Added 12/02/07}
      { ============================================================================== }

      { ------------------------------------------------------- }
      (*  TOTEdit.Had_Breakfast:= FALSE;  {08/10/08: not enabled}

          TOTEdit.Kids_Stolen:= 0;        {08/10/08: not enabled}

          TOTEdit.Level:= 1;              {08/10/08: not enabled}
               *)   {place-holder entries for later usage}
      { ======================================================= }

      WRITE_CUSTOMERS_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

      ShowMenu;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }


(*  { Re-enabled 05/10/08 temporarily. Re-disabled at 01:46 am after use. }

        {Created 12/28/07 to test New Day process code}
{ # }PROCEDURE DO_NEWDAY_TESTING;   {Created 12/28/07: VERIFIED 12/28/07}
BEGIN
  TOTEdit.Adoptions:= -100;

  { Skill_Points can not be set to negative value. }

  TOTEdit.Drunk_Meter:= -100;
  TOTEdit.HitMax:= -1000;

  TOTEdit.Strength:= -1000;
  TOTEdit.Defense:= -1000;
  TOTEdit.Charm:= -1000;
  TOTEdit.Gems:= -1000;
  TOTEdit.Forest:= -1000;

  TOTEdit.Gold:= -1000000;         {Reset to -1,000,000}
  TOTEdit.Wisdom:= -1000000;       {Reset to -1,000,000}

  TOTEdit.Captured:= TRUE;
  TOTEdit.Cocktail:= TRUE;
  TOTEdit.Dance:= TRUE;
  TOTEdit.Drunk_Punch:= TRUE;

  TOTEdit.Fairy_Food:= TRUE;
  TOTEdit.Sleeping:= TRUE;
  TOTEdit.Switched_Book:= TRUE;
  TOTEdit.Under_Attack:= TRUE;
  TOTEdit.Used_Kitchen:= TRUE;
  { ================================================== }

  WRITE_CUSTOMERS_FILE;

  PromptOK(' NewDay Testing: ','Variables reset to negative values for use in testing |'
               +'how the New Day for Player process handles them. ');

  ShowMenu;

END;  { DO_NEWDAY_TESTING ============================ }  *)


PROCEDURE RUN_EDITOR;       {VERIFIED 12/03/07}
  VAR Code: CHAR;
BEGIN
  ShowMenu;

  REPEAT
    Code:= AInput('1234567890ABCDEFGHIJKLMNQSX][*#');
            {Added # 12/28/07 for use with DO_NEWDAY_TESTING.}

    CASE Code OF
      '1' : DO_REAL_NAME;   {Edited 05/10/08: VERIFIED 05/10/08}

      '2' : DO_LORD_NAME;

      '3' : BEGIN           {Enabled 05/10/08: verified 05/10/08}
              CWGotoXY(1,25);   {Show text on Line 25. Edited 01/17/10}

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see ');
              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
              DELAY(3000);

              IF Debug_Mode THEN   {coded 07/22/07: VERIFIED 05/10/08}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the Player Number field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(3000);

                  DO_PLAYER_NUMBER;
                END;

              ShowMenu;
            END;

      '4' : DO_VISITS;         {Enabled 05/10/08: VERIFIED 05/10/08}

      '5' : DO_MAX_HITPOINTS;

      '6' : DO_STRENGTH_POINTS;

      '7' : DO_DEFENSE_POINTS;

      '8' : DO_CHARM_POINTS;

      '9' : DO_FOREST_FIGHTS;

      '0' : DO_GEMS;

      'A' : DO_GOLD_COINS;

      'B' : DO_WISDOM_POINTS;

      'C' : DO_ADOPTIONS;          {Coded 12/02/07}

      'D' : DO_SKILL_POINTS;       {Coded 12/02/07}

      'E' : DO_DRUNK_METER;        {Coded 12/02/07}

      'F' : DO_CAPTURED;       {Coded 12/02/07}

      'G' : DO_COCKTAIL;       {Coded 12/02/07}

      'H' : DO_DANCE;                {Coded 12/02/07}

      'I' : DO_DRUNK_PUNCH;          {Coded 12/02/07}

      'J' : DO_FAIRY_FOOD;           {Coded 12/02/07}

      'K' : DO_SLEEPING;             {Coded 12/02/07}

      'L' : DO_SWITCH_MUSIC;         {Coded 12/02/07}

      'M' : DO_UNDER_ATTACK;        {Coded 12/02/07}

      'N' : DO_USED_KITCHEN;        {Coded 12/02/07}


      { ------------------------------------------------------- }
      (*
      'O' : DO_BREAKFAST;           {Coded 08/10/08: not enabled}

      'P' : DO_KIDS_STOLEN;         {Coded 08/10/08: not enabled}

      'R' : DO_GAME_LEVEL;          {Coded 08/10/08: not enabled}

               *)   {place-holder entries for later usage}
      { ======================================================= }


      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'S' : DO_PLAYER_SEARCH;   {revised 12/02/07}

      { --------- Rewrote 01/17/10 to use Debug_Mode --------- }
      'X' : BEGIN               {Rewrote 01/17/10: VERIFIED 01/18/10 7:45 pm}
              CWGotoXY(1,25);   {Show text on Line 25}

              CWriteLn('  `0The `@Delete Player Record `0option is only usable when `$OT20EDIT ');
              CWriteLn('  `0is executed in `%Debug Mode, `0using the `!/Debug `0parameter. ');
              CWriteLn('  `!This option should only be used to deal with `@cheating players. ');
              DELAY(4000);     {wording layout verified}

              IF Debug_Mode THEN   {Created 01/17/10: VERIFIED 01/18/10 7:45 pm}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is allowed ');
                  CWriteLn('  `0to `#Delete this Record.  `0Do this only if absolutely necessary! ');
                  DELAY(3000);

                  DO_PLAYER_DELETION;
                END;

              ShowMenu;
            END;         {replaced 12/02/07 code on 01/18/10}
      { ------------------------------------------------------ }


      (*   {Re-Enabled 05/10/08: VERIFIED 05/10/08}
      '#' : DO_NEWDAY_TESTING;   {Coded 12/28/07: VERIFIED 12/28/07}
                      *)

      ']' : BEGIN                      {VERIFIED}
              Inc(RecordNum);
              IF RecordNum > (MaxPlayers - 1) THEN RecordNum:= 0;  {05/07/04 edit}

              READ_CUSTOMERS_FILE;
              ShowMenu;
            END;

      '[' : BEGIN                      {VERIFIED}
              IF RecordNum=0
                THEN RecordNum:= (MaxPlayers - 1)
                ELSE Dec(RecordNum);

              READ_CUSTOMERS_FILE;
              ShowMenu;
            END;

      '*' : BEGIN                      {VERIFIED}
              DO_NEW_DAY;

              ShowMenu;

              WRITE_CUSTOMERS_FILE;
            END;

    END;       {CASE Code - ending}
  UNTIL Code = 'Q';
END;       { RUN_EDITOR ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;          {VERIFIED 12/03/07}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' Outlands Skeleton''s Player Database Editor Credits: ',
      'OT20EDIT.EXE '+Version+'.  Copyright 2008-2011 by Donald Tidmore. ||'
              {12/26/10: revised copyright date info}

      +'** Dedication:  To Dennis Collins and Jason Brown. ** ||'

      +'** Compile Date:  '+Compile_Date+'  January 2011 Beta. ||'
      
      +'Database Path: '+Editor_Path);       {Compile_Date ends with period.}
END; { EXIT_SCREEN ============================================ }


BEGIN    { Main OT20EDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Gold Tool-Kit process}
  UseLordColors:= TRUE;

  Debug_Mode:= FALSE;   {07/22/07 Code}

  IF S2U(ParamStr(1)) = '/DEBUG'  {07/22/07 Code}
    THEN Debug_Mode:= TRUE;

  ReadVars.ReadHelp:= NIL;  { removes the HELP button in the prompts. }   {Gold Tool-Kit process}

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
		{Gold toolkit process}

  RecordNum:= 0;

  IF Exist('OUTSPLAY.DAX') THEN DeleteFile('OUTSPLAY.DAX');

  READ_CONFIG;  {process existing OT20EDIT.cfg file.}

  Editor_Path:= S2U(IGMDIR+OutsPlayer_FN);

  IF Exist(Editor_Path) THEN READ_CUSTOMERS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0OT20EDIT `!could not locate the `@Outlands Skeleton''s ');
      CWriteLn('  `#OUTSPLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0OT20EDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);

      CWriteLn(' ');   {12/18/09}
      CWriteLn('  `#Problem Solving Note: `%Make sure the `!OT20EDIT.CFG `%file contains ');
                     {12/18/09: verified 12/30/09}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}

      CWriteLn(' ');
      CWriteLn('  `!Terminating `0OT20EDIT `!after 3 seconds delay.  ');

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { OT20EDIT.pas }


{ First stage code editing finished 01:06 am 05/10/2008. }

          { Started with v0.25 beta 05/10/08. }
          { v0.30 beta. 05/29/08   v0.35 beta. 06/12/08 }
          { 07/04/08: use v0.45 Beta. 08/10/08: use v0.55 Beta}
          { 08/31/08: use v0.60 Beta. 10/01/08: v0.62    }
          { 11/03/08: used v0.65 Beta. compiled 11/05/08.}
          { 03/04/09: v0.72 beta. 06/03/09: v0.74 beta   }

          { 07/29/09: use v0.76 Beta. 10/08/09: v0.78 Beta }

      {12/16/09: use v0.80 beta}
            {01/17/10: use v0.82 beta}
            {02/27/10: v0.83 beta used}

